# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GoogleCloudDatalabelingV1beta1AnnotationSpecArgs',
    'GoogleCloudDatalabelingV1beta1AttemptArgs',
    'GoogleCloudDatalabelingV1beta1BigQuerySourceArgs',
    'GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsArgs',
    'GoogleCloudDatalabelingV1beta1BoundingPolyConfigArgs',
    'GoogleCloudDatalabelingV1beta1ClassificationMetadataArgs',
    'GoogleCloudDatalabelingV1beta1EvaluationConfigArgs',
    'GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigArgs',
    'GoogleCloudDatalabelingV1beta1EvaluationJobConfigArgs',
    'GoogleCloudDatalabelingV1beta1GcsSourceArgs',
    'GoogleCloudDatalabelingV1beta1HumanAnnotationConfigArgs',
    'GoogleCloudDatalabelingV1beta1ImageClassificationConfigArgs',
    'GoogleCloudDatalabelingV1beta1InputConfigArgs',
    'GoogleCloudDatalabelingV1beta1OperatorFeedbackMetadataArgs',
    'GoogleCloudDatalabelingV1beta1PdfInstructionArgs',
    'GoogleCloudDatalabelingV1beta1RequesterFeedbackMetadataArgs',
    'GoogleCloudDatalabelingV1beta1SentimentConfigArgs',
    'GoogleCloudDatalabelingV1beta1TextClassificationConfigArgs',
    'GoogleCloudDatalabelingV1beta1TextMetadataArgs',
    'GoogleRpcStatusArgs',
]

@pulumi.input_type
class GoogleCloudDatalabelingV1beta1AnnotationSpecArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[int]] = None):
        """
        Container of information related to one possible annotation that can be used in a labeling task. For example, an image classification task where images are labeled as `dog` or `cat` must reference an AnnotationSpec for `dog` and an AnnotationSpec for `cat`.
        :param pulumi.Input[str] description: Optional. User-provided description of the annotation specification. The description can be up to 10,000 characters long.
        :param pulumi.Input[str] display_name: Required. The display name of the AnnotationSpec. Maximum of 64 characters.
        :param pulumi.Input[int] index: This is the integer index of the AnnotationSpec. The index for the whole AnnotationSpecSet is sequential starting from 0. For example, an AnnotationSpecSet with classes `dog` and `cat`, might contain one AnnotationSpec with `{ display_name: "dog", index: 0 }` and one AnnotationSpec with `{ display_name: "cat", index: 1 }`. This is especially useful for model training as it encodes the string labels into numeric values.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if index is not None:
            pulumi.set(__self__, "index", index)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. User-provided description of the annotation specification. The description can be up to 10,000 characters long.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The display name of the AnnotationSpec. Maximum of 64 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[int]]:
        """
        This is the integer index of the AnnotationSpec. The index for the whole AnnotationSpecSet is sequential starting from 0. For example, an AnnotationSpecSet with classes `dog` and `cat`, might contain one AnnotationSpec with `{ display_name: "dog", index: 0 }` and one AnnotationSpec with `{ display_name: "cat", index: 1 }`. This is especially useful for model training as it encodes the string labels into numeric values.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "index", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1AttemptArgs:
    def __init__(__self__, *,
                 attempt_time: Optional[pulumi.Input[str]] = None,
                 partial_failures: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleRpcStatusArgs']]]] = None):
        """
        Records a failed evaluation job run.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleRpcStatusArgs']]] partial_failures: Details of errors that occurred.
        """
        if attempt_time is not None:
            pulumi.set(__self__, "attempt_time", attempt_time)
        if partial_failures is not None:
            pulumi.set(__self__, "partial_failures", partial_failures)

    @property
    @pulumi.getter(name="attemptTime")
    def attempt_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "attempt_time")

    @attempt_time.setter
    def attempt_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attempt_time", value)

    @property
    @pulumi.getter(name="partialFailures")
    def partial_failures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleRpcStatusArgs']]]]:
        """
        Details of errors that occurred.
        """
        return pulumi.get(self, "partial_failures")

    @partial_failures.setter
    def partial_failures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleRpcStatusArgs']]]]):
        pulumi.set(self, "partial_failures", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1BigQuerySourceArgs:
    def __init__(__self__, *,
                 input_uri: Optional[pulumi.Input[str]] = None):
        """
        The BigQuery location for input data. If used in an EvaluationJob, this is where the service saves the prediction input and output sampled from the model version.
        :param pulumi.Input[str] input_uri: Required. BigQuery URI to a table, up to 2,000 characters long. If you specify the URI of a table that does not exist, Data Labeling Service creates a table at the URI with the correct schema when you create your EvaluationJob. If you specify the URI of a table that already exists, it must have the [correct schema](/ml-engine/docs/continuous-evaluation/create-job#table-schema). Provide the table URI in the following format: "bq://{your_project_id}/ {your_dataset_name}/{your_table_name}" [Learn more](/ml-engine/docs/continuous-evaluation/create-job#table-schema).
        """
        if input_uri is not None:
            pulumi.set(__self__, "input_uri", input_uri)

    @property
    @pulumi.getter(name="inputUri")
    def input_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. BigQuery URI to a table, up to 2,000 characters long. If you specify the URI of a table that does not exist, Data Labeling Service creates a table at the URI with the correct schema when you create your EvaluationJob. If you specify the URI of a table that already exists, it must have the [correct schema](/ml-engine/docs/continuous-evaluation/create-job#table-schema). Provide the table URI in the following format: "bq://{your_project_id}/ {your_dataset_name}/{your_table_name}" [Learn more](/ml-engine/docs/continuous-evaluation/create-job#table-schema).
        """
        return pulumi.get(self, "input_uri")

    @input_uri.setter
    def input_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_uri", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsArgs:
    def __init__(__self__, *,
                 iou_threshold: Optional[pulumi.Input[float]] = None):
        """
        Options regarding evaluation between bounding boxes.
        :param pulumi.Input[float] iou_threshold: Minimum [intersection-over-union (IOU)](/vision/automl/object-detection/docs/evaluate#intersection-over-union) required for 2 bounding boxes to be considered a match. This must be a number between 0 and 1.
        """
        if iou_threshold is not None:
            pulumi.set(__self__, "iou_threshold", iou_threshold)

    @property
    @pulumi.getter(name="iouThreshold")
    def iou_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Minimum [intersection-over-union (IOU)](/vision/automl/object-detection/docs/evaluate#intersection-over-union) required for 2 bounding boxes to be considered a match. This must be a number between 0 and 1.
        """
        return pulumi.get(self, "iou_threshold")

    @iou_threshold.setter
    def iou_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "iou_threshold", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1BoundingPolyConfigArgs:
    def __init__(__self__, *,
                 annotation_spec_set: Optional[pulumi.Input[str]] = None,
                 instruction_message: Optional[pulumi.Input[str]] = None):
        """
        Config for image bounding poly (and bounding box) human labeling task.
        :param pulumi.Input[str] annotation_spec_set: Required. Annotation spec set resource name.
        :param pulumi.Input[str] instruction_message: Optional. Instruction message showed on contributors UI.
        """
        if annotation_spec_set is not None:
            pulumi.set(__self__, "annotation_spec_set", annotation_spec_set)
        if instruction_message is not None:
            pulumi.set(__self__, "instruction_message", instruction_message)

    @property
    @pulumi.getter(name="annotationSpecSet")
    def annotation_spec_set(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Annotation spec set resource name.
        """
        return pulumi.get(self, "annotation_spec_set")

    @annotation_spec_set.setter
    def annotation_spec_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation_spec_set", value)

    @property
    @pulumi.getter(name="instructionMessage")
    def instruction_message(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Instruction message showed on contributors UI.
        """
        return pulumi.get(self, "instruction_message")

    @instruction_message.setter
    def instruction_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instruction_message", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1ClassificationMetadataArgs:
    def __init__(__self__, *,
                 is_multi_label: Optional[pulumi.Input[bool]] = None):
        """
        Metadata for classification annotations.
        :param pulumi.Input[bool] is_multi_label: Whether the classification task is multi-label or not.
        """
        if is_multi_label is not None:
            pulumi.set(__self__, "is_multi_label", is_multi_label)

    @property
    @pulumi.getter(name="isMultiLabel")
    def is_multi_label(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the classification task is multi-label or not.
        """
        return pulumi.get(self, "is_multi_label")

    @is_multi_label.setter
    def is_multi_label(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_multi_label", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1EvaluationConfigArgs:
    def __init__(__self__, *,
                 bounding_box_evaluation_options: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsArgs']] = None):
        """
        Configuration details used for calculating evaluation metrics and creating an Evaluation.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsArgs'] bounding_box_evaluation_options: Only specify this field if the related model performs image object detection (`IMAGE_BOUNDING_BOX_ANNOTATION`). Describes how to evaluate bounding boxes.
        """
        if bounding_box_evaluation_options is not None:
            pulumi.set(__self__, "bounding_box_evaluation_options", bounding_box_evaluation_options)

    @property
    @pulumi.getter(name="boundingBoxEvaluationOptions")
    def bounding_box_evaluation_options(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsArgs']]:
        """
        Only specify this field if the related model performs image object detection (`IMAGE_BOUNDING_BOX_ANNOTATION`). Describes how to evaluate bounding boxes.
        """
        return pulumi.get(self, "bounding_box_evaluation_options")

    @bounding_box_evaluation_options.setter
    def bounding_box_evaluation_options(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsArgs']]):
        pulumi.set(self, "bounding_box_evaluation_options", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 min_acceptable_mean_average_precision: Optional[pulumi.Input[float]] = None):
        """
        Provides details for how an evaluation job sends email alerts based on the results of a run.
        :param pulumi.Input[str] email: Required. An email address to send alerts to.
        :param pulumi.Input[float] min_acceptable_mean_average_precision: Required. A number between 0 and 1 that describes a minimum mean average precision threshold. When the evaluation job runs, if it calculates that your model version's predictions from the recent interval have meanAveragePrecision below this threshold, then it sends an alert to your specified email.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if min_acceptable_mean_average_precision is not None:
            pulumi.set(__self__, "min_acceptable_mean_average_precision", min_acceptable_mean_average_precision)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Required. An email address to send alerts to.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="minAcceptableMeanAveragePrecision")
    def min_acceptable_mean_average_precision(self) -> Optional[pulumi.Input[float]]:
        """
        Required. A number between 0 and 1 that describes a minimum mean average precision threshold. When the evaluation job runs, if it calculates that your model version's predictions from the recent interval have meanAveragePrecision below this threshold, then it sends an alert to your specified email.
        """
        return pulumi.get(self, "min_acceptable_mean_average_precision")

    @min_acceptable_mean_average_precision.setter
    def min_acceptable_mean_average_precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min_acceptable_mean_average_precision", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1EvaluationJobConfigArgs:
    def __init__(__self__, *,
                 bigquery_import_keys: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bounding_poly_config: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1BoundingPolyConfigArgs']] = None,
                 evaluation_config: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1EvaluationConfigArgs']] = None,
                 evaluation_job_alert_config: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigArgs']] = None,
                 example_count: Optional[pulumi.Input[int]] = None,
                 example_sample_percentage: Optional[pulumi.Input[float]] = None,
                 human_annotation_config: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1HumanAnnotationConfigArgs']] = None,
                 image_classification_config: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1ImageClassificationConfigArgs']] = None,
                 input_config: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1InputConfigArgs']] = None,
                 text_classification_config: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1TextClassificationConfigArgs']] = None):
        """
        Configures specific details of how a continuous evaluation job works. Provide this configuration when you create an EvaluationJob.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] bigquery_import_keys: Required. Prediction keys that tell Data Labeling Service where to find the data for evaluation in your BigQuery table. When the service samples prediction input and output from your model version and saves it to BigQuery, the data gets stored as JSON strings in the BigQuery table. These keys tell Data Labeling Service how to parse the JSON. You can provide the following entries in this field: * `data_json_key`: the data key for prediction input. You must provide either this key or `reference_json_key`. * `reference_json_key`: the data reference key for prediction input. You must provide either this key or `data_json_key`. * `label_json_key`: the label key for prediction output. Required. * `label_score_json_key`: the score key for prediction output. Required. * `bounding_box_json_key`: the bounding box key for prediction output. Required if your model version perform image object detection. Learn [how to configure prediction keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1BoundingPolyConfigArgs'] bounding_poly_config: Specify this field if your model version performs image object detection (bounding box detection). `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1EvaluationConfigArgs'] evaluation_config: Required. Details for calculating evaluation metrics and creating Evaulations. If your model version performs image object detection, you must specify the `boundingBoxEvaluationOptions` field within this configuration. Otherwise, provide an empty object for this configuration.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigArgs'] evaluation_job_alert_config: Optional. Configuration details for evaluation job alerts. Specify this field if you want to receive email alerts if the evaluation job finds that your predictions have low mean average precision during a run.
        :param pulumi.Input[int] example_count: Required. The maximum number of predictions to sample and save to BigQuery during each evaluation interval. This limit overrides `example_sample_percentage`: even if the service has not sampled enough predictions to fulfill `example_sample_perecentage` during an interval, it stops sampling predictions when it meets this limit.
        :param pulumi.Input[float] example_sample_percentage: Required. Fraction of predictions to sample and save to BigQuery during each evaluation interval. For example, 0.1 means 10% of predictions served by your model version get saved to BigQuery.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1HumanAnnotationConfigArgs'] human_annotation_config: Optional. Details for human annotation of your data. If you set labelMissingGroundTruth to `true` for this evaluation job, then you must specify this field. If you plan to provide your own ground truth labels, then omit this field. Note that you must create an Instruction resource before you can specify this field. Provide the name of the instruction resource in the `instruction` field within this configuration.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1ImageClassificationConfigArgs'] image_classification_config: Specify this field if your model version performs image classification or general classification. `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet. `allowMultiLabel` in this configuration must match `classificationMetadata.isMultiLabel` in input_config.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1InputConfigArgs'] input_config: Rquired. Details for the sampled prediction input. Within this configuration, there are requirements for several fields: * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`. * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`, `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`, or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection). * If your machine learning model performs classification, you must specify `classificationMetadata.isMultiLabel`. * You must specify `bigquerySource` (not `gcsSource`).
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1TextClassificationConfigArgs'] text_classification_config: Specify this field if your model version performs text classification. `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet. `allowMultiLabel` in this configuration must match `classificationMetadata.isMultiLabel` in input_config.
        """
        if bigquery_import_keys is not None:
            pulumi.set(__self__, "bigquery_import_keys", bigquery_import_keys)
        if bounding_poly_config is not None:
            pulumi.set(__self__, "bounding_poly_config", bounding_poly_config)
        if evaluation_config is not None:
            pulumi.set(__self__, "evaluation_config", evaluation_config)
        if evaluation_job_alert_config is not None:
            pulumi.set(__self__, "evaluation_job_alert_config", evaluation_job_alert_config)
        if example_count is not None:
            pulumi.set(__self__, "example_count", example_count)
        if example_sample_percentage is not None:
            pulumi.set(__self__, "example_sample_percentage", example_sample_percentage)
        if human_annotation_config is not None:
            pulumi.set(__self__, "human_annotation_config", human_annotation_config)
        if image_classification_config is not None:
            pulumi.set(__self__, "image_classification_config", image_classification_config)
        if input_config is not None:
            pulumi.set(__self__, "input_config", input_config)
        if text_classification_config is not None:
            pulumi.set(__self__, "text_classification_config", text_classification_config)

    @property
    @pulumi.getter(name="bigqueryImportKeys")
    def bigquery_import_keys(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Required. Prediction keys that tell Data Labeling Service where to find the data for evaluation in your BigQuery table. When the service samples prediction input and output from your model version and saves it to BigQuery, the data gets stored as JSON strings in the BigQuery table. These keys tell Data Labeling Service how to parse the JSON. You can provide the following entries in this field: * `data_json_key`: the data key for prediction input. You must provide either this key or `reference_json_key`. * `reference_json_key`: the data reference key for prediction input. You must provide either this key or `data_json_key`. * `label_json_key`: the label key for prediction output. Required. * `label_score_json_key`: the score key for prediction output. Required. * `bounding_box_json_key`: the bounding box key for prediction output. Required if your model version perform image object detection. Learn [how to configure prediction keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
        """
        return pulumi.get(self, "bigquery_import_keys")

    @bigquery_import_keys.setter
    def bigquery_import_keys(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "bigquery_import_keys", value)

    @property
    @pulumi.getter(name="boundingPolyConfig")
    def bounding_poly_config(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1BoundingPolyConfigArgs']]:
        """
        Specify this field if your model version performs image object detection (bounding box detection). `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet.
        """
        return pulumi.get(self, "bounding_poly_config")

    @bounding_poly_config.setter
    def bounding_poly_config(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1BoundingPolyConfigArgs']]):
        pulumi.set(self, "bounding_poly_config", value)

    @property
    @pulumi.getter(name="evaluationConfig")
    def evaluation_config(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1EvaluationConfigArgs']]:
        """
        Required. Details for calculating evaluation metrics and creating Evaulations. If your model version performs image object detection, you must specify the `boundingBoxEvaluationOptions` field within this configuration. Otherwise, provide an empty object for this configuration.
        """
        return pulumi.get(self, "evaluation_config")

    @evaluation_config.setter
    def evaluation_config(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1EvaluationConfigArgs']]):
        pulumi.set(self, "evaluation_config", value)

    @property
    @pulumi.getter(name="evaluationJobAlertConfig")
    def evaluation_job_alert_config(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigArgs']]:
        """
        Optional. Configuration details for evaluation job alerts. Specify this field if you want to receive email alerts if the evaluation job finds that your predictions have low mean average precision during a run.
        """
        return pulumi.get(self, "evaluation_job_alert_config")

    @evaluation_job_alert_config.setter
    def evaluation_job_alert_config(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigArgs']]):
        pulumi.set(self, "evaluation_job_alert_config", value)

    @property
    @pulumi.getter(name="exampleCount")
    def example_count(self) -> Optional[pulumi.Input[int]]:
        """
        Required. The maximum number of predictions to sample and save to BigQuery during each evaluation interval. This limit overrides `example_sample_percentage`: even if the service has not sampled enough predictions to fulfill `example_sample_perecentage` during an interval, it stops sampling predictions when it meets this limit.
        """
        return pulumi.get(self, "example_count")

    @example_count.setter
    def example_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "example_count", value)

    @property
    @pulumi.getter(name="exampleSamplePercentage")
    def example_sample_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        Required. Fraction of predictions to sample and save to BigQuery during each evaluation interval. For example, 0.1 means 10% of predictions served by your model version get saved to BigQuery.
        """
        return pulumi.get(self, "example_sample_percentage")

    @example_sample_percentage.setter
    def example_sample_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "example_sample_percentage", value)

    @property
    @pulumi.getter(name="humanAnnotationConfig")
    def human_annotation_config(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1HumanAnnotationConfigArgs']]:
        """
        Optional. Details for human annotation of your data. If you set labelMissingGroundTruth to `true` for this evaluation job, then you must specify this field. If you plan to provide your own ground truth labels, then omit this field. Note that you must create an Instruction resource before you can specify this field. Provide the name of the instruction resource in the `instruction` field within this configuration.
        """
        return pulumi.get(self, "human_annotation_config")

    @human_annotation_config.setter
    def human_annotation_config(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1HumanAnnotationConfigArgs']]):
        pulumi.set(self, "human_annotation_config", value)

    @property
    @pulumi.getter(name="imageClassificationConfig")
    def image_classification_config(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1ImageClassificationConfigArgs']]:
        """
        Specify this field if your model version performs image classification or general classification. `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet. `allowMultiLabel` in this configuration must match `classificationMetadata.isMultiLabel` in input_config.
        """
        return pulumi.get(self, "image_classification_config")

    @image_classification_config.setter
    def image_classification_config(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1ImageClassificationConfigArgs']]):
        pulumi.set(self, "image_classification_config", value)

    @property
    @pulumi.getter(name="inputConfig")
    def input_config(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1InputConfigArgs']]:
        """
        Rquired. Details for the sampled prediction input. Within this configuration, there are requirements for several fields: * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`. * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`, `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`, or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection). * If your machine learning model performs classification, you must specify `classificationMetadata.isMultiLabel`. * You must specify `bigquerySource` (not `gcsSource`).
        """
        return pulumi.get(self, "input_config")

    @input_config.setter
    def input_config(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1InputConfigArgs']]):
        pulumi.set(self, "input_config", value)

    @property
    @pulumi.getter(name="textClassificationConfig")
    def text_classification_config(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1TextClassificationConfigArgs']]:
        """
        Specify this field if your model version performs text classification. `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet. `allowMultiLabel` in this configuration must match `classificationMetadata.isMultiLabel` in input_config.
        """
        return pulumi.get(self, "text_classification_config")

    @text_classification_config.setter
    def text_classification_config(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1TextClassificationConfigArgs']]):
        pulumi.set(self, "text_classification_config", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1GcsSourceArgs:
    def __init__(__self__, *,
                 input_uri: Optional[pulumi.Input[str]] = None,
                 mime_type: Optional[pulumi.Input[str]] = None):
        """
        Source of the Cloud Storage file to be imported.
        :param pulumi.Input[str] input_uri: Required. The input URI of source file. This must be a Cloud Storage path (`gs://...`).
        :param pulumi.Input[str] mime_type: Required. The format of the source file. Only "text/csv" is supported.
        """
        if input_uri is not None:
            pulumi.set(__self__, "input_uri", input_uri)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)

    @property
    @pulumi.getter(name="inputUri")
    def input_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The input URI of source file. This must be a Cloud Storage path (`gs://...`).
        """
        return pulumi.get(self, "input_uri")

    @input_uri.setter
    def input_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_uri", value)

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The format of the source file. Only "text/csv" is supported.
        """
        return pulumi.get(self, "mime_type")

    @mime_type.setter
    def mime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mime_type", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1HumanAnnotationConfigArgs:
    def __init__(__self__, *,
                 annotated_dataset_description: Optional[pulumi.Input[str]] = None,
                 annotated_dataset_display_name: Optional[pulumi.Input[str]] = None,
                 contributor_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instruction: Optional[pulumi.Input[str]] = None,
                 label_group: Optional[pulumi.Input[str]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 question_duration: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 user_email_address: Optional[pulumi.Input[str]] = None):
        """
        Configuration for how human labeling task should be done.
        :param pulumi.Input[str] annotated_dataset_description: Optional. A human-readable description for AnnotatedDataset. The description can be up to 10000 characters long.
        :param pulumi.Input[str] annotated_dataset_display_name: Required. A human-readable name for AnnotatedDataset defined by users. Maximum of 64 characters .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contributor_emails: Optional. If you want your own labeling contributors to manage and work on this labeling request, you can set these contributors here. We will give them access to the question types in crowdcompute. Note that these emails must be registered in crowdcompute worker UI: https://crowd-compute.appspot.com/
        :param pulumi.Input[str] instruction: Required. Instruction resource name.
        :param pulumi.Input[str] label_group: Optional. A human-readable label used to logically group labeling tasks. This string must match the regular expression `[a-zA-Z\\d_-]{0,128}`.
        :param pulumi.Input[str] language_code: Optional. The Language of this question, as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US. Only need to set this when task is language related. For example, French text classification.
        :param pulumi.Input[str] question_duration: Optional. Maximum duration for contributors to answer a question. Maximum is 3600 seconds. Default is 3600 seconds.
        :param pulumi.Input[int] replica_count: Optional. Replication of questions. Each question will be sent to up to this number of contributors to label. Aggregated answers will be returned. Default is set to 1. For image related labeling, valid values are 1, 3, 5.
        :param pulumi.Input[str] user_email_address: Email of the user who started the labeling task and should be notified by email. If empty no notification will be sent.
        """
        if annotated_dataset_description is not None:
            pulumi.set(__self__, "annotated_dataset_description", annotated_dataset_description)
        if annotated_dataset_display_name is not None:
            pulumi.set(__self__, "annotated_dataset_display_name", annotated_dataset_display_name)
        if contributor_emails is not None:
            pulumi.set(__self__, "contributor_emails", contributor_emails)
        if instruction is not None:
            pulumi.set(__self__, "instruction", instruction)
        if label_group is not None:
            pulumi.set(__self__, "label_group", label_group)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if question_duration is not None:
            pulumi.set(__self__, "question_duration", question_duration)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if user_email_address is not None:
            pulumi.set(__self__, "user_email_address", user_email_address)

    @property
    @pulumi.getter(name="annotatedDatasetDescription")
    def annotated_dataset_description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A human-readable description for AnnotatedDataset. The description can be up to 10000 characters long.
        """
        return pulumi.get(self, "annotated_dataset_description")

    @annotated_dataset_description.setter
    def annotated_dataset_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotated_dataset_description", value)

    @property
    @pulumi.getter(name="annotatedDatasetDisplayName")
    def annotated_dataset_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. A human-readable name for AnnotatedDataset defined by users. Maximum of 64 characters .
        """
        return pulumi.get(self, "annotated_dataset_display_name")

    @annotated_dataset_display_name.setter
    def annotated_dataset_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotated_dataset_display_name", value)

    @property
    @pulumi.getter(name="contributorEmails")
    def contributor_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. If you want your own labeling contributors to manage and work on this labeling request, you can set these contributors here. We will give them access to the question types in crowdcompute. Note that these emails must be registered in crowdcompute worker UI: https://crowd-compute.appspot.com/
        """
        return pulumi.get(self, "contributor_emails")

    @contributor_emails.setter
    def contributor_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contributor_emails", value)

    @property
    @pulumi.getter
    def instruction(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Instruction resource name.
        """
        return pulumi.get(self, "instruction")

    @instruction.setter
    def instruction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instruction", value)

    @property
    @pulumi.getter(name="labelGroup")
    def label_group(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A human-readable label used to logically group labeling tasks. This string must match the regular expression `[a-zA-Z\\d_-]{0,128}`.
        """
        return pulumi.get(self, "label_group")

    @label_group.setter
    def label_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_group", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Language of this question, as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US. Only need to set this when task is language related. For example, French text classification.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="questionDuration")
    def question_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Maximum duration for contributors to answer a question. Maximum is 3600 seconds. Default is 3600 seconds.
        """
        return pulumi.get(self, "question_duration")

    @question_duration.setter
    def question_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "question_duration", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Replication of questions. Each question will be sent to up to this number of contributors to label. Aggregated answers will be returned. Default is set to 1. For image related labeling, valid values are 1, 3, 5.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="userEmailAddress")
    def user_email_address(self) -> Optional[pulumi.Input[str]]:
        """
        Email of the user who started the labeling task and should be notified by email. If empty no notification will be sent.
        """
        return pulumi.get(self, "user_email_address")

    @user_email_address.setter
    def user_email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_email_address", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1ImageClassificationConfigArgs:
    def __init__(__self__, *,
                 allow_multi_label: Optional[pulumi.Input[bool]] = None,
                 annotation_spec_set: Optional[pulumi.Input[str]] = None,
                 answer_aggregation_type: Optional[pulumi.Input[str]] = None):
        """
        Config for image classification human labeling task.
        :param pulumi.Input[bool] allow_multi_label: Optional. If allow_multi_label is true, contributors are able to choose multiple labels for one image.
        :param pulumi.Input[str] annotation_spec_set: Required. Annotation spec set resource name.
        :param pulumi.Input[str] answer_aggregation_type: Optional. The type of how to aggregate answers.
        """
        if allow_multi_label is not None:
            pulumi.set(__self__, "allow_multi_label", allow_multi_label)
        if annotation_spec_set is not None:
            pulumi.set(__self__, "annotation_spec_set", annotation_spec_set)
        if answer_aggregation_type is not None:
            pulumi.set(__self__, "answer_aggregation_type", answer_aggregation_type)

    @property
    @pulumi.getter(name="allowMultiLabel")
    def allow_multi_label(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If allow_multi_label is true, contributors are able to choose multiple labels for one image.
        """
        return pulumi.get(self, "allow_multi_label")

    @allow_multi_label.setter
    def allow_multi_label(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_multi_label", value)

    @property
    @pulumi.getter(name="annotationSpecSet")
    def annotation_spec_set(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Annotation spec set resource name.
        """
        return pulumi.get(self, "annotation_spec_set")

    @annotation_spec_set.setter
    def annotation_spec_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation_spec_set", value)

    @property
    @pulumi.getter(name="answerAggregationType")
    def answer_aggregation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The type of how to aggregate answers.
        """
        return pulumi.get(self, "answer_aggregation_type")

    @answer_aggregation_type.setter
    def answer_aggregation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "answer_aggregation_type", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1InputConfigArgs:
    def __init__(__self__, *,
                 annotation_type: Optional[pulumi.Input[str]] = None,
                 bigquery_source: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1BigQuerySourceArgs']] = None,
                 classification_metadata: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1ClassificationMetadataArgs']] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 gcs_source: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1GcsSourceArgs']] = None,
                 text_metadata: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1TextMetadataArgs']] = None):
        """
        The configuration of input data, including data type, location, etc.
        :param pulumi.Input[str] annotation_type: Optional. The type of annotation to be performed on this data. You must specify this field if you are using this InputConfig in an EvaluationJob.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1BigQuerySourceArgs'] bigquery_source: Source located in BigQuery. You must specify this field if you are using this InputConfig in an EvaluationJob.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1ClassificationMetadataArgs'] classification_metadata: Optional. Metadata about annotations for the input. You must specify this field if you are using this InputConfig in an EvaluationJob for a model version that performs classification.
        :param pulumi.Input[str] data_type: Required. Data type must be specifed when user tries to import data.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1GcsSourceArgs'] gcs_source: Source located in Cloud Storage.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1TextMetadataArgs'] text_metadata: Required for text import, as language code must be specified.
        """
        if annotation_type is not None:
            pulumi.set(__self__, "annotation_type", annotation_type)
        if bigquery_source is not None:
            pulumi.set(__self__, "bigquery_source", bigquery_source)
        if classification_metadata is not None:
            pulumi.set(__self__, "classification_metadata", classification_metadata)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if gcs_source is not None:
            pulumi.set(__self__, "gcs_source", gcs_source)
        if text_metadata is not None:
            pulumi.set(__self__, "text_metadata", text_metadata)

    @property
    @pulumi.getter(name="annotationType")
    def annotation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The type of annotation to be performed on this data. You must specify this field if you are using this InputConfig in an EvaluationJob.
        """
        return pulumi.get(self, "annotation_type")

    @annotation_type.setter
    def annotation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation_type", value)

    @property
    @pulumi.getter(name="bigquerySource")
    def bigquery_source(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1BigQuerySourceArgs']]:
        """
        Source located in BigQuery. You must specify this field if you are using this InputConfig in an EvaluationJob.
        """
        return pulumi.get(self, "bigquery_source")

    @bigquery_source.setter
    def bigquery_source(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1BigQuerySourceArgs']]):
        pulumi.set(self, "bigquery_source", value)

    @property
    @pulumi.getter(name="classificationMetadata")
    def classification_metadata(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1ClassificationMetadataArgs']]:
        """
        Optional. Metadata about annotations for the input. You must specify this field if you are using this InputConfig in an EvaluationJob for a model version that performs classification.
        """
        return pulumi.get(self, "classification_metadata")

    @classification_metadata.setter
    def classification_metadata(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1ClassificationMetadataArgs']]):
        pulumi.set(self, "classification_metadata", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Data type must be specifed when user tries to import data.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="gcsSource")
    def gcs_source(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1GcsSourceArgs']]:
        """
        Source located in Cloud Storage.
        """
        return pulumi.get(self, "gcs_source")

    @gcs_source.setter
    def gcs_source(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1GcsSourceArgs']]):
        pulumi.set(self, "gcs_source", value)

    @property
    @pulumi.getter(name="textMetadata")
    def text_metadata(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1TextMetadataArgs']]:
        """
        Required for text import, as language code must be specified.
        """
        return pulumi.get(self, "text_metadata")

    @text_metadata.setter
    def text_metadata(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1TextMetadataArgs']]):
        pulumi.set(self, "text_metadata", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1OperatorFeedbackMetadataArgs:
    def __init__(__self__):
        """
        Metadata describing the feedback from the operator.
        """
        pass


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1PdfInstructionArgs:
    def __init__(__self__, *,
                 gcs_file_uri: Optional[pulumi.Input[str]] = None):
        """
        Instruction from a PDF file.
        :param pulumi.Input[str] gcs_file_uri: PDF file for the instruction. Only gcs path is allowed.
        """
        if gcs_file_uri is not None:
            pulumi.set(__self__, "gcs_file_uri", gcs_file_uri)

    @property
    @pulumi.getter(name="gcsFileUri")
    def gcs_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        PDF file for the instruction. Only gcs path is allowed.
        """
        return pulumi.get(self, "gcs_file_uri")

    @gcs_file_uri.setter
    def gcs_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcs_file_uri", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1RequesterFeedbackMetadataArgs:
    def __init__(__self__):
        """
        Metadata describing the feedback from the labeling task requester.
        """
        pass


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1SentimentConfigArgs:
    def __init__(__self__, *,
                 enable_label_sentiment_selection: Optional[pulumi.Input[bool]] = None):
        """
        Config for setting up sentiments.
        :param pulumi.Input[bool] enable_label_sentiment_selection: If set to true, contributors will have the option to select sentiment of the label they selected, to mark it as negative or positive label. Default is false.
        """
        if enable_label_sentiment_selection is not None:
            pulumi.set(__self__, "enable_label_sentiment_selection", enable_label_sentiment_selection)

    @property
    @pulumi.getter(name="enableLabelSentimentSelection")
    def enable_label_sentiment_selection(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, contributors will have the option to select sentiment of the label they selected, to mark it as negative or positive label. Default is false.
        """
        return pulumi.get(self, "enable_label_sentiment_selection")

    @enable_label_sentiment_selection.setter
    def enable_label_sentiment_selection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_label_sentiment_selection", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1TextClassificationConfigArgs:
    def __init__(__self__, *,
                 allow_multi_label: Optional[pulumi.Input[bool]] = None,
                 annotation_spec_set: Optional[pulumi.Input[str]] = None,
                 sentiment_config: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1SentimentConfigArgs']] = None):
        """
        Config for text classification human labeling task.
        :param pulumi.Input[bool] allow_multi_label: Optional. If allow_multi_label is true, contributors are able to choose multiple labels for one text segment.
        :param pulumi.Input[str] annotation_spec_set: Required. Annotation spec set resource name.
        :param pulumi.Input['GoogleCloudDatalabelingV1beta1SentimentConfigArgs'] sentiment_config: Optional. Configs for sentiment selection. We deprecate sentiment analysis in data labeling side as it is incompatible with uCAIP.
        """
        if allow_multi_label is not None:
            pulumi.set(__self__, "allow_multi_label", allow_multi_label)
        if annotation_spec_set is not None:
            pulumi.set(__self__, "annotation_spec_set", annotation_spec_set)
        if sentiment_config is not None:
            pulumi.set(__self__, "sentiment_config", sentiment_config)

    @property
    @pulumi.getter(name="allowMultiLabel")
    def allow_multi_label(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If allow_multi_label is true, contributors are able to choose multiple labels for one text segment.
        """
        return pulumi.get(self, "allow_multi_label")

    @allow_multi_label.setter
    def allow_multi_label(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_multi_label", value)

    @property
    @pulumi.getter(name="annotationSpecSet")
    def annotation_spec_set(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Annotation spec set resource name.
        """
        return pulumi.get(self, "annotation_spec_set")

    @annotation_spec_set.setter
    def annotation_spec_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation_spec_set", value)

    @property
    @pulumi.getter(name="sentimentConfig")
    def sentiment_config(self) -> Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1SentimentConfigArgs']]:
        """
        Optional. Configs for sentiment selection. We deprecate sentiment analysis in data labeling side as it is incompatible with uCAIP.
        """
        return pulumi.get(self, "sentiment_config")

    @sentiment_config.setter
    def sentiment_config(self, value: Optional[pulumi.Input['GoogleCloudDatalabelingV1beta1SentimentConfigArgs']]):
        pulumi.set(self, "sentiment_config", value)


@pulumi.input_type
class GoogleCloudDatalabelingV1beta1TextMetadataArgs:
    def __init__(__self__, *,
                 language_code: Optional[pulumi.Input[str]] = None):
        """
        Metadata for the text.
        :param pulumi.Input[str] language_code: The language of this text, as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US.
        """
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        The language of this text, as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)


@pulumi.input_type
class GoogleRpcStatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param pulumi.Input[int] code: The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param pulumi.Input[str] message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


