# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ArtifactResponse',
    'AttestationAuthorityHintResponse',
    'AttestationAuthorityResponse',
    'AttestationResponse',
    'BasisResponse',
    'BindingResponse',
    'BuildDetailsResponse',
    'BuildProvenanceResponse',
    'BuildSignatureResponse',
    'BuildTypeResponse',
    'CommandResponse',
    'DeployableResponse',
    'DeploymentResponse',
    'DerivedResponse',
    'DetailResponse',
    'DiscoveredResponse',
    'DiscoveryResponse',
    'DistributionResponse',
    'ExprResponse',
    'FingerprintResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse',
    'HashResponse',
    'InstallationResponse',
    'LayerResponse',
    'LocationResponse',
    'PackageIssueResponse',
    'PackageResponse',
    'PgpSignedAttestationResponse',
    'RelatedUrlResponse',
    'RepoSourceResponse',
    'ResourceResponse',
    'SourceResponse',
    'StatusResponse',
    'StorageSourceResponse',
    'UpgradeDistributionResponse',
    'UpgradeNoteResponse',
    'UpgradeOccurrenceResponse',
    'VersionResponse',
    'VulnerabilityDetailsResponse',
    'VulnerabilityLocationResponse',
    'VulnerabilityTypeResponse',
]

@pulumi.output_type
class ArtifactResponse(dict):
    """
    Artifact describes a build product.
    """
    def __init__(__self__, *,
                 checksum: str,
                 names: Sequence[str]):
        """
        Artifact describes a build product.
        :param str checksum: Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        :param Sequence[str] names: Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        return pulumi.get(self, "names")


@pulumi.output_type
class AttestationAuthorityHintResponse(dict):
    """
    This submessage provides human-readable hints about the purpose of the AttestationAuthority. Because the name of a Note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should NOT be used to look up AttestationAuthorities in security sensitive contexts, such as when looking up Attestations to verify.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "humanReadableName":
            suggest = "human_readable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttestationAuthorityHintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttestationAuthorityHintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttestationAuthorityHintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 human_readable_name: str):
        """
        This submessage provides human-readable hints about the purpose of the AttestationAuthority. Because the name of a Note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should NOT be used to look up AttestationAuthorities in security sensitive contexts, such as when looking up Attestations to verify.
        :param str human_readable_name: The human readable name of this Attestation Authority, for example "qa".
        """
        pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> str:
        """
        The human readable name of this Attestation Authority, for example "qa".
        """
        return pulumi.get(self, "human_readable_name")


@pulumi.output_type
class AttestationAuthorityResponse(dict):
    """
    Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `AttestationAuthority` for "QA" and one for "build". This Note is intended to act strictly as a grouping mechanism for the attached Occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an Occurrence to a given Note. It also provides a single point of lookup to find all attached Attestation Occurrences, even if they don't all live in the same project.
    """
    def __init__(__self__, *,
                 hint: 'outputs.AttestationAuthorityHintResponse'):
        """
        Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `AttestationAuthority` for "QA" and one for "build". This Note is intended to act strictly as a grouping mechanism for the attached Occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an Occurrence to a given Note. It also provides a single point of lookup to find all attached Attestation Occurrences, even if they don't all live in the same project.
        """
        pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> 'outputs.AttestationAuthorityHintResponse':
        return pulumi.get(self, "hint")


@pulumi.output_type
class AttestationResponse(dict):
    """
    Occurrence that represents a single "attestation". The authenticity of an Attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the AttestationAuthority to which this Attestation is attached is primarily useful for look-up (how to find this Attestation if you already know the Authority and artifact to be verified) and intent (which authority was this attestation intended to sign for).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pgpSignedAttestation":
            suggest = "pgp_signed_attestation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttestationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttestationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttestationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pgp_signed_attestation: 'outputs.PgpSignedAttestationResponse'):
        """
        Occurrence that represents a single "attestation". The authenticity of an Attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the AttestationAuthority to which this Attestation is attached is primarily useful for look-up (how to find this Attestation if you already know the Authority and artifact to be verified) and intent (which authority was this attestation intended to sign for).
        """
        pulumi.set(__self__, "pgp_signed_attestation", pgp_signed_attestation)

    @property
    @pulumi.getter(name="pgpSignedAttestation")
    def pgp_signed_attestation(self) -> 'outputs.PgpSignedAttestationResponse':
        return pulumi.get(self, "pgp_signed_attestation")


@pulumi.output_type
class BasisResponse(dict):
    """
    Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g. a tag of the resource_url.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUrl":
            suggest = "resource_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BasisResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BasisResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BasisResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fingerprint: 'outputs.FingerprintResponse',
                 resource_url: str):
        """
        Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g. a tag of the resource_url.
        :param 'FingerprintResponse' fingerprint: The fingerprint of the base image.
        :param str resource_url: The resource_url for the resource representing the basis of associated occurrence images.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter
    def fingerprint(self) -> 'outputs.FingerprintResponse':
        """
        The fingerprint of the base image.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> str:
        """
        The resource_url for the resource representing the basis of associated occurrence images.
        """
        return pulumi.get(self, "resource_url")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members` with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members` with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class BuildDetailsResponse(dict):
    """
    Message encapsulating build provenance details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provenanceBytes":
            suggest = "provenance_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provenance: 'outputs.BuildProvenanceResponse',
                 provenance_bytes: str):
        """
        Message encapsulating build provenance details.
        :param 'BuildProvenanceResponse' provenance: The actual provenance
        :param str provenance_bytes: Serialized JSON representation of the provenance, used in generating the `BuildSignature` in the corresponding Result. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        pulumi.set(__self__, "provenance", provenance)
        pulumi.set(__self__, "provenance_bytes", provenance_bytes)

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.BuildProvenanceResponse':
        """
        The actual provenance
        """
        return pulumi.get(self, "provenance")

    @property
    @pulumi.getter(name="provenanceBytes")
    def provenance_bytes(self) -> str:
        """
        Serialized JSON representation of the provenance, used in generating the `BuildSignature` in the corresponding Result. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        return pulumi.get(self, "provenance_bytes")


@pulumi.output_type
class BuildProvenanceResponse(dict):
    """
    Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildOptions":
            suggest = "build_options"
        elif key == "builderVersion":
            suggest = "builder_version"
        elif key == "builtArtifacts":
            suggest = "built_artifacts"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "finishTime":
            suggest = "finish_time"
        elif key == "logsBucket":
            suggest = "logs_bucket"
        elif key == "sourceProvenance":
            suggest = "source_provenance"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "triggerId":
            suggest = "trigger_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildProvenanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildProvenanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildProvenanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_options: Mapping[str, str],
                 builder_version: str,
                 built_artifacts: Sequence['outputs.ArtifactResponse'],
                 commands: Sequence['outputs.CommandResponse'],
                 create_time: str,
                 creator: str,
                 finish_time: str,
                 logs_bucket: str,
                 project: str,
                 source_provenance: 'outputs.SourceResponse',
                 start_time: str,
                 trigger_id: str):
        """
        Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
        :param Mapping[str, str] build_options: Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        :param str builder_version: Version string of the builder at the time this build was executed.
        :param Sequence['ArtifactResponse'] built_artifacts: Output of the build.
        :param Sequence['CommandResponse'] commands: Commands requested by the build.
        :param str create_time: Time at which the build was created.
        :param str creator: E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        :param str finish_time: Time at which execution of the build was finished.
        :param str logs_bucket: Google Cloud Storage bucket where logs were written.
        :param str project: ID of the project.
        :param 'SourceResponse' source_provenance: Details of the Source input to the build.
        :param str start_time: Time at which execution of the build was started.
        :param str trigger_id: Trigger identifier if the build was triggered automatically; empty if not.
        """
        pulumi.set(__self__, "build_options", build_options)
        pulumi.set(__self__, "builder_version", builder_version)
        pulumi.set(__self__, "built_artifacts", built_artifacts)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creator", creator)
        pulumi.set(__self__, "finish_time", finish_time)
        pulumi.set(__self__, "logs_bucket", logs_bucket)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "source_provenance", source_provenance)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "trigger_id", trigger_id)

    @property
    @pulumi.getter(name="buildOptions")
    def build_options(self) -> Mapping[str, str]:
        """
        Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        """
        return pulumi.get(self, "build_options")

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> str:
        """
        Version string of the builder at the time this build was executed.
        """
        return pulumi.get(self, "builder_version")

    @property
    @pulumi.getter(name="builtArtifacts")
    def built_artifacts(self) -> Sequence['outputs.ArtifactResponse']:
        """
        Output of the build.
        """
        return pulumi.get(self, "built_artifacts")

    @property
    @pulumi.getter
    def commands(self) -> Sequence['outputs.CommandResponse']:
        """
        Commands requested by the build.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time at which the build was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> str:
        """
        E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> str:
        """
        Time at which execution of the build was finished.
        """
        return pulumi.get(self, "finish_time")

    @property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> str:
        """
        Google Cloud Storage bucket where logs were written.
        """
        return pulumi.get(self, "logs_bucket")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sourceProvenance")
    def source_provenance(self) -> 'outputs.SourceResponse':
        """
        Details of the Source input to the build.
        """
        return pulumi.get(self, "source_provenance")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time at which execution of the build was started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> str:
        """
        Trigger identifier if the build was triggered automatically; empty if not.
        """
        return pulumi.get(self, "trigger_id")


@pulumi.output_type
class BuildSignatureResponse(dict):
    """
    Message encapsulating the signature of the verified build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildSignatureResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildSignatureResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildSignatureResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str,
                 key_type: str,
                 public_key: str,
                 signature: str):
        """
        Message encapsulating the signature of the verified build.
        :param str key_id: An Id for the key used to sign. This could be either an Id for the key stored in `public_key` (such as the Id or fingerprint for a PGP key, or the CN for a cert), or a reference to an external key (such as a reference to a key in Cloud Key Management Service).
        :param str key_type: The type of the key, either stored in `public_key` or referenced in `key_id`
        :param str public_key: Public key of the builder which can be used to verify that the related findings are valid and unchanged. If `key_type` is empty, this defaults to PEM encoded public keys. This field may be empty if `key_id` references an external key. For Cloud Build based signatures, this is a PEM encoded public key. To verify the Cloud Build signature, place the contents of this field into a file (public.pem). The signature field is base64-decoded into its binary representation in signature.bin, and the provenance bytes from `BuildDetails` are base64-decoded into a binary representation in signed.bin. OpenSSL can then verify the signature: `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
        :param str signature: Signature of the related `BuildProvenance`, encoded in a base64 string.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        An Id for the key used to sign. This could be either an Id for the key stored in `public_key` (such as the Id or fingerprint for a PGP key, or the CN for a cert), or a reference to an external key (such as a reference to a key in Cloud Key Management Service).
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> str:
        """
        The type of the key, either stored in `public_key` or referenced in `key_id`
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        Public key of the builder which can be used to verify that the related findings are valid and unchanged. If `key_type` is empty, this defaults to PEM encoded public keys. This field may be empty if `key_id` references an external key. For Cloud Build based signatures, this is a PEM encoded public key. To verify the Cloud Build signature, place the contents of this field into a file (public.pem). The signature field is base64-decoded into its binary representation in signature.bin, and the provenance bytes from `BuildDetails` are base64-decoded into a binary representation in signed.bin. OpenSSL can then verify the signature: `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def signature(self) -> str:
        """
        Signature of the related `BuildProvenance`, encoded in a base64 string.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class BuildTypeResponse(dict):
    """
    Note holding the version of the provider's builder and the signature of the provenance message in linked BuildDetails.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "builderVersion":
            suggest = "builder_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 builder_version: str,
                 signature: 'outputs.BuildSignatureResponse'):
        """
        Note holding the version of the provider's builder and the signature of the provenance message in linked BuildDetails.
        :param str builder_version: Version of the builder which produced this Note.
        :param 'BuildSignatureResponse' signature: Signature of the build in Occurrences pointing to the Note containing this `BuilderDetails`.
        """
        pulumi.set(__self__, "builder_version", builder_version)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> str:
        """
        Version of the builder which produced this Note.
        """
        return pulumi.get(self, "builder_version")

    @property
    @pulumi.getter
    def signature(self) -> 'outputs.BuildSignatureResponse':
        """
        Signature of the build in Occurrences pointing to the Note containing this `BuilderDetails`.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class CommandResponse(dict):
    """
    Command describes a step performed as part of the build pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "waitFor":
            suggest = "wait_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommandResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommandResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommandResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 dir: str,
                 env: Sequence[str],
                 name: str,
                 wait_for: Sequence[str]):
        """
        Command describes a step performed as part of the build pipeline.
        :param Sequence[str] args: Command-line arguments used when executing this Command.
        :param str dir: Working directory (relative to project source root) used when running this Command.
        :param Sequence[str] env: Environment variables set before running this Command.
        :param str name: Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        :param Sequence[str] wait_for: The ID(s) of the Command(s) that this Command depends on.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "wait_for", wait_for)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Command-line arguments used when executing this Command.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def dir(self) -> str:
        """
        Working directory (relative to project source root) used when running this Command.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter
    def env(self) -> Sequence[str]:
        """
        Environment variables set before running this Command.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Sequence[str]:
        """
        The ID(s) of the Command(s) that this Command depends on.
        """
        return pulumi.get(self, "wait_for")


@pulumi.output_type
class DeployableResponse(dict):
    """
    An artifact that can be deployed in some runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeployableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeployableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeployableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_uri: Sequence[str]):
        """
        An artifact that can be deployed in some runtime.
        :param Sequence[str] resource_uri: Resource URI for the artifact being deployed.
        """
        pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Sequence[str]:
        """
        Resource URI for the artifact being deployed.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class DeploymentResponse(dict):
    """
    The period during which some deployable was active in a runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployTime":
            suggest = "deploy_time"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "undeployTime":
            suggest = "undeploy_time"
        elif key == "userEmail":
            suggest = "user_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 config: str,
                 deploy_time: str,
                 platform: str,
                 resource_uri: Sequence[str],
                 undeploy_time: str,
                 user_email: str):
        """
        The period during which some deployable was active in a runtime.
        :param str address: Address of the runtime element hosting this deployment.
        :param str config: Configuration used to create this deployment.
        :param str deploy_time: Beginning of the lifetime of this deployment.
        :param str platform: Platform hosting this deployment.
        :param Sequence[str] resource_uri: Resource URI for the artifact being deployed taken from the deployable field with the same name.
        :param str undeploy_time: End of the lifetime of this deployment.
        :param str user_email: Identity of the user that triggered this deployment.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "deploy_time", deploy_time)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "resource_uri", resource_uri)
        pulumi.set(__self__, "undeploy_time", undeploy_time)
        pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Address of the runtime element hosting this deployment.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def config(self) -> str:
        """
        Configuration used to create this deployment.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="deployTime")
    def deploy_time(self) -> str:
        """
        Beginning of the lifetime of this deployment.
        """
        return pulumi.get(self, "deploy_time")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        Platform hosting this deployment.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Sequence[str]:
        """
        Resource URI for the artifact being deployed taken from the deployable field with the same name.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter(name="undeployTime")
    def undeploy_time(self) -> str:
        """
        End of the lifetime of this deployment.
        """
        return pulumi.get(self, "undeploy_time")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> str:
        """
        Identity of the user that triggered this deployment.
        """
        return pulumi.get(self, "user_email")


@pulumi.output_type
class DerivedResponse(dict):
    """
    Derived describes the derived image portion (Occurrence) of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseResourceUrl":
            suggest = "base_resource_url"
        elif key == "layerInfo":
            suggest = "layer_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DerivedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DerivedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DerivedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_resource_url: str,
                 distance: int,
                 fingerprint: 'outputs.FingerprintResponse',
                 layer_info: Sequence['outputs.LayerResponse']):
        """
        Derived describes the derived image portion (Occurrence) of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
        :param str base_resource_url: This contains the base image URL for the derived image occurrence.
        :param int distance: The number of layers by which this image differs from the associated image basis.
        :param 'FingerprintResponse' fingerprint: The fingerprint of the derived image.
        :param Sequence['LayerResponse'] layer_info: This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        pulumi.set(__self__, "base_resource_url", base_resource_url)
        pulumi.set(__self__, "distance", distance)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "layer_info", layer_info)

    @property
    @pulumi.getter(name="baseResourceUrl")
    def base_resource_url(self) -> str:
        """
        This contains the base image URL for the derived image occurrence.
        """
        return pulumi.get(self, "base_resource_url")

    @property
    @pulumi.getter
    def distance(self) -> int:
        """
        The number of layers by which this image differs from the associated image basis.
        """
        return pulumi.get(self, "distance")

    @property
    @pulumi.getter
    def fingerprint(self) -> 'outputs.FingerprintResponse':
        """
        The fingerprint of the derived image.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="layerInfo")
    def layer_info(self) -> Sequence['outputs.LayerResponse']:
        """
        This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        return pulumi.get(self, "layer_info")


@pulumi.output_type
class DetailResponse(dict):
    """
    Identifies all occurrences of this vulnerability in the package for a specific distro/location For example: glibc in cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "fixedLocation":
            suggest = "fixed_location"
        elif key == "isObsolete":
            suggest = "is_obsolete"
        elif key == "maxAffectedVersion":
            suggest = "max_affected_version"
        elif key == "minAffectedVersion":
            suggest = "min_affected_version"
        elif key == "packageType":
            suggest = "package_type"
        elif key == "severityName":
            suggest = "severity_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 description: str,
                 fixed_location: 'outputs.VulnerabilityLocationResponse',
                 is_obsolete: bool,
                 max_affected_version: 'outputs.VersionResponse',
                 min_affected_version: 'outputs.VersionResponse',
                 package: str,
                 package_type: str,
                 severity_name: str,
                 source: str,
                 vendor: str):
        """
        Identifies all occurrences of this vulnerability in the package for a specific distro/location For example: glibc in cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
        :param str cpe_uri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        :param str description: A vendor-specific description of this note.
        :param 'VulnerabilityLocationResponse' fixed_location: The fix for this specific package version.
        :param bool is_obsolete: Whether this Detail is obsolete. Occurrences are expected not to point to obsolete details.
        :param 'VersionResponse' max_affected_version: The max version of the package in which the vulnerability exists.
        :param 'VersionResponse' min_affected_version: The min version of the package in which the vulnerability exists.
        :param str package: The name of the package where the vulnerability was found. This field can be used as a filter in list requests.
        :param str package_type: The type of package; whether native or non native(ruby gems, node.js packages etc)
        :param str severity_name: The severity (eg: distro assigned severity) for this vulnerability.
        :param str source: The source from which the information in this Detail was obtained.
        :param str vendor: The vendor of the product. e.g. "google"
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "fixed_location", fixed_location)
        pulumi.set(__self__, "is_obsolete", is_obsolete)
        pulumi.set(__self__, "max_affected_version", max_affected_version)
        pulumi.set(__self__, "min_affected_version", min_affected_version)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "severity_name", severity_name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A vendor-specific description of this note.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fixedLocation")
    def fixed_location(self) -> 'outputs.VulnerabilityLocationResponse':
        """
        The fix for this specific package version.
        """
        return pulumi.get(self, "fixed_location")

    @property
    @pulumi.getter(name="isObsolete")
    def is_obsolete(self) -> bool:
        """
        Whether this Detail is obsolete. Occurrences are expected not to point to obsolete details.
        """
        return pulumi.get(self, "is_obsolete")

    @property
    @pulumi.getter(name="maxAffectedVersion")
    def max_affected_version(self) -> 'outputs.VersionResponse':
        """
        The max version of the package in which the vulnerability exists.
        """
        return pulumi.get(self, "max_affected_version")

    @property
    @pulumi.getter(name="minAffectedVersion")
    def min_affected_version(self) -> 'outputs.VersionResponse':
        """
        The min version of the package in which the vulnerability exists.
        """
        return pulumi.get(self, "min_affected_version")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        The name of the package where the vulnerability was found. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package; whether native or non native(ruby gems, node.js packages etc)
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> str:
        """
        The severity (eg: distro assigned severity) for this vulnerability.
        """
        return pulumi.get(self, "severity_name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source from which the information in this Detail was obtained.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def vendor(self) -> str:
        """
        The vendor of the product. e.g. "google"
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class DiscoveredResponse(dict):
    """
    Provides information about the scan status of a discovered resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisStatus":
            suggest = "analysis_status"
        elif key == "analysisStatusError":
            suggest = "analysis_status_error"
        elif key == "continuousAnalysis":
            suggest = "continuous_analysis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveredResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveredResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveredResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_status: str,
                 analysis_status_error: 'outputs.StatusResponse',
                 continuous_analysis: str,
                 cpe: str):
        """
        Provides information about the scan status of a discovered resource.
        :param str analysis_status: The status of discovery for the resource.
        :param 'StatusResponse' analysis_status_error: When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage output only and populated by the API.
        :param str continuous_analysis: Whether the resource is continuously analyzed.
        :param str cpe: The CPE of the resource being scanned.
        """
        pulumi.set(__self__, "analysis_status", analysis_status)
        pulumi.set(__self__, "analysis_status_error", analysis_status_error)
        pulumi.set(__self__, "continuous_analysis", continuous_analysis)
        pulumi.set(__self__, "cpe", cpe)

    @property
    @pulumi.getter(name="analysisStatus")
    def analysis_status(self) -> str:
        """
        The status of discovery for the resource.
        """
        return pulumi.get(self, "analysis_status")

    @property
    @pulumi.getter(name="analysisStatusError")
    def analysis_status_error(self) -> 'outputs.StatusResponse':
        """
        When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage output only and populated by the API.
        """
        return pulumi.get(self, "analysis_status_error")

    @property
    @pulumi.getter(name="continuousAnalysis")
    def continuous_analysis(self) -> str:
        """
        Whether the resource is continuously analyzed.
        """
        return pulumi.get(self, "continuous_analysis")

    @property
    @pulumi.getter
    def cpe(self) -> str:
        """
        The CPE of the resource being scanned.
        """
        return pulumi.get(self, "cpe")


@pulumi.output_type
class DiscoveryResponse(dict):
    """
    A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis. The occurrence's operation will indicate the status of the analysis. Absence of an occurrence linked to this note for a resource indicates that analysis hasn't started.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisKind":
            suggest = "analysis_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_kind: str):
        """
        A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis. The occurrence's operation will indicate the status of the analysis. Absence of an occurrence linked to this note for a resource indicates that analysis hasn't started.
        :param str analysis_kind: The kind of analysis that is handled by this discovery.
        """
        pulumi.set(__self__, "analysis_kind", analysis_kind)

    @property
    @pulumi.getter(name="analysisKind")
    def analysis_kind(self) -> str:
        """
        The kind of analysis that is handled by this discovery.
        """
        return pulumi.get(self, "analysis_kind")


@pulumi.output_type
class DistributionResponse(dict):
    """
    This represents a particular channel of distribution for a given package. e.g. Debian's jessie-backports dpkg mirror
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "latestVersion":
            suggest = "latest_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architecture: str,
                 cpe_uri: str,
                 description: str,
                 latest_version: 'outputs.VersionResponse',
                 maintainer: str,
                 url: str):
        """
        This represents a particular channel of distribution for a given package. e.g. Debian's jessie-backports dpkg mirror
        :param str architecture: The CPU architecture for which packages in this distribution channel were built
        :param str cpe_uri: The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param str description: The distribution channel-specific description of this package.
        :param 'VersionResponse' latest_version: The latest available version of this package in this distribution channel.
        :param str maintainer: A freeform string denoting the maintainer of this package.
        :param str url: The distribution channel-specific homepage for this package.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "maintainer", maintainer)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        """
        The CPU architecture for which packages in this distribution channel were built
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The distribution channel-specific description of this package.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> 'outputs.VersionResponse':
        """
        The latest available version of this package in this distribution channel.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter
    def maintainer(self) -> str:
        """
        A freeform string denoting the maintainer of this package.
        """
        return pulumi.get(self, "maintainer")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The distribution channel-specific homepage for this package.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class FingerprintResponse(dict):
    """
    A set of properties that uniquely identify a given Docker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "v1Name":
            suggest = "v1_name"
        elif key == "v2Blob":
            suggest = "v2_blob"
        elif key == "v2Name":
            suggest = "v2_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FingerprintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FingerprintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FingerprintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 v1_name: str,
                 v2_blob: Sequence[str],
                 v2_name: str):
        """
        A set of properties that uniquely identify a given Docker image.
        :param str v1_name: The layer-id of the final layer in the Docker image's v1 representation. This field can be used as a filter in list requests.
        :param Sequence[str] v2_blob: The ordered list of v2 blobs that represent a given image.
        :param str v2_name: The name of the image's v2 blobs computed via: [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of the final blob is kept. This field can be used as a filter in list requests.
        """
        pulumi.set(__self__, "v1_name", v1_name)
        pulumi.set(__self__, "v2_blob", v2_blob)
        pulumi.set(__self__, "v2_name", v2_name)

    @property
    @pulumi.getter(name="v1Name")
    def v1_name(self) -> str:
        """
        The layer-id of the final layer in the Docker image's v1 representation. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "v1_name")

    @property
    @pulumi.getter(name="v2Blob")
    def v2_blob(self) -> Sequence[str]:
        """
        The ordered list of v2 blobs that represent a given image.
        """
        return pulumi.get(self, "v2_blob")

    @property
    @pulumi.getter(name="v2Name")
    def v2_name(self) -> str:
        """
        The name of the image's v2 blobs computed via: [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of the final blob is kept. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "v2_name")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse(dict):
    """
    An alias to a repo revision.
    """
    def __init__(__self__, *,
                 kind: str,
                 name: str):
        """
        An alias to a repo revision.
        :param str kind: The alias kind.
        :param str name: The alias name.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The alias kind.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The alias name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse(dict):
    """
    A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aliasContext":
            suggest = "alias_context"
        elif key == "repoId":
            suggest = "repo_id"
        elif key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias_context: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse',
                 repo_id: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse',
                 revision_id: str):
        """
        A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse' alias_context: An alias, which may be a branch or tag.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse' repo_id: The ID of the repo.
        :param str revision_id: A revision ID.
        """
        pulumi.set(__self__, "alias_context", alias_context)
        pulumi.set(__self__, "repo_id", repo_id)
        pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse':
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse':
        """
        The ID of the repo.
        """
        return pulumi.get(self, "repo_id")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        A revision ID.
        """
        return pulumi.get(self, "revision_id")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse(dict):
    """
    A SourceContext referring to a Gerrit project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aliasContext":
            suggest = "alias_context"
        elif key == "gerritProject":
            suggest = "gerrit_project"
        elif key == "hostUri":
            suggest = "host_uri"
        elif key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias_context: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse',
                 gerrit_project: str,
                 host_uri: str,
                 revision_id: str):
        """
        A SourceContext referring to a Gerrit project.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse' alias_context: An alias, which may be a branch or tag.
        :param str gerrit_project: The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        :param str host_uri: The URI of a running Gerrit instance.
        :param str revision_id: A revision (commit) ID.
        """
        pulumi.set(__self__, "alias_context", alias_context)
        pulumi.set(__self__, "gerrit_project", gerrit_project)
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse':
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @property
    @pulumi.getter(name="gerritProject")
    def gerrit_project(self) -> str:
        """
        The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        """
        return pulumi.get(self, "gerrit_project")

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> str:
        """
        The URI of a running Gerrit instance.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        A revision (commit) ID.
        """
        return pulumi.get(self, "revision_id")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse(dict):
    """
    A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision_id: str,
                 url: str):
        """
        A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
        :param str revision_id: Required. Git commit hash.
        :param str url: Git repository URL.
        """
        pulumi.set(__self__, "revision_id", revision_id)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        Required. Git commit hash.
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Git repository URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse(dict):
    """
    Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoName":
            suggest = "repo_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project: str,
                 repo_name: str):
        """
        Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
        :param str project: The ID of the project.
        :param str repo_name: The name of the repo. Leave empty for the default repo.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "repo_name", repo_name)

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        The name of the repo. Leave empty for the default repo.
        """
        return pulumi.get(self, "repo_name")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse(dict):
    """
    A unique identifier for a Cloud Repo.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectRepoId":
            suggest = "project_repo_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_repo_id: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse',
                 uid: str):
        """
        A unique identifier for a Cloud Repo.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse' project_repo_id: A combination of a project ID and a repo name.
        :param str uid: A server-assigned, globally unique identifier.
        """
        pulumi.set(__self__, "project_repo_id", project_repo_id)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="projectRepoId")
    def project_repo_id(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse':
        """
        A combination of a project ID and a repo name.
        """
        return pulumi.get(self, "project_repo_id")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        A server-assigned, globally unique identifier.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse(dict):
    """
    A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRepo":
            suggest = "cloud_repo"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_repo: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse',
                 gerrit: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse',
                 git: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse',
                 labels: Mapping[str, str]):
        """
        A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse' cloud_repo: A SourceContext referring to a revision in a Google Cloud Source Repo.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse' gerrit: A SourceContext referring to a Gerrit project.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse' git: A SourceContext referring to any third party Git repo (e.g., GitHub).
        :param Mapping[str, str] labels: Labels with user defined metadata.
        """
        pulumi.set(__self__, "cloud_repo", cloud_repo)
        pulumi.set(__self__, "gerrit", gerrit)
        pulumi.set(__self__, "git", git)
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="cloudRepo")
    def cloud_repo(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse':
        """
        A SourceContext referring to a revision in a Google Cloud Source Repo.
        """
        return pulumi.get(self, "cloud_repo")

    @property
    @pulumi.getter
    def gerrit(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse':
        """
        A SourceContext referring to a Gerrit project.
        """
        return pulumi.get(self, "gerrit")

    @property
    @pulumi.getter
    def git(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse':
        """
        A SourceContext referring to any third party Git repo (e.g., GitHub).
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels with user defined metadata.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class HashResponse(dict):
    """
    Container message for hash values.
    """
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        Container message for hash values.
        :param str type: The type of hash that was performed.
        :param str value: The hash value.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of hash that was performed.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The hash value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstallationResponse(dict):
    """
    This represents how a particular software package may be installed on a system.
    """
    def __init__(__self__, *,
                 location: Sequence['outputs.LocationResponse'],
                 name: str):
        """
        This represents how a particular software package may be installed on a system.
        :param Sequence['LocationResponse'] location: All of the places within the filesystem versions of this package have been found.
        :param str name: The name of the installed package.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> Sequence['outputs.LocationResponse']:
        """
        All of the places within the filesystem versions of this package have been found.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the installed package.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LayerResponse(dict):
    """
    Layer holds metadata specific to a layer of a Docker image.
    """
    def __init__(__self__, *,
                 arguments: str,
                 directive: str):
        """
        Layer holds metadata specific to a layer of a Docker image.
        :param str arguments: The recovered arguments to the Dockerfile directive.
        :param str directive: The recovered Dockerfile directive used to construct this layer.
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "directive", directive)

    @property
    @pulumi.getter
    def arguments(self) -> str:
        """
        The recovered arguments to the Dockerfile directive.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def directive(self) -> str:
        """
        The recovered Dockerfile directive used to construct this layer.
        """
        return pulumi.get(self, "directive")


@pulumi.output_type
class LocationResponse(dict):
    """
    An occurrence of a particular package installation found within a system's filesystem. e.g. glibc was found in /var/lib/dpkg/status
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 path: str,
                 version: 'outputs.VersionResponse'):
        """
        An occurrence of a particular package installation found within a system's filesystem. e.g. glibc was found in /var/lib/dpkg/status
        :param str cpe_uri: The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param str path: The path from which we gathered that this package/version is installed.
        :param 'VersionResponse' version: The version installed at this location.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path from which we gathered that this package/version is installed.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        The version installed at this location.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PackageIssueResponse(dict):
    """
    This message wraps a location affected by a vulnerability and its associated fix (if one is available).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "affectedLocation":
            suggest = "affected_location"
        elif key == "fixedLocation":
            suggest = "fixed_location"
        elif key == "severityName":
            suggest = "severity_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackageIssueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackageIssueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackageIssueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 affected_location: 'outputs.VulnerabilityLocationResponse',
                 fixed_location: 'outputs.VulnerabilityLocationResponse',
                 severity_name: str):
        """
        This message wraps a location affected by a vulnerability and its associated fix (if one is available).
        :param 'VulnerabilityLocationResponse' affected_location: The location of the vulnerability.
        :param 'VulnerabilityLocationResponse' fixed_location: The location of the available fix for vulnerability.
        """
        pulumi.set(__self__, "affected_location", affected_location)
        pulumi.set(__self__, "fixed_location", fixed_location)
        pulumi.set(__self__, "severity_name", severity_name)

    @property
    @pulumi.getter(name="affectedLocation")
    def affected_location(self) -> 'outputs.VulnerabilityLocationResponse':
        """
        The location of the vulnerability.
        """
        return pulumi.get(self, "affected_location")

    @property
    @pulumi.getter(name="fixedLocation")
    def fixed_location(self) -> 'outputs.VulnerabilityLocationResponse':
        """
        The location of the available fix for vulnerability.
        """
        return pulumi.get(self, "fixed_location")

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> str:
        return pulumi.get(self, "severity_name")


@pulumi.output_type
class PackageResponse(dict):
    """
    This represents a particular package that is distributed over various channels. e.g. glibc (aka libc6) is distributed by many, at various versions.
    """
    def __init__(__self__, *,
                 distribution: Sequence['outputs.DistributionResponse'],
                 name: str):
        """
        This represents a particular package that is distributed over various channels. e.g. glibc (aka libc6) is distributed by many, at various versions.
        :param Sequence['DistributionResponse'] distribution: The various channels by which a package is distributed.
        :param str name: The name of the package.
        """
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def distribution(self) -> Sequence['outputs.DistributionResponse']:
        """
        The various channels by which a package is distributed.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the package.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PgpSignedAttestationResponse(dict):
    """
    An attestation wrapper with a PGP-compatible signature. This message only supports `ATTACHED` signatures, where the payload that is signed is included alongside the signature itself in the same file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "pgpKeyId":
            suggest = "pgp_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PgpSignedAttestationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PgpSignedAttestationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PgpSignedAttestationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: str,
                 pgp_key_id: str,
                 signature: str):
        """
        An attestation wrapper with a PGP-compatible signature. This message only supports `ATTACHED` signatures, where the payload that is signed is included alongside the signature itself in the same file.
        :param str content_type: Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        :param str pgp_key_id: The cryptographic fingerprint of the key used to generate the signature, as output by, e.g. `gpg --list-keys`. This should be the version 4, full 160-bit fingerprint, expressed as a 40 character hexadecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2 for details. Implementations may choose to acknowledge "LONG", "SHORT", or other abbreviated key IDs, but only the full fingerprint is guaranteed to work. In gpg, the full fingerprint can be retrieved from the `fpr` field returned when calling --list-keys with --with-colons. For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \ --list-keys attester@example.com tru::1:1513631572:0:3:1:5 pub:...... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB: ``` Above, the fingerprint is `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
        :param str signature: The raw content of the signature, as output by GNU Privacy Guard (GPG) or equivalent. Since this message only supports attached signatures, the payload that was signed must be attached. While the signature format supported is dependent on the verification implementation, currently only ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor --output=signature.gpg payload.json` will create the signature content expected in this field in `signature.gpg` for the `payload.json` attestation payload.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "pgp_key_id", pgp_key_id)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="pgpKeyId")
    def pgp_key_id(self) -> str:
        """
        The cryptographic fingerprint of the key used to generate the signature, as output by, e.g. `gpg --list-keys`. This should be the version 4, full 160-bit fingerprint, expressed as a 40 character hexadecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2 for details. Implementations may choose to acknowledge "LONG", "SHORT", or other abbreviated key IDs, but only the full fingerprint is guaranteed to work. In gpg, the full fingerprint can be retrieved from the `fpr` field returned when calling --list-keys with --with-colons. For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \ --list-keys attester@example.com tru::1:1513631572:0:3:1:5 pub:...... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB: ``` Above, the fingerprint is `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
        """
        return pulumi.get(self, "pgp_key_id")

    @property
    @pulumi.getter
    def signature(self) -> str:
        """
        The raw content of the signature, as output by GNU Privacy Guard (GPG) or equivalent. Since this message only supports attached signatures, the payload that was signed must be attached. While the signature format supported is dependent on the verification implementation, currently only ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor --output=signature.gpg payload.json` will create the signature content expected in this field in `signature.gpg` for the `payload.json` attestation payload.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class RelatedUrlResponse(dict):
    """
    Metadata for any related URL information
    """
    def __init__(__self__, *,
                 label: str,
                 url: str):
        """
        Metadata for any related URL information
        :param str label: Label to describe usage of the URL
        :param str url: Specific URL to associate with the note
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Label to describe usage of the URL
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Specific URL to associate with the note
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class RepoSourceResponse(dict):
    """
    RepoSource describes the location of the source in a Google Cloud Source Repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchName":
            suggest = "branch_name"
        elif key == "commitSha":
            suggest = "commit_sha"
        elif key == "repoName":
            suggest = "repo_name"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepoSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepoSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepoSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_name: str,
                 commit_sha: str,
                 project: str,
                 repo_name: str,
                 tag_name: str):
        """
        RepoSource describes the location of the source in a Google Cloud Source Repository.
        :param str branch_name: Name of the branch to build.
        :param str commit_sha: Explicit commit SHA to build.
        :param str project: ID of the project that owns the repo.
        :param str repo_name: Name of the repo.
        :param str tag_name: Name of the tag to build.
        """
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "commit_sha", commit_sha)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> str:
        """
        Name of the branch to build.
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> str:
        """
        Explicit commit SHA to build.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        ID of the project that owns the repo.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        Name of the repo.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> str:
        """
        Name of the tag to build.
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class ResourceResponse(dict):
    """
     Resource is an entity that can have metadata. E.g., a Docker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentHash":
            suggest = "content_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_hash: 'outputs.HashResponse',
                 name: str,
                 uri: str):
        """
         Resource is an entity that can have metadata. E.g., a Docker image.
        :param 'HashResponse' content_hash: The hash of the resource content. E.g., the Docker digest.
        :param str name: The name of the resource. E.g., the name of a Docker image - "Debian".
        :param str uri: The unique URI of the resource. E.g., "https://gcr.io/project/image@sha256:foo" for a Docker image.
        """
        pulumi.set(__self__, "content_hash", content_hash)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> 'outputs.HashResponse':
        """
        The hash of the resource content. E.g., the Docker digest.
        """
        return pulumi.get(self, "content_hash")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource. E.g., the name of a Docker image - "Debian".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The unique URI of the resource. E.g., "https://gcr.io/project/image@sha256:foo" for a Docker image.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class SourceResponse(dict):
    """
    Source describes the location of the source used for the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalContexts":
            suggest = "additional_contexts"
        elif key == "artifactStorageSource":
            suggest = "artifact_storage_source"
        elif key == "fileHashes":
            suggest = "file_hashes"
        elif key == "repoSource":
            suggest = "repo_source"
        elif key == "storageSource":
            suggest = "storage_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_contexts: Sequence['outputs.GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse'],
                 artifact_storage_source: 'outputs.StorageSourceResponse',
                 context: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse',
                 file_hashes: Mapping[str, str],
                 repo_source: 'outputs.RepoSourceResponse',
                 storage_source: 'outputs.StorageSourceResponse'):
        """
        Source describes the location of the source used for the build.
        :param Sequence['GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse'] additional_contexts: If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        :param 'StorageSourceResponse' artifact_storage_source: If provided, the input binary artifacts for the build came from this location.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse' context: If provided, the source code used for the build came from this location.
        :param Mapping[str, str] file_hashes: Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        :param 'RepoSourceResponse' repo_source: If provided, get source from this location in a Cloud Repo.
        :param 'StorageSourceResponse' storage_source: If provided, get the source from this location in in Google Cloud Storage.
        """
        pulumi.set(__self__, "additional_contexts", additional_contexts)
        pulumi.set(__self__, "artifact_storage_source", artifact_storage_source)
        pulumi.set(__self__, "context", context)
        pulumi.set(__self__, "file_hashes", file_hashes)
        pulumi.set(__self__, "repo_source", repo_source)
        pulumi.set(__self__, "storage_source", storage_source)

    @property
    @pulumi.getter(name="additionalContexts")
    def additional_contexts(self) -> Sequence['outputs.GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse']:
        """
        If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        """
        return pulumi.get(self, "additional_contexts")

    @property
    @pulumi.getter(name="artifactStorageSource")
    def artifact_storage_source(self) -> 'outputs.StorageSourceResponse':
        """
        If provided, the input binary artifacts for the build came from this location.
        """
        return pulumi.get(self, "artifact_storage_source")

    @property
    @pulumi.getter
    def context(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse':
        """
        If provided, the source code used for the build came from this location.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> Mapping[str, str]:
        """
        Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        return pulumi.get(self, "file_hashes")

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> 'outputs.RepoSourceResponse':
        """
        If provided, get source from this location in a Cloud Repo.
        """
        return pulumi.get(self, "repo_source")

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> 'outputs.StorageSourceResponse':
        """
        If provided, get the source from this location in in Google Cloud Storage.
        """
        return pulumi.get(self, "storage_source")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class StorageSourceResponse(dict):
    """
    StorageSource describes the location of the source in an archive file in Google Cloud Storage.
    """
    def __init__(__self__, *,
                 bucket: str,
                 generation: str,
                 object: str):
        """
        StorageSource describes the location of the source in an archive file in Google Cloud Storage.
        :param str bucket: Google Cloud Storage bucket containing source (see [Bucket Name Requirements] (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        :param str generation: Google Cloud Storage generation for the object.
        :param str object: Google Cloud Storage object containing source.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Google Cloud Storage bucket containing source (see [Bucket Name Requirements] (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        Google Cloud Storage generation for the object.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Google Cloud Storage object containing source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class UpgradeDistributionResponse(dict):
    """
    The Upgrade Distribution represents metadata about the Upgrade for each operating system (CPE). Some distributions have additional metadata around updates, classifying them into various categories and severities.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeDistributionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeDistributionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeDistributionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classification: str,
                 cpe_uri: str,
                 cve: Sequence[str],
                 severity: str):
        """
        The Upgrade Distribution represents metadata about the Upgrade for each operating system (CPE). Some distributions have additional metadata around updates, classifying them into various categories and severities.
        :param str classification: The operating system classification of this Upgrade, as specified by the upstream operating system upgrade feed.
        :param str cpe_uri: Required - The specific operating system this metadata applies to. See https://cpe.mitre.org/specification/.
        :param Sequence[str] cve: The cve that would be resolved by this upgrade.
        :param str severity: The severity as specified by the upstream operating system.
        """
        pulumi.set(__self__, "classification", classification)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "cve", cve)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def classification(self) -> str:
        """
        The operating system classification of this Upgrade, as specified by the upstream operating system upgrade feed.
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        Required - The specific operating system this metadata applies to. See https://cpe.mitre.org/specification/.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def cve(self) -> Sequence[str]:
        """
        The cve that would be resolved by this upgrade.
        """
        return pulumi.get(self, "cve")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The severity as specified by the upstream operating system.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class UpgradeNoteResponse(dict):
    """
    An Upgrade Note represents a potential upgrade of a package to a given version. For each package version combination (i.e. bash 4.0, bash 4.1, bash 4.1.2), there will be a Upgrade Note.
    """
    def __init__(__self__, *,
                 distributions: Sequence['outputs.UpgradeDistributionResponse'],
                 package: str,
                 version: 'outputs.VersionResponse'):
        """
        An Upgrade Note represents a potential upgrade of a package to a given version. For each package version combination (i.e. bash 4.0, bash 4.1, bash 4.1.2), there will be a Upgrade Note.
        :param Sequence['UpgradeDistributionResponse'] distributions: Metadata about the upgrade for each specific operating system.
        :param str package: Required - The package this Upgrade is for.
        :param 'VersionResponse' version: Required - The version of the package in machine + human readable form.
        """
        pulumi.set(__self__, "distributions", distributions)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def distributions(self) -> Sequence['outputs.UpgradeDistributionResponse']:
        """
        Metadata about the upgrade for each specific operating system.
        """
        return pulumi.get(self, "distributions")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        Required - The package this Upgrade is for.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        Required - The version of the package in machine + human readable form.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class UpgradeOccurrenceResponse(dict):
    """
    An Upgrade Occurrence represents that a specific resource_url could install a specific upgrade. This presence is supplied via local sources (i.e. it is present in the mirror and the running system has noticed its availability).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parsedVersion":
            suggest = "parsed_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution: 'outputs.UpgradeDistributionResponse',
                 package: str,
                 parsed_version: 'outputs.VersionResponse'):
        """
        An Upgrade Occurrence represents that a specific resource_url could install a specific upgrade. This presence is supplied via local sources (i.e. it is present in the mirror and the running system has noticed its availability).
        :param 'UpgradeDistributionResponse' distribution: Metadata about the upgrade for available for the specific operating system for the resource_url. This allows efficient filtering, as well as making it easier to use the occurrence.
        :param str package: Required - The package this Upgrade is for.
        :param 'VersionResponse' parsed_version: Required - The version of the package in a machine + human readable form.
        """
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "parsed_version", parsed_version)

    @property
    @pulumi.getter
    def distribution(self) -> 'outputs.UpgradeDistributionResponse':
        """
        Metadata about the upgrade for available for the specific operating system for the resource_url. This allows efficient filtering, as well as making it easier to use the occurrence.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        Required - The package this Upgrade is for.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter(name="parsedVersion")
    def parsed_version(self) -> 'outputs.VersionResponse':
        """
        Required - The version of the package in a machine + human readable form.
        """
        return pulumi.get(self, "parsed_version")


@pulumi.output_type
class VersionResponse(dict):
    """
    Version contains structured information about the version of the package. For a discussion of this in Debian/Ubuntu: http://serverfault.com/questions/604541/debian-packages-version-convention For a discussion of this in Redhat/Fedora/Centos: http://blog.jasonantman.com/2014/07/how-yum-and-rpm-compare-versions/
    """
    def __init__(__self__, *,
                 epoch: int,
                 inclusive: bool,
                 kind: str,
                 name: str,
                 revision: str):
        """
        Version contains structured information about the version of the package. For a discussion of this in Debian/Ubuntu: http://serverfault.com/questions/604541/debian-packages-version-convention For a discussion of this in Redhat/Fedora/Centos: http://blog.jasonantman.com/2014/07/how-yum-and-rpm-compare-versions/
        :param int epoch: Used to correct mistakes in the version numbering scheme.
        :param bool inclusive: Whether this version is vulnerable, when defining the version bounds. For example, if the minimum version is 2.0, inclusive=true would say 2.0 is vulnerable, while inclusive=false would say it's not
        :param str kind: Distinguish between sentinel MIN/MAX versions and normal versions. If kind is not NORMAL, then the other fields are ignored.
        :param str name: The main part of the version name.
        :param str revision: The iteration of the package build from the above version.
        """
        pulumi.set(__self__, "epoch", epoch)
        pulumi.set(__self__, "inclusive", inclusive)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def epoch(self) -> int:
        """
        Used to correct mistakes in the version numbering scheme.
        """
        return pulumi.get(self, "epoch")

    @property
    @pulumi.getter
    def inclusive(self) -> bool:
        """
        Whether this version is vulnerable, when defining the version bounds. For example, if the minimum version is 2.0, inclusive=true would say 2.0 is vulnerable, while inclusive=false would say it's not
        """
        return pulumi.get(self, "inclusive")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Distinguish between sentinel MIN/MAX versions and normal versions. If kind is not NORMAL, then the other fields are ignored.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The main part of the version name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        The iteration of the package build from the above version.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class VulnerabilityDetailsResponse(dict):
    """
    Used by Occurrence to point to where the vulnerability exists and how to fix it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvssScore":
            suggest = "cvss_score"
        elif key == "effectiveSeverity":
            suggest = "effective_severity"
        elif key == "packageIssue":
            suggest = "package_issue"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cvss_score: float,
                 effective_severity: str,
                 package_issue: Sequence['outputs.PackageIssueResponse'],
                 severity: str,
                 type: str):
        """
        Used by Occurrence to point to where the vulnerability exists and how to fix it.
        :param float cvss_score: The CVSS score of this vulnerability. CVSS score is on a scale of 0-10 where 0 indicates low severity and 10 indicates high severity.
        :param str effective_severity: The distro assigned severity for this vulnerability when that is available and note provider assigned severity when distro has not yet assigned a severity for this vulnerability.
        :param Sequence['PackageIssueResponse'] package_issue: The set of affected locations and their fixes (if available) within the associated resource.
        :param str severity: The note provider assigned Severity of the vulnerability.
        :param str type: The type of package; whether native or non native(ruby gems, node.js packages etc)
        """
        pulumi.set(__self__, "cvss_score", cvss_score)
        pulumi.set(__self__, "effective_severity", effective_severity)
        pulumi.set(__self__, "package_issue", package_issue)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> float:
        """
        The CVSS score of this vulnerability. CVSS score is on a scale of 0-10 where 0 indicates low severity and 10 indicates high severity.
        """
        return pulumi.get(self, "cvss_score")

    @property
    @pulumi.getter(name="effectiveSeverity")
    def effective_severity(self) -> str:
        """
        The distro assigned severity for this vulnerability when that is available and note provider assigned severity when distro has not yet assigned a severity for this vulnerability.
        """
        return pulumi.get(self, "effective_severity")

    @property
    @pulumi.getter(name="packageIssue")
    def package_issue(self) -> Sequence['outputs.PackageIssueResponse']:
        """
        The set of affected locations and their fixes (if available) within the associated resource.
        """
        return pulumi.get(self, "package_issue")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The note provider assigned Severity of the vulnerability.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of package; whether native or non native(ruby gems, node.js packages etc)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VulnerabilityLocationResponse(dict):
    """
    The location of the vulnerability
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 package: str,
                 version: 'outputs.VersionResponse'):
        """
        The location of the vulnerability
        :param str cpe_uri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) format. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        :param str package: The package being described.
        :param 'VersionResponse' version: The version of the package being described. This field can be used as a filter in list requests.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) format. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        The package being described.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        The version of the package being described. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class VulnerabilityTypeResponse(dict):
    """
    VulnerabilityType provides metadata about a security vulnerability.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvssScore":
            suggest = "cvss_score"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cvss_score: float,
                 details: Sequence['outputs.DetailResponse'],
                 severity: str):
        """
        VulnerabilityType provides metadata about a security vulnerability.
        :param float cvss_score: The CVSS score for this Vulnerability.
        :param Sequence['DetailResponse'] details: All information about the package to specifically identify this vulnerability. One entry per (version range and cpe_uri) the package vulnerability has manifested in.
        :param str severity: Note provider assigned impact of the vulnerability
        """
        pulumi.set(__self__, "cvss_score", cvss_score)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> float:
        """
        The CVSS score for this Vulnerability.
        """
        return pulumi.get(self, "cvss_score")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.DetailResponse']:
        """
        All information about the package to specifically identify this vulnerability. One entry per (version range and cpe_uri) the package vulnerability has manifested in.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Note provider assigned impact of the vulnerability
        """
        return pulumi.get(self, "severity")


