# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'AcceleratorConfigArgs',
    'AddonsConfigArgs',
    'AuthenticatorGroupsConfigArgs',
    'AutoUpgradeOptionsArgs',
    'AutopilotArgs',
    'AutoprovisioningNodePoolDefaultsArgs',
    'BigQueryDestinationArgs',
    'BinaryAuthorizationArgs',
    'CidrBlockArgs',
    'ClientCertificateConfigArgs',
    'CloudRunConfigArgs',
    'ClusterAutoscalingArgs',
    'ClusterTelemetryArgs',
    'ConfidentialNodesArgs',
    'ConfigConnectorConfigArgs',
    'ConsumptionMeteringConfigArgs',
    'DailyMaintenanceWindowArgs',
    'DatabaseEncryptionArgs',
    'DefaultSnatStatusArgs',
    'DnsCacheConfigArgs',
    'EphemeralStorageConfigArgs',
    'GcePersistentDiskCsiDriverConfigArgs',
    'HorizontalPodAutoscalingArgs',
    'HttpLoadBalancingArgs',
    'IPAllocationPolicyArgs',
    'IstioConfigArgs',
    'KalmConfigArgs',
    'KubernetesDashboardArgs',
    'LegacyAbacArgs',
    'LinuxNodeConfigArgs',
    'MaintenancePolicyArgs',
    'MaintenanceWindowArgs',
    'MasterArgs',
    'MasterAuthArgs',
    'MasterAuthorizedNetworksConfigArgs',
    'MaxPodsConstraintArgs',
    'NetworkConfigArgs',
    'NetworkPolicyArgs',
    'NetworkPolicyConfigArgs',
    'NodeConfigArgs',
    'NodeKubeletConfigArgs',
    'NodeManagementArgs',
    'NodeNetworkConfigArgs',
    'NodePoolArgs',
    'NodePoolAutoscalingArgs',
    'NodeTaintArgs',
    'NotificationConfigArgs',
    'PodSecurityPolicyConfigArgs',
    'PrivateClusterConfigArgs',
    'PrivateClusterMasterGlobalAccessConfigArgs',
    'PubSubArgs',
    'RecurringTimeWindowArgs',
    'ReleaseChannelArgs',
    'ReservationAffinityArgs',
    'ResourceLimitArgs',
    'ResourceUsageExportConfigArgs',
    'SandboxConfigArgs',
    'ShieldedInstanceConfigArgs',
    'ShieldedNodesArgs',
    'StatusConditionArgs',
    'TimeWindowArgs',
    'TpuConfigArgs',
    'UpgradeSettingsArgs',
    'VerticalPodAutoscalingArgs',
    'WorkloadCertificatesArgs',
    'WorkloadIdentityConfigArgs',
    'WorkloadMetadataConfigArgs',
]

@pulumi.input_type
class AcceleratorConfigArgs:
    def __init__(__self__, *,
                 accelerator_count: Optional[pulumi.Input[str]] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None,
                 gpu_partition_size: Optional[pulumi.Input[str]] = None):
        """
        AcceleratorConfig represents a Hardware Accelerator request.
        :param pulumi.Input[str] accelerator_count: The number of the accelerator cards exposed to an instance.
        :param pulumi.Input[str] accelerator_type: The accelerator type resource name. List of supported accelerators [here](https://cloud.google.com/compute/docs/gpus)
        :param pulumi.Input[str] gpu_partition_size: Size of partitions to create on the GPU. Valid values are described in the NVIDIA [mig user guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if gpu_partition_size is not None:
            pulumi.set(__self__, "gpu_partition_size", gpu_partition_size)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[pulumi.Input[str]]:
        """
        The number of the accelerator cards exposed to an instance.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[str]]:
        """
        The accelerator type resource name. List of supported accelerators [here](https://cloud.google.com/compute/docs/gpus)
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter(name="gpuPartitionSize")
    def gpu_partition_size(self) -> Optional[pulumi.Input[str]]:
        """
        Size of partitions to create on the GPU. Valid values are described in the NVIDIA [mig user guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
        """
        return pulumi.get(self, "gpu_partition_size")

    @gpu_partition_size.setter
    def gpu_partition_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gpu_partition_size", value)


@pulumi.input_type
class AddonsConfigArgs:
    def __init__(__self__, *,
                 cloud_run_config: Optional[pulumi.Input['CloudRunConfigArgs']] = None,
                 config_connector_config: Optional[pulumi.Input['ConfigConnectorConfigArgs']] = None,
                 dns_cache_config: Optional[pulumi.Input['DnsCacheConfigArgs']] = None,
                 gce_persistent_disk_csi_driver_config: Optional[pulumi.Input['GcePersistentDiskCsiDriverConfigArgs']] = None,
                 horizontal_pod_autoscaling: Optional[pulumi.Input['HorizontalPodAutoscalingArgs']] = None,
                 http_load_balancing: Optional[pulumi.Input['HttpLoadBalancingArgs']] = None,
                 istio_config: Optional[pulumi.Input['IstioConfigArgs']] = None,
                 kalm_config: Optional[pulumi.Input['KalmConfigArgs']] = None,
                 kubernetes_dashboard: Optional[pulumi.Input['KubernetesDashboardArgs']] = None,
                 network_policy_config: Optional[pulumi.Input['NetworkPolicyConfigArgs']] = None):
        """
        Configuration for the addons that can be automatically spun up in the cluster, enabling additional functionality.
        :param pulumi.Input['CloudRunConfigArgs'] cloud_run_config: Configuration for the Cloud Run addon. The `IstioConfig` addon must be enabled in order to enable Cloud Run addon. This option can only be enabled at cluster creation time.
        :param pulumi.Input['ConfigConnectorConfigArgs'] config_connector_config: Configuration for the ConfigConnector add-on, a Kubernetes extension to manage hosted GCP services through the Kubernetes API
        :param pulumi.Input['DnsCacheConfigArgs'] dns_cache_config: Configuration for NodeLocalDNS, a dns cache running on cluster nodes
        :param pulumi.Input['GcePersistentDiskCsiDriverConfigArgs'] gce_persistent_disk_csi_driver_config: Configuration for the Compute Engine Persistent Disk CSI driver.
        :param pulumi.Input['HorizontalPodAutoscalingArgs'] horizontal_pod_autoscaling: Configuration for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
        :param pulumi.Input['HttpLoadBalancingArgs'] http_load_balancing: Configuration for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
        :param pulumi.Input['IstioConfigArgs'] istio_config: Configuration for Istio, an open platform to connect, manage, and secure microservices.
        :param pulumi.Input['KalmConfigArgs'] kalm_config: Configuration for the KALM addon, which manages the lifecycle of k8s applications.
        :param pulumi.Input['KubernetesDashboardArgs'] kubernetes_dashboard: Configuration for the Kubernetes Dashboard. This addon is deprecated, and will be disabled in 1.15. It is recommended to use the Cloud Console to manage and monitor your Kubernetes clusters, workloads and applications. For more information, see: https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
        :param pulumi.Input['NetworkPolicyConfigArgs'] network_policy_config: Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
        """
        if cloud_run_config is not None:
            pulumi.set(__self__, "cloud_run_config", cloud_run_config)
        if config_connector_config is not None:
            pulumi.set(__self__, "config_connector_config", config_connector_config)
        if dns_cache_config is not None:
            pulumi.set(__self__, "dns_cache_config", dns_cache_config)
        if gce_persistent_disk_csi_driver_config is not None:
            pulumi.set(__self__, "gce_persistent_disk_csi_driver_config", gce_persistent_disk_csi_driver_config)
        if horizontal_pod_autoscaling is not None:
            pulumi.set(__self__, "horizontal_pod_autoscaling", horizontal_pod_autoscaling)
        if http_load_balancing is not None:
            pulumi.set(__self__, "http_load_balancing", http_load_balancing)
        if istio_config is not None:
            pulumi.set(__self__, "istio_config", istio_config)
        if kalm_config is not None:
            pulumi.set(__self__, "kalm_config", kalm_config)
        if kubernetes_dashboard is not None:
            pulumi.set(__self__, "kubernetes_dashboard", kubernetes_dashboard)
        if network_policy_config is not None:
            pulumi.set(__self__, "network_policy_config", network_policy_config)

    @property
    @pulumi.getter(name="cloudRunConfig")
    def cloud_run_config(self) -> Optional[pulumi.Input['CloudRunConfigArgs']]:
        """
        Configuration for the Cloud Run addon. The `IstioConfig` addon must be enabled in order to enable Cloud Run addon. This option can only be enabled at cluster creation time.
        """
        return pulumi.get(self, "cloud_run_config")

    @cloud_run_config.setter
    def cloud_run_config(self, value: Optional[pulumi.Input['CloudRunConfigArgs']]):
        pulumi.set(self, "cloud_run_config", value)

    @property
    @pulumi.getter(name="configConnectorConfig")
    def config_connector_config(self) -> Optional[pulumi.Input['ConfigConnectorConfigArgs']]:
        """
        Configuration for the ConfigConnector add-on, a Kubernetes extension to manage hosted GCP services through the Kubernetes API
        """
        return pulumi.get(self, "config_connector_config")

    @config_connector_config.setter
    def config_connector_config(self, value: Optional[pulumi.Input['ConfigConnectorConfigArgs']]):
        pulumi.set(self, "config_connector_config", value)

    @property
    @pulumi.getter(name="dnsCacheConfig")
    def dns_cache_config(self) -> Optional[pulumi.Input['DnsCacheConfigArgs']]:
        """
        Configuration for NodeLocalDNS, a dns cache running on cluster nodes
        """
        return pulumi.get(self, "dns_cache_config")

    @dns_cache_config.setter
    def dns_cache_config(self, value: Optional[pulumi.Input['DnsCacheConfigArgs']]):
        pulumi.set(self, "dns_cache_config", value)

    @property
    @pulumi.getter(name="gcePersistentDiskCsiDriverConfig")
    def gce_persistent_disk_csi_driver_config(self) -> Optional[pulumi.Input['GcePersistentDiskCsiDriverConfigArgs']]:
        """
        Configuration for the Compute Engine Persistent Disk CSI driver.
        """
        return pulumi.get(self, "gce_persistent_disk_csi_driver_config")

    @gce_persistent_disk_csi_driver_config.setter
    def gce_persistent_disk_csi_driver_config(self, value: Optional[pulumi.Input['GcePersistentDiskCsiDriverConfigArgs']]):
        pulumi.set(self, "gce_persistent_disk_csi_driver_config", value)

    @property
    @pulumi.getter(name="horizontalPodAutoscaling")
    def horizontal_pod_autoscaling(self) -> Optional[pulumi.Input['HorizontalPodAutoscalingArgs']]:
        """
        Configuration for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
        """
        return pulumi.get(self, "horizontal_pod_autoscaling")

    @horizontal_pod_autoscaling.setter
    def horizontal_pod_autoscaling(self, value: Optional[pulumi.Input['HorizontalPodAutoscalingArgs']]):
        pulumi.set(self, "horizontal_pod_autoscaling", value)

    @property
    @pulumi.getter(name="httpLoadBalancing")
    def http_load_balancing(self) -> Optional[pulumi.Input['HttpLoadBalancingArgs']]:
        """
        Configuration for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
        """
        return pulumi.get(self, "http_load_balancing")

    @http_load_balancing.setter
    def http_load_balancing(self, value: Optional[pulumi.Input['HttpLoadBalancingArgs']]):
        pulumi.set(self, "http_load_balancing", value)

    @property
    @pulumi.getter(name="istioConfig")
    def istio_config(self) -> Optional[pulumi.Input['IstioConfigArgs']]:
        """
        Configuration for Istio, an open platform to connect, manage, and secure microservices.
        """
        return pulumi.get(self, "istio_config")

    @istio_config.setter
    def istio_config(self, value: Optional[pulumi.Input['IstioConfigArgs']]):
        pulumi.set(self, "istio_config", value)

    @property
    @pulumi.getter(name="kalmConfig")
    def kalm_config(self) -> Optional[pulumi.Input['KalmConfigArgs']]:
        """
        Configuration for the KALM addon, which manages the lifecycle of k8s applications.
        """
        return pulumi.get(self, "kalm_config")

    @kalm_config.setter
    def kalm_config(self, value: Optional[pulumi.Input['KalmConfigArgs']]):
        pulumi.set(self, "kalm_config", value)

    @property
    @pulumi.getter(name="kubernetesDashboard")
    def kubernetes_dashboard(self) -> Optional[pulumi.Input['KubernetesDashboardArgs']]:
        """
        Configuration for the Kubernetes Dashboard. This addon is deprecated, and will be disabled in 1.15. It is recommended to use the Cloud Console to manage and monitor your Kubernetes clusters, workloads and applications. For more information, see: https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
        """
        return pulumi.get(self, "kubernetes_dashboard")

    @kubernetes_dashboard.setter
    def kubernetes_dashboard(self, value: Optional[pulumi.Input['KubernetesDashboardArgs']]):
        pulumi.set(self, "kubernetes_dashboard", value)

    @property
    @pulumi.getter(name="networkPolicyConfig")
    def network_policy_config(self) -> Optional[pulumi.Input['NetworkPolicyConfigArgs']]:
        """
        Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
        """
        return pulumi.get(self, "network_policy_config")

    @network_policy_config.setter
    def network_policy_config(self, value: Optional[pulumi.Input['NetworkPolicyConfigArgs']]):
        pulumi.set(self, "network_policy_config", value)


@pulumi.input_type
class AuthenticatorGroupsConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 security_group: Optional[pulumi.Input[str]] = None):
        """
        Configuration for returning group information from authenticators.
        :param pulumi.Input[bool] enabled: Whether this cluster should return group membership lookups during authentication using a group of security groups.
        :param pulumi.Input[str] security_group: The name of the security group-of-groups to be used. Only relevant if enabled = true.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if security_group is not None:
            pulumi.set(__self__, "security_group", security_group)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this cluster should return group membership lookups during authentication using a group of security groups.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security group-of-groups to be used. Only relevant if enabled = true.
        """
        return pulumi.get(self, "security_group")

    @security_group.setter
    def security_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group", value)


@pulumi.input_type
class AutoUpgradeOptionsArgs:
    def __init__(__self__, *,
                 auto_upgrade_start_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        AutoUpgradeOptions defines the set of options for the user to control how the Auto Upgrades will proceed.
        :param pulumi.Input[str] auto_upgrade_start_time: [Output only] This field is set when upgrades are about to commence with the approximate start time for the upgrades, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param pulumi.Input[str] description: [Output only] This field is set when upgrades are about to commence with the description of the upgrade.
        """
        if auto_upgrade_start_time is not None:
            pulumi.set(__self__, "auto_upgrade_start_time", auto_upgrade_start_time)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="autoUpgradeStartTime")
    def auto_upgrade_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only] This field is set when upgrades are about to commence with the approximate start time for the upgrades, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        """
        return pulumi.get(self, "auto_upgrade_start_time")

    @auto_upgrade_start_time.setter
    def auto_upgrade_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_upgrade_start_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only] This field is set when upgrades are about to commence with the description of the upgrade.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AutopilotArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Autopilot is the configuration for Autopilot settings on the cluster.
        :param pulumi.Input[bool] enabled: Enable Autopilot
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Autopilot
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class AutoprovisioningNodePoolDefaultsArgs:
    def __init__(__self__, *,
                 boot_disk_kms_key: Optional[pulumi.Input[str]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 management: Optional[pulumi.Input['NodeManagementArgs']] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 shielded_instance_config: Optional[pulumi.Input['ShieldedInstanceConfigArgs']] = None,
                 upgrade_settings: Optional[pulumi.Input['UpgradeSettingsArgs']] = None):
        """
        AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
        :param pulumi.Input[str] boot_disk_kms_key:  The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        :param pulumi.Input[int] disk_size_gb: Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        :param pulumi.Input[str] disk_type: Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        :param pulumi.Input['NodeManagementArgs'] management: NodeManagement configuration for this NodePool.
        :param pulumi.Input[str] min_cpu_platform: Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy Bridge"`. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform) To unset the min cpu platform field pass "automatic" as field value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_scopes: The set of Google API scopes to be made available on all of the node VMs under the "default" service account. The following scopes are recommended, but not required, and by default are not included: * `https://www.googleapis.com/auth/compute` is required for mounting persistent storage on your nodes. * `https://www.googleapis.com/auth/devstorage.read_only` is required for communicating with **gcr.io** (the [Google Container Registry](https://cloud.google.com/container-registry/)). If unspecified, no scopes are added, unless Cloud Logging or Cloud Monitoring are enabled, in which case their required scopes will be added.
        :param pulumi.Input[str] service_account: The Google Cloud Platform Service Account to be used by the node VMs. Specify the email address of the Service Account; otherwise, if no Service Account is specified, the "default" service account is used.
        :param pulumi.Input['ShieldedInstanceConfigArgs'] shielded_instance_config: Shielded Instance options.
        :param pulumi.Input['UpgradeSettingsArgs'] upgrade_settings: Upgrade settings control disruption and speed of the upgrade.
        """
        if boot_disk_kms_key is not None:
            pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> Optional[pulumi.Input[str]]:
        """
         The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        """
        return pulumi.get(self, "boot_disk_kms_key")

    @boot_disk_kms_key.setter
    def boot_disk_kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_kms_key", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['NodeManagementArgs']]:
        """
        NodeManagement configuration for this NodePool.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['NodeManagementArgs']]):
        pulumi.set(self, "management", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy Bridge"`. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform) To unset the min cpu platform field pass "automatic" as field value.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of Google API scopes to be made available on all of the node VMs under the "default" service account. The following scopes are recommended, but not required, and by default are not included: * `https://www.googleapis.com/auth/compute` is required for mounting persistent storage on your nodes. * `https://www.googleapis.com/auth/devstorage.read_only` is required for communicating with **gcr.io** (the [Google Container Registry](https://cloud.google.com/container-registry/)). If unspecified, no scopes are added, unless Cloud Logging or Cloud Monitoring are enabled, in which case their required scopes will be added.
        """
        return pulumi.get(self, "oauth_scopes")

    @oauth_scopes.setter
    def oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oauth_scopes", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The Google Cloud Platform Service Account to be used by the node VMs. Specify the email address of the Service Account; otherwise, if no Service Account is specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['ShieldedInstanceConfigArgs']]:
        """
        Shielded Instance options.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['ShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional[pulumi.Input['UpgradeSettingsArgs']]:
        """
        Upgrade settings control disruption and speed of the upgrade.
        """
        return pulumi.get(self, "upgrade_settings")

    @upgrade_settings.setter
    def upgrade_settings(self, value: Optional[pulumi.Input['UpgradeSettingsArgs']]):
        pulumi.set(self, "upgrade_settings", value)


@pulumi.input_type
class BigQueryDestinationArgs:
    def __init__(__self__, *,
                 dataset_id: Optional[pulumi.Input[str]] = None):
        """
        Parameters for using BigQuery as the destination of resource usage export.
        :param pulumi.Input[str] dataset_id: The ID of a BigQuery Dataset.
        """
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a BigQuery Dataset.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)


@pulumi.input_type
class BinaryAuthorizationArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for Binary Authorization.
        :param pulumi.Input[bool] enabled: Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binauthz.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binauthz.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class CidrBlockArgs:
    def __init__(__self__, *,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        CidrBlock contains an optional name and one CIDR block.
        :param pulumi.Input[str] cidr_block: cidr_block must be specified in CIDR notation.
        :param pulumi.Input[str] display_name: display_name is an optional field for users to identify CIDR blocks.
        """
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        cidr_block must be specified in CIDR notation.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        display_name is an optional field for users to identify CIDR blocks.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class ClientCertificateConfigArgs:
    def __init__(__self__, *,
                 issue_client_certificate: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for client certificates on the cluster.
        :param pulumi.Input[bool] issue_client_certificate: Issue a client certificate.
        """
        if issue_client_certificate is not None:
            pulumi.set(__self__, "issue_client_certificate", issue_client_certificate)

    @property
    @pulumi.getter(name="issueClientCertificate")
    def issue_client_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        Issue a client certificate.
        """
        return pulumi.get(self, "issue_client_certificate")

    @issue_client_certificate.setter
    def issue_client_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issue_client_certificate", value)


@pulumi.input_type
class CloudRunConfigArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 load_balancer_type: Optional[pulumi.Input[str]] = None):
        """
        Configuration options for the Cloud Run feature.
        :param pulumi.Input[bool] disabled: Whether Cloud Run addon is enabled for this cluster.
        :param pulumi.Input[str] load_balancer_type: Which load balancer type is installed for Cloud Run.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Cloud Run addon is enabled for this cluster.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[str]]:
        """
        Which load balancer type is installed for Cloud Run.
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_type", value)


@pulumi.input_type
class ClusterAutoscalingArgs:
    def __init__(__self__, *,
                 autoprovisioning_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 autoprovisioning_node_pool_defaults: Optional[pulumi.Input['AutoprovisioningNodePoolDefaultsArgs']] = None,
                 autoscaling_profile: Optional[pulumi.Input[str]] = None,
                 enable_node_autoprovisioning: Optional[pulumi.Input[bool]] = None,
                 resource_limits: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceLimitArgs']]]] = None):
        """
        ClusterAutoscaling contains global, per-cluster information required by Cluster Autoscaler to automatically adjust the size of the cluster and create/delete node pools based on the current needs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] autoprovisioning_locations: The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes can be created by NAP.
        :param pulumi.Input['AutoprovisioningNodePoolDefaultsArgs'] autoprovisioning_node_pool_defaults: AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
        :param pulumi.Input[str] autoscaling_profile: Defines autoscaling behaviour.
        :param pulumi.Input[bool] enable_node_autoprovisioning: Enables automatic node pool creation and deletion.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceLimitArgs']]] resource_limits: Contains global constraints regarding minimum and maximum amount of resources in the cluster.
        """
        if autoprovisioning_locations is not None:
            pulumi.set(__self__, "autoprovisioning_locations", autoprovisioning_locations)
        if autoprovisioning_node_pool_defaults is not None:
            pulumi.set(__self__, "autoprovisioning_node_pool_defaults", autoprovisioning_node_pool_defaults)
        if autoscaling_profile is not None:
            pulumi.set(__self__, "autoscaling_profile", autoscaling_profile)
        if enable_node_autoprovisioning is not None:
            pulumi.set(__self__, "enable_node_autoprovisioning", enable_node_autoprovisioning)
        if resource_limits is not None:
            pulumi.set(__self__, "resource_limits", resource_limits)

    @property
    @pulumi.getter(name="autoprovisioningLocations")
    def autoprovisioning_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes can be created by NAP.
        """
        return pulumi.get(self, "autoprovisioning_locations")

    @autoprovisioning_locations.setter
    def autoprovisioning_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "autoprovisioning_locations", value)

    @property
    @pulumi.getter(name="autoprovisioningNodePoolDefaults")
    def autoprovisioning_node_pool_defaults(self) -> Optional[pulumi.Input['AutoprovisioningNodePoolDefaultsArgs']]:
        """
        AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
        """
        return pulumi.get(self, "autoprovisioning_node_pool_defaults")

    @autoprovisioning_node_pool_defaults.setter
    def autoprovisioning_node_pool_defaults(self, value: Optional[pulumi.Input['AutoprovisioningNodePoolDefaultsArgs']]):
        pulumi.set(self, "autoprovisioning_node_pool_defaults", value)

    @property
    @pulumi.getter(name="autoscalingProfile")
    def autoscaling_profile(self) -> Optional[pulumi.Input[str]]:
        """
        Defines autoscaling behaviour.
        """
        return pulumi.get(self, "autoscaling_profile")

    @autoscaling_profile.setter
    def autoscaling_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autoscaling_profile", value)

    @property
    @pulumi.getter(name="enableNodeAutoprovisioning")
    def enable_node_autoprovisioning(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables automatic node pool creation and deletion.
        """
        return pulumi.get(self, "enable_node_autoprovisioning")

    @enable_node_autoprovisioning.setter
    def enable_node_autoprovisioning(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_autoprovisioning", value)

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceLimitArgs']]]]:
        """
        Contains global constraints regarding minimum and maximum amount of resources in the cluster.
        """
        return pulumi.get(self, "resource_limits")

    @resource_limits.setter
    def resource_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceLimitArgs']]]]):
        pulumi.set(self, "resource_limits", value)


@pulumi.input_type
class ClusterTelemetryArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Telemetry integration for the cluster.
        :param pulumi.Input[str] type: Type of the integration.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the integration.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConfidentialNodesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        ConfidentialNodes is configuration for the confidential nodes feature, which makes nodes run on confidential VMs.
        :param pulumi.Input[bool] enabled: Whether Confidential Nodes feature is enabled for all nodes in this cluster.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Confidential Nodes feature is enabled for all nodes in this cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ConfigConnectorConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration options for the Config Connector add-on.
        :param pulumi.Input[bool] enabled: Whether Cloud Connector is enabled for this cluster.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Cloud Connector is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ConsumptionMeteringConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Parameters for controlling consumption metering.
        :param pulumi.Input[bool] enabled: Whether to enable consumption metering for this cluster. If enabled, a second BigQuery table will be created to hold resource consumption records.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable consumption metering for this cluster. If enabled, a second BigQuery table will be created to hold resource consumption records.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class DailyMaintenanceWindowArgs:
    def __init__(__self__, *,
                 duration: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Time window specified for daily maintenance operations.
        :param pulumi.Input[str] duration: [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.
        :param pulumi.Input[str] start_time: Time within the maintenance window to start the maintenance operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time within the maintenance window to start the maintenance operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class DatabaseEncryptionArgs:
    def __init__(__self__, *,
                 key_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Configuration of etcd encryption.
        :param pulumi.Input[str] key_name: Name of CloudKMS key to use for the encryption of secrets in etcd. Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
        :param pulumi.Input[str] state: Denotes the state of etcd encryption.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of CloudKMS key to use for the encryption of secrets in etcd. Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Denotes the state of etcd encryption.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class DefaultSnatStatusArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None):
        """
        DefaultSnatStatus contains the desired state of whether default sNAT should be disabled on the cluster.
        :param pulumi.Input[bool] disabled: Disables cluster default sNAT rules.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables cluster default sNAT rules.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)


@pulumi.input_type
class DnsCacheConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for NodeLocal DNSCache
        :param pulumi.Input[bool] enabled: Whether NodeLocal DNSCache is enabled for this cluster.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether NodeLocal DNSCache is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class EphemeralStorageConfigArgs:
    def __init__(__self__, *,
                 local_ssd_count: Optional[pulumi.Input[int]] = None):
        """
        EphemeralStorageConfig contains configuration for the ephemeral storage filesystem.
        :param pulumi.Input[int] local_ssd_count: Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD is 375 GB in size. If zero, it means to disable using local SSDs as ephemeral storage.
        """
        if local_ssd_count is not None:
            pulumi.set(__self__, "local_ssd_count", local_ssd_count)

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD is 375 GB in size. If zero, it means to disable using local SSDs as ephemeral storage.
        """
        return pulumi.get(self, "local_ssd_count")

    @local_ssd_count.setter
    def local_ssd_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "local_ssd_count", value)


@pulumi.input_type
class GcePersistentDiskCsiDriverConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for the Compute Engine PD CSI driver.
        :param pulumi.Input[bool] enabled: Whether the Compute Engine PD CSI driver is enabled for this cluster.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the Compute Engine PD CSI driver is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class HorizontalPodAutoscalingArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration options for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
        :param pulumi.Input[bool] disabled: Whether the Horizontal Pod Autoscaling feature is enabled in the cluster. When enabled, it ensures that metrics are collected into Stackdriver Monitoring.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the Horizontal Pod Autoscaling feature is enabled in the cluster. When enabled, it ensures that metrics are collected into Stackdriver Monitoring.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)


@pulumi.input_type
class HttpLoadBalancingArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration options for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
        :param pulumi.Input[bool] disabled: Whether the HTTP Load Balancing controller is enabled in the cluster. When enabled, it runs a small pod in the cluster that manages the load balancers.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the HTTP Load Balancing controller is enabled in the cluster. When enabled, it runs a small pod in the cluster that manages the load balancers.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)


@pulumi.input_type
class IPAllocationPolicyArgs:
    def __init__(__self__, *,
                 allow_route_overlap: Optional[pulumi.Input[bool]] = None,
                 cluster_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 cluster_secondary_range_name: Optional[pulumi.Input[str]] = None,
                 create_subnetwork: Optional[pulumi.Input[bool]] = None,
                 node_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 services_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 services_secondary_range_name: Optional[pulumi.Input[str]] = None,
                 subnetwork_name: Optional[pulumi.Input[str]] = None,
                 use_ip_aliases: Optional[pulumi.Input[bool]] = None,
                 use_routes: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for controlling how IPs are allocated in the cluster.
        :param pulumi.Input[bool] allow_route_overlap: If true, allow allocation of cluster CIDR ranges that overlap with certain kinds of network routes. By default we do not allow cluster CIDR ranges to intersect with any user declared routes. With allow_route_overlap == true, we allow overlapping with CIDR ranges that are larger than the cluster CIDR range. If this field is set to true, then cluster and services CIDRs must be fully-specified (e.g. `10.96.0.0/14`, but not `/14`), which means: 1) When `use_ip_aliases` is true, `cluster_ipv4_cidr_block` and `services_ipv4_cidr_block` must be fully-specified. 2) When `use_ip_aliases` is false, `cluster.cluster_ipv4_cidr` muse be fully-specified.
        :param pulumi.Input[str] cluster_ipv4_cidr_block: The IP address range for the cluster pod IPs. If this field is set, then `cluster.cluster_ipv4_cidr` must be left blank. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param pulumi.Input[str] cluster_secondary_range_name: The name of the secondary range to be used for the cluster CIDR block. The secondary range will be used for pod IP addresses. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases and create_subnetwork is false.
        :param pulumi.Input[bool] create_subnetwork: Whether a new subnetwork will be created automatically for the cluster. This field is only applicable when `use_ip_aliases` is true.
        :param pulumi.Input[str] node_ipv4_cidr_block: The IP address range of the instance IPs in this cluster. This is applicable only if `create_subnetwork` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param pulumi.Input[str] services_ipv4_cidr_block: The IP address range of the services IPs in this cluster. If blank, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param pulumi.Input[str] services_secondary_range_name: The name of the secondary range to be used as for the services CIDR block. The secondary range will be used for service ClusterIPs. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases and create_subnetwork is false.
        :param pulumi.Input[str] subnetwork_name: A custom subnetwork name to be used if `create_subnetwork` is true. If this field is empty, then an automatic name will be chosen for the new subnetwork.
        :param pulumi.Input[bool] use_ip_aliases: Whether alias IPs will be used for pod IPs in the cluster. This is used in conjunction with use_routes. It cannot be true if use_routes is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        :param pulumi.Input[bool] use_routes: Whether routes will be used for pod IPs in the cluster. This is used in conjunction with use_ip_aliases. It cannot be true if use_ip_aliases is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        """
        if allow_route_overlap is not None:
            pulumi.set(__self__, "allow_route_overlap", allow_route_overlap)
        if cluster_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        if cluster_secondary_range_name is not None:
            pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        if create_subnetwork is not None:
            pulumi.set(__self__, "create_subnetwork", create_subnetwork)
        if node_ipv4_cidr_block is not None:
            pulumi.set(__self__, "node_ipv4_cidr_block", node_ipv4_cidr_block)
        if services_ipv4_cidr_block is not None:
            pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        if services_secondary_range_name is not None:
            pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)
        if subnetwork_name is not None:
            pulumi.set(__self__, "subnetwork_name", subnetwork_name)
        if use_ip_aliases is not None:
            pulumi.set(__self__, "use_ip_aliases", use_ip_aliases)
        if use_routes is not None:
            pulumi.set(__self__, "use_routes", use_routes)

    @property
    @pulumi.getter(name="allowRouteOverlap")
    def allow_route_overlap(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, allow allocation of cluster CIDR ranges that overlap with certain kinds of network routes. By default we do not allow cluster CIDR ranges to intersect with any user declared routes. With allow_route_overlap == true, we allow overlapping with CIDR ranges that are larger than the cluster CIDR range. If this field is set to true, then cluster and services CIDRs must be fully-specified (e.g. `10.96.0.0/14`, but not `/14`), which means: 1) When `use_ip_aliases` is true, `cluster_ipv4_cidr_block` and `services_ipv4_cidr_block` must be fully-specified. 2) When `use_ip_aliases` is false, `cluster.cluster_ipv4_cidr` muse be fully-specified.
        """
        return pulumi.get(self, "allow_route_overlap")

    @allow_route_overlap.setter
    def allow_route_overlap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_route_overlap", value)

    @property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address range for the cluster pod IPs. If this field is set, then `cluster.cluster_ipv4_cidr` must be left blank. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @cluster_ipv4_cidr_block.setter
    def cluster_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the secondary range to be used for the cluster CIDR block. The secondary range will be used for pod IP addresses. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases and create_subnetwork is false.
        """
        return pulumi.get(self, "cluster_secondary_range_name")

    @cluster_secondary_range_name.setter
    def cluster_secondary_range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_secondary_range_name", value)

    @property
    @pulumi.getter(name="createSubnetwork")
    def create_subnetwork(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether a new subnetwork will be created automatically for the cluster. This field is only applicable when `use_ip_aliases` is true.
        """
        return pulumi.get(self, "create_subnetwork")

    @create_subnetwork.setter
    def create_subnetwork(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_subnetwork", value)

    @property
    @pulumi.getter(name="nodeIpv4CidrBlock")
    def node_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address range of the instance IPs in this cluster. This is applicable only if `create_subnetwork` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "node_ipv4_cidr_block")

    @node_ipv4_cidr_block.setter
    def node_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address range of the services IPs in this cluster. If blank, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "services_ipv4_cidr_block")

    @services_ipv4_cidr_block.setter
    def services_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "services_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the secondary range to be used as for the services CIDR block. The secondary range will be used for service ClusterIPs. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases and create_subnetwork is false.
        """
        return pulumi.get(self, "services_secondary_range_name")

    @services_secondary_range_name.setter
    def services_secondary_range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "services_secondary_range_name", value)

    @property
    @pulumi.getter(name="subnetworkName")
    def subnetwork_name(self) -> Optional[pulumi.Input[str]]:
        """
        A custom subnetwork name to be used if `create_subnetwork` is true. If this field is empty, then an automatic name will be chosen for the new subnetwork.
        """
        return pulumi.get(self, "subnetwork_name")

    @subnetwork_name.setter
    def subnetwork_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork_name", value)

    @property
    @pulumi.getter(name="useIpAliases")
    def use_ip_aliases(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether alias IPs will be used for pod IPs in the cluster. This is used in conjunction with use_routes. It cannot be true if use_routes is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        """
        return pulumi.get(self, "use_ip_aliases")

    @use_ip_aliases.setter
    def use_ip_aliases(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ip_aliases", value)

    @property
    @pulumi.getter(name="useRoutes")
    def use_routes(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether routes will be used for pod IPs in the cluster. This is used in conjunction with use_ip_aliases. It cannot be true if use_ip_aliases is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        """
        return pulumi.get(self, "use_routes")

    @use_routes.setter
    def use_routes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_routes", value)


@pulumi.input_type
class IstioConfigArgs:
    def __init__(__self__, *,
                 auth: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration options for Istio addon.
        :param pulumi.Input[str] auth: The specified Istio auth mode, either none, or mutual TLS.
        :param pulumi.Input[bool] disabled: Whether Istio is enabled for this cluster.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[str]]:
        """
        The specified Istio auth mode, either none, or mutual TLS.
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Istio is enabled for this cluster.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)


@pulumi.input_type
class KalmConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration options for the KALM addon.
        :param pulumi.Input[bool] enabled: Whether KALM is enabled for this cluster.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether KALM is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class KubernetesDashboardArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for the Kubernetes Dashboard.
        :param pulumi.Input[bool] disabled: Whether the Kubernetes Dashboard is enabled for this cluster.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the Kubernetes Dashboard is enabled for this cluster.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)


@pulumi.input_type
class LegacyAbacArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for the legacy Attribute Based Access Control authorization mode.
        :param pulumi.Input[bool] enabled: Whether the ABAC authorizer is enabled for this cluster. When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the ABAC authorizer is enabled for this cluster. When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class LinuxNodeConfigArgs:
    def __init__(__self__, *,
                 sysctls: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Parameters that can be configured on Linux nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] sysctls: The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. The following parameters are supported. net.core.netdev_max_backlog net.core.rmem_max net.core.wmem_default net.core.wmem_max net.core.optmem_max net.core.somaxconn net.ipv4.tcp_rmem net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse
        """
        if sysctls is not None:
            pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter
    def sysctls(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. The following parameters are supported. net.core.netdev_max_backlog net.core.rmem_max net.core.wmem_default net.core.wmem_max net.core.optmem_max net.core.somaxconn net.ipv4.tcp_rmem net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse
        """
        return pulumi.get(self, "sysctls")

    @sysctls.setter
    def sysctls(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "sysctls", value)


@pulumi.input_type
class MaintenancePolicyArgs:
    def __init__(__self__, *,
                 resource_version: Optional[pulumi.Input[str]] = None,
                 window: Optional[pulumi.Input['MaintenanceWindowArgs']] = None):
        """
        MaintenancePolicy defines the maintenance policy to be used for the cluster.
        :param pulumi.Input[str] resource_version: A hash identifying the version of this policy, so that updates to fields of the policy won't accidentally undo intermediate changes (and so that users of the API unaware of some fields won't accidentally remove other fields). Make a `get()` request to the cluster to get the current resource version and include it with requests to set the policy.
        :param pulumi.Input['MaintenanceWindowArgs'] window: Specifies the maintenance window in which maintenance may be performed.
        """
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[str]]:
        """
        A hash identifying the version of this policy, so that updates to fields of the policy won't accidentally undo intermediate changes (and so that users of the API unaware of some fields won't accidentally remove other fields). Make a `get()` request to the cluster to get the current resource version and include it with requests to set the policy.
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input['MaintenanceWindowArgs']]:
        """
        Specifies the maintenance window in which maintenance may be performed.
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input['MaintenanceWindowArgs']]):
        pulumi.set(self, "window", value)


@pulumi.input_type
class MaintenanceWindowArgs:
    def __init__(__self__, *,
                 daily_maintenance_window: Optional[pulumi.Input['DailyMaintenanceWindowArgs']] = None,
                 maintenance_exclusions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 recurring_window: Optional[pulumi.Input['RecurringTimeWindowArgs']] = None):
        """
        MaintenanceWindow defines the maintenance window to be used for the cluster.
        :param pulumi.Input['DailyMaintenanceWindowArgs'] daily_maintenance_window: DailyMaintenanceWindow specifies a daily maintenance operation window.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] maintenance_exclusions: Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows.
        :param pulumi.Input['RecurringTimeWindowArgs'] recurring_window: RecurringWindow specifies some number of recurring time periods for maintenance to occur. The time windows may be overlapping. If no maintenance windows are set, maintenance can occur at any time.
        """
        if daily_maintenance_window is not None:
            pulumi.set(__self__, "daily_maintenance_window", daily_maintenance_window)
        if maintenance_exclusions is not None:
            pulumi.set(__self__, "maintenance_exclusions", maintenance_exclusions)
        if recurring_window is not None:
            pulumi.set(__self__, "recurring_window", recurring_window)

    @property
    @pulumi.getter(name="dailyMaintenanceWindow")
    def daily_maintenance_window(self) -> Optional[pulumi.Input['DailyMaintenanceWindowArgs']]:
        """
        DailyMaintenanceWindow specifies a daily maintenance operation window.
        """
        return pulumi.get(self, "daily_maintenance_window")

    @daily_maintenance_window.setter
    def daily_maintenance_window(self, value: Optional[pulumi.Input['DailyMaintenanceWindowArgs']]):
        pulumi.set(self, "daily_maintenance_window", value)

    @property
    @pulumi.getter(name="maintenanceExclusions")
    def maintenance_exclusions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows.
        """
        return pulumi.get(self, "maintenance_exclusions")

    @maintenance_exclusions.setter
    def maintenance_exclusions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "maintenance_exclusions", value)

    @property
    @pulumi.getter(name="recurringWindow")
    def recurring_window(self) -> Optional[pulumi.Input['RecurringTimeWindowArgs']]:
        """
        RecurringWindow specifies some number of recurring time periods for maintenance to occur. The time windows may be overlapping. If no maintenance windows are set, maintenance can occur at any time.
        """
        return pulumi.get(self, "recurring_window")

    @recurring_window.setter
    def recurring_window(self, value: Optional[pulumi.Input['RecurringTimeWindowArgs']]):
        pulumi.set(self, "recurring_window", value)


@pulumi.input_type
class MasterArgs:
    def __init__(__self__):
        """
        Master is the configuration for components on master.
        """
        pass


@pulumi.input_type
class MasterAuthArgs:
    def __init__(__self__, *,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_certificate_config: Optional[pulumi.Input['ClientCertificateConfigArgs']] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_certificate: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The authentication information for accessing the master endpoint. Authentication can be done using HTTP basic auth or using client certificates.
        :param pulumi.Input[str] client_certificate: [Output only] Base64-encoded public certificate used by clients to authenticate to the cluster endpoint.
        :param pulumi.Input['ClientCertificateConfigArgs'] client_certificate_config: Configuration for client certificate authentication on the cluster. For clusters before v1.12, if no configuration is specified, a client certificate is issued.
        :param pulumi.Input[str] client_key: [Output only] Base64-encoded private key used by clients to authenticate to the cluster endpoint.
        :param pulumi.Input[str] password: The password to use for HTTP basic authentication to the master endpoint. Because the master endpoint is open to the Internet, you should create a strong password. If a password is provided for cluster creation, username must be non-empty. Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        :param pulumi.Input[str] username: The username to use for HTTP basic authentication to the master endpoint. For clusters v1.6.0 and later, basic authentication can be disabled by leaving username unspecified (or setting it to the empty string). Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_certificate_config is not None:
            pulumi.set(__self__, "client_certificate_config", client_certificate_config)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only] Base64-encoded public certificate used by clients to authenticate to the cluster endpoint.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientCertificateConfig")
    def client_certificate_config(self) -> Optional[pulumi.Input['ClientCertificateConfigArgs']]:
        """
        Configuration for client certificate authentication on the cluster. For clusters before v1.12, if no configuration is specified, a client certificate is issued.
        """
        return pulumi.get(self, "client_certificate_config")

    @client_certificate_config.setter
    def client_certificate_config(self, value: Optional[pulumi.Input['ClientCertificateConfigArgs']]):
        pulumi.set(self, "client_certificate_config", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only] Base64-encoded private key used by clients to authenticate to the cluster endpoint.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_ca_certificate")

    @cluster_ca_certificate.setter
    def cluster_ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_certificate", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password to use for HTTP basic authentication to the master endpoint. Because the master endpoint is open to the Internet, you should create a strong password. If a password is provided for cluster creation, username must be non-empty. Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username to use for HTTP basic authentication to the master endpoint. For clusters v1.6.0 and later, basic authentication can be disabled by leaving username unspecified (or setting it to the empty string). Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class MasterAuthorizedNetworksConfigArgs:
    def __init__(__self__, *,
                 cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input['CidrBlockArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
        :param pulumi.Input[Sequence[pulumi.Input['CidrBlockArgs']]] cidr_blocks: cidr_blocks define up to 10 external networks that could access Kubernetes master through HTTPS.
        :param pulumi.Input[bool] enabled: Whether or not master authorized networks is enabled.
        """
        if cidr_blocks is not None:
            pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CidrBlockArgs']]]]:
        """
        cidr_blocks define up to 10 external networks that could access Kubernetes master through HTTPS.
        """
        return pulumi.get(self, "cidr_blocks")

    @cidr_blocks.setter
    def cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CidrBlockArgs']]]]):
        pulumi.set(self, "cidr_blocks", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not master authorized networks is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class MaxPodsConstraintArgs:
    def __init__(__self__, *,
                 max_pods_per_node: Optional[pulumi.Input[str]] = None):
        """
        Constraints applied to pods.
        :param pulumi.Input[str] max_pods_per_node: Constraint enforced on the max num of pods per node.
        """
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[pulumi.Input[str]]:
        """
        Constraint enforced on the max num of pods per node.
        """
        return pulumi.get(self, "max_pods_per_node")

    @max_pods_per_node.setter
    def max_pods_per_node(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_pods_per_node", value)


@pulumi.input_type
class NetworkConfigArgs:
    def __init__(__self__, *,
                 datapath_provider: Optional[pulumi.Input[str]] = None,
                 default_snat_status: Optional[pulumi.Input['DefaultSnatStatusArgs']] = None,
                 enable_intra_node_visibility: Optional[pulumi.Input[bool]] = None,
                 enable_l4ilb_subsetting: Optional[pulumi.Input[bool]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None):
        """
        NetworkConfig reports the relative names of network & subnetwork.
        :param pulumi.Input[str] datapath_provider: The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.
        :param pulumi.Input['DefaultSnatStatusArgs'] default_snat_status: Whether the cluster disables default in-node sNAT rules. In-node sNAT rules will be disabled when default_snat_status is disabled. When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
        :param pulumi.Input[bool] enable_intra_node_visibility: Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
        :param pulumi.Input[bool] enable_l4ilb_subsetting: Whether L4ILB Subsetting is enabled for this cluster.
        :param pulumi.Input[str] network: The relative name of the Google Compute Engine network(https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to which the cluster is connected. Example: projects/my-project/global/networks/my-network
        :param pulumi.Input[str] private_ipv6_google_access: The desired state of IPv6 connectivity to Google Services. By default, no private IPv6 access to or from Google Services (all access will be via IPv4)
        :param pulumi.Input[str] subnetwork: The relative name of the Google Compute Engine [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the cluster is connected. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
        """
        if datapath_provider is not None:
            pulumi.set(__self__, "datapath_provider", datapath_provider)
        if default_snat_status is not None:
            pulumi.set(__self__, "default_snat_status", default_snat_status)
        if enable_intra_node_visibility is not None:
            pulumi.set(__self__, "enable_intra_node_visibility", enable_intra_node_visibility)
        if enable_l4ilb_subsetting is not None:
            pulumi.set(__self__, "enable_l4ilb_subsetting", enable_l4ilb_subsetting)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_ipv6_google_access is not None:
            pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="datapathProvider")
    def datapath_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.
        """
        return pulumi.get(self, "datapath_provider")

    @datapath_provider.setter
    def datapath_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datapath_provider", value)

    @property
    @pulumi.getter(name="defaultSnatStatus")
    def default_snat_status(self) -> Optional[pulumi.Input['DefaultSnatStatusArgs']]:
        """
        Whether the cluster disables default in-node sNAT rules. In-node sNAT rules will be disabled when default_snat_status is disabled. When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
        """
        return pulumi.get(self, "default_snat_status")

    @default_snat_status.setter
    def default_snat_status(self, value: Optional[pulumi.Input['DefaultSnatStatusArgs']]):
        pulumi.set(self, "default_snat_status", value)

    @property
    @pulumi.getter(name="enableIntraNodeVisibility")
    def enable_intra_node_visibility(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
        """
        return pulumi.get(self, "enable_intra_node_visibility")

    @enable_intra_node_visibility.setter
    def enable_intra_node_visibility(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_intra_node_visibility", value)

    @property
    @pulumi.getter(name="enableL4ilbSubsetting")
    def enable_l4ilb_subsetting(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether L4ILB Subsetting is enabled for this cluster.
        """
        return pulumi.get(self, "enable_l4ilb_subsetting")

    @enable_l4ilb_subsetting.setter
    def enable_l4ilb_subsetting(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_l4ilb_subsetting", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The relative name of the Google Compute Engine network(https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to which the cluster is connected. Example: projects/my-project/global/networks/my-network
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> Optional[pulumi.Input[str]]:
        """
        The desired state of IPv6 connectivity to Google Services. By default, no private IPv6 access to or from Google Services (all access will be via IPv4)
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @private_ipv6_google_access.setter
    def private_ipv6_google_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ipv6_google_access", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The relative name of the Google Compute Engine [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the cluster is connected. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class NetworkPolicyArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 provider: Optional[pulumi.Input[str]] = None):
        """
        Configuration options for the NetworkPolicy feature. https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
        :param pulumi.Input[bool] enabled: Whether network policy is enabled on the cluster.
        :param pulumi.Input[str] provider: The selected network policy provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether network policy is enabled on the cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def provider(self) -> Optional[pulumi.Input[str]]:
        """
        The selected network policy provider.
        """
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider", value)


@pulumi.input_type
class NetworkPolicyConfigArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
        :param pulumi.Input[bool] disabled: Whether NetworkPolicy is enabled for this cluster.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether NetworkPolicy is enabled for this cluster.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)


@pulumi.input_type
class NodeConfigArgs:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]] = None,
                 boot_disk_kms_key: Optional[pulumi.Input[str]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 ephemeral_storage_config: Optional[pulumi.Input['EphemeralStorageConfigArgs']] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 kubelet_config: Optional[pulumi.Input['NodeKubeletConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linux_node_config: Optional[pulumi.Input['LinuxNodeConfigArgs']] = None,
                 local_ssd_count: Optional[pulumi.Input[int]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 node_group: Optional[pulumi.Input[str]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preemptible: Optional[pulumi.Input[bool]] = None,
                 reservation_affinity: Optional[pulumi.Input['ReservationAffinityArgs']] = None,
                 sandbox_config: Optional[pulumi.Input['SandboxConfigArgs']] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 shielded_instance_config: Optional[pulumi.Input['ShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]]] = None,
                 workload_metadata_config: Optional[pulumi.Input['WorkloadMetadataConfigArgs']] = None):
        """
        Parameters that describe the nodes in a cluster.
        :param pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]] accelerators: A list of hardware accelerators to be attached to each node. See https://cloud.google.com/compute/docs/gpus for more information about support for GPUs.
        :param pulumi.Input[str] boot_disk_kms_key:  The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        :param pulumi.Input[int] disk_size_gb: Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        :param pulumi.Input[str] disk_type: Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        :param pulumi.Input['EphemeralStorageConfigArgs'] ephemeral_storage_config: Parameters for the ephemeral storage filesystem. If unspecified, ephemeral storage is backed by the boot disk.
        :param pulumi.Input[str] image_type: The image type to use for this node. Note that for a given image type, the latest version of it will be used.
        :param pulumi.Input['NodeKubeletConfigArgs'] kubelet_config: Node kubelet configs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node. In case of conflict in label keys, the applied set may differ depending on the Kubernetes version -- it's best to assume the behavior is undefined and conflicts should be avoided. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
        :param pulumi.Input['LinuxNodeConfigArgs'] linux_node_config: Parameters that can be configured on Linux nodes.
        :param pulumi.Input[int] local_ssd_count: The number of local SSD disks to be attached to the node. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.
        :param pulumi.Input[str] machine_type: The name of a Google Compute Engine [machine type](https://cloud.google.com/compute/docs/machine-types). If unspecified, the default machine type is `e2-medium`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: The metadata key/value pairs assigned to instances in the cluster. Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes in length. These are reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project or be one of the reserved keys: - "cluster-location" - "cluster-name" - "cluster-uid" - "configure-sh" - "containerd-configure-sh" - "enable-oslogin" - "gci-ensure-gke-docker" - "gci-metrics-enabled" - "gci-update-strategy" - "instance-template" - "kube-env" - "startup-script" - "user-data" - "disable-address-manager" - "windows-startup-script-ps1" - "common-psm1" - "k8s-node-setup-psm1" - "install-ssh-psm1" - "user-profile-psm1" The following keys are reserved for Windows nodes: - "serial-port-logging-enable" Values are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on them is that each value's size must be less than or equal to 32 KB. The total size of all keys and values must be less than 512 KB.
        :param pulumi.Input[str] min_cpu_platform: Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy Bridge"`. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        :param pulumi.Input[str] node_group: Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on [sole tenant nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_scopes: The set of Google API scopes to be made available on all of the node VMs under the "default" service account. The following scopes are recommended, but not required, and by default are not included: * `https://www.googleapis.com/auth/compute` is required for mounting persistent storage on your nodes. * `https://www.googleapis.com/auth/devstorage.read_only` is required for communicating with **gcr.io** (the [Google Container Registry](https://cloud.google.com/container-registry/)). If unspecified, no scopes are added, unless Cloud Logging or Cloud Monitoring are enabled, in which case their required scopes will be added.
        :param pulumi.Input[bool] preemptible: Whether the nodes are created as preemptible VM instances. See: https://cloud.google.com/compute/docs/instances/preemptible for more inforamtion about preemptible VM instances.
        :param pulumi.Input['ReservationAffinityArgs'] reservation_affinity: The optional reservation affinity. Setting this field will apply the specified [Zonal Compute Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) to this node pool.
        :param pulumi.Input['SandboxConfigArgs'] sandbox_config: Sandbox configuration for this node.
        :param pulumi.Input[str] service_account: The Google Cloud Platform Service Account to be used by the node VMs. Specify the email address of the Service Account; otherwise, if no Service Account is specified, the "default" service account is used.
        :param pulumi.Input['ShieldedInstanceConfigArgs'] shielded_instance_config: Shielded Instance options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        :param pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]] taints: List of kubernetes taints to be applied to each node. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
        :param pulumi.Input['WorkloadMetadataConfigArgs'] workload_metadata_config: The workload metadata configuration for this node.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if boot_disk_kms_key is not None:
            pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if ephemeral_storage_config is not None:
            pulumi.set(__self__, "ephemeral_storage_config", ephemeral_storage_config)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if kubelet_config is not None:
            pulumi.set(__self__, "kubelet_config", kubelet_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linux_node_config is not None:
            pulumi.set(__self__, "linux_node_config", linux_node_config)
        if local_ssd_count is not None:
            pulumi.set(__self__, "local_ssd_count", local_ssd_count)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if node_group is not None:
            pulumi.set(__self__, "node_group", node_group)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if preemptible is not None:
            pulumi.set(__self__, "preemptible", preemptible)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if sandbox_config is not None:
            pulumi.set(__self__, "sandbox_config", sandbox_config)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if workload_metadata_config is not None:
            pulumi.set(__self__, "workload_metadata_config", workload_metadata_config)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]]:
        """
        A list of hardware accelerators to be attached to each node. See https://cloud.google.com/compute/docs/gpus for more information about support for GPUs.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> Optional[pulumi.Input[str]]:
        """
         The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        """
        return pulumi.get(self, "boot_disk_kms_key")

    @boot_disk_kms_key.setter
    def boot_disk_kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_kms_key", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="ephemeralStorageConfig")
    def ephemeral_storage_config(self) -> Optional[pulumi.Input['EphemeralStorageConfigArgs']]:
        """
        Parameters for the ephemeral storage filesystem. If unspecified, ephemeral storage is backed by the boot disk.
        """
        return pulumi.get(self, "ephemeral_storage_config")

    @ephemeral_storage_config.setter
    def ephemeral_storage_config(self, value: Optional[pulumi.Input['EphemeralStorageConfigArgs']]):
        pulumi.set(self, "ephemeral_storage_config", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[str]]:
        """
        The image type to use for this node. Note that for a given image type, the latest version of it will be used.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> Optional[pulumi.Input['NodeKubeletConfigArgs']]:
        """
        Node kubelet configs.
        """
        return pulumi.get(self, "kubelet_config")

    @kubelet_config.setter
    def kubelet_config(self, value: Optional[pulumi.Input['NodeKubeletConfigArgs']]):
        pulumi.set(self, "kubelet_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node. In case of conflict in label keys, the applied set may differ depending on the Kubernetes version -- it's best to assume the behavior is undefined and conflicts should be avoided. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linuxNodeConfig")
    def linux_node_config(self) -> Optional[pulumi.Input['LinuxNodeConfigArgs']]:
        """
        Parameters that can be configured on Linux nodes.
        """
        return pulumi.get(self, "linux_node_config")

    @linux_node_config.setter
    def linux_node_config(self, value: Optional[pulumi.Input['LinuxNodeConfigArgs']]):
        pulumi.set(self, "linux_node_config", value)

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of local SSD disks to be attached to the node. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.
        """
        return pulumi.get(self, "local_ssd_count")

    @local_ssd_count.setter
    def local_ssd_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "local_ssd_count", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Google Compute Engine [machine type](https://cloud.google.com/compute/docs/machine-types). If unspecified, the default machine type is `e2-medium`.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The metadata key/value pairs assigned to instances in the cluster. Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes in length. These are reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project or be one of the reserved keys: - "cluster-location" - "cluster-name" - "cluster-uid" - "configure-sh" - "containerd-configure-sh" - "enable-oslogin" - "gci-ensure-gke-docker" - "gci-metrics-enabled" - "gci-update-strategy" - "instance-template" - "kube-env" - "startup-script" - "user-data" - "disable-address-manager" - "windows-startup-script-ps1" - "common-psm1" - "k8s-node-setup-psm1" - "install-ssh-psm1" - "user-profile-psm1" The following keys are reserved for Windows nodes: - "serial-port-logging-enable" Values are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on them is that each value's size must be less than or equal to 32 KB. The total size of all keys and values must be less than 512 KB.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy Bridge"`. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="nodeGroup")
    def node_group(self) -> Optional[pulumi.Input[str]]:
        """
        Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on [sole tenant nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
        """
        return pulumi.get(self, "node_group")

    @node_group.setter
    def node_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_group", value)

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of Google API scopes to be made available on all of the node VMs under the "default" service account. The following scopes are recommended, but not required, and by default are not included: * `https://www.googleapis.com/auth/compute` is required for mounting persistent storage on your nodes. * `https://www.googleapis.com/auth/devstorage.read_only` is required for communicating with **gcr.io** (the [Google Container Registry](https://cloud.google.com/container-registry/)). If unspecified, no scopes are added, unless Cloud Logging or Cloud Monitoring are enabled, in which case their required scopes will be added.
        """
        return pulumi.get(self, "oauth_scopes")

    @oauth_scopes.setter
    def oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oauth_scopes", value)

    @property
    @pulumi.getter
    def preemptible(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the nodes are created as preemptible VM instances. See: https://cloud.google.com/compute/docs/instances/preemptible for more inforamtion about preemptible VM instances.
        """
        return pulumi.get(self, "preemptible")

    @preemptible.setter
    def preemptible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preemptible", value)

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['ReservationAffinityArgs']]:
        """
        The optional reservation affinity. Setting this field will apply the specified [Zonal Compute Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) to this node pool.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['ReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @property
    @pulumi.getter(name="sandboxConfig")
    def sandbox_config(self) -> Optional[pulumi.Input['SandboxConfigArgs']]:
        """
        Sandbox configuration for this node.
        """
        return pulumi.get(self, "sandbox_config")

    @sandbox_config.setter
    def sandbox_config(self, value: Optional[pulumi.Input['SandboxConfigArgs']]):
        pulumi.set(self, "sandbox_config", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The Google Cloud Platform Service Account to be used by the node VMs. Specify the email address of the Service Account; otherwise, if no Service Account is specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['ShieldedInstanceConfigArgs']]:
        """
        Shielded Instance options.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['ShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]]]:
        """
        List of kubernetes taints to be applied to each node. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="workloadMetadataConfig")
    def workload_metadata_config(self) -> Optional[pulumi.Input['WorkloadMetadataConfigArgs']]:
        """
        The workload metadata configuration for this node.
        """
        return pulumi.get(self, "workload_metadata_config")

    @workload_metadata_config.setter
    def workload_metadata_config(self, value: Optional[pulumi.Input['WorkloadMetadataConfigArgs']]):
        pulumi.set(self, "workload_metadata_config", value)


@pulumi.input_type
class NodeKubeletConfigArgs:
    def __init__(__self__, *,
                 cpu_cfs_quota: Optional[pulumi.Input[bool]] = None,
                 cpu_cfs_quota_period: Optional[pulumi.Input[str]] = None,
                 cpu_manager_policy: Optional[pulumi.Input[str]] = None):
        """
        Node kubelet configs.
        :param pulumi.Input[bool] cpu_cfs_quota: Enable CPU CFS quota enforcement for containers that specify CPU limits. This option is enabled by default which makes kubelet use CFS quota (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to enforce container CPU limits. Otherwise, CPU limits will not be enforced at all. Disable this option to mitigate CPU throttling problems while still having your pods to be in Guaranteed QoS class by specifying the CPU limits. The default value is 'true' if unspecified.
        :param pulumi.Input[str] cpu_cfs_quota_period: Set the CPU CFS quota period value 'cpu.cfs_period_us'. The string must be a sequence of decimal numbers, each with optional fraction and a unit suffix, such as "300ms". Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". The value must be a positive duration.
        :param pulumi.Input[str] cpu_manager_policy: Control the CPU management policy on the node. See https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/ The following values are allowed. - "none": the default, which represents the existing scheduling behavior. - "static": allows pods with certain resource characteristics to be granted increased CPU affinity and exclusivity on the node. The default value is 'none' if unspecified.
        """
        if cpu_cfs_quota is not None:
            pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        if cpu_cfs_quota_period is not None:
            pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)
        if cpu_manager_policy is not None:
            pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)

    @property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable CPU CFS quota enforcement for containers that specify CPU limits. This option is enabled by default which makes kubelet use CFS quota (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to enforce container CPU limits. Otherwise, CPU limits will not be enforced at all. Disable this option to mitigate CPU throttling problems while still having your pods to be in Guaranteed QoS class by specifying the CPU limits. The default value is 'true' if unspecified.
        """
        return pulumi.get(self, "cpu_cfs_quota")

    @cpu_cfs_quota.setter
    def cpu_cfs_quota(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cpu_cfs_quota", value)

    @property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> Optional[pulumi.Input[str]]:
        """
        Set the CPU CFS quota period value 'cpu.cfs_period_us'. The string must be a sequence of decimal numbers, each with optional fraction and a unit suffix, such as "300ms". Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". The value must be a positive duration.
        """
        return pulumi.get(self, "cpu_cfs_quota_period")

    @cpu_cfs_quota_period.setter
    def cpu_cfs_quota_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_cfs_quota_period", value)

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Control the CPU management policy on the node. See https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/ The following values are allowed. - "none": the default, which represents the existing scheduling behavior. - "static": allows pods with certain resource characteristics to be granted increased CPU affinity and exclusivity on the node. The default value is 'none' if unspecified.
        """
        return pulumi.get(self, "cpu_manager_policy")

    @cpu_manager_policy.setter
    def cpu_manager_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_manager_policy", value)


@pulumi.input_type
class NodeManagementArgs:
    def __init__(__self__, *,
                 auto_repair: Optional[pulumi.Input[bool]] = None,
                 auto_upgrade: Optional[pulumi.Input[bool]] = None,
                 upgrade_options: Optional[pulumi.Input['AutoUpgradeOptionsArgs']] = None):
        """
        NodeManagement defines the set of node management services turned on for the node pool.
        :param pulumi.Input[bool] auto_repair: Whether the nodes will be automatically repaired.
        :param pulumi.Input[bool] auto_upgrade: Whether the nodes will be automatically upgraded.
        :param pulumi.Input['AutoUpgradeOptionsArgs'] upgrade_options: Specifies the Auto Upgrade knobs for the node pool.
        """
        if auto_repair is not None:
            pulumi.set(__self__, "auto_repair", auto_repair)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if upgrade_options is not None:
            pulumi.set(__self__, "upgrade_options", upgrade_options)

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the nodes will be automatically repaired.
        """
        return pulumi.get(self, "auto_repair")

    @auto_repair.setter
    def auto_repair(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_repair", value)

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the nodes will be automatically upgraded.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_upgrade", value)

    @property
    @pulumi.getter(name="upgradeOptions")
    def upgrade_options(self) -> Optional[pulumi.Input['AutoUpgradeOptionsArgs']]:
        """
        Specifies the Auto Upgrade knobs for the node pool.
        """
        return pulumi.get(self, "upgrade_options")

    @upgrade_options.setter
    def upgrade_options(self, value: Optional[pulumi.Input['AutoUpgradeOptionsArgs']]):
        pulumi.set(self, "upgrade_options", value)


@pulumi.input_type
class NodeNetworkConfigArgs:
    def __init__(__self__, *,
                 create_pod_range: Optional[pulumi.Input[bool]] = None,
                 pod_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 pod_range: Optional[pulumi.Input[str]] = None):
        """
        Parameters for node pool-level network config. Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
        :param pulumi.Input[bool] create_pod_range: Input only. Whether to create a new range for pod IPs in this node pool. Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they are not specified. If neither `create_pod_range` or `pod_range` are specified, the cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is used.
        :param pulumi.Input[str] pod_ipv4_cidr_block: The IP address range for pod IPs in this node pool. Only applicable if `create_pod_range` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
        :param pulumi.Input[str] pod_range: The ID of the secondary range for pod IPs. If `create_pod_range` is true, this ID is used for the new range. If `create_pod_range` is false, uses an existing secondary range with this ID.
        """
        if create_pod_range is not None:
            pulumi.set(__self__, "create_pod_range", create_pod_range)
        if pod_ipv4_cidr_block is not None:
            pulumi.set(__self__, "pod_ipv4_cidr_block", pod_ipv4_cidr_block)
        if pod_range is not None:
            pulumi.set(__self__, "pod_range", pod_range)

    @property
    @pulumi.getter(name="createPodRange")
    def create_pod_range(self) -> Optional[pulumi.Input[bool]]:
        """
        Input only. Whether to create a new range for pod IPs in this node pool. Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they are not specified. If neither `create_pod_range` or `pod_range` are specified, the cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is used.
        """
        return pulumi.get(self, "create_pod_range")

    @create_pod_range.setter
    def create_pod_range(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_pod_range", value)

    @property
    @pulumi.getter(name="podIpv4CidrBlock")
    def pod_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address range for pod IPs in this node pool. Only applicable if `create_pod_range` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
        """
        return pulumi.get(self, "pod_ipv4_cidr_block")

    @pod_ipv4_cidr_block.setter
    def pod_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="podRange")
    def pod_range(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the secondary range for pod IPs. If `create_pod_range` is true, this ID is used for the new range. If `create_pod_range` is false, uses an existing secondary range with this ID.
        """
        return pulumi.get(self, "pod_range")

    @pod_range.setter
    def pod_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_range", value)


@pulumi.input_type
class NodePoolArgs:
    def __init__(__self__, *,
                 autoscaling: Optional[pulumi.Input['NodePoolAutoscalingArgs']] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['StatusConditionArgs']]]] = None,
                 config: Optional[pulumi.Input['NodeConfigArgs']] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 instance_group_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 management: Optional[pulumi.Input['NodeManagementArgs']] = None,
                 max_pods_constraint: Optional[pulumi.Input['MaxPodsConstraintArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input['NodeNetworkConfigArgs']] = None,
                 pod_ipv4_cidr_size: Optional[pulumi.Input[int]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 upgrade_settings: Optional[pulumi.Input['UpgradeSettingsArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        NodePool contains the name and configuration for a cluster's node pool. Node pools are a set of nodes (i.e. VM's), with a common configuration and specification, under the control of the cluster master. They may have a set of Kubernetes labels applied to them, which may be used to reference them during pod scheduling. They may also be resized up or down, to accommodate the workload.
        :param pulumi.Input['NodePoolAutoscalingArgs'] autoscaling: Autoscaler configuration for this NodePool. Autoscaler is enabled only if a valid configuration is present.
        :param pulumi.Input[Sequence[pulumi.Input['StatusConditionArgs']]] conditions: Which conditions caused the current node pool state.
        :param pulumi.Input['NodeConfigArgs'] config: The node configuration of the pool.
        :param pulumi.Input[int] initial_node_count: The initial node count for the pool. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_group_urls: [Output only] The resource URLs of the [managed instance groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with this node pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes should be located. If this value is unspecified during node pool creation, the [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations) value will be used, instead. Warning: changing node pool locations will result in nodes being added and/or removed.
        :param pulumi.Input['NodeManagementArgs'] management: NodeManagement configuration for this NodePool.
        :param pulumi.Input['MaxPodsConstraintArgs'] max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param pulumi.Input[str] name: The name of the node pool.
        :param pulumi.Input['NodeNetworkConfigArgs'] network_config: Networking configuration for this NodePool. If specified, it overrides the cluster-level defaults.
        :param pulumi.Input[int] pod_ipv4_cidr_size: [Output only] The pod CIDR block size per node in this node pool.
        :param pulumi.Input[str] self_link: [Output only] Server-defined URL for the resource.
        :param pulumi.Input[str] status: [Output only] The status of the nodes in this pool instance.
        :param pulumi.Input['UpgradeSettingsArgs'] upgrade_settings: Upgrade settings control disruption and speed of the upgrade.
        :param pulumi.Input[str] version: The version of the Kubernetes of this node.
        """
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if initial_node_count is not None:
            pulumi.set(__self__, "initial_node_count", initial_node_count)
        if instance_group_urls is not None:
            pulumi.set(__self__, "instance_group_urls", instance_group_urls)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if max_pods_constraint is not None:
            pulumi.set(__self__, "max_pods_constraint", max_pods_constraint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if pod_ipv4_cidr_size is not None:
            pulumi.set(__self__, "pod_ipv4_cidr_size", pod_ipv4_cidr_size)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input['NodePoolAutoscalingArgs']]:
        """
        Autoscaler configuration for this NodePool. Autoscaler is enabled only if a valid configuration is present.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input['NodePoolAutoscalingArgs']]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StatusConditionArgs']]]]:
        """
        Which conditions caused the current node pool state.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StatusConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['NodeConfigArgs']]:
        """
        The node configuration of the pool.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['NodeConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The initial node count for the pool. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota.
        """
        return pulumi.get(self, "initial_node_count")

    @initial_node_count.setter
    def initial_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_node_count", value)

    @property
    @pulumi.getter(name="instanceGroupUrls")
    def instance_group_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Output only] The resource URLs of the [managed instance groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with this node pool.
        """
        return pulumi.get(self, "instance_group_urls")

    @instance_group_urls.setter
    def instance_group_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_group_urls", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes should be located. If this value is unspecified during node pool creation, the [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations) value will be used, instead. Warning: changing node pool locations will result in nodes being added and/or removed.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['NodeManagementArgs']]:
        """
        NodeManagement configuration for this NodePool.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['NodeManagementArgs']]):
        pulumi.set(self, "management", value)

    @property
    @pulumi.getter(name="maxPodsConstraint")
    def max_pods_constraint(self) -> Optional[pulumi.Input['MaxPodsConstraintArgs']]:
        """
        The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        """
        return pulumi.get(self, "max_pods_constraint")

    @max_pods_constraint.setter
    def max_pods_constraint(self, value: Optional[pulumi.Input['MaxPodsConstraintArgs']]):
        pulumi.set(self, "max_pods_constraint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['NodeNetworkConfigArgs']]:
        """
        Networking configuration for this NodePool. If specified, it overrides the cluster-level defaults.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['NodeNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="podIpv4CidrSize")
    def pod_ipv4_cidr_size(self) -> Optional[pulumi.Input[int]]:
        """
        [Output only] The pod CIDR block size per node in this node pool.
        """
        return pulumi.get(self, "pod_ipv4_cidr_size")

    @pod_ipv4_cidr_size.setter
    def pod_ipv4_cidr_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pod_ipv4_cidr_size", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only] The status of the nodes in this pool instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional[pulumi.Input['UpgradeSettingsArgs']]:
        """
        Upgrade settings control disruption and speed of the upgrade.
        """
        return pulumi.get(self, "upgrade_settings")

    @upgrade_settings.setter
    def upgrade_settings(self, value: Optional[pulumi.Input['UpgradeSettingsArgs']]):
        pulumi.set(self, "upgrade_settings", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Kubernetes of this node.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class NodePoolAutoscalingArgs:
    def __init__(__self__, *,
                 autoprovisioned: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None):
        """
        NodePoolAutoscaling contains information required by cluster autoscaler to adjust the size of the node pool to the current cluster usage.
        :param pulumi.Input[bool] autoprovisioned: Can this node pool be deleted automatically.
        :param pulumi.Input[bool] enabled: Is autoscaling enabled for this node pool.
        :param pulumi.Input[int] max_node_count: Maximum number of nodes in the NodePool. Must be >= min_node_count. There has to enough quota to scale up the cluster.
        :param pulumi.Input[int] min_node_count: Minimum number of nodes in the NodePool. Must be >= 1 and <= max_node_count.
        """
        if autoprovisioned is not None:
            pulumi.set(__self__, "autoprovisioned", autoprovisioned)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter
    def autoprovisioned(self) -> Optional[pulumi.Input[bool]]:
        """
        Can this node pool be deleted automatically.
        """
        return pulumi.get(self, "autoprovisioned")

    @autoprovisioned.setter
    def autoprovisioned(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoprovisioned", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Is autoscaling enabled for this node pool.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of nodes in the NodePool. Must be >= min_node_count. There has to enough quota to scale up the cluster.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of nodes in the NodePool. Must be >= 1 and <= max_node_count.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)


@pulumi.input_type
class NodeTaintArgs:
    def __init__(__self__, *,
                 effect: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Kubernetes taint is comprised of three fields: key, value, and effect. Effect can only be one of three types: NoSchedule, PreferNoSchedule or NoExecute. See [here](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration) for more information, including usage and the valid values.
        :param pulumi.Input[str] effect: Effect for taint.
        :param pulumi.Input[str] key: Key for taint.
        :param pulumi.Input[str] value: Value for taint.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[str]]:
        """
        Effect for taint.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key for taint.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value for taint.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NotificationConfigArgs:
    def __init__(__self__, *,
                 pubsub: Optional[pulumi.Input['PubSubArgs']] = None):
        """
        NotificationConfig is the configuration of notifications.
        :param pulumi.Input['PubSubArgs'] pubsub: Notification config for Pub/Sub.
        """
        if pubsub is not None:
            pulumi.set(__self__, "pubsub", pubsub)

    @property
    @pulumi.getter
    def pubsub(self) -> Optional[pulumi.Input['PubSubArgs']]:
        """
        Notification config for Pub/Sub.
        """
        return pulumi.get(self, "pubsub")

    @pubsub.setter
    def pubsub(self, value: Optional[pulumi.Input['PubSubArgs']]):
        pulumi.set(self, "pubsub", value)


@pulumi.input_type
class PodSecurityPolicyConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for the PodSecurityPolicy feature.
        :param pulumi.Input[bool] enabled: Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class PrivateClusterConfigArgs:
    def __init__(__self__, *,
                 enable_private_endpoint: Optional[pulumi.Input[bool]] = None,
                 enable_private_nodes: Optional[pulumi.Input[bool]] = None,
                 master_global_access_config: Optional[pulumi.Input['PrivateClusterMasterGlobalAccessConfigArgs']] = None,
                 master_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 peering_name: Optional[pulumi.Input[str]] = None,
                 private_endpoint: Optional[pulumi.Input[str]] = None,
                 public_endpoint: Optional[pulumi.Input[str]] = None):
        """
        Configuration options for private clusters.
        :param pulumi.Input[bool] enable_private_endpoint: Whether the master's internal IP address is used as the cluster endpoint.
        :param pulumi.Input[bool] enable_private_nodes: Whether nodes have internal IP addresses only. If enabled, all nodes are given only RFC 1918 private addresses and communicate with the master via private networking.
        :param pulumi.Input['PrivateClusterMasterGlobalAccessConfigArgs'] master_global_access_config: Controls master global access settings.
        :param pulumi.Input[str] master_ipv4_cidr_block: The IP range in CIDR notation to use for the hosted master network. This range will be used for assigning internal IP addresses to the master or set of masters, as well as the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network.
        :param pulumi.Input[str] peering_name: The peering name in the customer VPC used by this cluster.
        :param pulumi.Input[str] private_endpoint: The internal IP address of this cluster's master endpoint.
        :param pulumi.Input[str] public_endpoint: The external IP address of this cluster's master endpoint.
        """
        if enable_private_endpoint is not None:
            pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        if enable_private_nodes is not None:
            pulumi.set(__self__, "enable_private_nodes", enable_private_nodes)
        if master_global_access_config is not None:
            pulumi.set(__self__, "master_global_access_config", master_global_access_config)
        if master_ipv4_cidr_block is not None:
            pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)
        if peering_name is not None:
            pulumi.set(__self__, "peering_name", peering_name)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the master's internal IP address is used as the cluster endpoint.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @enable_private_endpoint.setter
    def enable_private_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_endpoint", value)

    @property
    @pulumi.getter(name="enablePrivateNodes")
    def enable_private_nodes(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether nodes have internal IP addresses only. If enabled, all nodes are given only RFC 1918 private addresses and communicate with the master via private networking.
        """
        return pulumi.get(self, "enable_private_nodes")

    @enable_private_nodes.setter
    def enable_private_nodes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_nodes", value)

    @property
    @pulumi.getter(name="masterGlobalAccessConfig")
    def master_global_access_config(self) -> Optional[pulumi.Input['PrivateClusterMasterGlobalAccessConfigArgs']]:
        """
        Controls master global access settings.
        """
        return pulumi.get(self, "master_global_access_config")

    @master_global_access_config.setter
    def master_global_access_config(self, value: Optional[pulumi.Input['PrivateClusterMasterGlobalAccessConfigArgs']]):
        pulumi.set(self, "master_global_access_config", value)

    @property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IP range in CIDR notation to use for the hosted master network. This range will be used for assigning internal IP addresses to the master or set of masters, as well as the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network.
        """
        return pulumi.get(self, "master_ipv4_cidr_block")

    @master_ipv4_cidr_block.setter
    def master_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="peeringName")
    def peering_name(self) -> Optional[pulumi.Input[str]]:
        """
        The peering name in the customer VPC used by this cluster.
        """
        return pulumi.get(self, "peering_name")

    @peering_name.setter
    def peering_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_name", value)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The internal IP address of this cluster's master endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The external IP address of this cluster's master endpoint.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_endpoint", value)


@pulumi.input_type
class PrivateClusterMasterGlobalAccessConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for controlling master global access settings.
        :param pulumi.Input[bool] enabled: Whenever master is accessible globally or not.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whenever master is accessible globally or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class PubSubArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 topic: Optional[pulumi.Input[str]] = None):
        """
        Pub/Sub specific notification config.
        :param pulumi.Input[bool] enabled: Enable notifications for Pub/Sub.
        :param pulumi.Input[str] topic: The desired Pub/Sub topic to which notifications will be sent by GKE. Format is `projects/{project}/topics/{topic}`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for Pub/Sub.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[str]]:
        """
        The desired Pub/Sub topic to which notifications will be sent by GKE. Format is `projects/{project}/topics/{topic}`.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic", value)


@pulumi.input_type
class RecurringTimeWindowArgs:
    def __init__(__self__, *,
                 recurrence: Optional[pulumi.Input[str]] = None,
                 window: Optional[pulumi.Input['TimeWindowArgs']] = None):
        """
        Represents an arbitrary window of time that recurs.
        :param pulumi.Input[str] recurrence: An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how this window reccurs. They go on for the span of time between the start and end time. For example, to have something repeat every weekday, you'd use: `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR` To repeat some window daily (equivalent to the DailyMaintenanceWindow): `FREQ=DAILY` For the first weekend of every month: `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU` This specifies how frequently the window starts. Eg, if you wanted to have a 9-5 UTC-4 window every weekday, you'd use something like: ``` start time = 2019-01-01T09:00:00-0400 end time = 2019-01-01T17:00:00-0400 recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR ``` Windows can span multiple days. Eg, to make the window encompass every weekend from midnight Saturday till the last minute of Sunday UTC: ``` start time = 2019-01-05T00:00:00Z end time = 2019-01-07T23:59:00Z recurrence = FREQ=WEEKLY;BYDAY=SA ``` Note the start and end time's specific dates are largely arbitrary except to specify duration of the window and when it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.
        :param pulumi.Input['TimeWindowArgs'] window: The window of the first recurrence.
        """
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input[str]]:
        """
        An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how this window reccurs. They go on for the span of time between the start and end time. For example, to have something repeat every weekday, you'd use: `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR` To repeat some window daily (equivalent to the DailyMaintenanceWindow): `FREQ=DAILY` For the first weekend of every month: `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU` This specifies how frequently the window starts. Eg, if you wanted to have a 9-5 UTC-4 window every weekday, you'd use something like: ``` start time = 2019-01-01T09:00:00-0400 end time = 2019-01-01T17:00:00-0400 recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR ``` Windows can span multiple days. Eg, to make the window encompass every weekend from midnight Saturday till the last minute of Sunday UTC: ``` start time = 2019-01-05T00:00:00Z end time = 2019-01-07T23:59:00Z recurrence = FREQ=WEEKLY;BYDAY=SA ``` Note the start and end time's specific dates are largely arbitrary except to specify duration of the window and when it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input['TimeWindowArgs']]:
        """
        The window of the first recurrence.
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input['TimeWindowArgs']]):
        pulumi.set(self, "window", value)


@pulumi.input_type
class ReleaseChannelArgs:
    def __init__(__self__, *,
                 channel: Optional[pulumi.Input[str]] = None):
        """
        ReleaseChannel indicates which release channel a cluster is subscribed to. Release channels are arranged in order of risk. When a cluster is subscribed to a release channel, Google maintains both the master version and the node version. Node auto-upgrade defaults to true and cannot be disabled.
        :param pulumi.Input[str] channel: channel specifies which release channel the cluster is subscribed to.
        """
        if channel is not None:
            pulumi.set(__self__, "channel", channel)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input[str]]:
        """
        channel specifies which release channel the cluster is subscribed to.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel", value)


@pulumi.input_type
class ReservationAffinityArgs:
    def __init__(__self__, *,
                 consume_reservation_type: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        [ReservationAffinity](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) is the configuration of desired reservation which instances could take capacity from.
        :param pulumi.Input[str] consume_reservation_type: Corresponds to the type of reservation consumption.
        :param pulumi.Input[str] key: Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify "googleapis.com/reservation-name" as the key and specify the name of your reservation as its value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Corresponds to the label value(s) of reservation resource(s).
        """
        if consume_reservation_type is not None:
            pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Corresponds to the type of reservation consumption.
        """
        return pulumi.get(self, "consume_reservation_type")

    @consume_reservation_type.setter
    def consume_reservation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consume_reservation_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify "googleapis.com/reservation-name" as the key and specify the name of your reservation as its value.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Corresponds to the label value(s) of reservation resource(s).
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ResourceLimitArgs:
    def __init__(__self__, *,
                 maximum: Optional[pulumi.Input[str]] = None,
                 minimum: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None):
        """
        Contains information about amount of some resource in the cluster. For memory, value should be in GB.
        :param pulumi.Input[str] maximum: Maximum amount of the resource in the cluster.
        :param pulumi.Input[str] minimum: Minimum amount of the resource in the cluster.
        :param pulumi.Input[str] resource_type: Resource name "cpu", "memory" or gpu-specific string.
        """
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def maximum(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum amount of the resource in the cluster.
        """
        return pulumi.get(self, "maximum")

    @maximum.setter
    def maximum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum", value)

    @property
    @pulumi.getter
    def minimum(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum amount of the resource in the cluster.
        """
        return pulumi.get(self, "minimum")

    @minimum.setter
    def minimum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimum", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name "cpu", "memory" or gpu-specific string.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)


@pulumi.input_type
class ResourceUsageExportConfigArgs:
    def __init__(__self__, *,
                 bigquery_destination: Optional[pulumi.Input['BigQueryDestinationArgs']] = None,
                 consumption_metering_config: Optional[pulumi.Input['ConsumptionMeteringConfigArgs']] = None,
                 enable_network_egress_metering: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for exporting cluster resource usages.
        :param pulumi.Input['BigQueryDestinationArgs'] bigquery_destination: Configuration to use BigQuery as usage export destination.
        :param pulumi.Input['ConsumptionMeteringConfigArgs'] consumption_metering_config: Configuration to enable resource consumption metering.
        :param pulumi.Input[bool] enable_network_egress_metering: Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created in the cluster to meter network egress traffic.
        """
        if bigquery_destination is not None:
            pulumi.set(__self__, "bigquery_destination", bigquery_destination)
        if consumption_metering_config is not None:
            pulumi.set(__self__, "consumption_metering_config", consumption_metering_config)
        if enable_network_egress_metering is not None:
            pulumi.set(__self__, "enable_network_egress_metering", enable_network_egress_metering)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> Optional[pulumi.Input['BigQueryDestinationArgs']]:
        """
        Configuration to use BigQuery as usage export destination.
        """
        return pulumi.get(self, "bigquery_destination")

    @bigquery_destination.setter
    def bigquery_destination(self, value: Optional[pulumi.Input['BigQueryDestinationArgs']]):
        pulumi.set(self, "bigquery_destination", value)

    @property
    @pulumi.getter(name="consumptionMeteringConfig")
    def consumption_metering_config(self) -> Optional[pulumi.Input['ConsumptionMeteringConfigArgs']]:
        """
        Configuration to enable resource consumption metering.
        """
        return pulumi.get(self, "consumption_metering_config")

    @consumption_metering_config.setter
    def consumption_metering_config(self, value: Optional[pulumi.Input['ConsumptionMeteringConfigArgs']]):
        pulumi.set(self, "consumption_metering_config", value)

    @property
    @pulumi.getter(name="enableNetworkEgressMetering")
    def enable_network_egress_metering(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created in the cluster to meter network egress traffic.
        """
        return pulumi.get(self, "enable_network_egress_metering")

    @enable_network_egress_metering.setter
    def enable_network_egress_metering(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_network_egress_metering", value)


@pulumi.input_type
class SandboxConfigArgs:
    def __init__(__self__, *,
                 sandbox_type: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        SandboxConfig contains configurations of the sandbox to use for the node.
        :param pulumi.Input[str] sandbox_type: Type of the sandbox to use for the node (e.g. 'gvisor')
        :param pulumi.Input[str] type: Type of the sandbox to use for the node.
        """
        if sandbox_type is not None:
            pulumi.set(__self__, "sandbox_type", sandbox_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="sandboxType")
    def sandbox_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the sandbox to use for the node (e.g. 'gvisor')
        """
        return pulumi.get(self, "sandbox_type")

    @sandbox_type.setter
    def sandbox_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sandbox_type", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the sandbox to use for the node.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ShieldedInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[pulumi.Input[bool]] = None,
                 enable_secure_boot: Optional[pulumi.Input[bool]] = None):
        """
        A set of Shielded Instance options.
        :param pulumi.Input[bool] enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created.
        :param pulumi.Input[bool] enable_secure_boot: Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @enable_integrity_monitoring.setter
    def enable_integrity_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_integrity_monitoring", value)

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails.
        """
        return pulumi.get(self, "enable_secure_boot")

    @enable_secure_boot.setter
    def enable_secure_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_secure_boot", value)


@pulumi.input_type
class ShieldedNodesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration of Shielded Nodes feature.
        :param pulumi.Input[bool] enabled: Whether Shielded Nodes features are enabled on all nodes in this cluster.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Shielded Nodes features are enabled on all nodes in this cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class StatusConditionArgs:
    def __init__(__self__, *,
                 canonical_code: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        StatusCondition describes why a cluster or a node pool has a certain status (e.g., ERROR or DEGRADED).
        :param pulumi.Input[str] canonical_code: Canonical code of the condition.
        :param pulumi.Input[str] message: Human-friendly representation of the condition
        """
        if canonical_code is not None:
            pulumi.set(__self__, "canonical_code", canonical_code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter(name="canonicalCode")
    def canonical_code(self) -> Optional[pulumi.Input[str]]:
        """
        Canonical code of the condition.
        """
        return pulumi.get(self, "canonical_code")

    @canonical_code.setter
    def canonical_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "canonical_code", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Human-friendly representation of the condition
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class TimeWindowArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Represents an arbitrary window of time.
        :param pulumi.Input[str] end_time: The time that the window ends. The end time should take place after the start time.
        :param pulumi.Input[str] start_time: The time that the window first starts.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the window ends. The end time should take place after the start time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the window first starts.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class TpuConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 use_service_networking: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for Cloud TPU.
        :param pulumi.Input[bool] enabled: Whether Cloud TPU integration is enabled or not.
        :param pulumi.Input[str] ipv4_cidr_block: IPv4 CIDR block reserved for Cloud TPU in the VPC.
        :param pulumi.Input[bool] use_service_networking: Whether to use service networking for Cloud TPU or not.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ipv4_cidr_block is not None:
            pulumi.set(__self__, "ipv4_cidr_block", ipv4_cidr_block)
        if use_service_networking is not None:
            pulumi.set(__self__, "use_service_networking", use_service_networking)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Cloud TPU integration is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ipv4CidrBlock")
    def ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 CIDR block reserved for Cloud TPU in the VPC.
        """
        return pulumi.get(self, "ipv4_cidr_block")

    @ipv4_cidr_block.setter
    def ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="useServiceNetworking")
    def use_service_networking(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use service networking for Cloud TPU or not.
        """
        return pulumi.get(self, "use_service_networking")

    @use_service_networking.setter
    def use_service_networking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_service_networking", value)


@pulumi.input_type
class UpgradeSettingsArgs:
    def __init__(__self__, *,
                 max_surge: Optional[pulumi.Input[int]] = None,
                 max_unavailable: Optional[pulumi.Input[int]] = None):
        """
        These upgrade settings control the level of parallelism and the level of disruption caused by an upgrade. maxUnavailable controls the number of nodes that can be simultaneously unavailable. maxSurge controls the number of additional nodes that can be added to the node pool temporarily for the time of the upgrade to increase the number of available nodes. (maxUnavailable + maxSurge) determines the level of parallelism (how many nodes are being upgraded at the same time). Note: upgrades inevitably introduce some disruption since workloads need to be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0, this holds true. (Disruption stays within the limits of PodDisruptionBudget, if it is configured.) Consider a hypothetical node pool with 5 nodes having maxSurge=2, maxUnavailable=1. This means the upgrade process upgrades 3 nodes simultaneously. It creates 2 additional (upgraded) nodes, then it brings down 3 old (not yet upgraded) nodes at the same time. This ensures that there are always at least 4 nodes available.
        :param pulumi.Input[int] max_surge: The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process.
        :param pulumi.Input[int] max_unavailable: The maximum number of nodes that can be simultaneously unavailable during the upgrade process. A node is considered available if its status is Ready.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process.
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_surge", value)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes that can be simultaneously unavailable during the upgrade process. A node is considered available if its status is Ready.
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_unavailable", value)


@pulumi.input_type
class VerticalPodAutoscalingArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        VerticalPodAutoscaling contains global, per-cluster information required by Vertical Pod Autoscaler to automatically adjust the resources of pods controlled by it.
        :param pulumi.Input[bool] enabled: Enables vertical pod autoscaling.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables vertical pod autoscaling.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class WorkloadCertificatesArgs:
    def __init__(__self__, *,
                 enable_certificates: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for issuance of mTLS keys and certificates to Kubernetes pods.
        :param pulumi.Input[bool] enable_certificates: enable_certificates controls issuance of workload mTLS certificates. If set, the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster, which can then be configured by creating a WorkloadCertificateConfig Custom Resource. Requires Workload Identity (workload_pool must be non-empty).
        """
        if enable_certificates is not None:
            pulumi.set(__self__, "enable_certificates", enable_certificates)

    @property
    @pulumi.getter(name="enableCertificates")
    def enable_certificates(self) -> Optional[pulumi.Input[bool]]:
        """
        enable_certificates controls issuance of workload mTLS certificates. If set, the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster, which can then be configured by creating a WorkloadCertificateConfig Custom Resource. Requires Workload Identity (workload_pool must be non-empty).
        """
        return pulumi.get(self, "enable_certificates")

    @enable_certificates.setter
    def enable_certificates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_certificates", value)


@pulumi.input_type
class WorkloadIdentityConfigArgs:
    def __init__(__self__, *,
                 identity_namespace: Optional[pulumi.Input[str]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 workload_pool: Optional[pulumi.Input[str]] = None):
        """
        Configuration for the use of Kubernetes Service Accounts in GCP IAM policies.
        :param pulumi.Input[str] identity_namespace: IAM Identity Namespace to attach all Kubernetes Service Accounts to.
        :param pulumi.Input[str] identity_provider: identity provider is the third party identity provider.
        :param pulumi.Input[str] workload_pool: The workload pool to attach all Kubernetes service accounts to.
        """
        if identity_namespace is not None:
            pulumi.set(__self__, "identity_namespace", identity_namespace)
        if identity_provider is not None:
            pulumi.set(__self__, "identity_provider", identity_provider)
        if workload_pool is not None:
            pulumi.set(__self__, "workload_pool", workload_pool)

    @property
    @pulumi.getter(name="identityNamespace")
    def identity_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        IAM Identity Namespace to attach all Kubernetes Service Accounts to.
        """
        return pulumi.get(self, "identity_namespace")

    @identity_namespace.setter
    def identity_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_namespace", value)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional[pulumi.Input[str]]:
        """
        identity provider is the third party identity provider.
        """
        return pulumi.get(self, "identity_provider")

    @identity_provider.setter
    def identity_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_provider", value)

    @property
    @pulumi.getter(name="workloadPool")
    def workload_pool(self) -> Optional[pulumi.Input[str]]:
        """
        The workload pool to attach all Kubernetes service accounts to.
        """
        return pulumi.get(self, "workload_pool")

    @workload_pool.setter
    def workload_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workload_pool", value)


@pulumi.input_type
class WorkloadMetadataConfigArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[str]] = None,
                 node_metadata: Optional[pulumi.Input[str]] = None):
        """
        WorkloadMetadataConfig defines the metadata configuration to expose to workloads on the node pool.
        :param pulumi.Input[str] mode: Mode is the configuration for how to expose metadata to workloads running on the node pool.
        :param pulumi.Input[str] node_metadata: NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if node_metadata is not None:
            pulumi.set(__self__, "node_metadata", node_metadata)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Mode is the configuration for how to expose metadata to workloads running on the node pool.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> Optional[pulumi.Input[str]]:
        """
        NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
        """
        return pulumi.get(self, "node_metadata")

    @node_metadata.setter
    def node_metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_metadata", value)


