# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 project: pulumi.Input[str],
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 build_worker_pool: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 event_trigger: Optional[pulumi.Input['EventTriggerArgs']] = None,
                 https_trigger: Optional[pulumi.Input['HttpsTriggerArgs']] = None,
                 ingress_settings: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 source_archive_url: Optional[pulumi.Input[str]] = None,
                 source_repository: Optional[pulumi.Input['SourceRepositoryArgs']] = None,
                 source_token: Optional[pulumi.Input[str]] = None,
                 source_upload_url: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 vpc_connector: Optional[pulumi.Input[str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[int] available_memory_mb: The amount of memory in MB available for a function. Defaults to 256MB.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_environment_variables: Build environment variables that shall be available during build time.
        :param pulumi.Input[str] build_worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function. The format of this field is `projects/{project}/locations/{region}/workerPools/{workerPool}` where {project} and {region} are the project id and region respectively where the worker pool is defined and {workerPool} is the short name of the worker pool. If the project id is not the same as the function, then the Cloud Functions Service Agent (service-@gcf-admin-robot.iam.gserviceaccount.com) must be granted the role Cloud Build Custom Workers Builder (roles/cloudbuild.customworkers.builder) in the project.
        :param pulumi.Input[str] description: User-provided description of a function.
        :param pulumi.Input[str] entry_point: The name of the function (as defined in source code) that will be executed. Defaults to the resource name suffix, if not specified. For backward compatibility, if function with given name is not found, then the system will try to use function named "function". For Node.js this is name of a function exported by the module specified in `source_location`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables that shall be available during function execution.
        :param pulumi.Input['EventTriggerArgs'] event_trigger: A source that fires events in response to a condition in another service.
        :param pulumi.Input['HttpsTriggerArgs'] https_trigger: An HTTPS endpoint type of source that can be triggered via URL.
        :param pulumi.Input[str] ingress_settings: The ingress settings for the function, controlling what traffic can reach it.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels associated with this Cloud Function.
        :param pulumi.Input[int] max_instances: The limit on the maximum number of function instances that may coexist at a given time. In some cases, such as rapid traffic surges, Cloud Functions may, for a short period of time, create more instances than the specified max instances limit. If your function cannot tolerate this temporary behavior, you may want to factor in a safety margin and set a lower max instances value than your function can tolerate. See the [Max Instances](https://cloud.google.com/functions/docs/max-instances) Guide for more details.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must be unique globally and match pattern `projects/*/locations/*/functions/*`
        :param pulumi.Input[str] network: The VPC Network that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network resource. If the short network name is used, the network must belong to the same project. Otherwise, it must belong to a project within the same organization. The format of this field is either `projects/{project}/global/networks/{network}` or `{network}`, where {project} is a project id where the network is defined, and {network} is the short name of the network. This field is mutually exclusive with `vpc_connector` and will be replaced by it. See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for more information on connecting Cloud projects.
        :param pulumi.Input[str] runtime: The runtime in which to run the function. Required when deploying a new function, optional when updating an existing function. For a complete list of possible choices, see the [`gcloud` command reference](/sdk/gcloud/reference/functions/deploy#--runtime).
        :param pulumi.Input[str] service_account_email: The email of the function's service account. If empty, defaults to `{project_id}@appspot.gserviceaccount.com`.
        :param pulumi.Input[str] source_archive_url: The Google Cloud Storage URL, starting with gs://, pointing to the zip archive which contains the function.
        :param pulumi.Input['SourceRepositoryArgs'] source_repository: **Beta Feature** The source repository where a function is hosted.
        :param pulumi.Input[str] source_token: Input only. An identifier for Firebase function sources. Disclaimer: This field is only supported for Firebase function deployments.
        :param pulumi.Input[str] source_upload_url: The Google Cloud Storage signed URL used for source uploading, generated by google.cloud.functions.v1.GenerateUploadUrl
        :param pulumi.Input[str] timeout: The function execution timeout. Execution is considered failed and can be terminated if the function is not completed at the end of the timeout period. Defaults to 60 seconds.
        :param pulumi.Input[str] vpc_connector: The VPC Network Connector that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is `projects/*/locations/*/connectors/*` This field is mutually exclusive with `network` field and will eventually replace it. See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for more information on connecting Cloud projects.
        :param pulumi.Input[str] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "project", project)
        if available_memory_mb is not None:
            pulumi.set(__self__, "available_memory_mb", available_memory_mb)
        if build_environment_variables is not None:
            pulumi.set(__self__, "build_environment_variables", build_environment_variables)
        if build_worker_pool is not None:
            pulumi.set(__self__, "build_worker_pool", build_worker_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if https_trigger is not None:
            pulumi.set(__self__, "https_trigger", https_trigger)
        if ingress_settings is not None:
            pulumi.set(__self__, "ingress_settings", ingress_settings)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if source_archive_url is not None:
            pulumi.set(__self__, "source_archive_url", source_archive_url)
        if source_repository is not None:
            pulumi.set(__self__, "source_repository", source_repository)
        if source_token is not None:
            pulumi.set(__self__, "source_token", source_token)
        if source_upload_url is not None:
            pulumi.set(__self__, "source_upload_url", source_upload_url)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vpc_connector is not None:
            pulumi.set(__self__, "vpc_connector", vpc_connector)
        if vpc_connector_egress_settings is not None:
            pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of memory in MB available for a function. Defaults to 256MB.
        """
        return pulumi.get(self, "available_memory_mb")

    @available_memory_mb.setter
    def available_memory_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_memory_mb", value)

    @property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Build environment variables that shall be available during build time.
        """
        return pulumi.get(self, "build_environment_variables")

    @build_environment_variables.setter
    def build_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "build_environment_variables", value)

    @property
    @pulumi.getter(name="buildWorkerPool")
    def build_worker_pool(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function. The format of this field is `projects/{project}/locations/{region}/workerPools/{workerPool}` where {project} and {region} are the project id and region respectively where the worker pool is defined and {workerPool} is the short name of the worker pool. If the project id is not the same as the function, then the Cloud Functions Service Agent (service-@gcf-admin-robot.iam.gserviceaccount.com) must be granted the role Cloud Build Custom Workers Builder (roles/cloudbuild.customworkers.builder) in the project.
        """
        return pulumi.get(self, "build_worker_pool")

    @build_worker_pool.setter
    def build_worker_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_worker_pool", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description of a function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the function (as defined in source code) that will be executed. Defaults to the resource name suffix, if not specified. For backward compatibility, if function with given name is not found, then the system will try to use function named "function". For Node.js this is name of a function exported by the module specified in `source_location`.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables that shall be available during function execution.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['EventTriggerArgs']]:
        """
        A source that fires events in response to a condition in another service.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['EventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @property
    @pulumi.getter(name="httpsTrigger")
    def https_trigger(self) -> Optional[pulumi.Input['HttpsTriggerArgs']]:
        """
        An HTTPS endpoint type of source that can be triggered via URL.
        """
        return pulumi.get(self, "https_trigger")

    @https_trigger.setter
    def https_trigger(self, value: Optional[pulumi.Input['HttpsTriggerArgs']]):
        pulumi.set(self, "https_trigger", value)

    @property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> Optional[pulumi.Input[str]]:
        """
        The ingress settings for the function, controlling what traffic can reach it.
        """
        return pulumi.get(self, "ingress_settings")

    @ingress_settings.setter
    def ingress_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_settings", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels associated with this Cloud Function.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[int]]:
        """
        The limit on the maximum number of function instances that may coexist at a given time. In some cases, such as rapid traffic surges, Cloud Functions may, for a short period of time, create more instances than the specified max instances limit. If your function cannot tolerate this temporary behavior, you may want to factor in a safety margin and set a lower max instances value than your function can tolerate. See the [Max Instances](https://cloud.google.com/functions/docs/max-instances) Guide for more details.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined name of the function. Function names must be unique globally and match pattern `projects/*/locations/*/functions/*`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC Network that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network resource. If the short network name is used, the network must belong to the same project. Otherwise, it must belong to a project within the same organization. The format of this field is either `projects/{project}/global/networks/{network}` or `{network}`, where {project} is a project id where the network is defined, and {network} is the short name of the network. This field is mutually exclusive with `vpc_connector` and will be replaced by it. See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for more information on connecting Cloud projects.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime in which to run the function. Required when deploying a new function, optional when updating an existing function. For a complete list of possible choices, see the [`gcloud` command reference](/sdk/gcloud/reference/functions/deploy#--runtime).
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the function's service account. If empty, defaults to `{project_id}@appspot.gserviceaccount.com`.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter(name="sourceArchiveUrl")
    def source_archive_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Google Cloud Storage URL, starting with gs://, pointing to the zip archive which contains the function.
        """
        return pulumi.get(self, "source_archive_url")

    @source_archive_url.setter
    def source_archive_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_archive_url", value)

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> Optional[pulumi.Input['SourceRepositoryArgs']]:
        """
        **Beta Feature** The source repository where a function is hosted.
        """
        return pulumi.get(self, "source_repository")

    @source_repository.setter
    def source_repository(self, value: Optional[pulumi.Input['SourceRepositoryArgs']]):
        pulumi.set(self, "source_repository", value)

    @property
    @pulumi.getter(name="sourceToken")
    def source_token(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. An identifier for Firebase function sources. Disclaimer: This field is only supported for Firebase function deployments.
        """
        return pulumi.get(self, "source_token")

    @source_token.setter
    def source_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_token", value)

    @property
    @pulumi.getter(name="sourceUploadUrl")
    def source_upload_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Google Cloud Storage signed URL used for source uploading, generated by google.cloud.functions.v1.GenerateUploadUrl
        """
        return pulumi.get(self, "source_upload_url")

    @source_upload_url.setter
    def source_upload_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_upload_url", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The function execution timeout. Execution is considered failed and can be terminated if the function is not completed at the end of the timeout period. Defaults to 60 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC Network Connector that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is `projects/*/locations/*/connectors/*` This field is mutually exclusive with `network` field and will eventually replace it. See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for more information on connecting Cloud projects.
        """
        return pulumi.get(self, "vpc_connector")

    @vpc_connector.setter
    def vpc_connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_connector", value)

    @property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> Optional[pulumi.Input[str]]:
        """
        The egress settings for the connector, controlling what traffic is diverted through it.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")

    @vpc_connector_egress_settings.setter
    def vpc_connector_egress_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_connector_egress_settings", value)


class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 build_worker_pool: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 event_trigger: Optional[pulumi.Input[pulumi.InputType['EventTriggerArgs']]] = None,
                 https_trigger: Optional[pulumi.Input[pulumi.InputType['HttpsTriggerArgs']]] = None,
                 ingress_settings: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 source_archive_url: Optional[pulumi.Input[str]] = None,
                 source_repository: Optional[pulumi.Input[pulumi.InputType['SourceRepositoryArgs']]] = None,
                 source_token: Optional[pulumi.Input[str]] = None,
                 source_upload_url: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 vpc_connector: Optional[pulumi.Input[str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new function. If a function with the given name already exists in the specified project, the long running operation will return `ALREADY_EXISTS` error.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] available_memory_mb: The amount of memory in MB available for a function. Defaults to 256MB.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_environment_variables: Build environment variables that shall be available during build time.
        :param pulumi.Input[str] build_worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function. The format of this field is `projects/{project}/locations/{region}/workerPools/{workerPool}` where {project} and {region} are the project id and region respectively where the worker pool is defined and {workerPool} is the short name of the worker pool. If the project id is not the same as the function, then the Cloud Functions Service Agent (service-@gcf-admin-robot.iam.gserviceaccount.com) must be granted the role Cloud Build Custom Workers Builder (roles/cloudbuild.customworkers.builder) in the project.
        :param pulumi.Input[str] description: User-provided description of a function.
        :param pulumi.Input[str] entry_point: The name of the function (as defined in source code) that will be executed. Defaults to the resource name suffix, if not specified. For backward compatibility, if function with given name is not found, then the system will try to use function named "function". For Node.js this is name of a function exported by the module specified in `source_location`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables that shall be available during function execution.
        :param pulumi.Input[pulumi.InputType['EventTriggerArgs']] event_trigger: A source that fires events in response to a condition in another service.
        :param pulumi.Input[pulumi.InputType['HttpsTriggerArgs']] https_trigger: An HTTPS endpoint type of source that can be triggered via URL.
        :param pulumi.Input[str] ingress_settings: The ingress settings for the function, controlling what traffic can reach it.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels associated with this Cloud Function.
        :param pulumi.Input[int] max_instances: The limit on the maximum number of function instances that may coexist at a given time. In some cases, such as rapid traffic surges, Cloud Functions may, for a short period of time, create more instances than the specified max instances limit. If your function cannot tolerate this temporary behavior, you may want to factor in a safety margin and set a lower max instances value than your function can tolerate. See the [Max Instances](https://cloud.google.com/functions/docs/max-instances) Guide for more details.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must be unique globally and match pattern `projects/*/locations/*/functions/*`
        :param pulumi.Input[str] network: The VPC Network that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network resource. If the short network name is used, the network must belong to the same project. Otherwise, it must belong to a project within the same organization. The format of this field is either `projects/{project}/global/networks/{network}` or `{network}`, where {project} is a project id where the network is defined, and {network} is the short name of the network. This field is mutually exclusive with `vpc_connector` and will be replaced by it. See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for more information on connecting Cloud projects.
        :param pulumi.Input[str] runtime: The runtime in which to run the function. Required when deploying a new function, optional when updating an existing function. For a complete list of possible choices, see the [`gcloud` command reference](/sdk/gcloud/reference/functions/deploy#--runtime).
        :param pulumi.Input[str] service_account_email: The email of the function's service account. If empty, defaults to `{project_id}@appspot.gserviceaccount.com`.
        :param pulumi.Input[str] source_archive_url: The Google Cloud Storage URL, starting with gs://, pointing to the zip archive which contains the function.
        :param pulumi.Input[pulumi.InputType['SourceRepositoryArgs']] source_repository: **Beta Feature** The source repository where a function is hosted.
        :param pulumi.Input[str] source_token: Input only. An identifier for Firebase function sources. Disclaimer: This field is only supported for Firebase function deployments.
        :param pulumi.Input[str] source_upload_url: The Google Cloud Storage signed URL used for source uploading, generated by google.cloud.functions.v1.GenerateUploadUrl
        :param pulumi.Input[str] timeout: The function execution timeout. Execution is considered failed and can be terminated if the function is not completed at the end of the timeout period. Defaults to 60 seconds.
        :param pulumi.Input[str] vpc_connector: The VPC Network Connector that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is `projects/*/locations/*/connectors/*` This field is mutually exclusive with `network` field and will eventually replace it. See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for more information on connecting Cloud projects.
        :param pulumi.Input[str] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new function. If a function with the given name already exists in the specified project, the long running operation will return `ALREADY_EXISTS` error.

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 build_worker_pool: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 event_trigger: Optional[pulumi.Input[pulumi.InputType['EventTriggerArgs']]] = None,
                 https_trigger: Optional[pulumi.Input[pulumi.InputType['HttpsTriggerArgs']]] = None,
                 ingress_settings: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 source_archive_url: Optional[pulumi.Input[str]] = None,
                 source_repository: Optional[pulumi.Input[pulumi.InputType['SourceRepositoryArgs']]] = None,
                 source_token: Optional[pulumi.Input[str]] = None,
                 source_upload_url: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 vpc_connector: Optional[pulumi.Input[str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["available_memory_mb"] = available_memory_mb
            __props__.__dict__["build_environment_variables"] = build_environment_variables
            __props__.__dict__["build_worker_pool"] = build_worker_pool
            __props__.__dict__["description"] = description
            __props__.__dict__["entry_point"] = entry_point
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["event_trigger"] = event_trigger
            __props__.__dict__["https_trigger"] = https_trigger
            __props__.__dict__["ingress_settings"] = ingress_settings
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["max_instances"] = max_instances
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["source_archive_url"] = source_archive_url
            __props__.__dict__["source_repository"] = source_repository
            __props__.__dict__["source_token"] = source_token
            __props__.__dict__["source_upload_url"] = source_upload_url
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["vpc_connector"] = vpc_connector
            __props__.__dict__["vpc_connector_egress_settings"] = vpc_connector_egress_settings
            __props__.__dict__["build_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["version_id"] = None
        super(Function, __self__).__init__(
            'google-native:cloudfunctions/v1:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FunctionArgs.__new__(FunctionArgs)

        __props__.__dict__["available_memory_mb"] = None
        __props__.__dict__["build_environment_variables"] = None
        __props__.__dict__["build_id"] = None
        __props__.__dict__["build_worker_pool"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["entry_point"] = None
        __props__.__dict__["environment_variables"] = None
        __props__.__dict__["event_trigger"] = None
        __props__.__dict__["https_trigger"] = None
        __props__.__dict__["ingress_settings"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["max_instances"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network"] = None
        __props__.__dict__["runtime"] = None
        __props__.__dict__["service_account_email"] = None
        __props__.__dict__["source_archive_url"] = None
        __props__.__dict__["source_repository"] = None
        __props__.__dict__["source_token"] = None
        __props__.__dict__["source_upload_url"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["timeout"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["version_id"] = None
        __props__.__dict__["vpc_connector"] = None
        __props__.__dict__["vpc_connector_egress_settings"] = None
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> pulumi.Output[int]:
        """
        The amount of memory in MB available for a function. Defaults to 256MB.
        """
        return pulumi.get(self, "available_memory_mb")

    @property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Build environment variables that shall be available during build time.
        """
        return pulumi.get(self, "build_environment_variables")

    @property
    @pulumi.getter(name="buildId")
    def build_id(self) -> pulumi.Output[str]:
        """
        The Cloud Build ID of the latest successful deployment of the function.
        """
        return pulumi.get(self, "build_id")

    @property
    @pulumi.getter(name="buildWorkerPool")
    def build_worker_pool(self) -> pulumi.Output[str]:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function. The format of this field is `projects/{project}/locations/{region}/workerPools/{workerPool}` where {project} and {region} are the project id and region respectively where the worker pool is defined and {workerPool} is the short name of the worker pool. If the project id is not the same as the function, then the Cloud Functions Service Agent (service-@gcf-admin-robot.iam.gserviceaccount.com) must be granted the role Cloud Build Custom Workers Builder (roles/cloudbuild.customworkers.builder) in the project.
        """
        return pulumi.get(self, "build_worker_pool")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        User-provided description of a function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> pulumi.Output[str]:
        """
        The name of the function (as defined in source code) that will be executed. Defaults to the resource name suffix, if not specified. For backward compatibility, if function with given name is not found, then the system will try to use function named "function". For Node.js this is name of a function exported by the module specified in `source_location`.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Environment variables that shall be available during function execution.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> pulumi.Output['outputs.EventTriggerResponse']:
        """
        A source that fires events in response to a condition in another service.
        """
        return pulumi.get(self, "event_trigger")

    @property
    @pulumi.getter(name="httpsTrigger")
    def https_trigger(self) -> pulumi.Output['outputs.HttpsTriggerResponse']:
        """
        An HTTPS endpoint type of source that can be triggered via URL.
        """
        return pulumi.get(self, "https_trigger")

    @property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> pulumi.Output[str]:
        """
        The ingress settings for the function, controlling what traffic can reach it.
        """
        return pulumi.get(self, "ingress_settings")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels associated with this Cloud Function.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> pulumi.Output[int]:
        """
        The limit on the maximum number of function instances that may coexist at a given time. In some cases, such as rapid traffic surges, Cloud Functions may, for a short period of time, create more instances than the specified max instances limit. If your function cannot tolerate this temporary behavior, you may want to factor in a safety margin and set a lower max instances value than your function can tolerate. See the [Max Instances](https://cloud.google.com/functions/docs/max-instances) Guide for more details.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-defined name of the function. Function names must be unique globally and match pattern `projects/*/locations/*/functions/*`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The VPC Network that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network resource. If the short network name is used, the network must belong to the same project. Otherwise, it must belong to a project within the same organization. The format of this field is either `projects/{project}/global/networks/{network}` or `{network}`, where {project} is a project id where the network is defined, and {network} is the short name of the network. This field is mutually exclusive with `vpc_connector` and will be replaced by it. See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for more information on connecting Cloud projects.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        The runtime in which to run the function. Required when deploying a new function, optional when updating an existing function. For a complete list of possible choices, see the [`gcloud` command reference](/sdk/gcloud/reference/functions/deploy#--runtime).
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[str]:
        """
        The email of the function's service account. If empty, defaults to `{project_id}@appspot.gserviceaccount.com`.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter(name="sourceArchiveUrl")
    def source_archive_url(self) -> pulumi.Output[str]:
        """
        The Google Cloud Storage URL, starting with gs://, pointing to the zip archive which contains the function.
        """
        return pulumi.get(self, "source_archive_url")

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> pulumi.Output['outputs.SourceRepositoryResponse']:
        """
        **Beta Feature** The source repository where a function is hosted.
        """
        return pulumi.get(self, "source_repository")

    @property
    @pulumi.getter(name="sourceToken")
    def source_token(self) -> pulumi.Output[str]:
        """
        Input only. An identifier for Firebase function sources. Disclaimer: This field is only supported for Firebase function deployments.
        """
        return pulumi.get(self, "source_token")

    @property
    @pulumi.getter(name="sourceUploadUrl")
    def source_upload_url(self) -> pulumi.Output[str]:
        """
        The Google Cloud Storage signed URL used for source uploading, generated by google.cloud.functions.v1.GenerateUploadUrl
        """
        return pulumi.get(self, "source_upload_url")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the function deployment.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[str]:
        """
        The function execution timeout. Execution is considered failed and can be terminated if the function is not completed at the end of the timeout period. Defaults to 60 seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The last update timestamp of a Cloud Function.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[str]:
        """
        The version identifier of the Cloud Function. Each deployment attempt results in a new version of a function being created.
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> pulumi.Output[str]:
        """
        The VPC Network Connector that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is `projects/*/locations/*/connectors/*` This field is mutually exclusive with `network` field and will eventually replace it. See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for more information on connecting Cloud projects.
        """
        return pulumi.get(self, "vpc_connector")

    @property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> pulumi.Output[str]:
        """
        The egress settings for the connector, controlling what traffic is diverted through it.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")

