# About
The Python Package Index Project (pypipr)


pypi : https://pypi.org/project/pypipr



# Setup
Install with pip
```
python -m pip install pypipr
```

Import with * for fastest access
```
from pypipr.pypipr import *
```

Test with
```python
Pypipr.test_print()
```


# Pypipr Class
`test_print()` memastikan module sudah terinstal dan dapat dijalankan

```python
Pypipr.test_print()
```


# functions
`sets_ordered()` Hanya mengambil nilai unik dari suatu list

```python
array = [2, 3, 12, 3, 3, 42, 42, 1, 43, 2, 42, 41, 4, 24, 32, 42, 3, 12, 32, 42, 42]
print([i for i in sets_ordered(array)])
```


`list_unique()` sama seperti `sets_ordered()`

```python
array = [2, 3, 12, 3, 3, 42, 42, 1, 43, 2, 42, 41, 4, 24, 32, 42, 3, 12, 32, 42, 42]
print([i for i in list_unique(array)])
```


`chunck_array()` membagi array menjadi potongan dengan besaran yg diinginkan

```python
array = [2, 3, 12, 3, 3, 42, 42, 1, 43, 2, 42, 41, 4, 24, 32, 42, 3, 12, 32, 42, 42]
print([i for i in chunck_array(array, 5)])
```


`print_colorize()` print ke console dengan warna

```python
print_colorize("Print some text")
```


`@Log()` / `Log decorator` akan melakukan print ke console. Mempermudah pembuatan log karena tidak perlu mengubah fungsi yg sudah ada. Berguna untuk memberikan informasi proses program yg sedang berjalan.

```python
@log("Calling some function")
def some_function():
    ...
    return
```


`print_log` akan melakukan print ke console. Berguna untuk memberikan informasi proses program yg sedang berjalan.

```python
print_log("Standalone Log")
```


`input_char()` meminta masukan satu huruf tanpa menekan enter. Char tidak ditampilkan.

```python
input_char("Input Char without print : ")
```


`input_char()` meminta masukan satu huruf tanpa menekan enter. Char ditampilkan.

```python
input_char_echo("Input Char n : ")
```


`datetime_now()` memudahkan dalam membuat tanggal dan waktu untuk suatu timezone

```python
datetime_now("Asia/Jakarta")
datetime_now("GMT")
datetime_now("Etc/GMT+7")
```


`WINDOWS` True apabila berjalan di platform Windows

```python
print(WINDOWS)
```


`LINUX` True apabila berjalan di platform Linux

```python
print(LINUX)
```


`file_put_contents()` membuat file kemudian menuliskan contents ke file. Apabila file memiliki contents, maka contents akan di overwrite.

```python
file_put_contents("ifile_test.txt", "Contoh menulis content")
```


`file_get_contents()` membaca contents file ke memory.

```python
print(file_get_contents("ifile_test.txt"))
```


`create_folder()` membuat folder secara recursive.

```python
create_folder("contoh_membuat_folder")
create_folder("contoh/membuat/folder/recursive")
create_folder("./contoh_membuat_folder/secara/recursive")
```


`iscandir()` scan folder, subfolder, dan file

```python
for i in iscandir():
    print(i)
```


`scan_folder()` scan folder dan subfolder

```python
for i in scan_folder():
    print(i)
```


`scan_file()` scan file dalam folder dan subfolder

```python
for i in scan_file():
    print(i)
```


`regex_multiple_replace()` Melakukan multiple replacement untuk setiap list regex. 

```python
regex_replacement_list = [
    {"regex": r"\{\{\s*ini\s*\}\}", "replacement": "itu"},
    {"regex": r"\{\{\s*sini\s*\}\}", "replacement": "situ"},
]
data = "{{ ini }} adalah ini. {{sini}} berarti kesini."
data = regex_multiple_replace(data, regex_replacement_list)
print(data)
```


`github_push()` simple github push

```python
github_push()
```


`github_pull()` simple github pull

```python
github_pull()
```


`html_get_contents()` Mengambil content html dari url

```python
a = html_get_contents("https://google.com/", xpath="//a")
for i in a:
    print(i.text)
    print(i.attrib.get('href'))
```


`get_filesize()` Mengambil informasi file size dalam bytes

```python
print(get_filesize(__file__))
```


`get_filemtime()` Mengambil informasi last modification time file dalam nano seconds

```python
print(get_filemtime(__file__))
```
