# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/messaging/kafkaConnection.json
#   timestamp: 2022-04-05T04:21:49+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field


class SupportedPipelineTypes7(Enum):
    Metadata = 'Metadata'


class KafkaType(Enum):
    Kafka = 'Kafka'


class KafkaConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[KafkaType] = Field('Kafka', description='Service Type')
    bootstrapServers: Optional[str] = Field(
        'localhost:9092',
        description='Kafka bootstrap servers. add them in comma separated values ex: host1:9092,host2:9092',
    )
    schemaRegistryURL: Optional[AnyUrl] = Field(
        'http://localhost:8081', description='Confluent Kafka Schema Registry URL.'
    )
    supportedPipelineTypes: Optional[SupportedPipelineTypes7] = Field(
        None, description='Supported Metadata Extraction Pipelines.'
    )
