# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/snowflakeConnection.json
#   timestamp: 2022-04-05T04:21:49+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from . import connectionBasicType


class SupportedPipelineType5(Enum):
    Metadata = 'Metadata'


class SnowflakeType(Enum):
    Snowflake = 'Snowflake'


class SnowflakeScheme(Enum):
    snowflake = 'snowflake'


class SnowflakeConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SnowflakeType] = Field('Snowflake', description='Service Type')
    scheme: Optional[SnowflakeScheme] = Field(
        'snowflake', description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Snowflake. This user should have privileges to read all the metadata in Snowflake.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Snowflake.'
    )
    hostPort: Optional[str] = Field(
        None, description='Host and port of the data source.'
    )
    account: Optional[str] = Field(None, description='Snowflake Account.')
    role: Optional[str] = Field(None, description='Snowflake Role.')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Snowflake.',
    )
    warehouse: Optional[str] = Field(None, description='Snowflake warehouse.')
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportedPipelineTypes: Optional[List[SupportedPipelineType5]] = Field(
        ['Metadata'], description='Supported Metadata Extraction Pipelines.'
    )
