# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/hiveConnection.json
#   timestamp: 2022-04-05T04:21:49+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from . import connectionBasicType


class SupportedPipelineType14(Enum):
    Metadata = 'Metadata'


class HiveType(Enum):
    Hive = 'Hive'


class HiveScheme(Enum):
    hive = 'hive'


class HiveSQLConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[HiveType] = Field('Hive', description='Service Type')
    scheme: Optional[HiveScheme] = Field(
        'hive', description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Athena. This user should have privileges to read all the metadata in Hive.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Hive.'
    )
    hostPort: Optional[str] = Field(None, description='Host and port of the Hive.')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Hive.',
    )
    authOptions: Optional[str] = Field(
        None,
        description='Authentication options to pass to Hive connector. These options are based on SQLAlchemy.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportedPipelineTypes: Optional[List[SupportedPipelineType14]] = Field(
        ['Metadata'], description='Supported Metadata Extraction Pipelines.'
    )
