# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/bigQueryConnection.json
#   timestamp: 2022-04-05T04:21:49+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from . import connectionBasicType


class SupportedPipelineType21(Enum):
    Metadata = 'Metadata'
    Usage = 'Usage'


class BigqueryType(Enum):
    BigQuery = 'BigQuery'


class BigqueryScheme(Enum):
    bigquery = 'bigquery'


class BigQueryConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[BigqueryType] = Field('BigQuery', description='Service Type')
    scheme: Optional[BigqueryScheme] = Field(
        'bigquery', description='SQLAlchemy driver scheme options.'
    )
    hostPort: Optional[str] = Field(
        'bigquery.googleapis.com', description='BigQuery APIs URL'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Athena. This user should have privileges to read all the metadata in Athena.',
    )
    projectID: Optional[str] = Field(None, description='Google BigQuery project id.')
    enablePolicyTagImport: Optional[bool] = Field(
        'true', description='Enable importing policy tags of BigQuery into OpenMetadata'
    )
    tagCategoryName: Optional[str] = Field(
        'BigqueryPolicyTags',
        description='OpenMetadata Tag category name if enablePolicyTagImport is set to true.',
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Athena.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportedPipelineTypes: Optional[List[SupportedPipelineType21]] = Field(
        ['Metadata', 'Usage'], description='Supported Metadata Extraction Pipelines.'
    )
