"use strict";
const aws_secretsmanager_1 = require("@aws-cdk/aws-secretsmanager");
const lib_1 = require("../lib");
module.exports = {
    'cluster parameter group correctly determined for AURORA'(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.AURORA;
        // WHEN
        const family = engine.parameterGroupFamily();
        // THEN
        test.equals(family, 'aurora5.6');
        test.done();
    },
    'cluster parameter group correctly determined for AURORA_MYSQL'(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.AURORA_MYSQL;
        // WHEN
        const family = engine.parameterGroupFamily();
        // THEN
        test.equals(family, 'aurora-mysql5.7');
        test.done();
    },
    'cluster parameter group correctly determined for AURORA_POSTGRESQL'(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.AURORA_POSTGRESQL;
        // WHEN
        const family = engine.parameterGroupFamily();
        // THEN
        test.equals(family, 'aurora-postgresql11');
        test.done();
    },
    'cluster parameter group correctly determined for AURORA and given version'(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.AURORA;
        // WHEN
        const family = engine.parameterGroupFamily('5.6.mysql_aurora.1.22.2');
        // THEN
        test.equals(family, 'aurora5.6');
        test.done();
    },
    'cluster parameter group correctly determined for AURORA_MYSQL and given version'(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.AURORA_MYSQL;
        // WHEN
        const family = engine.parameterGroupFamily('5.7.mysql_aurora.2.07.1');
        // THEN
        test.equals(family, 'aurora-mysql5.7');
        test.done();
    },
    'cluster parameter group correctly determined for AURORA_POSTGRESQL and given version'(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.AURORA_POSTGRESQL;
        // WHEN
        const family = engine.parameterGroupFamily('11.6');
        // THEN
        test.equals(family, 'aurora-postgresql11');
        test.done();
    },
    'parameter group family'(test) {
        // WHEN
        const engine1 = new lib_1.DatabaseClusterEngine('no-parameter-group-family', aws_secretsmanager_1.SecretRotationApplication.POSTGRES_ROTATION_SINGLE_USER, aws_secretsmanager_1.SecretRotationApplication.POSTGRES_ROTATION_SINGLE_USER);
        const engine2 = new lib_1.DatabaseClusterEngine('aurora-postgresql', aws_secretsmanager_1.SecretRotationApplication.POSTGRES_ROTATION_SINGLE_USER, aws_secretsmanager_1.SecretRotationApplication.POSTGRES_ROTATION_SINGLE_USER, [
            { engineMajorVersion: '1.0', parameterGroupFamily: 'family-1' },
            { engineMajorVersion: '2.0', parameterGroupFamily: 'family-2' },
        ]);
        // THEN
        test.equals(engine1.parameterGroupFamily(), undefined);
        test.equals(engine1.parameterGroupFamily('1'), undefined);
        test.equals(engine2.parameterGroupFamily('3'), undefined);
        test.equals(engine2.parameterGroupFamily('1'), undefined);
        test.equals(engine2.parameterGroupFamily('1.1'), undefined);
        test.equals(engine2.parameterGroupFamily('1.0'), 'family-1');
        test.equals(engine2.parameterGroupFamily('2.0.2'), 'family-2');
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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