"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compare = void 0;
/**
 * Compare two version strings. Fails if the comparison has to tiebreak with non-numbers.
 * @returns 0 if both are same, 1 if 'a' is later version than 'b' and -1 if 'b' is later version than 'a'
 */
function compare(a, b) {
    const aParts = a.split('.');
    const bParts = b.split('.');
    for (let i = 0; i < Math.max(aParts.length, bParts.length); i++) {
        if (i === aParts.length) {
            return -1;
        }
        if (i === bParts.length) {
            return 1;
        }
        if (!aParts[i] || !bParts[i] || isNaN(aParts[i]) || isNaN(bParts[i])) {
            throw new Error(`Can only compare version strings with numbers. Received [${a}] and [${b}].`);
        }
        const partCompare = parseInt(aParts[i], 10) - parseInt(bParts[i], 10);
        if (partCompare < 0) {
            return -1;
        }
        if (partCompare > 0) {
            return 1;
        }
    }
    return 0;
}
exports.compare = compare;
//# sourceMappingURL=data:application/json;base64,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