import * as kms from '@aws-cdk/aws-kms';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import { Construct } from '@aws-cdk/core';
/**
 * Construction properties for a DatabaseSecret.
 */
export interface DatabaseSecretProps {
    /**
     * The username.
     */
    readonly username: string;
    /**
     * The KMS key to use to encrypt the secret.
     *
     * @default default master key
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * The master secret which will be used to rotate this secret.
     *
     * @default - no master secret information will be included
     */
    readonly masterSecret?: secretsmanager.ISecret;
}
/**
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
export declare class DatabaseSecret extends secretsmanager.Secret {
    constructor(scope: Construct, id: string, props: DatabaseSecretProps);
}
