# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/athenaConnection.json
#   timestamp: 2022-07-01T04:05:22+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from .....security.credentials import awsCredentials
from .. import connectionBasicType


class AthenaType(Enum):
    Athena = 'Athena'


class AthenaScheme(Enum):
    awsathena_rest = 'awsathena+rest'


class AthenaConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[AthenaType] = Field(
        AthenaType.Athena, description='Service Type', title='Service Type'
    )
    scheme: Optional[AthenaScheme] = Field(
        AthenaScheme.awsathena_rest,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    awsConfig: awsCredentials.AWSCredentials = Field(
        ..., title='AWS Credentials Configuration'
    )
    hostPort: Optional[str] = Field(
        None, description='Host and port of the Athena service.', title='Host and Port'
    )
    s3StagingDir: str = Field(
        ..., description='S3 Staging Directory.', title='S3 Staging Directory'
    )
    workgroup: str = Field(
        ..., description='Athena workgroup.', title='Athena Workgroup'
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
