"""
Django settings for pwdtk.testproject.dj18 project.

Generated by 'django-admin startproject' using Django 1.8.19.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

TOP_DIR = os.environ.get("PWDTK_TOPDIR",
                         os.path.dirname(os.path.dirname(BASE_DIR)))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'ojdyec9*_m^xva1!5d1fttq9c@gr)@2p1ozs1x%9v@5)r8g*=-'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


LOGIN_URL = "/login"

AUTHENTICATION_BACKENDS = [
    'pwdtk.auth_backends.PwdtkBackend',
    ]

# Application definition


INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'pwdtk',
]
if os.environ.get('USE_DJANGO_EXTENSIONS', "no").lower()[:1] in "yt1":
    INSTALLED_APPS += [
        "django_extensions"
        ]

PASSWORD_DURATION_SECONDS = 180

MIDDLEWARE_CLASSES = [
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'pwdtk.middlewares.PwdtkMiddleware',
]

ROOT_URLCONF = 'pwdtk.testproject.dj18.urls'

# PWDTK specifics
import pwdtk.settings  # noqa E402
from pwdtk.settings import *  # noqa F401

PWDTK_PASSWD_CHANGE_TEMPLATE = None

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.template.context_processors.static',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]


WSGI_APPLICATION = 'pwdtk.testproject.dj18.wsgi.application'


# Database
# https://docs.djangoproject.com/en/1.8/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(
            TOP_DIR,
            os.environ.get('PWDTK_DB_FILE', 'db18.sqlite3')),
    }
}


# Internationalization
# https://docs.djangoproject.com/en/1.8/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/

STATIC_URL = '/static/'

STATIC_ROOT = os.path.join(BASE_DIR, 'cstatic18')


TEST_RUNNER = 'pwdtk.testproject.pytest_runner.PytestTestRunner'

from pwdtk.testproject.logcfg import LOGGING  # noqa: F401, E402

# Just for debugging
# PASSWORD_HASHERS = [
#     'django.contrib.auth.hashers.UnsaltedMD5PasswordHasher',
#     ]
