"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_vpc_1 = require("@pepperize/cdk-vpc");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
/**
 * Network settings for the manager and runners
 *
 *  All EC2 instances should belong to the same subnet, availability zone and vpc.
 */
class Network extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.vpc =
            props?.vpc ??
                new cdk_vpc_1.CheapVpc(scope, `Vpc`, {
                    maxAzs: 1,
                });
        this.subnet = this.findSubnet(this.vpc, props?.subnetSelection);
        this.availabilityZone = this.subnet.availabilityZone;
        if (!this.hasPrivateSubnets()) {
            aws_cdk_lib_1.Annotations.of(this).addWarning(`No private network found in ${this.vpc.vpcId}, using public addresses.`);
        }
    }
    hasPrivateSubnets() {
        return !!this.vpc.privateSubnets.length;
    }
    /**
     * Returns the first private or public subnet. Optionally filters by AZ.
     *
     * @exception Throws an error if no private or public is found.
     */
    findSubnet(vpc, subnetSelection) {
        const selectedSubnets = vpc.selectSubnets(subnetSelection || {
            subnetType: this.hasPrivateSubnets() ? aws_ec2_1.SubnetType.PRIVATE_WITH_NAT : aws_ec2_1.SubnetType.PUBLIC,
            availabilityZones: vpc.availabilityZones,
        });
        const subnet = selectedSubnets.subnets.find(() => true);
        if (!subnet) {
            throw new Error(`Neither a private nor a public subnet is found in ${vpc.vpcId}`);
        }
        return subnet;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Network", version: "0.2.631" };
//# sourceMappingURL=data:application/json;base64,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