"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabRunnerAutoscalingJobRunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const pascal_case_1 = require("pascal-case");
class GitlabRunnerAutoscalingJobRunner extends constructs_1.Construct {
    static generateUniqueName() {
        return `gitlab-runner-${new Date().getTime().toString().toString()}${Math.floor(Math.random() * 100000)}`;
    }
    constructor(scope, id, props) {
        super(scope, id);
        this.configuration = {
            ...props.configuration,
            token: props.configuration.token ?? props.token?.stringValue,
            name: props.configuration.name ?? GitlabRunnerAutoscalingJobRunner.generateUniqueName(),
        };
        this.instanceType = props.instanceType || aws_ec2_1.InstanceType.of(aws_ec2_1.InstanceClass.T3, aws_ec2_1.InstanceSize.MICRO);
        this.machineImage =
            props.machineImage ||
                aws_ec2_1.MachineImage.genericLinux({
                    [aws_cdk_lib_1.Stack.of(this).region]: new aws_ec2_1.LookupMachineImage({
                        name: "ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-*",
                        owners: ["099720109477"],
                        filters: {
                            architecture: ["x86_64"],
                            "image-type": ["machine"],
                            state: ["available"],
                            "root-device-type": ["ebs"],
                            "virtualization-type": ["hvm"],
                        },
                    }).getImage(scope).imageId,
                });
        this.role =
            props.role ||
                new aws_iam_1.Role(scope, `RunnersRoleFor${(0, pascal_case_1.pascalCase)(this.configuration.name)}`, {
                    assumedBy: new aws_iam_1.ServicePrincipal("ec2.amazonaws.com", {}),
                    managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName("AmazonSSMManagedInstanceCore")],
                });
        this.instanceProfile = new aws_iam_1.CfnInstanceProfile(scope, `RunnersInstanceProfileFor${(0, pascal_case_1.pascalCase)(this.configuration.name)}`, {
            roles: [this.role.roleName],
        });
        if (props.keyPair && !props.configuration.machine?.machineOptions?.keypairName) {
            aws_cdk_lib_1.Annotations.of(this).addError("If runner.keyPair is configured, then props.configuration.machine.machineOptions.keypairName must also be set.");
        }
        this.keyPair = props.keyPair;
        aws_cdk_lib_1.Tags.of(this.role).add("RunnersRole", "RunnersRole");
    }
}
exports.GitlabRunnerAutoscalingJobRunner = GitlabRunnerAutoscalingJobRunner;
_a = JSII_RTTI_SYMBOL_1;
GitlabRunnerAutoscalingJobRunner[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.GitlabRunnerAutoscalingJobRunner", version: "0.2.631" };
//# sourceMappingURL=data:application/json;base64,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