# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CheckGroupArgs', 'CheckGroup']

@pulumi.input_type
class CheckGroupArgs:
    def __init__(__self__, *,
                 activated: pulumi.Input[bool],
                 concurrency: pulumi.Input[int],
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input['CheckGroupAlertChannelSubscriptionArgs']]]] = None,
                 alert_settings: Optional[pulumi.Input['CheckGroupAlertSettingsArgs']] = None,
                 api_check_defaults: Optional[pulumi.Input['CheckGroupApiCheckDefaultsArgs']] = None,
                 double_check: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 local_setup_script: Optional[pulumi.Input[str]] = None,
                 local_teardown_script: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_id: Optional[pulumi.Input[str]] = None,
                 setup_snippet_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 teardown_snippet_id: Optional[pulumi.Input[int]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a CheckGroup resource.
        :param pulumi.Input[bool] activated: Determines if the checks in the group are running or not.
        :param pulumi.Input[int] concurrency: Determines how many checks are run concurrently when triggering a check group from CI/CD or through the API.
        :param pulumi.Input[bool] double_check: Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected
               region before marking the check as failed.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks.
               Use global environment variables whenever possible.
        :param pulumi.Input[str] local_setup_script: A valid piece of Node.js code to run in the setup phase of an API check in this group.
        :param pulumi.Input[str] local_teardown_script: A valid piece of Node.js code to run in the teardown phase of an API check in this group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: An array of one or more data center locations where to run the checks.
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check in this group fails and/or recovers.
        :param pulumi.Input[str] name: The name of the check group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_locations: An array of one or more private locations slugs.
        :param pulumi.Input[str] runtime_id: The id of the runtime to use for this group.
        :param pulumi.Input[int] setup_snippet_id: An ID reference to a snippet to use in the setup phase of an API check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for organizing and filtering checks.
        :param pulumi.Input[int] teardown_snippet_id: An ID reference to a snippet to use in the teardown phase of an API check.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check group.
        """
        pulumi.set(__self__, "activated", activated)
        pulumi.set(__self__, "concurrency", concurrency)
        if alert_channel_subscriptions is not None:
            pulumi.set(__self__, "alert_channel_subscriptions", alert_channel_subscriptions)
        if alert_settings is not None:
            pulumi.set(__self__, "alert_settings", alert_settings)
        if api_check_defaults is not None:
            pulumi.set(__self__, "api_check_defaults", api_check_defaults)
        if double_check is not None:
            pulumi.set(__self__, "double_check", double_check)
        if environment_variables is not None:
            warnings.warn("""The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""", DeprecationWarning)
            pulumi.log.warn("""environment_variables is deprecated: The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""")
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if local_setup_script is not None:
            pulumi.set(__self__, "local_setup_script", local_setup_script)
        if local_teardown_script is not None:
            pulumi.set(__self__, "local_teardown_script", local_teardown_script)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if muted is not None:
            pulumi.set(__self__, "muted", muted)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_locations is not None:
            pulumi.set(__self__, "private_locations", private_locations)
        if runtime_id is not None:
            pulumi.set(__self__, "runtime_id", runtime_id)
        if setup_snippet_id is not None:
            pulumi.set(__self__, "setup_snippet_id", setup_snippet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teardown_snippet_id is not None:
            pulumi.set(__self__, "teardown_snippet_id", teardown_snippet_id)
        if use_global_alert_settings is not None:
            pulumi.set(__self__, "use_global_alert_settings", use_global_alert_settings)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Input[bool]:
        """
        Determines if the checks in the group are running or not.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: pulumi.Input[bool]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter
    def concurrency(self) -> pulumi.Input[int]:
        """
        Determines how many checks are run concurrently when triggering a check group from CI/CD or through the API.
        """
        return pulumi.get(self, "concurrency")

    @concurrency.setter
    def concurrency(self, value: pulumi.Input[int]):
        pulumi.set(self, "concurrency", value)

    @property
    @pulumi.getter(name="alertChannelSubscriptions")
    def alert_channel_subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckGroupAlertChannelSubscriptionArgs']]]]:
        return pulumi.get(self, "alert_channel_subscriptions")

    @alert_channel_subscriptions.setter
    def alert_channel_subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckGroupAlertChannelSubscriptionArgs']]]]):
        pulumi.set(self, "alert_channel_subscriptions", value)

    @property
    @pulumi.getter(name="alertSettings")
    def alert_settings(self) -> Optional[pulumi.Input['CheckGroupAlertSettingsArgs']]:
        return pulumi.get(self, "alert_settings")

    @alert_settings.setter
    def alert_settings(self, value: Optional[pulumi.Input['CheckGroupAlertSettingsArgs']]):
        pulumi.set(self, "alert_settings", value)

    @property
    @pulumi.getter(name="apiCheckDefaults")
    def api_check_defaults(self) -> Optional[pulumi.Input['CheckGroupApiCheckDefaultsArgs']]:
        return pulumi.get(self, "api_check_defaults")

    @api_check_defaults.setter
    def api_check_defaults(self, value: Optional[pulumi.Input['CheckGroupApiCheckDefaultsArgs']]):
        pulumi.set(self, "api_check_defaults", value)

    @property
    @pulumi.getter(name="doubleCheck")
    def double_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected
        region before marking the check as failed.
        """
        return pulumi.get(self, "double_check")

    @double_check.setter
    def double_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "double_check", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks.
        Use global environment variables whenever possible.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="localSetupScript")
    def local_setup_script(self) -> Optional[pulumi.Input[str]]:
        """
        A valid piece of Node.js code to run in the setup phase of an API check in this group.
        """
        return pulumi.get(self, "local_setup_script")

    @local_setup_script.setter
    def local_setup_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_setup_script", value)

    @property
    @pulumi.getter(name="localTeardownScript")
    def local_teardown_script(self) -> Optional[pulumi.Input[str]]:
        """
        A valid piece of Node.js code to run in the teardown phase of an API check in this group.
        """
        return pulumi.get(self, "local_teardown_script")

    @local_teardown_script.setter
    def local_teardown_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_teardown_script", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of one or more data center locations where to run the checks.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def muted(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if any notifications will be sent out when a check in this group fails and/or recovers.
        """
        return pulumi.get(self, "muted")

    @muted.setter
    def muted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "muted", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the check group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateLocations")
    def private_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of one or more private locations slugs.
        """
        return pulumi.get(self, "private_locations")

    @private_locations.setter
    def private_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_locations", value)

    @property
    @pulumi.getter(name="runtimeId")
    def runtime_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the runtime to use for this group.
        """
        return pulumi.get(self, "runtime_id")

    @runtime_id.setter
    def runtime_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_id", value)

    @property
    @pulumi.getter(name="setupSnippetId")
    def setup_snippet_id(self) -> Optional[pulumi.Input[int]]:
        """
        An ID reference to a snippet to use in the setup phase of an API check.
        """
        return pulumi.get(self, "setup_snippet_id")

    @setup_snippet_id.setter
    def setup_snippet_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "setup_snippet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags for organizing and filtering checks.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="teardownSnippetId")
    def teardown_snippet_id(self) -> Optional[pulumi.Input[int]]:
        """
        An ID reference to a snippet to use in the teardown phase of an API check.
        """
        return pulumi.get(self, "teardown_snippet_id")

    @teardown_snippet_id.setter
    def teardown_snippet_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "teardown_snippet_id", value)

    @property
    @pulumi.getter(name="useGlobalAlertSettings")
    def use_global_alert_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, the account level alert settings will be used, not the alert setting defined on this check group.
        """
        return pulumi.get(self, "use_global_alert_settings")

    @use_global_alert_settings.setter
    def use_global_alert_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_global_alert_settings", value)


@pulumi.input_type
class _CheckGroupState:
    def __init__(__self__, *,
                 activated: Optional[pulumi.Input[bool]] = None,
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input['CheckGroupAlertChannelSubscriptionArgs']]]] = None,
                 alert_settings: Optional[pulumi.Input['CheckGroupAlertSettingsArgs']] = None,
                 api_check_defaults: Optional[pulumi.Input['CheckGroupApiCheckDefaultsArgs']] = None,
                 concurrency: Optional[pulumi.Input[int]] = None,
                 double_check: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 local_setup_script: Optional[pulumi.Input[str]] = None,
                 local_teardown_script: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_id: Optional[pulumi.Input[str]] = None,
                 setup_snippet_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 teardown_snippet_id: Optional[pulumi.Input[int]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering CheckGroup resources.
        :param pulumi.Input[bool] activated: Determines if the checks in the group are running or not.
        :param pulumi.Input[int] concurrency: Determines how many checks are run concurrently when triggering a check group from CI/CD or through the API.
        :param pulumi.Input[bool] double_check: Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected
               region before marking the check as failed.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks.
               Use global environment variables whenever possible.
        :param pulumi.Input[str] local_setup_script: A valid piece of Node.js code to run in the setup phase of an API check in this group.
        :param pulumi.Input[str] local_teardown_script: A valid piece of Node.js code to run in the teardown phase of an API check in this group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: An array of one or more data center locations where to run the checks.
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check in this group fails and/or recovers.
        :param pulumi.Input[str] name: The name of the check group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_locations: An array of one or more private locations slugs.
        :param pulumi.Input[str] runtime_id: The id of the runtime to use for this group.
        :param pulumi.Input[int] setup_snippet_id: An ID reference to a snippet to use in the setup phase of an API check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for organizing and filtering checks.
        :param pulumi.Input[int] teardown_snippet_id: An ID reference to a snippet to use in the teardown phase of an API check.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check group.
        """
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if alert_channel_subscriptions is not None:
            pulumi.set(__self__, "alert_channel_subscriptions", alert_channel_subscriptions)
        if alert_settings is not None:
            pulumi.set(__self__, "alert_settings", alert_settings)
        if api_check_defaults is not None:
            pulumi.set(__self__, "api_check_defaults", api_check_defaults)
        if concurrency is not None:
            pulumi.set(__self__, "concurrency", concurrency)
        if double_check is not None:
            pulumi.set(__self__, "double_check", double_check)
        if environment_variables is not None:
            warnings.warn("""The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""", DeprecationWarning)
            pulumi.log.warn("""environment_variables is deprecated: The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""")
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if local_setup_script is not None:
            pulumi.set(__self__, "local_setup_script", local_setup_script)
        if local_teardown_script is not None:
            pulumi.set(__self__, "local_teardown_script", local_teardown_script)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if muted is not None:
            pulumi.set(__self__, "muted", muted)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_locations is not None:
            pulumi.set(__self__, "private_locations", private_locations)
        if runtime_id is not None:
            pulumi.set(__self__, "runtime_id", runtime_id)
        if setup_snippet_id is not None:
            pulumi.set(__self__, "setup_snippet_id", setup_snippet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teardown_snippet_id is not None:
            pulumi.set(__self__, "teardown_snippet_id", teardown_snippet_id)
        if use_global_alert_settings is not None:
            pulumi.set(__self__, "use_global_alert_settings", use_global_alert_settings)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the checks in the group are running or not.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter(name="alertChannelSubscriptions")
    def alert_channel_subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckGroupAlertChannelSubscriptionArgs']]]]:
        return pulumi.get(self, "alert_channel_subscriptions")

    @alert_channel_subscriptions.setter
    def alert_channel_subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckGroupAlertChannelSubscriptionArgs']]]]):
        pulumi.set(self, "alert_channel_subscriptions", value)

    @property
    @pulumi.getter(name="alertSettings")
    def alert_settings(self) -> Optional[pulumi.Input['CheckGroupAlertSettingsArgs']]:
        return pulumi.get(self, "alert_settings")

    @alert_settings.setter
    def alert_settings(self, value: Optional[pulumi.Input['CheckGroupAlertSettingsArgs']]):
        pulumi.set(self, "alert_settings", value)

    @property
    @pulumi.getter(name="apiCheckDefaults")
    def api_check_defaults(self) -> Optional[pulumi.Input['CheckGroupApiCheckDefaultsArgs']]:
        return pulumi.get(self, "api_check_defaults")

    @api_check_defaults.setter
    def api_check_defaults(self, value: Optional[pulumi.Input['CheckGroupApiCheckDefaultsArgs']]):
        pulumi.set(self, "api_check_defaults", value)

    @property
    @pulumi.getter
    def concurrency(self) -> Optional[pulumi.Input[int]]:
        """
        Determines how many checks are run concurrently when triggering a check group from CI/CD or through the API.
        """
        return pulumi.get(self, "concurrency")

    @concurrency.setter
    def concurrency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "concurrency", value)

    @property
    @pulumi.getter(name="doubleCheck")
    def double_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected
        region before marking the check as failed.
        """
        return pulumi.get(self, "double_check")

    @double_check.setter
    def double_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "double_check", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks.
        Use global environment variables whenever possible.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="localSetupScript")
    def local_setup_script(self) -> Optional[pulumi.Input[str]]:
        """
        A valid piece of Node.js code to run in the setup phase of an API check in this group.
        """
        return pulumi.get(self, "local_setup_script")

    @local_setup_script.setter
    def local_setup_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_setup_script", value)

    @property
    @pulumi.getter(name="localTeardownScript")
    def local_teardown_script(self) -> Optional[pulumi.Input[str]]:
        """
        A valid piece of Node.js code to run in the teardown phase of an API check in this group.
        """
        return pulumi.get(self, "local_teardown_script")

    @local_teardown_script.setter
    def local_teardown_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_teardown_script", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of one or more data center locations where to run the checks.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def muted(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if any notifications will be sent out when a check in this group fails and/or recovers.
        """
        return pulumi.get(self, "muted")

    @muted.setter
    def muted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "muted", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the check group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateLocations")
    def private_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of one or more private locations slugs.
        """
        return pulumi.get(self, "private_locations")

    @private_locations.setter
    def private_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_locations", value)

    @property
    @pulumi.getter(name="runtimeId")
    def runtime_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the runtime to use for this group.
        """
        return pulumi.get(self, "runtime_id")

    @runtime_id.setter
    def runtime_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_id", value)

    @property
    @pulumi.getter(name="setupSnippetId")
    def setup_snippet_id(self) -> Optional[pulumi.Input[int]]:
        """
        An ID reference to a snippet to use in the setup phase of an API check.
        """
        return pulumi.get(self, "setup_snippet_id")

    @setup_snippet_id.setter
    def setup_snippet_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "setup_snippet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags for organizing and filtering checks.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="teardownSnippetId")
    def teardown_snippet_id(self) -> Optional[pulumi.Input[int]]:
        """
        An ID reference to a snippet to use in the teardown phase of an API check.
        """
        return pulumi.get(self, "teardown_snippet_id")

    @teardown_snippet_id.setter
    def teardown_snippet_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "teardown_snippet_id", value)

    @property
    @pulumi.getter(name="useGlobalAlertSettings")
    def use_global_alert_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, the account level alert settings will be used, not the alert setting defined on this check group.
        """
        return pulumi.get(self, "use_global_alert_settings")

    @use_global_alert_settings.setter
    def use_global_alert_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_global_alert_settings", value)


class CheckGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[bool]] = None,
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CheckGroupAlertChannelSubscriptionArgs']]]]] = None,
                 alert_settings: Optional[pulumi.Input[pulumi.InputType['CheckGroupAlertSettingsArgs']]] = None,
                 api_check_defaults: Optional[pulumi.Input[pulumi.InputType['CheckGroupApiCheckDefaultsArgs']]] = None,
                 concurrency: Optional[pulumi.Input[int]] = None,
                 double_check: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 local_setup_script: Optional[pulumi.Input[str]] = None,
                 local_teardown_script: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_id: Optional[pulumi.Input[str]] = None,
                 setup_snippet_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 teardown_snippet_id: Optional[pulumi.Input[int]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Check groups allow  you to group together a set of related checks, which can also share default settings for various attributes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_checkly as checkly

        test_group1_check_group = checkly.CheckGroup("testGroup1CheckGroup",
            activated=True,
            muted=False,
            tags=["auto"],
            locations=["eu-west-1"],
            concurrency=3,
            api_check_defaults=checkly.CheckGroupApiCheckDefaultsArgs(
                url="http://example.com/",
                headers={
                    "X-Test": "foo",
                },
                query_parameters={
                    "query": "foo",
                },
                assertions=[
                    checkly.CheckGroupApiCheckDefaultsAssertionArgs(
                        source="STATUS_CODE",
                        property="",
                        comparison="EQUALS",
                        target="200",
                    ),
                    checkly.CheckGroupApiCheckDefaultsAssertionArgs(
                        source="TEXT_BODY",
                        property="",
                        comparison="CONTAINS",
                        target="welcome",
                    ),
                ],
                basic_auth=checkly.CheckGroupApiCheckDefaultsBasicAuthArgs(
                    username="user",
                    password="pass",
                ),
            ),
            environment_variables={
                "ENVTEST": "Hello world",
            },
            double_check=True,
            use_global_alert_settings=False,
            alert_settings=checkly.CheckGroupAlertSettingsArgs(
                escalation_type="RUN_BASED",
                run_based_escalations=[checkly.CheckGroupAlertSettingsRunBasedEscalationArgs(
                    failed_run_threshold=1,
                )],
                time_based_escalations=[checkly.CheckGroupAlertSettingsTimeBasedEscalationArgs(
                    minutes_failing_threshold=5,
                )],
                reminders=[checkly.CheckGroupAlertSettingsReminderArgs(
                    amount=2,
                    interval=5,
                )],
            ),
            local_setup_script="setup-test",
            local_teardown_script="teardown-test")
        # Add a check to a group
        test_check1 = checkly.Check("testCheck1",
            group_id=test_group1_check_group.id,
            group_order=1)
        # Using with alert channels
        email_ac1 = checkly.AlertChannel("emailAc1", email=checkly.AlertChannelEmailArgs(
            address="info@example.com",
        ))
        email_ac2 = checkly.AlertChannel("emailAc2", email=checkly.AlertChannelEmailArgs(
            address="info2@example.com",
        ))
        # Connect the check group to the alert channels
        test_group1_index_check_group_check_group = checkly.CheckGroup("testGroup1Index/checkGroupCheckGroup", alert_channel_subscriptions=[
            checkly.CheckGroupAlertChannelSubscriptionArgs(
                channel_id=email_ac1.id,
                activated=True,
            ),
            checkly.CheckGroupAlertChannelSubscriptionArgs(
                channel_id=email_ac2.id,
                activated=True,
            ),
        ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activated: Determines if the checks in the group are running or not.
        :param pulumi.Input[int] concurrency: Determines how many checks are run concurrently when triggering a check group from CI/CD or through the API.
        :param pulumi.Input[bool] double_check: Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected
               region before marking the check as failed.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks.
               Use global environment variables whenever possible.
        :param pulumi.Input[str] local_setup_script: A valid piece of Node.js code to run in the setup phase of an API check in this group.
        :param pulumi.Input[str] local_teardown_script: A valid piece of Node.js code to run in the teardown phase of an API check in this group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: An array of one or more data center locations where to run the checks.
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check in this group fails and/or recovers.
        :param pulumi.Input[str] name: The name of the check group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_locations: An array of one or more private locations slugs.
        :param pulumi.Input[str] runtime_id: The id of the runtime to use for this group.
        :param pulumi.Input[int] setup_snippet_id: An ID reference to a snippet to use in the setup phase of an API check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for organizing and filtering checks.
        :param pulumi.Input[int] teardown_snippet_id: An ID reference to a snippet to use in the teardown phase of an API check.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CheckGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Check groups allow  you to group together a set of related checks, which can also share default settings for various attributes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_checkly as checkly

        test_group1_check_group = checkly.CheckGroup("testGroup1CheckGroup",
            activated=True,
            muted=False,
            tags=["auto"],
            locations=["eu-west-1"],
            concurrency=3,
            api_check_defaults=checkly.CheckGroupApiCheckDefaultsArgs(
                url="http://example.com/",
                headers={
                    "X-Test": "foo",
                },
                query_parameters={
                    "query": "foo",
                },
                assertions=[
                    checkly.CheckGroupApiCheckDefaultsAssertionArgs(
                        source="STATUS_CODE",
                        property="",
                        comparison="EQUALS",
                        target="200",
                    ),
                    checkly.CheckGroupApiCheckDefaultsAssertionArgs(
                        source="TEXT_BODY",
                        property="",
                        comparison="CONTAINS",
                        target="welcome",
                    ),
                ],
                basic_auth=checkly.CheckGroupApiCheckDefaultsBasicAuthArgs(
                    username="user",
                    password="pass",
                ),
            ),
            environment_variables={
                "ENVTEST": "Hello world",
            },
            double_check=True,
            use_global_alert_settings=False,
            alert_settings=checkly.CheckGroupAlertSettingsArgs(
                escalation_type="RUN_BASED",
                run_based_escalations=[checkly.CheckGroupAlertSettingsRunBasedEscalationArgs(
                    failed_run_threshold=1,
                )],
                time_based_escalations=[checkly.CheckGroupAlertSettingsTimeBasedEscalationArgs(
                    minutes_failing_threshold=5,
                )],
                reminders=[checkly.CheckGroupAlertSettingsReminderArgs(
                    amount=2,
                    interval=5,
                )],
            ),
            local_setup_script="setup-test",
            local_teardown_script="teardown-test")
        # Add a check to a group
        test_check1 = checkly.Check("testCheck1",
            group_id=test_group1_check_group.id,
            group_order=1)
        # Using with alert channels
        email_ac1 = checkly.AlertChannel("emailAc1", email=checkly.AlertChannelEmailArgs(
            address="info@example.com",
        ))
        email_ac2 = checkly.AlertChannel("emailAc2", email=checkly.AlertChannelEmailArgs(
            address="info2@example.com",
        ))
        # Connect the check group to the alert channels
        test_group1_index_check_group_check_group = checkly.CheckGroup("testGroup1Index/checkGroupCheckGroup", alert_channel_subscriptions=[
            checkly.CheckGroupAlertChannelSubscriptionArgs(
                channel_id=email_ac1.id,
                activated=True,
            ),
            checkly.CheckGroupAlertChannelSubscriptionArgs(
                channel_id=email_ac2.id,
                activated=True,
            ),
        ])
        ```

        :param str resource_name: The name of the resource.
        :param CheckGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CheckGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[bool]] = None,
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CheckGroupAlertChannelSubscriptionArgs']]]]] = None,
                 alert_settings: Optional[pulumi.Input[pulumi.InputType['CheckGroupAlertSettingsArgs']]] = None,
                 api_check_defaults: Optional[pulumi.Input[pulumi.InputType['CheckGroupApiCheckDefaultsArgs']]] = None,
                 concurrency: Optional[pulumi.Input[int]] = None,
                 double_check: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 local_setup_script: Optional[pulumi.Input[str]] = None,
                 local_teardown_script: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_id: Optional[pulumi.Input[str]] = None,
                 setup_snippet_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 teardown_snippet_id: Optional[pulumi.Input[int]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CheckGroupArgs.__new__(CheckGroupArgs)

            if activated is None and not opts.urn:
                raise TypeError("Missing required property 'activated'")
            __props__.__dict__["activated"] = activated
            __props__.__dict__["alert_channel_subscriptions"] = alert_channel_subscriptions
            __props__.__dict__["alert_settings"] = alert_settings
            __props__.__dict__["api_check_defaults"] = api_check_defaults
            if concurrency is None and not opts.urn:
                raise TypeError("Missing required property 'concurrency'")
            __props__.__dict__["concurrency"] = concurrency
            __props__.__dict__["double_check"] = double_check
            if environment_variables is not None and not opts.urn:
                warnings.warn("""The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""", DeprecationWarning)
                pulumi.log.warn("""environment_variables is deprecated: The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""")
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["local_setup_script"] = local_setup_script
            __props__.__dict__["local_teardown_script"] = local_teardown_script
            __props__.__dict__["locations"] = locations
            __props__.__dict__["muted"] = muted
            __props__.__dict__["name"] = name
            __props__.__dict__["private_locations"] = private_locations
            __props__.__dict__["runtime_id"] = runtime_id
            __props__.__dict__["setup_snippet_id"] = setup_snippet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["teardown_snippet_id"] = teardown_snippet_id
            __props__.__dict__["use_global_alert_settings"] = use_global_alert_settings
        super(CheckGroup, __self__).__init__(
            'checkly:index/checkGroup:CheckGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated: Optional[pulumi.Input[bool]] = None,
            alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CheckGroupAlertChannelSubscriptionArgs']]]]] = None,
            alert_settings: Optional[pulumi.Input[pulumi.InputType['CheckGroupAlertSettingsArgs']]] = None,
            api_check_defaults: Optional[pulumi.Input[pulumi.InputType['CheckGroupApiCheckDefaultsArgs']]] = None,
            concurrency: Optional[pulumi.Input[int]] = None,
            double_check: Optional[pulumi.Input[bool]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            local_setup_script: Optional[pulumi.Input[str]] = None,
            local_teardown_script: Optional[pulumi.Input[str]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            muted: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            private_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            runtime_id: Optional[pulumi.Input[str]] = None,
            setup_snippet_id: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            teardown_snippet_id: Optional[pulumi.Input[int]] = None,
            use_global_alert_settings: Optional[pulumi.Input[bool]] = None) -> 'CheckGroup':
        """
        Get an existing CheckGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activated: Determines if the checks in the group are running or not.
        :param pulumi.Input[int] concurrency: Determines how many checks are run concurrently when triggering a check group from CI/CD or through the API.
        :param pulumi.Input[bool] double_check: Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected
               region before marking the check as failed.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks.
               Use global environment variables whenever possible.
        :param pulumi.Input[str] local_setup_script: A valid piece of Node.js code to run in the setup phase of an API check in this group.
        :param pulumi.Input[str] local_teardown_script: A valid piece of Node.js code to run in the teardown phase of an API check in this group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: An array of one or more data center locations where to run the checks.
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check in this group fails and/or recovers.
        :param pulumi.Input[str] name: The name of the check group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_locations: An array of one or more private locations slugs.
        :param pulumi.Input[str] runtime_id: The id of the runtime to use for this group.
        :param pulumi.Input[int] setup_snippet_id: An ID reference to a snippet to use in the setup phase of an API check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for organizing and filtering checks.
        :param pulumi.Input[int] teardown_snippet_id: An ID reference to a snippet to use in the teardown phase of an API check.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CheckGroupState.__new__(_CheckGroupState)

        __props__.__dict__["activated"] = activated
        __props__.__dict__["alert_channel_subscriptions"] = alert_channel_subscriptions
        __props__.__dict__["alert_settings"] = alert_settings
        __props__.__dict__["api_check_defaults"] = api_check_defaults
        __props__.__dict__["concurrency"] = concurrency
        __props__.__dict__["double_check"] = double_check
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["local_setup_script"] = local_setup_script
        __props__.__dict__["local_teardown_script"] = local_teardown_script
        __props__.__dict__["locations"] = locations
        __props__.__dict__["muted"] = muted
        __props__.__dict__["name"] = name
        __props__.__dict__["private_locations"] = private_locations
        __props__.__dict__["runtime_id"] = runtime_id
        __props__.__dict__["setup_snippet_id"] = setup_snippet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["teardown_snippet_id"] = teardown_snippet_id
        __props__.__dict__["use_global_alert_settings"] = use_global_alert_settings
        return CheckGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Output[bool]:
        """
        Determines if the checks in the group are running or not.
        """
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="alertChannelSubscriptions")
    def alert_channel_subscriptions(self) -> pulumi.Output[Optional[Sequence['outputs.CheckGroupAlertChannelSubscription']]]:
        return pulumi.get(self, "alert_channel_subscriptions")

    @property
    @pulumi.getter(name="alertSettings")
    def alert_settings(self) -> pulumi.Output['outputs.CheckGroupAlertSettings']:
        return pulumi.get(self, "alert_settings")

    @property
    @pulumi.getter(name="apiCheckDefaults")
    def api_check_defaults(self) -> pulumi.Output['outputs.CheckGroupApiCheckDefaults']:
        return pulumi.get(self, "api_check_defaults")

    @property
    @pulumi.getter
    def concurrency(self) -> pulumi.Output[int]:
        """
        Determines how many checks are run concurrently when triggering a check group from CI/CD or through the API.
        """
        return pulumi.get(self, "concurrency")

    @property
    @pulumi.getter(name="doubleCheck")
    def double_check(self) -> pulumi.Output[Optional[bool]]:
        """
        Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected
        region before marking the check as failed.
        """
        return pulumi.get(self, "double_check")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks.
        Use global environment variables whenever possible.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="localSetupScript")
    def local_setup_script(self) -> pulumi.Output[Optional[str]]:
        """
        A valid piece of Node.js code to run in the setup phase of an API check in this group.
        """
        return pulumi.get(self, "local_setup_script")

    @property
    @pulumi.getter(name="localTeardownScript")
    def local_teardown_script(self) -> pulumi.Output[Optional[str]]:
        """
        A valid piece of Node.js code to run in the teardown phase of an API check in this group.
        """
        return pulumi.get(self, "local_teardown_script")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of one or more data center locations where to run the checks.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def muted(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if any notifications will be sent out when a check in this group fails and/or recovers.
        """
        return pulumi.get(self, "muted")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the check group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLocations")
    def private_locations(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of one or more private locations slugs.
        """
        return pulumi.get(self, "private_locations")

    @property
    @pulumi.getter(name="runtimeId")
    def runtime_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the runtime to use for this group.
        """
        return pulumi.get(self, "runtime_id")

    @property
    @pulumi.getter(name="setupSnippetId")
    def setup_snippet_id(self) -> pulumi.Output[Optional[int]]:
        """
        An ID reference to a snippet to use in the setup phase of an API check.
        """
        return pulumi.get(self, "setup_snippet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags for organizing and filtering checks.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="teardownSnippetId")
    def teardown_snippet_id(self) -> pulumi.Output[Optional[int]]:
        """
        An ID reference to a snippet to use in the teardown phase of an API check.
        """
        return pulumi.get(self, "teardown_snippet_id")

    @property
    @pulumi.getter(name="useGlobalAlertSettings")
    def use_global_alert_settings(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, the account level alert settings will be used, not the alert setting defined on this check group.
        """
        return pulumi.get(self, "use_global_alert_settings")

