# coding: utf-8

"""
    FlashArray REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 2.8
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re

import six
import typing

from ....properties import Property
if typing.TYPE_CHECKING:
    from pypureclient.flasharray.FA_2_8 import models

class DirectoryExport(object):
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'destroyed': 'bool',
        'directory': 'FixedReferenceWithType',
        'enabled': 'bool',
        'export_name': 'str',
        'path': 'str',
        'policy': 'FixedReferenceWithType'
    }

    attribute_map = {
        'destroyed': 'destroyed',
        'directory': 'directory',
        'enabled': 'enabled',
        'export_name': 'export_name',
        'path': 'path',
        'policy': 'policy'
    }

    required_args = {
    }

    def __init__(
        self,
        destroyed=None,  # type: bool
        directory=None,  # type: models.FixedReferenceWithType
        enabled=None,  # type: bool
        export_name=None,  # type: str
        path=None,  # type: str
        policy=None,  # type: models.FixedReferenceWithType
    ):
        """
        Keyword args:
            destroyed (bool): Returns a value of `true` if the managed directory of the export has been destroyed and is pending eradication. The export can be recovered by recovering the destroyed managed directory.
            directory (FixedReferenceWithType): The managed directory of the export.
            enabled (bool): Returns a value of `true` if the export policy that manages this export is enabled.
            export_name (str): The export name for accessing this export.
            path (str): The path of the exported managed directory.
            policy (FixedReferenceWithType): The export policy that manages this export. An export can be managed by at most one export policy.
        """
        if destroyed is not None:
            self.destroyed = destroyed
        if directory is not None:
            self.directory = directory
        if enabled is not None:
            self.enabled = enabled
        if export_name is not None:
            self.export_name = export_name
        if path is not None:
            self.path = path
        if policy is not None:
            self.policy = policy

    def __setattr__(self, key, value):
        if key not in self.attribute_map:
            raise KeyError("Invalid key `{}` for `DirectoryExport`".format(key))
        self.__dict__[key] = value

    def __getattribute__(self, item):
        value = object.__getattribute__(self, item)
        if isinstance(value, Property):
            raise AttributeError
        else:
            return value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            if hasattr(self, attr):
                value = getattr(self, attr)
                if isinstance(value, list):
                    result[attr] = list(map(
                        lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                        value
                    ))
                elif hasattr(value, "to_dict"):
                    result[attr] = value.to_dict()
                elif isinstance(value, dict):
                    result[attr] = dict(map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict") else item,
                        value.items()
                    ))
                else:
                    result[attr] = value
        if issubclass(DirectoryExport, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DirectoryExport):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
