# coding: utf-8

"""
    FlashArray REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 2.20
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re

import six
import typing

from ....properties import Property
if typing.TYPE_CHECKING:
    from pypureclient.flasharray.FA_2_20 import models

class SoftwareBundle(object):
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'source': 'str',
        'created': 'float',
        'details': 'str',
        'download_progress': 'float',
        'status': 'str'
    }

    attribute_map = {
        'id': 'id',
        'source': 'source',
        'created': 'created',
        'details': 'details',
        'download_progress': 'download_progress',
        'status': 'status'
    }

    required_args = {
    }

    def __init__(
        self,
        id=None,  # type: str
        source=None,  # type: str
        created=None,  # type: float
        details=None,  # type: str
        download_progress=None,  # type: float
        status=None,  # type: str
    ):
        """
        Keyword args:
            id (str): A non-modifiable, globally unique ID chosen by the system.
            source (str): The location of the upgrade bundle.
            created (float): Creation time in milliseconds since the UNIX epoch.
            details (str): The detailed reason for the `status`.
            download_progress (float): The progress of the download. Displayed in decimal format.
            status (str): The status of the software bundle. Valid values are `downloading`, `failed`, `ready`, and `verifying`. A status of `downloading` indicates that the array is downloading the upgrade bundle. A status of `failed` indicates that the array has failed to download the upgrade bundle. A status of `ready` indicates that the upgrade bundle is ready to be installed. A status of `verifying` indicates that the array is verifying the upgrade bundle.
        """
        if id is not None:
            self.id = id
        if source is not None:
            self.source = source
        if created is not None:
            self.created = created
        if details is not None:
            self.details = details
        if download_progress is not None:
            self.download_progress = download_progress
        if status is not None:
            self.status = status

    def __setattr__(self, key, value):
        if key not in self.attribute_map:
            raise KeyError("Invalid key `{}` for `SoftwareBundle`".format(key))
        self.__dict__[key] = value

    def __getattribute__(self, item):
        value = object.__getattribute__(self, item)
        if isinstance(value, Property):
            raise AttributeError
        else:
            return value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            if hasattr(self, attr):
                value = getattr(self, attr)
                if isinstance(value, list):
                    result[attr] = list(map(
                        lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                        value
                    ))
                elif hasattr(value, "to_dict"):
                    result[attr] = value.to_dict()
                elif isinstance(value, dict):
                    result[attr] = dict(map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict") else item,
                        value.items()
                    ))
                else:
                    result[attr] = value
        if issubclass(SoftwareBundle, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SoftwareBundle):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
