"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBMappingTemplate = exports.RESOLVER_VERSION_ID = void 0;
const ast_1 = require("./ast");
exports.RESOLVER_VERSION_ID = '2018-05-29';
class DynamoDBMappingTemplate {
    static putItem({ key, attributeValues, condition, }, version = exports.RESOLVER_VERSION_ID) {
        return ast_1.obj({
            version: ast_1.str(version),
            operation: ast_1.str('PutItem'),
            key,
            attributeValues,
            condition,
        });
    }
    static getItem({ key, isSyncEnabled }) {
        let version = exports.RESOLVER_VERSION_ID;
        if (isSyncEnabled) {
            version = '2018-05-29';
        }
        return ast_1.obj({
            version: ast_1.str(version),
            operation: ast_1.str('GetItem'),
            key,
        });
    }
    static query({ query, scanIndexForward, filter, limit, nextToken, index, }) {
        return ast_1.obj({
            version: ast_1.str(exports.RESOLVER_VERSION_ID),
            operation: ast_1.str('Query'),
            query,
            scanIndexForward,
            filter,
            limit,
            ...(nextToken ? { nextToken } : {}),
            ...(index ? { index } : {}),
        });
    }
    static listItem({ filter, limit, nextToken, scanIndexForward, query, index, }, version = exports.RESOLVER_VERSION_ID) {
        return ast_1.obj({
            version: ast_1.str(version),
            operation: ast_1.str('Scan'),
            filter,
            limit,
            nextToken,
            query,
            index,
            scanIndexForward,
        });
    }
    static syncItem({ filter, limit, nextToken, lastSync, }) {
        return ast_1.compoundExpression([
            ast_1.obj({
                version: ast_1.str('2018-05-29'),
                operation: ast_1.str('Sync'),
                limit,
                nextToken,
                lastSync,
                filter,
            }),
        ]);
    }
    static deleteItem({ key, condition, isSyncEnabled, }) {
        return ast_1.obj({
            version: ast_1.str(exports.RESOLVER_VERSION_ID),
            operation: ast_1.str('DeleteItem'),
            key,
            condition,
            ...(isSyncEnabled && { _version: ast_1.ref('util.defaultIfNull($ctx.args.input["_version"], "0")') }),
        });
    }
    static updateItem({ key, condition, objectKeyVariable, nameOverrideMap, isSyncEnabled, }) {
        const entryKeyAttributeNameVar = 'entryKeyAttributeName';
        let keyFields = [ast_1.str('id')];
        let version = exports.RESOLVER_VERSION_ID;
        if (isSyncEnabled) {
            keyFields = [...keyFields, ast_1.str('_version'), ast_1.str('_deleted'), ast_1.str('_lastChangedAt')];
            version = '2018-05-29';
        }
        const handleRename = (keyVar) => ast_1.ifElse(ast_1.raw(`!$util.isNull($${nameOverrideMap}) && $${nameOverrideMap}.containsKey("${keyVar}")`), ast_1.set(ast_1.ref(entryKeyAttributeNameVar), ast_1.raw(`$${nameOverrideMap}.get("${keyVar}")`)), ast_1.set(ast_1.ref(entryKeyAttributeNameVar), ast_1.raw(keyVar)));
        return ast_1.compoundExpression([
            ast_1.set(ast_1.ref('expNames'), ast_1.obj({})),
            ast_1.set(ast_1.ref('expValues'), ast_1.obj({})),
            ast_1.set(ast_1.ref('expSet'), ast_1.obj({})),
            ast_1.set(ast_1.ref('expAdd'), ast_1.obj({})),
            ast_1.set(ast_1.ref('expRemove'), ast_1.list([])),
            ast_1.ifElse(ast_1.ref(objectKeyVariable), ast_1.compoundExpression([
                ast_1.set(ast_1.ref('keyFields'), isSyncEnabled ? ast_1.list([ast_1.str('_version'), ast_1.str('_deleted'), ast_1.str('_lastChangedAt')]) : ast_1.list([])),
                ast_1.forEach(ast_1.ref('entry'), ast_1.ref(`${objectKeyVariable}.entrySet()`), [ast_1.qref('$keyFields.add("$entry.key")')]),
            ]), ast_1.set(ast_1.ref('keyFields'), ast_1.list(keyFields))),
            ast_1.forEach(ast_1.ref('entry'), ast_1.ref(`util.map.copyAndRemoveAllKeys($context.args.input, $keyFields).entrySet()`), [
                handleRename('$entry.key'),
                ast_1.ifElse(ast_1.ref('util.isNull($entry.value)'), ast_1.compoundExpression([
                    ast_1.set(ast_1.ref('discard'), ast_1.ref(`expRemove.add("#$${entryKeyAttributeNameVar}")`)),
                    ast_1.qref(`$expNames.put("#$${entryKeyAttributeNameVar}", "$entry.key")`),
                ]), ast_1.compoundExpression([
                    ast_1.qref(`$expSet.put("#$${entryKeyAttributeNameVar}", ":$${entryKeyAttributeNameVar}")`),
                    ast_1.qref(`$expNames.put("#$${entryKeyAttributeNameVar}", "$entry.key")`),
                    ast_1.qref(`$expValues.put(":$${entryKeyAttributeNameVar}", $util.dynamodb.toDynamoDB($entry.value))`),
                ])),
            ]),
            ast_1.set(ast_1.ref('expression'), ast_1.str('')),
            ast_1.iff(ast_1.raw('!$expSet.isEmpty()'), ast_1.compoundExpression([
                ast_1.set(ast_1.ref('expression'), ast_1.str('SET')),
                ast_1.forEach(ast_1.ref('entry'), ast_1.ref('expSet.entrySet()'), [
                    ast_1.set(ast_1.ref('expression'), ast_1.str('$expression $entry.key = $entry.value')),
                    ast_1.iff(ast_1.ref('foreach.hasNext()'), ast_1.set(ast_1.ref('expression'), ast_1.str('$expression,'))),
                ]),
            ])),
            ast_1.iff(ast_1.raw('!$expAdd.isEmpty()'), ast_1.compoundExpression([
                ast_1.set(ast_1.ref('expression'), ast_1.str('$expression ADD')),
                ast_1.forEach(ast_1.ref('entry'), ast_1.ref('expAdd.entrySet()'), [
                    ast_1.set(ast_1.ref('expression'), ast_1.str('$expression $entry.key $entry.value')),
                    ast_1.iff(ast_1.ref('foreach.hasNext()'), ast_1.set(ast_1.ref('expression'), ast_1.str('$expression,'))),
                ]),
            ])),
            ast_1.iff(ast_1.raw('!$expRemove.isEmpty()'), ast_1.compoundExpression([
                ast_1.set(ast_1.ref('expression'), ast_1.str('$expression REMOVE')),
                ast_1.forEach(ast_1.ref('entry'), ast_1.ref('expRemove'), [
                    ast_1.set(ast_1.ref('expression'), ast_1.str('$expression $entry')),
                    ast_1.iff(ast_1.ref('foreach.hasNext()'), ast_1.set(ast_1.ref('expression'), ast_1.str('$expression,'))),
                ]),
            ])),
            ast_1.set(ast_1.ref('update'), ast_1.obj({})),
            ast_1.qref('$update.put("expression", "$expression")'),
            ast_1.iff(ast_1.raw('!$expNames.isEmpty()'), ast_1.qref('$update.put("expressionNames", $expNames)')),
            ast_1.iff(ast_1.raw('!$expValues.isEmpty()'), ast_1.qref('$update.put("expressionValues", $expValues)')),
            ast_1.obj({
                version: ast_1.str(version),
                operation: ast_1.str('UpdateItem'),
                key,
                update: ast_1.ref('util.toJson($update)'),
                condition,
                ...(isSyncEnabled && { _version: ast_1.ref('util.defaultIfNull($ctx.args.input["_version"], "0")') }),
            }),
        ]);
    }
    static dynamoDBResponse(isSyncEnabled, returnExpression) {
        const errorExpresion = isSyncEnabled
            ? ast_1.ref('util.error($ctx.error.message, $ctx.error.type, $ctx.result)')
            : ast_1.ref('util.error($ctx.error.message, $ctx.error.type)');
        const resultExpression = returnExpression ? returnExpression : ast_1.ref('util.toJson($ctx.result)');
        return ast_1.compoundExpression([ast_1.ifElse(ast_1.ref('ctx.error'), errorExpresion, resultExpression)]);
    }
    static stringAttributeValue(value) {
        return {
            kind: 'Object',
            attributes: [['S', { kind: 'Quotes', expr: value }]],
        };
    }
    static numericAttributeValue(value) {
        return {
            kind: 'Object',
            attributes: [['N', { kind: 'Quotes', expr: value }]],
        };
    }
    static binaryAttributeValue(value) {
        return {
            kind: 'Object',
            attributes: [['B', { kind: 'Quotes', expr: value }]],
        };
    }
    static paginatedResponse() {
        return ast_1.obj({
            items: ast_1.ref('util.toJson($ctx.result.items)'),
            nextToken: ast_1.ref('util.toJson($util.defaultIfNullOrBlank($context.result.nextToken, null))'),
        });
    }
}
exports.DynamoDBMappingTemplate = DynamoDBMappingTemplate;
//# sourceMappingURL=dynamodb.js.map