# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['byroapi']

package_data = \
{'': ['*']}

install_requires = \
['PyPDF2>=1.26.0,<2.0.0',
 'PyYAML>=6.0,<7.0',
 'aiohttp>=3.7.4,<4.0.0',
 'aioyagmail>=0.0.4,<0.0.5',
 'click>=8.0.1,<9.0.0',
 'onacol>=0.3.0,<0.4.0',
 'reportlab>=3.6.5,<4.0.0']

entry_points = \
{'console_scripts': ['byroapi = byroapi.cli:main']}

setup_kwargs = {
    'name': 'byroapi',
    'version': '0.2.1',
    'description': 'REST API service for filling in and signig forms.',
    'long_description': '=======\nByroapi\n=======\n\n.. image:: https://img.shields.io/lgtm/grade/python/g/calcite/byroapi.svg?logo=lgtm&logoWidth=18\n        :target: https://lgtm.com/projects/g/calcite/byroapi/context:python\n        :alt: Language grade: Python\n\nREST API service for filling in and (visually) signing PDF documents.\n\nThe administrator provides form templates (PDF documents with blank fields) and\nconfiguration (YAML) describing fields that shall be filled on each PDF document.\n\nThe user then POSTs JSON request to the REST API endpoint. The JSON contains\ntemplate id and values for the fields defined in the configuration of the\nparticular template.\nThe service uses the data in the JSON to write over a template PDF with the data\n(text fields or images) and either returns API response with the filled PDF\ndocument, or can send this document as email attachment to a specified address.\n\nFeatures and limitations\n------------------------\n\n* Can add strings over any PDF (doesn\'t require PDF form fields)\n* But, also doesn\'t yet support PDF form fields ;)\n* Can add images with transparent mask (=signatures)\n* Supports multi-page documents\n* Does not yet support real cryptographic signatures.\n\nInstallation\n-------------\n\n.. code-block:: console\n\n    $ pip install byroapi\n\nConfiguration\n-------------\n\nFor the usual operation, byroapi requires following:\n\n* configuration file (YAML) - contains entire configuration including template\n  definitions\n* template files - for each supported PDF form, a "blank" template file is\n  required on which the field contents and signatures are overlaid. These\n  template files may be multiple for the same form - e.g. bianco signed forms\n  for each user, differentiated by filename.\n* other assets - image files, additional fonts etc.\n\nTemplate files and other assets can be stored in any path referenced in the\nconfiguration file.\n\nConfiguration file\n++++++++++++++++++\n\nByroapi uses `Onacol`_ configuration, so any configuration parameter described\nbelow can be configured either in the YAML file or through CLI option\nor environment variable.\n\nThis documentation only describes the YAML configuration method.\n\nTo create a configuration file template, use following command::\n\n    $ byroapi --get-config-template your_config.yaml\n\nTypical example configuration with some template looks as follows:\n\n.. code-block:: yaml\n\n    general:\n      log_level: INFO  # Logging level [DEBUG, INFO, WARNING, ERROR, CRITICAL]\n\n    templating:  # This section contains all configuration regarding PDF processing\n      fonts:  # List of additional TTF fonts to be used in PDF processing\n      - name: Arial\n        path: fonts/arial.ttf\n\n      templates:  # List of defined templates\n        - id:  MyForm\n          template:    # Template source\n            path:  templates/myform_files\n            path_value_substitution:    #\n              value: user_id\n              pattern: \'myform_{0}_signed.pdf\'\n          field_defaults: # Default settings for each form field element\n            string:\n              custom:\n                - property: Font\n                  values: [ "Arial", 12 ]\n          fields: # PDF form field definitions\n\n            - name: date_from\n              coords:\n                x: 42\n                y: 174.5\n              type: string\n\n            - name: date_to\n              coords:\n                x: 75\n                y: 174.5\n              type: string\n\n            - name: date_approved\n              coords:\n                x: 57\n                y: 132.25\n              type: string\n\n            - name: sign_approver\n              default: signature2.png\n              coords:\n                x: 143\n                y: 87\n              height: 25\n              type: image\n\n\n    email:  # Configuration for email (can be used for sending processed PDF forms)\n      smpt:  # SMTP settings as defined in YagMail: https://github.com/kootenpv/yagmail/blob/f24af871c670c29f30c34ef2a4ab5abc3b17d005/yagmail/sender.py#L22 , if you set the user, you will not be able to use the "from" field in the "result:email" part of the API request.\n        host: smtp.myserver.com\n        port: 25\n        smtp_skip_login: true\n        smtp_ssl: true\n        smtp_starttls: true\n\n    rest_api:  # Configuration of the REST API endpoint\n      addr: 0.0.0.0\n      port: 8080\n\nNow, let\'s discuss main parts of this.\n\n``templating`` section contains all definitions regarding the supported\nPDF form templates.\nIn the section ``templating:fonts`` you can list additional fonts that can be\nused in the PDF processing. Only TrueType fonts are supported for now.\nThe ``name`` parameter is used in the consequent references to the font in the\nform field configurations.\n\nThe section ``templating:templates`` then includes list of all supported PDF\nform templates. In this example, we support only one PDF form, called "MyForm".\n\nTemplate definition\n~~~~~~~~~~~~~~~~~~~\n\nEach form template configuration then defines further configuration. ``id``\nparameter defines ID that is used to select the particular form in the REST API\ncall (see the API section).\n\nThe ``template`` parameter defines which PDF file should be used as the "blank"\nform to write the data over. There are two ways to select a PDF file:\n\n* If only one PDF blank is used for all possible data contents, then the\n  ``template:path`` parameter should provide path to a PDF file with the blank\n  form.\n* If the PDF blank should be different for different data contents, then the\n  ``template:path`` parameter should be a path to a folder that contains files\n  named in the ``template:path_value_substitution:pattern`` (the pattern format\n  is the same as the Python `str.format()`_). The values in the pattern will\n  be substituted by parameter defined in\n  ``template:path_value_substitution:value``\n\nSo in our example, let\'s say the API call should include parameter ``user_id``\nwith value ``user33444``. Then, as the blank PDF form, file\n``templates/myform_files/\'myform_user33444_signed.pdf\'`` will be used.\n\nForm field elements\n~~~~~~~~~~~~~~~~~~~\n\nEach form template consists of several fields that are filled in. Byroapi\ncurrently supports three field types:\n\n* ``string`` - draws text string on a given coordinates.\n* ``image``  - puts an image (from an image file) on a given coordinats.\n* ``page_break`` - switches to the next page in case of a multi-page document.\n\nEach of these fields can have further custom configurations. This configuration\ncan be done per-template (so this configuration is a default within a given\ntemplate) in the ``field_defaults`` section.\n\nIn the given example, we configure the ``string`` fields with default font\nArial, size 12 pts. This will be applied to the each ``string`` element within\nthe "MyForm" template.\n\nThen, the individual fields are defined in the ``fields`` section. Each field\nmust contain ``name`` and ``type`` identifiers. The ``name`` identifiers is\nmatched against the data provided in the REST API call.\n\nField can also have a ``default`` value. That value is used if no value for\ngiven field is provided in the API call.\n\nFields are processed in the order they are defined in the configuration.\nTherefore, to fill a multi-page document, the field type ``page_break`` is used\nto switch the pages. (for ``type: page_break`` fields, the ``name`` doesn\'t\nmatter but must be present, other fields do not have to be present and do\nnot matter).\n\nBoth ``string`` and ``image`` can have a ``custom`` property configuration that\noverloads the default configuration. The contents of the ``custom`` is a list of\nproperties that match the `reportlab`_ setXXX() method calls using pattern\n``set{property}(*{values})``.\n\nGraphical fields also have the ``coords`` configuration property with ``x`` and\n``y`` coordinates in millimeters from the bottom-left corner of the page (see\n`reportlab`_ for details).\n\nEmail settings\n~~~~~~~~~~~~~~\n\nDepending on the API call paramters, one can request byroapi to send the\nresult of the PDF processing to a selected email address(es). For this, SMTP\nis used, with configuration in ``email:smtp``. Each parameter of this section\nshould match the Yagmail_ sender config.\n\nThere are two ways how to configure the sender. If you use a SMTP server without\nlogin process (usually an internal service), you don\'t use the ``user`` value in\nthe ``email:smtp`` and you can use it to emulate any sender address using the\n``from`` parameter in the API call (see below).\n\nIf you SMTP server requires a login, then ``user`` parameter in ``email:smtp``\nmust be set and the ``from`` parameter in the api call will be ignored if\npresent.\n\nREST API structure\n++++++++++++++++++\n\nThe byroapi REST API provides two endpoints:\n\n* POST ``/api/v1/form`` - for providing the form filling data and retrieving\n  processed PDF file.\n* PUT ``/api/v2/template/{template_id}/{var}`` - for updating the PDF blank files for each template\n\n\n/api/v1/form\n~~~~~~~~~~~~\n\nIs a POST endpoint accepting JSON payload with following structure:\n\n.. code-block:: json\n\n    {\n        "template": "template_id",\n        "form_data": {\n            "field_name": "field_value",\n            ...\n        },\n        "result": {\n            "download": true,\n            "email": {\n                "from": {"some@email.com": "Some Guy Name"},\n                "to": {\n                    "recipient1@email.com": "Recipient One",\n                    "recipient2@email.com": "Recipient Two"\n                },\n                "cc": {...},\n                "subject": "",\n                "contents": "",\n                "attachments": ""\n            }\n        }\n\n    }\n\nThe ``template`` value shall match some ``id`` in the template configuration.\n\nThe section ``form_data`` then contains key-value collection where key matches\nfield names for and values are data to be filled into the form fields.\n\nThe ``result`` section then contains information about how to handle the result\nof the PDF processing. If ``result:download`` is set to true, the PDF file will\nbe included in the REST response to the API call (otherwise, just status code\n200 is returned in case of sucessful processing).\n\nIf ``result: email`` section (optional) is populated, then the PDF file will be\nattached to an email and sent to the selected address. ``result:email:from``\nneeds to be filled only in case SMTP server doesn\'t use login (see the\n`Email settings`_). The other parameters are matching the Yagmail_ send()\noptions. Only one attachment file is supported. If no file-name is defined,\na default file name will be used.\n\nTo continue with the example configuration from the `Configuration file`_ section\n, the template "MyForm" can be processed with following JSON request:\n\n.. code-block:: json\n\n    {\n        "template": "MyForm",\n        "form_data": {\n            "date_from": "2022/01/13",\n            "date_to": "2022/01/14",\n            "date_approved": "2022/01/12",\n            "user_id": "user33444"\n        },\n        "result": {\n            "download": true,\n            "email":\n                "to": {"some.guy@email.com": "Some Guy"},\n                "subject": "My form processed",\n                "contents": "My form is provided in attachment.",\n                "attachments": "my_form_user33444.pdf"\n        }\n    }\n\n/api/v1/template\n~~~~~~~~~~~~~~~~\n\nThis PUT endpoint can be used for updates of the PDF "blank" files, especially in\ncase they use the path value substitution.\nThe use case is singular - a new or updated PDF "blank" for a given variable\nvalue used in substitution can uploaded to the byroapi::\n\n    $ curl -T new_template.pdf http://host:port/api/v1/template/{template_id}/{substitution_variable}\n\nFor example "MyForm" used above, "user33444" can update the PDF blank like\nthis::\n\n    $ curl -T user33444_updated_blank.pdf http://host:port/api/v1/template/MyForm/user33444\n\nThis will update the existing platform in the substitution path, or add the new\none if none exists.\n\nUsage\n-----\n\nByroapi provides a simple CLI. To run as a server::\n\n    $ byroapi --config your_config.yaml\n\nTo process PDF from CLI::\n\n    $ byroapi --config your_config.yaml --fill-form your_form.yaml --output your_form_output.pdf\n\nIn this case, the ``your_form.yaml`` should be a YAML file with contents matching\nthe ``/api/v1/form`` JSON payload (only the ``template`` and ``form_data`` items\nmatter).\n\n.. _`JNevrly/cookiecutter-pypackage-poetry`: https://github.com/JNevrly/cookiecutter-pypackage-poetry\n.. _Onacol: https://github.com/calcite/onacol\n.. _str.format(): https://docs.python.org/3/tutorial/inputoutput.html#the-string-format-method\n.. _reportlab: https://www.reportlab.com/docs/reportlab-userguide.pdf\n.. _Yagmail: https://github.com/kootenpv/yagmail/blob/f24af871c670c29f30c34ef2a4ab5abc3b17d005/yagmail/sender.py#L22\n',
    'author': 'Josef Nevrly',
    'author_email': 'josef.nevrly@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/JNevrly/byroapi',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
