"""Initialize database

Revision ID: ab8ec674d281
Revises:
Create Date: 2018-08-13 08:26:26.508945

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = 'ab8ec674d281'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'hosts',
        sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column('hostname', sa.String(length=45), nullable=False),
        sa.Column('created', sa.TIMESTAMP(), server_default=sa.func.now(),
                  nullable=False),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('hostname'),
        sa.UniqueConstraint('id')
    )
    op.create_table(
        'files',
        sa.Column('id', sa.BIGINT(), autoincrement=True, nullable=False),
        sa.Column('path', sa.String(length=1023), nullable=False),
        sa.Column('filename', sa.String(length=255), nullable=False),
        sa.Column('owner', sa.String(length=48), nullable=True),
        sa.Column('grp', sa.String(length=48), nullable=True),
        sa.Column('uid', sa.INTEGER(), nullable=False),
        sa.Column('gid', sa.INTEGER(), nullable=False),
        sa.Column('mode', sa.INTEGER(), nullable=False),
        sa.Column('size', sa.BIGINT(), nullable=False),
        sa.Column('ctime', sa.TIMESTAMP(), nullable=True),
        sa.Column('mtime', sa.TIMESTAMP(), nullable=True),
        sa.Column('type', sa.Enum(u'c', u'd', u'f', u'l', u's'),
                  nullable=False),
        sa.Column('links', sa.INTEGER(), server_default=sa.text(u'1'),
                  nullable=False),
        sa.Column('sparseness', sa.Float(), server_default=sa.text(u'1'),
                  nullable=False),
        sa.Column('shasum', sa.VARBINARY(length=64), nullable=True),
        sa.Column('first_backup', sa.TIMESTAMP(), server_default=sa.func.now(),
                  nullable=False),
        sa.Column('last_backup', sa.TIMESTAMP(), nullable=True),
        sa.Column('host_id', sa.INTEGER(), nullable=False),
        sa.ForeignKeyConstraint(['host_id'], [u'hosts.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('id')
    )
    op.create_index('index3', 'files', [
        'filename', 'path', 'host_id', 'mode', 'size', 'mtime', 'uid', 'gid'],
        unique=True)
    op.create_index(op.f('ix_files_host_id'), 'files', ['host_id'],
                    unique=False)
    op.create_table(
        'savesets',
        sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column('saveset', sa.String(length=45), nullable=False),
        sa.Column('location', sa.String(length=32), nullable=True),
        sa.Column('created', sa.TIMESTAMP(), server_default=sa.func.now(),
                  nullable=False),
        sa.Column('finished', sa.TIMESTAMP(), nullable=True),
        sa.Column('host_id', sa.INTEGER(), nullable=False),
        sa.Column('backup_host_id', sa.INTEGER(), nullable=False),
        sa.ForeignKeyConstraint(['backup_host_id'], [u'hosts.id'], ),
        sa.ForeignKeyConstraint(['host_id'], [u'hosts.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('id'),
        sa.UniqueConstraint('saveset')
    )
    op.create_index(op.f('ix_savesets_backup_host_id'), 'savesets',
                    ['backup_host_id'], unique=False)
    op.create_index(op.f('ix_savesets_finished'), 'savesets', ['finished'],
                    unique=False)
    op.create_index(op.f('ix_savesets_host_id'), 'savesets', ['host_id'],
                    unique=False)
    op.create_table(
        'volumes',
        sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column('volume', sa.String(length=45), nullable=False),
        sa.Column('path', sa.String(length=255), nullable=False),
        sa.Column('size', sa.BIGINT(), nullable=True),
        sa.Column('created', sa.TIMESTAMP(), server_default=sa.func.now(),
                  nullable=False),
        sa.Column('removable', sa.BOOLEAN(), server_default=sa.text(u'0'),
                  nullable=False),
        sa.Column('mounted', sa.BOOLEAN(), server_default=sa.text(u'1'),
                  nullable=False),
        sa.Column('host_id', sa.INTEGER(), server_default=sa.text(u'0'),
                  nullable=False),
        sa.ForeignKeyConstraint(['host_id'], [u'hosts.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('id'),
        sa.UniqueConstraint('volume')
    )
    op.create_index(op.f('ix_volumes_host_id'), 'volumes', ['host_id'],
                    unique=False)
    op.create_table(
        'backups',
        sa.Column('id', sa.BIGINT(), autoincrement=True, nullable=False),
        sa.Column('saveset_id', sa.INTEGER(), nullable=False),
        sa.Column('volume_id', sa.INTEGER(), nullable=False),
        sa.Column('file_id', sa.BIGINT(), nullable=False),
        sa.ForeignKeyConstraint(['file_id'], [u'files.id'], ),
        sa.ForeignKeyConstraint(['saveset_id'], [u'savesets.id'],
                                ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['volume_id'], [u'volumes.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('id')
    )
    op.create_index(op.f('ix_backups_file_id'), 'backups', ['file_id'],
                    unique=False)
    op.create_index(op.f('ix_backups_saveset_id'), 'backups', ['saveset_id'],
                    unique=False)
    op.create_index(op.f('ix_backups_volume_id'), 'backups', ['volume_id'],
                    unique=False)
    # ### end Alembic commands ###


"""
def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_backups_volume_id'), table_name='backups')
    op.drop_index(op.f('ix_backups_saveset_id'), table_name='backups')
    op.drop_index(op.f('ix_backups_file_id'), table_name='backups')
    op.drop_table('backups')
    op.drop_index(op.f('ix_volumes_host_id'), table_name='volumes')
    op.drop_table('volumes')
    op.drop_index(op.f('ix_savesets_host_id'), table_name='savesets')
    op.drop_index(op.f('ix_savesets_finished'), table_name='savesets')
    op.drop_index(op.f('ix_savesets_backup_host_id'), table_name='savesets')
    op.drop_table('savesets')
    op.drop_index(op.f('ix_files_host_id'), table_name='files')
    op.drop_index('index3', table_name='files')
    op.drop_table('files')
    op.drop_table('hosts')
    # ### end Alembic commands ###
"""
