import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceQuotaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#id ResourceQuota#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#metadata ResourceQuota#metadata}
    */
    readonly metadata: ResourceQuotaMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#spec ResourceQuota#spec}
    */
    readonly spec?: ResourceQuotaSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#timeouts ResourceQuota#timeouts}
    */
    readonly timeouts?: ResourceQuotaTimeouts;
}
export interface ResourceQuotaMetadata {
    /**
    * An unstructured key value map stored with the resource quota that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#annotations ResourceQuota#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#generate_name ResourceQuota#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the resource quota. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#labels ResourceQuota#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the resource quota, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#name ResourceQuota#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the resource quota must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#namespace ResourceQuota#namespace}
    */
    readonly namespace?: string;
}
export declare function resourceQuotaMetadataToTerraform(struct?: ResourceQuotaMetadataOutputReference | ResourceQuotaMetadata): any;
export declare class ResourceQuotaMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceQuotaMetadata | undefined;
    set internalValue(value: ResourceQuotaMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface ResourceQuotaSpecScopeSelectorMatchExpression {
    /**
    * Represents a scope's relationship to a set of values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#operator ResourceQuota#operator}
    */
    readonly operator: string;
    /**
    * The name of the scope that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#scope_name ResourceQuota#scope_name}
    */
    readonly scopeName: string;
    /**
    * A list of scope selector requirements by scope of the resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#values ResourceQuota#values}
    */
    readonly values?: string[];
}
export declare function resourceQuotaSpecScopeSelectorMatchExpressionToTerraform(struct?: ResourceQuotaSpecScopeSelectorMatchExpression | cdktf.IResolvable): any;
export declare class ResourceQuotaSpecScopeSelectorMatchExpressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceQuotaSpecScopeSelectorMatchExpression | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceQuotaSpecScopeSelectorMatchExpression | cdktf.IResolvable | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _scopeName?;
    get scopeName(): string;
    set scopeName(value: string);
    get scopeNameInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class ResourceQuotaSpecScopeSelectorMatchExpressionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceQuotaSpecScopeSelectorMatchExpression[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceQuotaSpecScopeSelectorMatchExpressionOutputReference;
}
export interface ResourceQuotaSpecScopeSelector {
    /**
    * match_expression block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#match_expression ResourceQuota#match_expression}
    */
    readonly matchExpression?: ResourceQuotaSpecScopeSelectorMatchExpression[] | cdktf.IResolvable;
}
export declare function resourceQuotaSpecScopeSelectorToTerraform(struct?: ResourceQuotaSpecScopeSelectorOutputReference | ResourceQuotaSpecScopeSelector): any;
export declare class ResourceQuotaSpecScopeSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceQuotaSpecScopeSelector | undefined;
    set internalValue(value: ResourceQuotaSpecScopeSelector | undefined);
    private _matchExpression;
    get matchExpression(): ResourceQuotaSpecScopeSelectorMatchExpressionList;
    putMatchExpression(value: ResourceQuotaSpecScopeSelectorMatchExpression[] | cdktf.IResolvable): void;
    resetMatchExpression(): void;
    get matchExpressionInput(): cdktf.IResolvable | ResourceQuotaSpecScopeSelectorMatchExpression[] | undefined;
}
export interface ResourceQuotaSpec {
    /**
    * The set of desired hard limits for each named resource. More info: http://releases.k8s.io/HEAD/docs/design/admission_control_resource_quota.md#admissioncontrol-plugin-resourcequota
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#hard ResourceQuota#hard}
    */
    readonly hard?: {
        [key: string]: string;
    };
    /**
    * A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#scopes ResourceQuota#scopes}
    */
    readonly scopes?: string[];
    /**
    * scope_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#scope_selector ResourceQuota#scope_selector}
    */
    readonly scopeSelector?: ResourceQuotaSpecScopeSelector;
}
export declare function resourceQuotaSpecToTerraform(struct?: ResourceQuotaSpecOutputReference | ResourceQuotaSpec): any;
export declare class ResourceQuotaSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceQuotaSpec | undefined;
    set internalValue(value: ResourceQuotaSpec | undefined);
    private _hard?;
    get hard(): {
        [key: string]: string;
    };
    set hard(value: {
        [key: string]: string;
    });
    resetHard(): void;
    get hardInput(): {
        [key: string]: string;
    } | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    private _scopeSelector;
    get scopeSelector(): ResourceQuotaSpecScopeSelectorOutputReference;
    putScopeSelector(value: ResourceQuotaSpecScopeSelector): void;
    resetScopeSelector(): void;
    get scopeSelectorInput(): ResourceQuotaSpecScopeSelector | undefined;
}
export interface ResourceQuotaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#create ResourceQuota#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota#update ResourceQuota#update}
    */
    readonly update?: string;
}
export declare function resourceQuotaTimeoutsToTerraform(struct?: ResourceQuotaTimeoutsOutputReference | ResourceQuotaTimeouts | cdktf.IResolvable): any;
export declare class ResourceQuotaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceQuotaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceQuotaTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota kubernetes_resource_quota}
*/
export declare class ResourceQuota extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_resource_quota";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/resource_quota kubernetes_resource_quota} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceQuotaConfig
    */
    constructor(scope: Construct, id: string, config: ResourceQuotaConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): ResourceQuotaMetadataOutputReference;
    putMetadata(value: ResourceQuotaMetadata): void;
    get metadataInput(): ResourceQuotaMetadata | undefined;
    private _spec;
    get spec(): ResourceQuotaSpecOutputReference;
    putSpec(value: ResourceQuotaSpec): void;
    resetSpec(): void;
    get specInput(): ResourceQuotaSpec | undefined;
    private _timeouts;
    get timeouts(): ResourceQuotaTimeoutsOutputReference;
    putTimeouts(value: ResourceQuotaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourceQuotaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
