import { PodV1Metadata, PodV1MetadataOutputReference, PodV1Spec, PodV1SpecOutputReference, PodV1Timeouts, PodV1TimeoutsOutputReference } from './pod-v1-structs';
export * from './pod-v1-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PodV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#id PodV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#metadata PodV1#metadata}
    */
    readonly metadata: PodV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#spec PodV1#spec}
    */
    readonly spec: PodV1Spec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1#timeouts PodV1#timeouts}
    */
    readonly timeouts?: PodV1Timeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1 kubernetes_pod_v1}
*/
export declare class PodV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_pod_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_v1 kubernetes_pod_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PodV1Config
    */
    constructor(scope: Construct, id: string, config: PodV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): PodV1MetadataOutputReference;
    putMetadata(value: PodV1Metadata): void;
    get metadataInput(): PodV1Metadata | undefined;
    private _spec;
    get spec(): PodV1SpecOutputReference;
    putSpec(value: PodV1Spec): void;
    get specInput(): PodV1Spec | undefined;
    private _timeouts;
    get timeouts(): PodV1TimeoutsOutputReference;
    putTimeouts(value: PodV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PodV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
