import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManifestConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of manifest fields whose values can be altered by the API server during 'apply'. Defaults to: ["metadata.annotations", "metadata.labels"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#computed_fields Manifest#computed_fields}
    */
    readonly computedFields?: string[];
    /**
    * A Kubernetes manifest describing the desired state of the resource in HCL format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#manifest Manifest#manifest}
    */
    readonly manifest: {
        [key: string]: any;
    };
    /**
    * The resulting resource state, as returned by the API server after applying the desired state from `manifest`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#object Manifest#object}
    */
    readonly object?: {
        [key: string]: any;
    };
    /**
    * A map of attribute paths and desired patterns to be matched. After each apply the provider will wait for all attributes listed here to reach a value that matches the desired pattern.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#wait_for Manifest#wait_for}
    */
    readonly waitFor?: ManifestWaitFor | cdktf.IResolvable;
    /**
    * field_manager block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#field_manager Manifest#field_manager}
    */
    readonly fieldManager?: ManifestFieldManager;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#timeouts Manifest#timeouts}
    */
    readonly timeouts?: ManifestTimeouts;
    /**
    * wait block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#wait Manifest#wait}
    */
    readonly wait?: ManifestWait;
}
export interface ManifestWaitFor {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#fields Manifest#fields}
    */
    readonly fields?: {
        [key: string]: string;
    };
}
export declare function manifestWaitForToTerraform(struct?: ManifestWaitFor | cdktf.IResolvable): any;
export declare class ManifestWaitForOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManifestWaitFor | cdktf.IResolvable | undefined;
    set internalValue(value: ManifestWaitFor | cdktf.IResolvable | undefined);
    private _fields?;
    get fields(): {
        [key: string]: string;
    };
    set fields(value: {
        [key: string]: string;
    });
    resetFields(): void;
    get fieldsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface ManifestFieldManager {
    /**
    * Force changes against conflicts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#force_conflicts Manifest#force_conflicts}
    */
    readonly forceConflicts?: boolean | cdktf.IResolvable;
    /**
    * The name to use for the field manager when creating and updating the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#name Manifest#name}
    */
    readonly name?: string;
}
export declare function manifestFieldManagerToTerraform(struct?: ManifestFieldManagerOutputReference | ManifestFieldManager): any;
export declare class ManifestFieldManagerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManifestFieldManager | undefined;
    set internalValue(value: ManifestFieldManager | undefined);
    private _forceConflicts?;
    get forceConflicts(): boolean | cdktf.IResolvable;
    set forceConflicts(value: boolean | cdktf.IResolvable);
    resetForceConflicts(): void;
    get forceConflictsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface ManifestTimeouts {
    /**
    * Timeout for the create operation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#create Manifest#create}
    */
    readonly create?: string;
    /**
    * Timeout for the delete operation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#delete Manifest#delete}
    */
    readonly delete?: string;
    /**
    * Timeout for the update operation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#update Manifest#update}
    */
    readonly update?: string;
}
export declare function manifestTimeoutsToTerraform(struct?: ManifestTimeoutsOutputReference | ManifestTimeouts): any;
export declare class ManifestTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManifestTimeouts | undefined;
    set internalValue(value: ManifestTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ManifestWaitCondition {
    /**
    * The condition status.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#status Manifest#status}
    */
    readonly status?: string;
    /**
    * The type of condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#type Manifest#type}
    */
    readonly type?: string;
}
export declare function manifestWaitConditionToTerraform(struct?: ManifestWaitCondition | cdktf.IResolvable): any;
export declare class ManifestWaitConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManifestWaitCondition | cdktf.IResolvable | undefined;
    set internalValue(value: ManifestWaitCondition | cdktf.IResolvable | undefined);
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class ManifestWaitConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManifestWaitCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManifestWaitConditionOutputReference;
}
export interface ManifestWait {
    /**
    * A map of paths to fields to wait for a specific field value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#fields Manifest#fields}
    */
    readonly fields?: {
        [key: string]: string;
    };
    /**
    * Wait for rollout to complete on resources that support `kubectl rollout status`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#rollout Manifest#rollout}
    */
    readonly rollout?: boolean | cdktf.IResolvable;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest#condition Manifest#condition}
    */
    readonly condition?: ManifestWaitCondition[] | cdktf.IResolvable;
}
export declare function manifestWaitToTerraform(struct?: ManifestWaitOutputReference | ManifestWait): any;
export declare class ManifestWaitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManifestWait | undefined;
    set internalValue(value: ManifestWait | undefined);
    private _fields?;
    get fields(): {
        [key: string]: string;
    };
    set fields(value: {
        [key: string]: string;
    });
    resetFields(): void;
    get fieldsInput(): {
        [key: string]: string;
    } | undefined;
    private _rollout?;
    get rollout(): boolean | cdktf.IResolvable;
    set rollout(value: boolean | cdktf.IResolvable);
    resetRollout(): void;
    get rolloutInput(): boolean | cdktf.IResolvable | undefined;
    private _condition;
    get condition(): ManifestWaitConditionList;
    putCondition(value: ManifestWaitCondition[] | cdktf.IResolvable): void;
    resetCondition(): void;
    get conditionInput(): cdktf.IResolvable | ManifestWaitCondition[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest kubernetes_manifest}
*/
export declare class Manifest extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_manifest";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/manifest kubernetes_manifest} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManifestConfig
    */
    constructor(scope: Construct, id: string, config: ManifestConfig);
    private _computedFields?;
    get computedFields(): string[];
    set computedFields(value: string[]);
    resetComputedFields(): void;
    get computedFieldsInput(): string[] | undefined;
    private _manifest?;
    get manifest(): {
        [key: string]: any;
    };
    set manifest(value: {
        [key: string]: any;
    });
    get manifestInput(): {
        [key: string]: any;
    } | undefined;
    private _object?;
    get object(): {
        [key: string]: any;
    };
    set object(value: {
        [key: string]: any;
    });
    resetObject(): void;
    get objectInput(): {
        [key: string]: any;
    } | undefined;
    private _waitFor?;
    get waitFor(): ManifestWaitFor | cdktf.IResolvable;
    set waitFor(value: ManifestWaitFor | cdktf.IResolvable);
    resetWaitFor(): void;
    get waitForInput(): cdktf.IResolvable | ManifestWaitFor | undefined;
    private _fieldManager;
    get fieldManager(): ManifestFieldManagerOutputReference;
    putFieldManager(value: ManifestFieldManager): void;
    resetFieldManager(): void;
    get fieldManagerInput(): ManifestFieldManager | undefined;
    private _timeouts;
    get timeouts(): ManifestTimeoutsOutputReference;
    putTimeouts(value: ManifestTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ManifestTimeouts | undefined;
    private _wait;
    get wait(): ManifestWaitOutputReference;
    putWait(value: ManifestWait): void;
    resetWait(): void;
    get waitInput(): ManifestWait | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
