import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HorizontalPodAutoscalerV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#id HorizontalPodAutoscalerV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#metadata HorizontalPodAutoscalerV2#metadata}
    */
    readonly metadata: HorizontalPodAutoscalerV2Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#spec HorizontalPodAutoscalerV2#spec}
    */
    readonly spec: HorizontalPodAutoscalerV2Spec;
}
export interface HorizontalPodAutoscalerV2Metadata {
    /**
    * An unstructured key value map stored with the horizontal pod autoscaler that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#annotations HorizontalPodAutoscalerV2#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#generate_name HorizontalPodAutoscalerV2#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the horizontal pod autoscaler. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#labels HorizontalPodAutoscalerV2#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the horizontal pod autoscaler, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#name HorizontalPodAutoscalerV2#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the horizontal pod autoscaler must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#namespace HorizontalPodAutoscalerV2#namespace}
    */
    readonly namespace?: string;
}
export declare function horizontalPodAutoscalerV2MetadataToTerraform(struct?: HorizontalPodAutoscalerV2MetadataOutputReference | HorizontalPodAutoscalerV2Metadata): any;
export declare class HorizontalPodAutoscalerV2MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2Metadata | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicy {
    /**
    * Period specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#period_seconds HorizontalPodAutoscalerV2#period_seconds}
    */
    readonly periodSeconds: number;
    /**
    * Type is used to specify the scaling policy: Percent or Pods
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#type HorizontalPodAutoscalerV2#type}
    */
    readonly type: string;
    /**
    * Value contains the amount of change which is permitted by the policy. It must be greater than zero.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#value HorizontalPodAutoscalerV2#value}
    */
    readonly value: number;
}
export declare function horizontalPodAutoscalerV2SpecBehaviorScaleDownPolicyToTerraform(struct?: HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicy | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicy | cdktf.IResolvable | undefined);
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    get periodSecondsInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicyOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecBehaviorScaleDown {
    /**
    * Used to specify which policy should be used. If not set, the default value Max is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#select_policy HorizontalPodAutoscalerV2#select_policy}
    */
    readonly selectPolicy?: string;
    /**
    * Number of seconds for which past recommendations should be considered while scaling up or scaling down. This value must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#stabilization_window_seconds HorizontalPodAutoscalerV2#stabilization_window_seconds}
    */
    readonly stabilizationWindowSeconds?: number;
    /**
    * policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#policy HorizontalPodAutoscalerV2#policy}
    */
    readonly policy: HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicy[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerV2SpecBehaviorScaleDownToTerraform(struct?: HorizontalPodAutoscalerV2SpecBehaviorScaleDown | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecBehaviorScaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecBehaviorScaleDown | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecBehaviorScaleDown | cdktf.IResolvable | undefined);
    private _selectPolicy?;
    get selectPolicy(): string;
    set selectPolicy(value: string);
    resetSelectPolicy(): void;
    get selectPolicyInput(): string | undefined;
    private _stabilizationWindowSeconds?;
    get stabilizationWindowSeconds(): number;
    set stabilizationWindowSeconds(value: number);
    resetStabilizationWindowSeconds(): void;
    get stabilizationWindowSecondsInput(): number | undefined;
    private _policy;
    get policy(): HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicyList;
    putPolicy(value: HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicy[] | cdktf.IResolvable): void;
    get policyInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecBehaviorScaleDownPolicy[] | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecBehaviorScaleDownList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecBehaviorScaleDown[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecBehaviorScaleDownOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicy {
    /**
    * Period specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#period_seconds HorizontalPodAutoscalerV2#period_seconds}
    */
    readonly periodSeconds: number;
    /**
    * Type is used to specify the scaling policy: Percent or Pods
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#type HorizontalPodAutoscalerV2#type}
    */
    readonly type: string;
    /**
    * Value contains the amount of change which is permitted by the policy. It must be greater than zero.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#value HorizontalPodAutoscalerV2#value}
    */
    readonly value: number;
}
export declare function horizontalPodAutoscalerV2SpecBehaviorScaleUpPolicyToTerraform(struct?: HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicy | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicy | cdktf.IResolvable | undefined);
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    get periodSecondsInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicyOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecBehaviorScaleUp {
    /**
    * Used to specify which policy should be used. If not set, the default value Max is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#select_policy HorizontalPodAutoscalerV2#select_policy}
    */
    readonly selectPolicy?: string;
    /**
    * Number of seconds for which past recommendations should be considered while scaling up or scaling down. This value must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#stabilization_window_seconds HorizontalPodAutoscalerV2#stabilization_window_seconds}
    */
    readonly stabilizationWindowSeconds?: number;
    /**
    * policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#policy HorizontalPodAutoscalerV2#policy}
    */
    readonly policy: HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicy[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerV2SpecBehaviorScaleUpToTerraform(struct?: HorizontalPodAutoscalerV2SpecBehaviorScaleUp | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecBehaviorScaleUpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecBehaviorScaleUp | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecBehaviorScaleUp | cdktf.IResolvable | undefined);
    private _selectPolicy?;
    get selectPolicy(): string;
    set selectPolicy(value: string);
    resetSelectPolicy(): void;
    get selectPolicyInput(): string | undefined;
    private _stabilizationWindowSeconds?;
    get stabilizationWindowSeconds(): number;
    set stabilizationWindowSeconds(value: number);
    resetStabilizationWindowSeconds(): void;
    get stabilizationWindowSecondsInput(): number | undefined;
    private _policy;
    get policy(): HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicyList;
    putPolicy(value: HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicy[] | cdktf.IResolvable): void;
    get policyInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecBehaviorScaleUpPolicy[] | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecBehaviorScaleUpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecBehaviorScaleUp[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecBehaviorScaleUpOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecBehavior {
    /**
    * scale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#scale_down HorizontalPodAutoscalerV2#scale_down}
    */
    readonly scaleDown?: HorizontalPodAutoscalerV2SpecBehaviorScaleDown[] | cdktf.IResolvable;
    /**
    * scale_up block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#scale_up HorizontalPodAutoscalerV2#scale_up}
    */
    readonly scaleUp?: HorizontalPodAutoscalerV2SpecBehaviorScaleUp[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerV2SpecBehaviorToTerraform(struct?: HorizontalPodAutoscalerV2SpecBehaviorOutputReference | HorizontalPodAutoscalerV2SpecBehavior): any;
export declare class HorizontalPodAutoscalerV2SpecBehaviorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecBehavior | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecBehavior | undefined);
    private _scaleDown;
    get scaleDown(): HorizontalPodAutoscalerV2SpecBehaviorScaleDownList;
    putScaleDown(value: HorizontalPodAutoscalerV2SpecBehaviorScaleDown[] | cdktf.IResolvable): void;
    resetScaleDown(): void;
    get scaleDownInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecBehaviorScaleDown[] | undefined;
    private _scaleUp;
    get scaleUp(): HorizontalPodAutoscalerV2SpecBehaviorScaleUpList;
    putScaleUp(value: HorizontalPodAutoscalerV2SpecBehaviorScaleUp[] | cdktf.IResolvable): void;
    resetScaleUp(): void;
    get scaleUpInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecBehaviorScaleUp[] | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricContainerResourceTarget {
    /**
    * averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#average_utilization HorizontalPodAutoscalerV2#average_utilization}
    */
    readonly averageUtilization?: number;
    /**
    * averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#average_value HorizontalPodAutoscalerV2#average_value}
    */
    readonly averageValue?: string;
    /**
    * type represents whether the metric type is Utilization, Value, or AverageValue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#type HorizontalPodAutoscalerV2#type}
    */
    readonly type: string;
    /**
    * value is the target value of the metric (as a quantity).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#value HorizontalPodAutoscalerV2#value}
    */
    readonly value?: string;
}
export declare function horizontalPodAutoscalerV2SpecMetricContainerResourceTargetToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricContainerResourceTargetOutputReference | HorizontalPodAutoscalerV2SpecMetricContainerResourceTarget): any;
export declare class HorizontalPodAutoscalerV2SpecMetricContainerResourceTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricContainerResourceTarget | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricContainerResourceTarget | undefined);
    private _averageUtilization?;
    get averageUtilization(): number;
    set averageUtilization(value: number);
    resetAverageUtilization(): void;
    get averageUtilizationInput(): number | undefined;
    private _averageValue?;
    get averageValue(): string;
    set averageValue(value: string);
    resetAverageValue(): void;
    get averageValueInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricContainerResource {
    /**
    * name of the container in the pods of the scaling target
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#container HorizontalPodAutoscalerV2#container}
    */
    readonly container: string;
    /**
    * name of the resource in question
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#name HorizontalPodAutoscalerV2#name}
    */
    readonly name: string;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#target HorizontalPodAutoscalerV2#target}
    */
    readonly target?: HorizontalPodAutoscalerV2SpecMetricContainerResourceTarget;
}
export declare function horizontalPodAutoscalerV2SpecMetricContainerResourceToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricContainerResourceOutputReference | HorizontalPodAutoscalerV2SpecMetricContainerResource): any;
export declare class HorizontalPodAutoscalerV2SpecMetricContainerResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricContainerResource | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricContainerResource | undefined);
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _target;
    get target(): HorizontalPodAutoscalerV2SpecMetricContainerResourceTargetOutputReference;
    putTarget(value: HorizontalPodAutoscalerV2SpecMetricContainerResourceTarget): void;
    resetTarget(): void;
    get targetInput(): HorizontalPodAutoscalerV2SpecMetricContainerResourceTarget | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#key HorizontalPodAutoscalerV2#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#operator HorizontalPodAutoscalerV2#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#values HorizontalPodAutoscalerV2#values}
    */
    readonly values?: string[];
}
export declare function horizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressionsToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressionsOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecMetricExternalMetricSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#match_labels HorizontalPodAutoscalerV2#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#match_expressions HorizontalPodAutoscalerV2#match_expressions}
    */
    readonly matchExpressions?: HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerV2SpecMetricExternalMetricSelectorToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricExternalMetricSelector | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricExternalMetricSelector | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricExternalMetricSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressionsList;
    putMatchExpressions(value: HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorMatchExpressions[] | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecMetricExternalMetricSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecMetricExternalMetric {
    /**
    * name is the name of the given metric
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#name HorizontalPodAutoscalerV2#name}
    */
    readonly name: string;
    /**
    * selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#selector HorizontalPodAutoscalerV2#selector}
    */
    readonly selector?: HorizontalPodAutoscalerV2SpecMetricExternalMetricSelector[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerV2SpecMetricExternalMetricToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricExternalMetricOutputReference | HorizontalPodAutoscalerV2SpecMetricExternalMetric): any;
export declare class HorizontalPodAutoscalerV2SpecMetricExternalMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricExternalMetric | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricExternalMetric | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _selector;
    get selector(): HorizontalPodAutoscalerV2SpecMetricExternalMetricSelectorList;
    putSelector(value: HorizontalPodAutoscalerV2SpecMetricExternalMetricSelector[] | cdktf.IResolvable): void;
    resetSelector(): void;
    get selectorInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecMetricExternalMetricSelector[] | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricExternalTarget {
    /**
    * averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#average_utilization HorizontalPodAutoscalerV2#average_utilization}
    */
    readonly averageUtilization?: number;
    /**
    * averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#average_value HorizontalPodAutoscalerV2#average_value}
    */
    readonly averageValue?: string;
    /**
    * type represents whether the metric type is Utilization, Value, or AverageValue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#type HorizontalPodAutoscalerV2#type}
    */
    readonly type: string;
    /**
    * value is the target value of the metric (as a quantity).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#value HorizontalPodAutoscalerV2#value}
    */
    readonly value?: string;
}
export declare function horizontalPodAutoscalerV2SpecMetricExternalTargetToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricExternalTargetOutputReference | HorizontalPodAutoscalerV2SpecMetricExternalTarget): any;
export declare class HorizontalPodAutoscalerV2SpecMetricExternalTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricExternalTarget | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricExternalTarget | undefined);
    private _averageUtilization?;
    get averageUtilization(): number;
    set averageUtilization(value: number);
    resetAverageUtilization(): void;
    get averageUtilizationInput(): number | undefined;
    private _averageValue?;
    get averageValue(): string;
    set averageValue(value: string);
    resetAverageValue(): void;
    get averageValueInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricExternal {
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#metric HorizontalPodAutoscalerV2#metric}
    */
    readonly metric: HorizontalPodAutoscalerV2SpecMetricExternalMetric;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#target HorizontalPodAutoscalerV2#target}
    */
    readonly target?: HorizontalPodAutoscalerV2SpecMetricExternalTarget;
}
export declare function horizontalPodAutoscalerV2SpecMetricExternalToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricExternalOutputReference | HorizontalPodAutoscalerV2SpecMetricExternal): any;
export declare class HorizontalPodAutoscalerV2SpecMetricExternalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricExternal | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricExternal | undefined);
    private _metric;
    get metric(): HorizontalPodAutoscalerV2SpecMetricExternalMetricOutputReference;
    putMetric(value: HorizontalPodAutoscalerV2SpecMetricExternalMetric): void;
    get metricInput(): HorizontalPodAutoscalerV2SpecMetricExternalMetric | undefined;
    private _target;
    get target(): HorizontalPodAutoscalerV2SpecMetricExternalTargetOutputReference;
    putTarget(value: HorizontalPodAutoscalerV2SpecMetricExternalTarget): void;
    resetTarget(): void;
    get targetInput(): HorizontalPodAutoscalerV2SpecMetricExternalTarget | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricObjectDescribedObject {
    /**
    * API version of the referent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#api_version HorizontalPodAutoscalerV2#api_version}
    */
    readonly apiVersion: string;
    /**
    * Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#kind HorizontalPodAutoscalerV2#kind}
    */
    readonly kind: string;
    /**
    * Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#name HorizontalPodAutoscalerV2#name}
    */
    readonly name: string;
}
export declare function horizontalPodAutoscalerV2SpecMetricObjectDescribedObjectToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricObjectDescribedObjectOutputReference | HorizontalPodAutoscalerV2SpecMetricObjectDescribedObject): any;
export declare class HorizontalPodAutoscalerV2SpecMetricObjectDescribedObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricObjectDescribedObject | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricObjectDescribedObject | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    get apiVersionInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#key HorizontalPodAutoscalerV2#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#operator HorizontalPodAutoscalerV2#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#values HorizontalPodAutoscalerV2#values}
    */
    readonly values?: string[];
}
export declare function horizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressionsToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressionsOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecMetricObjectMetricSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#match_labels HorizontalPodAutoscalerV2#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#match_expressions HorizontalPodAutoscalerV2#match_expressions}
    */
    readonly matchExpressions?: HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerV2SpecMetricObjectMetricSelectorToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricObjectMetricSelector | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricObjectMetricSelector | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricObjectMetricSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressionsList;
    putMatchExpressions(value: HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorMatchExpressions[] | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecMetricObjectMetricSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecMetricObjectMetric {
    /**
    * name is the name of the given metric
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#name HorizontalPodAutoscalerV2#name}
    */
    readonly name: string;
    /**
    * selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#selector HorizontalPodAutoscalerV2#selector}
    */
    readonly selector?: HorizontalPodAutoscalerV2SpecMetricObjectMetricSelector[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerV2SpecMetricObjectMetricToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricObjectMetricOutputReference | HorizontalPodAutoscalerV2SpecMetricObjectMetric): any;
export declare class HorizontalPodAutoscalerV2SpecMetricObjectMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricObjectMetric | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricObjectMetric | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _selector;
    get selector(): HorizontalPodAutoscalerV2SpecMetricObjectMetricSelectorList;
    putSelector(value: HorizontalPodAutoscalerV2SpecMetricObjectMetricSelector[] | cdktf.IResolvable): void;
    resetSelector(): void;
    get selectorInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecMetricObjectMetricSelector[] | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricObjectTarget {
    /**
    * averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#average_utilization HorizontalPodAutoscalerV2#average_utilization}
    */
    readonly averageUtilization?: number;
    /**
    * averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#average_value HorizontalPodAutoscalerV2#average_value}
    */
    readonly averageValue?: string;
    /**
    * type represents whether the metric type is Utilization, Value, or AverageValue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#type HorizontalPodAutoscalerV2#type}
    */
    readonly type: string;
    /**
    * value is the target value of the metric (as a quantity).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#value HorizontalPodAutoscalerV2#value}
    */
    readonly value?: string;
}
export declare function horizontalPodAutoscalerV2SpecMetricObjectTargetToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricObjectTargetOutputReference | HorizontalPodAutoscalerV2SpecMetricObjectTarget): any;
export declare class HorizontalPodAutoscalerV2SpecMetricObjectTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricObjectTarget | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricObjectTarget | undefined);
    private _averageUtilization?;
    get averageUtilization(): number;
    set averageUtilization(value: number);
    resetAverageUtilization(): void;
    get averageUtilizationInput(): number | undefined;
    private _averageValue?;
    get averageValue(): string;
    set averageValue(value: string);
    resetAverageValue(): void;
    get averageValueInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricObject {
    /**
    * described_object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#described_object HorizontalPodAutoscalerV2#described_object}
    */
    readonly describedObject: HorizontalPodAutoscalerV2SpecMetricObjectDescribedObject;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#metric HorizontalPodAutoscalerV2#metric}
    */
    readonly metric: HorizontalPodAutoscalerV2SpecMetricObjectMetric;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#target HorizontalPodAutoscalerV2#target}
    */
    readonly target?: HorizontalPodAutoscalerV2SpecMetricObjectTarget;
}
export declare function horizontalPodAutoscalerV2SpecMetricObjectToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricObjectOutputReference | HorizontalPodAutoscalerV2SpecMetricObject): any;
export declare class HorizontalPodAutoscalerV2SpecMetricObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricObject | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricObject | undefined);
    private _describedObject;
    get describedObject(): HorizontalPodAutoscalerV2SpecMetricObjectDescribedObjectOutputReference;
    putDescribedObject(value: HorizontalPodAutoscalerV2SpecMetricObjectDescribedObject): void;
    get describedObjectInput(): HorizontalPodAutoscalerV2SpecMetricObjectDescribedObject | undefined;
    private _metric;
    get metric(): HorizontalPodAutoscalerV2SpecMetricObjectMetricOutputReference;
    putMetric(value: HorizontalPodAutoscalerV2SpecMetricObjectMetric): void;
    get metricInput(): HorizontalPodAutoscalerV2SpecMetricObjectMetric | undefined;
    private _target;
    get target(): HorizontalPodAutoscalerV2SpecMetricObjectTargetOutputReference;
    putTarget(value: HorizontalPodAutoscalerV2SpecMetricObjectTarget): void;
    resetTarget(): void;
    get targetInput(): HorizontalPodAutoscalerV2SpecMetricObjectTarget | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#key HorizontalPodAutoscalerV2#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#operator HorizontalPodAutoscalerV2#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#values HorizontalPodAutoscalerV2#values}
    */
    readonly values?: string[];
}
export declare function horizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressionsToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressionsOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecMetricPodsMetricSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#match_labels HorizontalPodAutoscalerV2#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#match_expressions HorizontalPodAutoscalerV2#match_expressions}
    */
    readonly matchExpressions?: HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerV2SpecMetricPodsMetricSelectorToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricPodsMetricSelector | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricPodsMetricSelector | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricPodsMetricSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressionsList;
    putMatchExpressions(value: HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorMatchExpressions[] | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecMetricPodsMetricSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecMetricPodsMetric {
    /**
    * name is the name of the given metric
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#name HorizontalPodAutoscalerV2#name}
    */
    readonly name: string;
    /**
    * selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#selector HorizontalPodAutoscalerV2#selector}
    */
    readonly selector?: HorizontalPodAutoscalerV2SpecMetricPodsMetricSelector[] | cdktf.IResolvable;
}
export declare function horizontalPodAutoscalerV2SpecMetricPodsMetricToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricPodsMetricOutputReference | HorizontalPodAutoscalerV2SpecMetricPodsMetric): any;
export declare class HorizontalPodAutoscalerV2SpecMetricPodsMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricPodsMetric | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricPodsMetric | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _selector;
    get selector(): HorizontalPodAutoscalerV2SpecMetricPodsMetricSelectorList;
    putSelector(value: HorizontalPodAutoscalerV2SpecMetricPodsMetricSelector[] | cdktf.IResolvable): void;
    resetSelector(): void;
    get selectorInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecMetricPodsMetricSelector[] | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricPodsTarget {
    /**
    * averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#average_utilization HorizontalPodAutoscalerV2#average_utilization}
    */
    readonly averageUtilization?: number;
    /**
    * averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#average_value HorizontalPodAutoscalerV2#average_value}
    */
    readonly averageValue?: string;
    /**
    * type represents whether the metric type is Utilization, Value, or AverageValue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#type HorizontalPodAutoscalerV2#type}
    */
    readonly type: string;
    /**
    * value is the target value of the metric (as a quantity).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#value HorizontalPodAutoscalerV2#value}
    */
    readonly value?: string;
}
export declare function horizontalPodAutoscalerV2SpecMetricPodsTargetToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricPodsTargetOutputReference | HorizontalPodAutoscalerV2SpecMetricPodsTarget): any;
export declare class HorizontalPodAutoscalerV2SpecMetricPodsTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricPodsTarget | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricPodsTarget | undefined);
    private _averageUtilization?;
    get averageUtilization(): number;
    set averageUtilization(value: number);
    resetAverageUtilization(): void;
    get averageUtilizationInput(): number | undefined;
    private _averageValue?;
    get averageValue(): string;
    set averageValue(value: string);
    resetAverageValue(): void;
    get averageValueInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricPods {
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#metric HorizontalPodAutoscalerV2#metric}
    */
    readonly metric: HorizontalPodAutoscalerV2SpecMetricPodsMetric;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#target HorizontalPodAutoscalerV2#target}
    */
    readonly target?: HorizontalPodAutoscalerV2SpecMetricPodsTarget;
}
export declare function horizontalPodAutoscalerV2SpecMetricPodsToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricPodsOutputReference | HorizontalPodAutoscalerV2SpecMetricPods): any;
export declare class HorizontalPodAutoscalerV2SpecMetricPodsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricPods | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricPods | undefined);
    private _metric;
    get metric(): HorizontalPodAutoscalerV2SpecMetricPodsMetricOutputReference;
    putMetric(value: HorizontalPodAutoscalerV2SpecMetricPodsMetric): void;
    get metricInput(): HorizontalPodAutoscalerV2SpecMetricPodsMetric | undefined;
    private _target;
    get target(): HorizontalPodAutoscalerV2SpecMetricPodsTargetOutputReference;
    putTarget(value: HorizontalPodAutoscalerV2SpecMetricPodsTarget): void;
    resetTarget(): void;
    get targetInput(): HorizontalPodAutoscalerV2SpecMetricPodsTarget | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricResourceTarget {
    /**
    * averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#average_utilization HorizontalPodAutoscalerV2#average_utilization}
    */
    readonly averageUtilization?: number;
    /**
    * averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#average_value HorizontalPodAutoscalerV2#average_value}
    */
    readonly averageValue?: string;
    /**
    * type represents whether the metric type is Utilization, Value, or AverageValue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#type HorizontalPodAutoscalerV2#type}
    */
    readonly type: string;
    /**
    * value is the target value of the metric (as a quantity).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#value HorizontalPodAutoscalerV2#value}
    */
    readonly value?: string;
}
export declare function horizontalPodAutoscalerV2SpecMetricResourceTargetToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricResourceTargetOutputReference | HorizontalPodAutoscalerV2SpecMetricResourceTarget): any;
export declare class HorizontalPodAutoscalerV2SpecMetricResourceTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricResourceTarget | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricResourceTarget | undefined);
    private _averageUtilization?;
    get averageUtilization(): number;
    set averageUtilization(value: number);
    resetAverageUtilization(): void;
    get averageUtilizationInput(): number | undefined;
    private _averageValue?;
    get averageValue(): string;
    set averageValue(value: string);
    resetAverageValue(): void;
    get averageValueInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetricResource {
    /**
    * name is the name of the resource in question.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#name HorizontalPodAutoscalerV2#name}
    */
    readonly name: string;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#target HorizontalPodAutoscalerV2#target}
    */
    readonly target?: HorizontalPodAutoscalerV2SpecMetricResourceTarget;
}
export declare function horizontalPodAutoscalerV2SpecMetricResourceToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetricResourceOutputReference | HorizontalPodAutoscalerV2SpecMetricResource): any;
export declare class HorizontalPodAutoscalerV2SpecMetricResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetricResource | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetricResource | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _target;
    get target(): HorizontalPodAutoscalerV2SpecMetricResourceTargetOutputReference;
    putTarget(value: HorizontalPodAutoscalerV2SpecMetricResourceTarget): void;
    resetTarget(): void;
    get targetInput(): HorizontalPodAutoscalerV2SpecMetricResourceTarget | undefined;
}
export interface HorizontalPodAutoscalerV2SpecMetric {
    /**
    * type is the type of metric source. It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#type HorizontalPodAutoscalerV2#type}
    */
    readonly type: string;
    /**
    * container_resource block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#container_resource HorizontalPodAutoscalerV2#container_resource}
    */
    readonly containerResource?: HorizontalPodAutoscalerV2SpecMetricContainerResource;
    /**
    * external block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#external HorizontalPodAutoscalerV2#external}
    */
    readonly external?: HorizontalPodAutoscalerV2SpecMetricExternal;
    /**
    * object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#object HorizontalPodAutoscalerV2#object}
    */
    readonly object?: HorizontalPodAutoscalerV2SpecMetricObject;
    /**
    * pods block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#pods HorizontalPodAutoscalerV2#pods}
    */
    readonly pods?: HorizontalPodAutoscalerV2SpecMetricPods;
    /**
    * resource block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#resource HorizontalPodAutoscalerV2#resource}
    */
    readonly resource?: HorizontalPodAutoscalerV2SpecMetricResource;
}
export declare function horizontalPodAutoscalerV2SpecMetricToTerraform(struct?: HorizontalPodAutoscalerV2SpecMetric | cdktf.IResolvable): any;
export declare class HorizontalPodAutoscalerV2SpecMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HorizontalPodAutoscalerV2SpecMetric | cdktf.IResolvable | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecMetric | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _containerResource;
    get containerResource(): HorizontalPodAutoscalerV2SpecMetricContainerResourceOutputReference;
    putContainerResource(value: HorizontalPodAutoscalerV2SpecMetricContainerResource): void;
    resetContainerResource(): void;
    get containerResourceInput(): HorizontalPodAutoscalerV2SpecMetricContainerResource | undefined;
    private _external;
    get external(): HorizontalPodAutoscalerV2SpecMetricExternalOutputReference;
    putExternal(value: HorizontalPodAutoscalerV2SpecMetricExternal): void;
    resetExternal(): void;
    get externalInput(): HorizontalPodAutoscalerV2SpecMetricExternal | undefined;
    private _object;
    get object(): HorizontalPodAutoscalerV2SpecMetricObjectOutputReference;
    putObject(value: HorizontalPodAutoscalerV2SpecMetricObject): void;
    resetObject(): void;
    get objectInput(): HorizontalPodAutoscalerV2SpecMetricObject | undefined;
    private _pods;
    get pods(): HorizontalPodAutoscalerV2SpecMetricPodsOutputReference;
    putPods(value: HorizontalPodAutoscalerV2SpecMetricPods): void;
    resetPods(): void;
    get podsInput(): HorizontalPodAutoscalerV2SpecMetricPods | undefined;
    private _resource;
    get resource(): HorizontalPodAutoscalerV2SpecMetricResourceOutputReference;
    putResource(value: HorizontalPodAutoscalerV2SpecMetricResource): void;
    resetResource(): void;
    get resourceInput(): HorizontalPodAutoscalerV2SpecMetricResource | undefined;
}
export declare class HorizontalPodAutoscalerV2SpecMetricList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HorizontalPodAutoscalerV2SpecMetric[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HorizontalPodAutoscalerV2SpecMetricOutputReference;
}
export interface HorizontalPodAutoscalerV2SpecScaleTargetRef {
    /**
    * API version of the referent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#api_version HorizontalPodAutoscalerV2#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Kind of the referent. e.g. `ReplicationController`. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#kind HorizontalPodAutoscalerV2#kind}
    */
    readonly kind: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#name HorizontalPodAutoscalerV2#name}
    */
    readonly name: string;
}
export declare function horizontalPodAutoscalerV2SpecScaleTargetRefToTerraform(struct?: HorizontalPodAutoscalerV2SpecScaleTargetRefOutputReference | HorizontalPodAutoscalerV2SpecScaleTargetRef): any;
export declare class HorizontalPodAutoscalerV2SpecScaleTargetRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2SpecScaleTargetRef | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2SpecScaleTargetRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface HorizontalPodAutoscalerV2Spec {
    /**
    * Upper limit for the number of pods that can be set by the autoscaler.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#max_replicas HorizontalPodAutoscalerV2#max_replicas}
    */
    readonly maxReplicas: number;
    /**
    * Lower limit for the number of pods that can be set by the autoscaler, defaults to `1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#min_replicas HorizontalPodAutoscalerV2#min_replicas}
    */
    readonly minReplicas?: number;
    /**
    * Target average CPU utilization (represented as a percentage of requested CPU) over all the pods. If not specified the default autoscaling policy will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#target_cpu_utilization_percentage HorizontalPodAutoscalerV2#target_cpu_utilization_percentage}
    */
    readonly targetCpuUtilizationPercentage?: number;
    /**
    * behavior block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#behavior HorizontalPodAutoscalerV2#behavior}
    */
    readonly behavior?: HorizontalPodAutoscalerV2SpecBehavior;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#metric HorizontalPodAutoscalerV2#metric}
    */
    readonly metric?: HorizontalPodAutoscalerV2SpecMetric[] | cdktf.IResolvable;
    /**
    * scale_target_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2#scale_target_ref HorizontalPodAutoscalerV2#scale_target_ref}
    */
    readonly scaleTargetRef: HorizontalPodAutoscalerV2SpecScaleTargetRef;
}
export declare function horizontalPodAutoscalerV2SpecToTerraform(struct?: HorizontalPodAutoscalerV2SpecOutputReference | HorizontalPodAutoscalerV2Spec): any;
export declare class HorizontalPodAutoscalerV2SpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HorizontalPodAutoscalerV2Spec | undefined;
    set internalValue(value: HorizontalPodAutoscalerV2Spec | undefined);
    private _maxReplicas?;
    get maxReplicas(): number;
    set maxReplicas(value: number);
    get maxReplicasInput(): number | undefined;
    private _minReplicas?;
    get minReplicas(): number;
    set minReplicas(value: number);
    resetMinReplicas(): void;
    get minReplicasInput(): number | undefined;
    private _targetCpuUtilizationPercentage?;
    get targetCpuUtilizationPercentage(): number;
    set targetCpuUtilizationPercentage(value: number);
    resetTargetCpuUtilizationPercentage(): void;
    get targetCpuUtilizationPercentageInput(): number | undefined;
    private _behavior;
    get behavior(): HorizontalPodAutoscalerV2SpecBehaviorOutputReference;
    putBehavior(value: HorizontalPodAutoscalerV2SpecBehavior): void;
    resetBehavior(): void;
    get behaviorInput(): HorizontalPodAutoscalerV2SpecBehavior | undefined;
    private _metric;
    get metric(): HorizontalPodAutoscalerV2SpecMetricList;
    putMetric(value: HorizontalPodAutoscalerV2SpecMetric[] | cdktf.IResolvable): void;
    resetMetric(): void;
    get metricInput(): cdktf.IResolvable | HorizontalPodAutoscalerV2SpecMetric[] | undefined;
    private _scaleTargetRef;
    get scaleTargetRef(): HorizontalPodAutoscalerV2SpecScaleTargetRefOutputReference;
    putScaleTargetRef(value: HorizontalPodAutoscalerV2SpecScaleTargetRef): void;
    get scaleTargetRefInput(): HorizontalPodAutoscalerV2SpecScaleTargetRef | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2 kubernetes_horizontal_pod_autoscaler_v2}
*/
export declare class HorizontalPodAutoscalerV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_horizontal_pod_autoscaler_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/horizontal_pod_autoscaler_v2 kubernetes_horizontal_pod_autoscaler_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HorizontalPodAutoscalerV2Config
    */
    constructor(scope: Construct, id: string, config: HorizontalPodAutoscalerV2Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): HorizontalPodAutoscalerV2MetadataOutputReference;
    putMetadata(value: HorizontalPodAutoscalerV2Metadata): void;
    get metadataInput(): HorizontalPodAutoscalerV2Metadata | undefined;
    private _spec;
    get spec(): HorizontalPodAutoscalerV2SpecOutputReference;
    putSpec(value: HorizontalPodAutoscalerV2Spec): void;
    get specInput(): HorizontalPodAutoscalerV2Spec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
