import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesResourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource apiVersion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resource#api_version DataKubernetesResource#api_version}
    */
    readonly apiVersion: string;
    /**
    * The resource kind.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resource#kind DataKubernetesResource#kind}
    */
    readonly kind: string;
    /**
    * The response from the API server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resource#object DataKubernetesResource#object}
    */
    readonly object?: {
        [key: string]: any;
    };
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resource#metadata DataKubernetesResource#metadata}
    */
    readonly metadata: DataKubernetesResourceMetadata;
}
export interface DataKubernetesResourceMetadata {
    /**
    * The resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resource#name DataKubernetesResource#name}
    */
    readonly name: string;
    /**
    * The resource namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/resource#namespace DataKubernetesResource#namespace}
    */
    readonly namespace?: string;
}
export declare function dataKubernetesResourceMetadataToTerraform(struct?: DataKubernetesResourceMetadataOutputReference | DataKubernetesResourceMetadata): any;
export declare class DataKubernetesResourceMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesResourceMetadata | undefined;
    set internalValue(value: DataKubernetesResourceMetadata | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/resource kubernetes_resource}
*/
export declare class DataKubernetesResource extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_resource";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/resource kubernetes_resource} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesResourceConfig
    */
    constructor(scope: Construct, id: string, config: DataKubernetesResourceConfig);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    get apiVersionInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _object?;
    get object(): {
        [key: string]: any;
    };
    set object(value: {
        [key: string]: any;
    });
    resetObject(): void;
    get objectInput(): {
        [key: string]: any;
    } | undefined;
    private _metadata;
    get metadata(): DataKubernetesResourceMetadataOutputReference;
    putMetadata(value: DataKubernetesResourceMetadata): void;
    get metadataInput(): DataKubernetesResourceMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
