import { DaemonsetMetadata, DaemonsetMetadataOutputReference, DaemonsetSpec, DaemonsetSpecOutputReference, DaemonsetTimeouts, DaemonsetTimeoutsOutputReference } from './daemonset-structs';
export * from './daemonset-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DaemonsetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#id Daemonset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Wait for the rollout of the deployment to complete. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#wait_for_rollout Daemonset#wait_for_rollout}
    */
    readonly waitForRollout?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#metadata Daemonset#metadata}
    */
    readonly metadata: DaemonsetMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#spec Daemonset#spec}
    */
    readonly spec: DaemonsetSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset#timeouts Daemonset#timeouts}
    */
    readonly timeouts?: DaemonsetTimeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset kubernetes_daemonset}
*/
export declare class Daemonset extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_daemonset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/daemonset kubernetes_daemonset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DaemonsetConfig
    */
    constructor(scope: Construct, id: string, config: DaemonsetConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _waitForRollout?;
    get waitForRollout(): boolean | cdktf.IResolvable;
    set waitForRollout(value: boolean | cdktf.IResolvable);
    resetWaitForRollout(): void;
    get waitForRolloutInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): DaemonsetMetadataOutputReference;
    putMetadata(value: DaemonsetMetadata): void;
    get metadataInput(): DaemonsetMetadata | undefined;
    private _spec;
    get spec(): DaemonsetSpecOutputReference;
    putSpec(value: DaemonsetSpec): void;
    get specInput(): DaemonsetSpec | undefined;
    private _timeouts;
    get timeouts(): DaemonsetTimeoutsOutputReference;
    putTimeouts(value: DaemonsetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DaemonsetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
