import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ClusterRoleBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#id ClusterRoleBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#metadata ClusterRoleBinding#metadata}
    */
    readonly metadata: ClusterRoleBindingMetadata;
    /**
    * role_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#role_ref ClusterRoleBinding#role_ref}
    */
    readonly roleRef: ClusterRoleBindingRoleRef;
    /**
    * subject block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#subject ClusterRoleBinding#subject}
    */
    readonly subject: ClusterRoleBindingSubject[] | cdktf.IResolvable;
}
export interface ClusterRoleBindingMetadata {
    /**
    * An unstructured key value map stored with the clusterRoleBinding that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#annotations ClusterRoleBinding#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the clusterRoleBinding. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#labels ClusterRoleBinding#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the clusterRoleBinding, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#name ClusterRoleBinding#name}
    */
    readonly name?: string;
}
export declare function clusterRoleBindingMetadataToTerraform(struct?: ClusterRoleBindingMetadataOutputReference | ClusterRoleBindingMetadata): any;
export declare class ClusterRoleBindingMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterRoleBindingMetadata | undefined;
    set internalValue(value: ClusterRoleBindingMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface ClusterRoleBindingRoleRef {
    /**
    * The API group of the user. The only value possible at the moment is `rbac.authorization.k8s.io`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#api_group ClusterRoleBinding#api_group}
    */
    readonly apiGroup: string;
    /**
    * The kind of resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#kind ClusterRoleBinding#kind}
    */
    readonly kind: string;
    /**
    * The name of the User to bind to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#name ClusterRoleBinding#name}
    */
    readonly name: string;
}
export declare function clusterRoleBindingRoleRefToTerraform(struct?: ClusterRoleBindingRoleRefOutputReference | ClusterRoleBindingRoleRef): any;
export declare class ClusterRoleBindingRoleRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterRoleBindingRoleRef | undefined;
    set internalValue(value: ClusterRoleBindingRoleRef | undefined);
    private _apiGroup?;
    get apiGroup(): string;
    set apiGroup(value: string);
    get apiGroupInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface ClusterRoleBindingSubject {
    /**
    * The API group of the subject resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#api_group ClusterRoleBinding#api_group}
    */
    readonly apiGroup?: string;
    /**
    * The kind of resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#kind ClusterRoleBinding#kind}
    */
    readonly kind: string;
    /**
    * The name of the resource to bind to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#name ClusterRoleBinding#name}
    */
    readonly name: string;
    /**
    * The Namespace of the subject resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding#namespace ClusterRoleBinding#namespace}
    */
    readonly namespace?: string;
}
export declare function clusterRoleBindingSubjectToTerraform(struct?: ClusterRoleBindingSubject | cdktf.IResolvable): any;
export declare class ClusterRoleBindingSubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterRoleBindingSubject | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterRoleBindingSubject | cdktf.IResolvable | undefined);
    private _apiGroup?;
    get apiGroup(): string;
    set apiGroup(value: string);
    resetApiGroup(): void;
    get apiGroupInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export declare class ClusterRoleBindingSubjectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ClusterRoleBindingSubject[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterRoleBindingSubjectOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding kubernetes_cluster_role_binding}
*/
export declare class ClusterRoleBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_cluster_role_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding kubernetes_cluster_role_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ClusterRoleBindingConfig
    */
    constructor(scope: Construct, id: string, config: ClusterRoleBindingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): ClusterRoleBindingMetadataOutputReference;
    putMetadata(value: ClusterRoleBindingMetadata): void;
    get metadataInput(): ClusterRoleBindingMetadata | undefined;
    private _roleRef;
    get roleRef(): ClusterRoleBindingRoleRefOutputReference;
    putRoleRef(value: ClusterRoleBindingRoleRef): void;
    get roleRefInput(): ClusterRoleBindingRoleRef | undefined;
    private _subject;
    get subject(): ClusterRoleBindingSubjectList;
    putSubject(value: ClusterRoleBindingSubject[] | cdktf.IResolvable): void;
    get subjectInput(): cdktf.IResolvable | ClusterRoleBindingSubject[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
