from __future__ import annotations

from tcsoa.gen.Server import ServiceData
from tcsoa.utils import TcBaseObj
from dataclasses import dataclass


@dataclass
class ArchiveRestoreResponse(TcBaseObj):
    """
    Return structure for ArchiveRestore operation.
    
    :var reportFileName: Name of the report file generated by archive/restore operation under staging directory.
    :var reportFileTicket: The  report file FMS read ticket generated by the operation. The report file ticket will be
    empty when executed in background mode.
    :var progRecUid: Unique Identifier of the progress data record generated by the operation.
    :var serviceData: Holds any partial errors occurred during the operation.
    """
    reportFileName: str = ''
    reportFileTicket: str = ''
    progRecUid: str = ''
    serviceData: ServiceData = None


@dataclass
class GetReportTicketResponse(TcBaseObj):
    """
    Return structure for getReportFileTicket operation.
    
    :var ticket: The requested report file  FMS transient ticket.
    :var serviceData: Holds any partial errors occurred during the operation.
    """
    ticket: str = ''
    serviceData: ServiceData = None


@dataclass
class NamesAndValues(TcBaseObj):
    """
    The NamesAndValues structure represents a generic name-value pair.
    
    :var nameStr: The name of the session option.
    :var valueStr: The value of the session option.
    """
    nameStr: str = ''
    valueStr: str = ''
