from __future__ import annotations

from tcsoa.gen.BusinessObjects import GSIdentity
from typing import List
from tcsoa.gen.Server import ServiceData
from tcsoa.utils import TcBaseObj
from dataclasses import dataclass


@dataclass
class GetHashedUIDResponse(TcBaseObj):
    """
    The GetHashedUIDResponse structure defines the response from
    getHashedUID operation. It contains hashed uid generated by taking the hash key and site-id as input.
    
    :var hashedUID: The hashed uid  generated.
    :var serviceData: Service data contains the list of created or modified objects and also the partial errors.
    """
    hashedUID: str = ''
    serviceData: ServiceData = None


@dataclass
class TIEGSIdentityInput(TcBaseObj):
    """
    The GS identity input structure contains the fields required to create a GS identity object.
    
    :var system: Attribute system of class system GSIdentity.This is the site id of source system.
    :var label: Attribute label of class GSIdentity
    :var subLabel: Attribute subLabel of of class GSIdentity
    :var className: Attribute className of class GSIdentity.This is the className of the Teamcenter BusinessObject for
    which GSId is being created.
    :var splitToken: Attribute split_token of class GSIdentity
    :var context: Attribute context of class GSIdentity
    :var objectUid: Attribute object_uid of class GSIdentity.This is 14 digit unique identifier.
    :var factorId: Attribute factor_id of class GSIdentity
    :var atomic: Attribute atomic of class GSIdentity
    """
    system: str = ''
    label: str = ''
    subLabel: str = ''
    className: str = ''
    splitToken: str = ''
    context: str = ''
    objectUid: str = ''
    factorId: str = ''
    atomic: bool = False


@dataclass
class CreateGSIdentitiesResponse(TcBaseObj):
    """
    The CreateGSIdentitiesResponse structure defines the response from
    createGSIdentities operation.It contains vector of GS identity object
    references that were created.
    
    :var gsIdentities: A list of GS identity object references.
    :var serviceData: Service data contains the list of created or modified objects and also the partial errors.
    """
    gsIdentities: List[GSIdentity] = ()
    serviceData: ServiceData = None
