# Generated by Django 3.0.7 on 2020-10-06 07:43

from django.conf import settings
import django.contrib.sites.managers
import django.contrib.sites.models
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='BigBlueButtonGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, verbose_name='Group name')),
                ('site', models.ForeignKey(default=django.contrib.sites.models.SiteManager.get_current, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
            options={
                'permissions': [('add_servers', 'Can add servers to this group'), ('add_apitokens', 'Can add API tokens valid for this group'), ('add_meetings', 'Can add meetings on servers in this group')],
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('on_site', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='Meeting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, verbose_name='Meeting name')),
                ('welcome_message', models.TextField(blank=True, verbose_name='Welcome message')),
                ('moderator_message', models.TextField(blank=True, verbose_name='Welcome message for moderators')),
                ('conference_pin', models.CharField(blank=True, help_text='PIN for phone dial-in (if available)', max_length=10, null=True, unique=True, validators=[django.core.validators.RegexValidator('[0-9]*', 'The PIN must be numerical')], verbose_name='Conference PIN')),
                ('record', models.BooleanField(default=False, verbose_name='Record media and events')),
                ('auto_start_recording', models.BooleanField(default=False, verbose_name='Auto-start recording on first join')),
                ('allow_start_stop_recording', models.BooleanField(default=True, help_text='Allows users to manually start and stop recording. If recording is set to auto-start, this forces the whole meeting to be recorded. If auto-start is disabled, this causes the recording to be discarded.', verbose_name='Allow starting and stopping recording')),
                ('webcams_only_for_moderator', models.BooleanField(default=False, help_text='Webcam streams of participants are only visible for moderators, not for other participants.', verbose_name='Webcams only for moderators')),
                ('mute_on_start', models.BooleanField(default=False, help_text='Participants are muted when they join the meeting', verbose_name='Mute on start')),
                ('allow_mods_to_unmute_users', models.BooleanField(default=False, help_text='Allow moderators to unmute other users (this is a privacy risk)', verbose_name='Allow moderators to unmute')),
                ('enable_cam', models.BooleanField(default=True, verbose_name='Allow sharing webcam')),
                ('enable_mic', models.BooleanField(default=True, verbose_name='Allow sharing microphone')),
                ('enable_private_chat', models.BooleanField(default=True, verbose_name='Allow private chat')),
                ('enable_public_chat', models.BooleanField(default=True, verbose_name='Allow public chat')),
                ('enable_note', models.BooleanField(default=True, verbose_name='Allow editing shared notes')),
                ('max_participants', models.PositiveSmallIntegerField(null=True, verbose_name='Maximum number of participants')),
                ('duration', models.PositiveIntegerField(null=True, verbose_name='Maximum duration (in minutes)')),
                ('guid', models.UUIDField(default=uuid.uuid1, editable=False)),
                ('api_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='meetings', to='bigbluebutton.BigBlueButtonGroup')),
            ],
            options={
                'permissions': [('join_as_attendee', 'Can join this meeting with viewer role'), ('join_as_moderator', 'Can join this meeting with moderator role'), ('grant_attendee', 'Can grant attendee privileges to others'), ('grant_moderator', 'Can grant moderator privileges to others'), ('enforce_conference_pin', 'Can enforce a static conference PIN'), ('add_urls', 'Can add new URLs for this meeting')],
            },
        ),
        migrations.CreateModel(
            name='BigBlueButton',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, verbose_name='Server name')),
                ('url', models.URLField(verbose_name='API base URL')),
                ('salt', models.CharField(max_length=60, verbose_name='API shared secret')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='apis', to='bigbluebutton.BigBlueButtonGroup')),
            ],
        ),
        migrations.CreateModel(
            name='APIToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, unique=True, verbose_name='Descriptive name')),
                ('salt', models.CharField(max_length=60, unique=True, verbose_name='API salt')),
                ('scope', models.CharField(choices=[('token', 'Data associated to this token'), ('user', 'Data associated to the owning user'), ('global', 'All data')], default='token', max_length=15, verbose_name='Privilege scope')),
                ('guid', models.UUIDField(default=uuid.uuid1, editable=False)),
                ('server_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bigbluebutton.BigBlueButtonGroup')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User owning this token')),
            ],
        ),
    ]
