# Copyright 2018 D-Wave Systems Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.
#
# ================================================================================================
def distinguishable_color_map(num_colors):
    # Creates a matplotlib Colormap with num_colors visually distinct colors.
    try:
        from matplotlib.colors import LinearSegmentedColormap
    except ImportError:
        raise ImportError("Matplotlib required for distinguishable_color_map()")
    return LinearSegmentedColormap.from_list('dist_colors', distinguishable_colors[:min(num_colors, 1000)], num_colors)


# Colors originally generated using:
# https://www.mathworks.com/matlabcentral/fileexchange/29702-generate-maximally-perceptually-distinct-colors
distinguishable_colors = \
    [(0.000000, 0.000000, 1.000000),
     (0.000000, 1.000000, 0.000000),
     (1.000000, 0.000000, 0.000000),
     (1.000000, 0.000000, 0.689655),
     (1.000000, 0.827586, 0.034483),
     (0.000000, 0.517241, 0.965517),
     (0.000000, 0.551724, 0.275862),
     (0.689655, 0.413793, 0.241379),
     (0.344828, 0.034483, 0.379310),
     (0.000000, 0.551724, 0.655172),
     (1.000000, 0.689655, 1.000000),
     (0.000000, 1.000000, 0.931034),
     (0.758621, 1.000000, 0.482759),
     (0.689655, 0.344828, 0.965517),
     (0.793103, 0.000000, 0.275862),
     (0.517241, 0.551724, 0.000000),
     (0.551724, 0.413793, 0.517241),
     (0.172414, 0.241379, 0.000000),
     (1.000000, 0.517241, 0.000000),
     (0.344828, 0.000000, 0.103448),
     (1.000000, 0.862069, 0.551724),
     (0.000000, 0.000000, 0.586207),
     (0.551724, 0.620690, 0.482759),
     (0.000000, 1.000000, 0.620690),
     (0.103448, 0.689655, 0.000000),
     (1.000000, 0.551724, 0.620690),
     (0.000000, 0.241379, 0.448276),
     (0.620690, 0.758621, 1.000000),
     (1.000000, 0.000000, 1.000000),
     (0.862069, 1.000000, 0.000000),
     (0.758621, 1.000000, 0.793103),
     (0.655172, 0.137931, 0.000000),
     (0.758621, 0.310345, 0.586207),
     (0.068966, 0.310345, 0.275862),
     (0.551724, 0.379310, 0.758621),
     (0.000000, 0.379310, 1.000000),
     (0.413793, 0.896552, 1.000000),
     (0.344828, 0.241379, 0.172414),
     (0.655172, 0.000000, 0.620690),
     (0.862069, 0.689655, 0.655172),
     (0.827586, 0.586207, 0.172414),
     (0.103448, 0.000000, 0.172414),
     (0.206897, 0.689655, 0.586207),
     (1.000000, 0.448276, 0.344828),
     (0.000000, 0.172414, 0.551724),
     (1.000000, 0.482759, 0.965517),
     (0.655172, 0.068966, 1.000000),
     (0.586207, 0.758621, 0.413793),
     (0.551724, 0.965517, 0.206897),
     (0.655172, 0.310345, 0.344828),
     (0.586207, 0.758621, 0.000000),
     (0.000000, 0.517241, 0.793103),
     (0.413793, 0.310345, 0.000000),
     (0.413793, 0.137931, 0.000000),
     (0.620690, 0.724138, 0.758621),
     (1.000000, 0.827586, 0.965517),
     (0.965517, 0.241379, 0.551724),
     (1.000000, 0.965517, 0.448276),
     (0.241379, 0.172414, 0.896552),
     (0.000000, 0.965517, 0.379310),
     (1.000000, 0.689655, 0.517241),
     (0.344828, 0.827586, 0.551724),
     (0.275862, 0.551724, 0.034483),
     (0.241379, 0.206897, 0.275862),
     (0.379310, 0.482759, 0.206897),
     (1.000000, 0.000000, 0.241379),
     (0.482759, 0.172414, 0.344828),
     (0.655172, 0.551724, 0.275862),
     (0.620690, 0.620690, 1.000000),
     (0.413793, 0.137931, 0.620690),
     (0.034483, 0.344828, 0.000000),
     (0.758621, 0.379310, 0.034483),
     (0.862069, 0.862069, 0.689655),
     (0.413793, 0.448276, 0.448276),
     (0.413793, 0.413793, 0.655172),
     (0.034483, 0.758621, 1.000000),
     (0.931034, 1.000000, 0.655172),
     (0.655172, 0.000000, 0.344828),
     (0.965517, 0.344828, 0.103448),
     (0.827586, 0.551724, 0.724138),
     (0.000000, 0.137931, 0.034483),
     (0.241379, 0.482759, 0.344828),
     (0.724138, 1.000000, 0.965517),
     (0.000000, 0.758621, 0.344828),
     (0.103448, 0.344828, 0.448276),
     (0.551724, 0.000000, 0.103448),
     (0.517241, 0.482759, 1.000000),
     (0.586207, 0.448276, 0.379310),
     (0.758621, 0.724138, 0.068966),
     (0.448276, 0.551724, 0.689655),
     (0.896552, 0.000000, 0.793103),
     (0.068966, 0.000000, 0.310345),
     (0.172414, 0.000000, 0.068966),
     (1.000000, 0.689655, 0.068966),
     (0.068966, 0.344828, 0.689655),
     (0.482759, 0.034483, 0.758621),
     (1.000000, 0.379310, 0.758621),
     (0.344828, 0.379310, 0.241379),
     (1.000000, 0.586207, 0.310345),
     (0.862069, 0.344828, 0.379310),
     (0.344828, 0.206897, 0.413793),
     (0.482759, 0.965517, 0.482759),
     (0.793103, 0.551724, 1.000000),
     (0.758621, 0.758621, 0.344828),
     (0.758621, 0.000000, 0.517241),
     (0.758621, 0.655172, 0.896552),
     (0.965517, 0.793103, 0.310345),
     (0.586207, 0.344828, 0.586207),
     (0.000000, 0.724138, 0.758621),
     (0.000000, 0.172414, 0.206897),
     (0.655172, 1.000000, 0.655172),
     (0.000000, 0.344828, 0.827586),
     (0.482759, 0.793103, 0.275862),
     (0.000000, 0.310345, 0.137931),
     (0.000000, 0.965517, 0.758621),
     (0.344828, 0.586207, 0.551724),
     (0.931034, 0.931034, 0.206897),
     (0.241379, 0.068966, 0.000000),
     (0.758621, 0.344828, 0.758621),
     (0.586207, 0.793103, 0.689655),
     (0.758621, 0.103448, 0.896552),
     (0.896552, 0.517241, 0.448276),
     (0.793103, 0.517241, 0.551724),
     (1.000000, 0.517241, 0.758621),
     (0.448276, 0.896552, 0.758621),
     (0.551724, 0.034483, 0.413793),
     (0.724138, 0.620690, 0.724138),
     (0.448276, 0.689655, 0.482759),
     (0.275862, 0.000000, 0.206897),
     (0.310345, 0.241379, 0.793103),
     (0.620690, 0.413793, 0.068966),
     (0.448276, 0.241379, 0.275862),
     (0.827586, 0.034483, 0.068966),
     (0.793103, 0.896552, 1.000000),
     (1.000000, 0.000000, 0.413793),
     (0.827586, 0.689655, 0.517241),
     (0.827586, 0.310345, 0.482759),
     (0.758621, 0.517241, 0.827586),
     (0.137931, 0.862069, 0.068966),
     (0.689655, 0.275862, 0.206897),
     (0.103448, 0.000000, 0.448276),
     (0.172414, 0.137931, 0.000000),
     (0.758621, 0.965517, 0.275862),
     (0.931034, 0.379310, 1.000000),
     (0.448276, 0.724138, 0.862069),
     (0.344828, 0.689655, 0.310345),
     (0.379310, 0.655172, 1.000000),
     (0.517241, 0.275862, 0.206897),
     (0.413793, 0.413793, 0.000000),
     (0.034483, 0.103448, 0.206897),
     (0.344828, 0.275862, 0.586207),
     (1.000000, 0.689655, 0.758621),
     (0.620690, 0.655172, 0.379310),
     (0.310345, 0.172414, 0.000000),
     (0.551724, 0.103448, 0.241379),
     (0.862069, 0.241379, 0.241379),
     (0.724138, 0.379310, 0.517241),
     (0.620690, 0.517241, 0.068966),
     (0.586207, 0.241379, 0.000000),
     (0.620690, 0.586207, 0.551724),
     (0.206897, 0.241379, 0.206897),
     (0.137931, 0.137931, 0.379310),
     (0.344828, 0.344828, 0.482759),
     (0.586207, 0.724138, 0.241379),
     (1.000000, 0.724138, 0.413793),
     (0.551724, 0.206897, 0.586207),
     (0.482759, 0.379310, 0.206897),
     (0.448276, 0.793103, 0.034483),
     (0.931034, 0.517241, 0.862069),
     (0.068966, 0.931034, 0.965517),
     (0.551724, 0.275862, 1.000000),
     (0.862069, 0.793103, 0.827586),
     (1.000000, 0.862069, 0.758621),
     (0.689655, 0.827586, 0.586207),
     (0.896552, 1.000000, 0.896552),
     (0.586207, 0.310345, 0.793103),
     (1.000000, 0.310345, 0.413793),
     (0.000000, 0.448276, 0.448276),
     (0.758621, 0.758621, 0.689655),
     (0.310345, 0.448276, 0.000000),
     (0.793103, 0.862069, 0.275862),
     (0.827586, 0.413793, 0.241379),
     (0.827586, 0.689655, 0.344828),
     (0.862069, 0.206897, 0.724138),
     (0.517241, 0.586207, 0.827586),
     (0.413793, 0.448276, 0.827586),
     (0.344828, 0.862069, 0.275862),
     (0.620690, 0.172414, 0.758621),
     (0.000000, 0.379310, 0.586207),
     (0.482759, 0.137931, 0.137931),
     (0.482759, 0.827586, 0.827586),
     (0.827586, 0.586207, 0.344828),
     (0.758621, 0.620690, 0.000000),
     (0.413793, 0.137931, 1.000000),
     (0.620690, 0.482759, 0.689655),
     (0.793103, 0.896552, 0.448276),
     (0.241379, 0.137931, 0.137931),
     (0.758621, 0.517241, 0.413793),
     (0.172414, 0.448276, 0.206897),
     (0.482759, 0.379310, 1.000000),
     (0.793103, 0.413793, 0.931034),
     (0.344828, 0.344828, 0.103448),
     (0.310345, 0.137931, 0.241379),
     (0.517241, 1.000000, 0.758621),
     (0.862069, 0.517241, 0.000000),
     (0.344828, 0.275862, 0.689655),
     (0.517241, 0.517241, 0.310345),
     (0.000000, 0.793103, 0.620690),
     (0.482759, 0.275862, 0.068966),
     (0.000000, 0.586207, 0.413793),
     (0.448276, 0.344828, 0.344828),
     (0.103448, 0.620690, 0.137931),
     (0.689655, 0.724138, 0.862069),
     (0.206897, 0.034483, 0.275862),
     (0.448276, 1.000000, 0.000000),
     (0.310345, 0.551724, 0.206897),
     (0.344828, 0.655172, 0.896552),
     (0.482759, 0.586207, 0.206897),
     (1.000000, 0.310345, 0.241379),
     (0.275862, 0.137931, 0.482759),
     (0.689655, 0.965517, 0.000000),
     (0.827586, 0.827586, 0.517241),
     (0.310345, 0.482759, 0.551724),
     (0.000000, 0.482759, 0.103448),
     (0.827586, 0.310345, 0.137931),
     (1.000000, 0.482759, 0.206897),
     (0.517241, 0.103448, 0.000000),
     (1.000000, 0.655172, 0.620690),
     (0.000000, 0.724138, 0.862069),
     (1.000000, 1.000000, 0.758621),
     (1.000000, 1.000000, 0.000000),
     (0.448276, 1.000000, 0.655172),
     (0.586207, 0.862069, 0.448276),
     (0.103448, 0.137931, 0.620690),
     (0.448276, 0.275862, 0.413793),
     (1.000000, 0.000000, 0.586207),
     (1.000000, 0.413793, 0.551724),
     (0.413793, 0.655172, 0.000000),
     (0.206897, 0.137931, 0.275862),
     (0.689655, 0.172414, 0.586207),
     (0.000000, 0.827586, 0.758621),
     (0.551724, 0.862069, 0.620690),
     (0.000000, 0.689655, 0.379310),
     (0.310345, 0.448276, 0.379310),
     (0.689655, 0.000000, 0.103448),
     (0.793103, 0.482759, 0.206897),
     (0.482759, 0.172414, 0.448276),
     (0.206897, 0.482759, 0.827586),
     (0.724138, 0.862069, 0.827586),
     (0.655172, 0.517241, 0.551724),
     (0.620690, 1.000000, 0.413793),
     (0.413793, 0.000000, 0.206897),
     (0.689655, 0.206897, 0.275862),
     (0.000000, 0.000000, 0.241379),
     (0.655172, 0.586207, 0.448276),
     (0.172414, 0.275862, 0.137931),
     (0.000000, 0.000000, 0.862069),
     (0.103448, 0.000000, 0.103448),
     (0.241379, 0.344828, 0.000000),
     (0.241379, 0.310345, 0.344828),
     (0.827586, 0.413793, 0.482759),
     (0.241379, 0.034483, 0.724138),
     (0.827586, 0.655172, 1.000000),
     (0.517241, 1.000000, 0.965517),
     (1.000000, 0.724138, 0.931034),
     (0.172414, 0.310345, 1.000000),
     (0.137931, 0.896552, 0.413793),
     (0.275862, 0.241379, 0.068966),
     (0.413793, 0.689655, 0.724138),
     (0.137931, 0.862069, 0.517241),
     (0.586207, 0.482759, 0.793103),
     (0.172414, 0.517241, 0.689655),
     (0.793103, 0.206897, 0.793103),
     (0.827586, 0.793103, 1.000000),
     (0.586207, 0.379310, 0.413793),
     (0.103448, 1.000000, 0.275862),
     (1.000000, 0.793103, 0.586207),
     (0.068966, 0.551724, 0.482759),
     (0.827586, 0.000000, 0.379310),
     (0.241379, 0.379310, 0.172414),
     (0.413793, 0.000000, 0.482759),
     (0.241379, 0.482759, 1.000000),
     (0.482759, 0.000000, 0.862069),
     (0.689655, 0.379310, 0.310345),
     (1.000000, 0.655172, 0.241379),
     (0.758621, 0.862069, 0.000000),
     (0.482759, 0.482759, 0.379310),
     (1.000000, 0.620690, 0.793103),
     (0.931034, 0.551724, 0.379310),
     (0.034483, 0.206897, 0.310345),
     (1.000000, 0.241379, 0.965517),
     (0.724138, 0.379310, 0.689655),
     (0.620690, 0.206897, 0.379310),
     (1.000000, 0.344828, 0.896552),
     (0.448276, 1.000000, 0.344828),
     (0.827586, 0.000000, 1.000000),
     (0.620690, 0.862069, 0.931034),
     (0.655172, 0.620690, 0.241379),
     (0.137931, 0.137931, 0.137931),
     (0.275862, 0.689655, 0.448276),
     (1.000000, 0.896552, 0.275862),
     (0.344828, 0.000000, 0.620690),
     (0.379310, 0.172414, 0.137931),
     (0.482759, 0.586207, 0.620690),
     (0.000000, 0.103448, 0.068966),
     (1.000000, 0.758621, 0.655172),
     (0.965517, 0.379310, 0.655172),
     (0.482759, 0.241379, 0.862069),
     (0.034483, 0.103448, 0.275862),
     (0.724138, 0.931034, 0.620690),
     (0.482759, 0.551724, 1.000000),
     (0.896552, 1.000000, 0.448276),
     (0.620690, 0.689655, 0.068966),
     (0.517241, 0.517241, 0.206897),
     (1.000000, 0.793103, 0.827586),
     (0.000000, 0.206897, 0.827586),
     (0.655172, 0.448276, 1.000000),
     (0.379310, 0.551724, 0.344828),
     (0.413793, 0.000000, 0.310345),
     (0.379310, 0.344828, 0.275862),
     (0.000000, 0.206897, 0.517241),
     (0.137931, 0.068966, 0.000000),
     (0.620690, 0.689655, 1.000000),
     (0.931034, 0.862069, 0.448276),
     (0.965517, 0.000000, 0.310345),
     (0.793103, 1.000000, 0.586207),
     (0.275862, 0.275862, 0.482759),
     (0.793103, 0.000000, 0.448276),
     (0.344828, 0.000000, 0.000000),
     (0.000000, 0.206897, 0.000000),
     (0.724138, 0.724138, 0.551724),
     (0.551724, 0.517241, 0.620690),
     (0.655172, 0.862069, 0.310345),
     (0.344828, 0.482759, 0.689655),
     (0.724138, 0.448276, 0.000000),
     (0.620690, 0.827586, 1.000000),
     (0.620690, 0.448276, 0.241379),
     (0.517241, 0.413793, 0.034483),
     (0.586207, 0.275862, 0.137931),
     (0.827586, 0.448276, 0.689655),
     (0.896552, 0.896552, 0.827586),
     (0.379310, 0.827586, 0.448276),
     (0.551724, 0.275862, 0.379310),
     (0.620690, 0.517241, 0.931034),
     (0.896552, 0.724138, 0.068966),
     (0.758621, 0.689655, 0.206897),
     (0.000000, 0.379310, 0.275862),
     (1.000000, 0.482759, 0.482759),
     (1.000000, 0.896552, 0.689655),
     (0.413793, 0.206897, 0.517241),
     (0.758621, 0.689655, 0.413793),
     (0.448276, 0.758621, 0.448276),
     (0.482759, 0.172414, 0.241379),
     (0.448276, 0.344828, 0.862069),
     (0.517241, 0.000000, 0.310345),
     (0.379310, 0.310345, 0.379310),
     (0.862069, 0.827586, 0.310345),
     (0.827586, 0.241379, 0.379310),
     (0.310345, 0.103448, 0.137931),
     (0.896552, 0.482759, 0.620690),
     (0.724138, 0.275862, 1.000000),
     (0.448276, 0.655172, 0.241379),
     (0.206897, 0.241379, 0.379310),
     (0.862069, 0.379310, 0.724138),
     (0.137931, 0.379310, 0.655172),
     (0.068966, 0.344828, 0.379310),
     (0.620690, 0.931034, 0.827586),
     (0.586207, 0.689655, 0.620690),
     (0.931034, 0.206897, 0.620690),
     (0.310345, 0.689655, 0.655172),
     (0.448276, 0.586207, 0.000000),
     (0.655172, 1.000000, 0.551724),
     (0.172414, 0.000000, 0.137931),
     (0.620690, 0.206897, 0.689655),
     (0.620690, 0.275862, 0.482759),
     (0.931034, 0.551724, 1.000000),
     (0.862069, 0.379310, 0.310345),
     (1.000000, 0.206897, 0.137931),
     (0.862069, 1.000000, 1.000000),
     (0.448276, 0.517241, 0.827586),
     (0.896552, 0.689655, 0.793103),
     (1.000000, 0.275862, 0.482759),
     (0.103448, 0.172414, 0.000000),
     (0.551724, 0.000000, 0.517241),
     (0.379310, 0.827586, 1.000000),
     (0.310345, 0.241379, 0.241379),
     (0.689655, 0.034483, 0.275862),
     (0.758621, 0.172414, 0.241379),
     (0.620690, 0.586207, 0.758621),
     (0.655172, 0.413793, 0.586207),
     (0.931034, 0.896552, 1.000000),
     (0.862069, 0.000000, 0.206897),
     (0.896552, 1.000000, 0.275862),
     (0.275862, 0.000000, 0.137931),
     (0.862069, 0.379310, 0.000000),
     (0.000000, 0.620690, 0.793103),
     (0.000000, 0.758621, 0.241379),
     (0.862069, 0.620690, 0.034483),
     (0.000000, 0.689655, 1.000000),
     (0.482759, 0.344828, 0.620690),
     (0.758621, 0.206897, 0.482759),
     (0.448276, 0.655172, 0.551724),
     (0.379310, 0.758621, 0.586207),
     (0.724138, 0.551724, 0.206897),
     (0.379310, 0.620690, 0.344828),
     (0.482759, 0.379310, 0.551724),
     (0.724138, 0.586207, 0.517241),
     (0.000000, 0.586207, 0.620690),
     (0.103448, 0.241379, 0.689655),
     (0.862069, 0.620690, 0.862069),
     (0.862069, 0.965517, 0.758621),
     (0.620690, 0.241379, 0.551724),
     (0.000000, 0.103448, 0.413793),
     (0.689655, 0.655172, 0.689655),
     (0.034483, 0.206897, 0.172414),
     (0.275862, 0.413793, 0.551724),
     (0.620690, 0.862069, 0.000000),
     (0.724138, 0.517241, 0.620690),
     (0.827586, 0.206897, 0.000000),
     (0.413793, 0.275862, 0.137931),
     (0.482759, 0.241379, 0.655172),
     (0.206897, 0.379310, 0.793103),
     (0.275862, 0.793103, 0.034483),
     (0.551724, 0.310345, 0.000000),
     (0.275862, 0.344828, 0.275862),
     (0.448276, 0.551724, 0.482759),
     (0.965517, 1.000000, 0.551724),
     (1.000000, 0.413793, 0.241379),
     (0.275862, 0.000000, 0.448276),
     (0.586207, 0.724138, 0.551724),
     (0.241379, 0.241379, 0.137931),
     (0.275862, 0.655172, 0.034483),
     (0.344828, 0.827586, 0.344828),
     (0.758621, 0.448276, 0.827586),
     (0.034483, 0.448276, 0.517241),
     (0.344828, 0.103448, 0.344828),
     (0.000000, 0.275862, 0.172414),
     (1.000000, 0.172414, 0.793103),
     (0.413793, 0.413793, 0.482759),
     (0.586207, 0.965517, 1.000000),
     (1.000000, 0.965517, 0.827586),
     (0.103448, 0.275862, 0.000000),
     (0.206897, 0.931034, 0.793103),
     (0.344828, 0.379310, 0.689655),
     (0.862069, 0.000000, 0.620690),
     (1.000000, 0.896552, 0.896552),
     (0.517241, 0.000000, 0.586207),
     (0.413793, 0.827586, 0.758621),
     (1.000000, 0.275862, 0.758621),
     (1.000000, 0.275862, 0.310345),
     (0.896552, 0.275862, 1.000000),
     (0.965517, 0.793103, 0.413793),
     (0.413793, 0.413793, 0.862069),
     (0.172414, 0.275862, 0.655172),
     (0.000000, 0.206897, 1.000000),
     (0.896552, 0.827586, 0.000000),
     (1.000000, 0.275862, 0.000000),
     (0.758621, 0.862069, 0.517241),
     (0.724138, 0.551724, 0.379310),
     (0.689655, 0.448276, 0.413793),
     (0.758621, 0.896552, 0.758621),
     (0.000000, 0.275862, 0.551724),
     (0.482759, 0.482759, 0.655172),
     (0.758621, 0.000000, 0.793103),
     (0.000000, 0.448276, 0.275862),
     (0.862069, 0.344828, 0.827586),
     (0.620690, 1.000000, 0.827586),
     (0.965517, 0.379310, 0.379310),
     (0.793103, 0.413793, 0.310345),
     (0.517241, 0.655172, 0.758621),
     (1.000000, 0.655172, 0.413793),
     (0.310345, 0.620690, 0.482759),
     (0.896552, 0.482759, 0.137931),
     (0.793103, 0.620690, 0.655172),
     (0.448276, 0.034483, 0.034483),
     (1.000000, 0.413793, 0.000000),
     (0.241379, 0.137931, 0.068966),
     (0.620690, 0.862069, 0.689655),
     (0.517241, 0.448276, 0.206897),
     (0.862069, 0.724138, 0.896552),
     (0.620690, 0.689655, 0.310345),
     (0.379310, 0.482759, 0.344828),
     (0.965517, 0.724138, 0.310345),
     (0.965517, 0.931034, 0.586207),
     (0.931034, 0.620690, 1.000000),
     (0.275862, 0.413793, 0.413793),
     (0.586207, 0.379310, 0.275862),
     (0.896552, 0.620690, 0.517241),
     (0.310345, 0.413793, 0.965517),
     (0.206897, 0.103448, 0.172414),
     (0.724138, 0.206897, 0.172414),
     (0.862069, 0.793103, 0.551724),
     (0.000000, 0.034483, 0.103448),
     (0.689655, 0.413793, 0.862069),
     (0.758621, 0.344828, 0.344828),
     (0.482759, 0.310345, 0.275862),
     (0.000000, 0.620690, 0.241379),
     (0.103448, 0.310345, 0.862069),
     (0.517241, 0.655172, 0.379310),
     (0.724138, 0.310345, 0.103448),
     (0.586207, 0.896552, 0.275862),
     (0.827586, 0.586207, 0.551724),
     (0.206897, 0.000000, 0.000000),
     (0.620690, 0.206897, 0.862069),
     (0.241379, 0.551724, 0.344828),
     (0.448276, 1.000000, 0.896552),
     (0.827586, 0.379310, 0.586207),
     (0.068966, 0.862069, 0.620690),
     (0.827586, 0.241379, 0.655172),
     (0.827586, 0.724138, 0.620690),
     (0.344828, 0.586207, 0.689655),
     (0.758621, 0.275862, 0.896552),
     (0.482759, 0.241379, 0.448276),
     (0.275862, 0.172414, 0.448276),
     (0.379310, 0.241379, 0.724138),
     (0.482759, 0.068966, 0.448276),
     (0.724138, 0.275862, 0.379310),
     (0.896552, 0.724138, 1.000000),
     (0.413793, 1.000000, 0.448276),
     (0.241379, 0.137931, 0.551724),
     (0.620690, 0.241379, 0.241379),
     (0.758621, 0.793103, 0.034483),
     (0.206897, 0.448276, 0.068966),
     (0.931034, 0.586207, 0.620690),
     (0.620690, 0.000000, 0.862069),
     (0.482759, 0.000000, 0.137931),
     (1.000000, 0.931034, 0.068966),
     (0.344828, 1.000000, 0.551724),
     (0.068966, 0.862069, 0.241379),
     (0.517241, 0.448276, 0.448276),
     (0.172414, 0.827586, 0.827586),
     (0.689655, 0.620690, 0.931034),
     (1.000000, 0.482759, 0.655172),
     (0.344828, 0.137931, 0.034483),
     (0.827586, 0.206897, 0.137931),
     (0.758621, 0.827586, 0.862069),
     (0.724138, 0.448276, 0.689655),
     (0.965517, 0.000000, 0.482759),
     (0.103448, 0.137931, 0.034483),
     (0.862069, 0.551724, 0.655172),
     (0.482759, 0.137931, 0.724138),
     (0.965517, 1.000000, 0.379310),
     (0.413793, 0.586207, 0.965517),
     (0.620690, 0.310345, 0.724138),
     (1.000000, 0.448276, 0.862069),
     (0.586207, 0.482759, 0.310345),
     (0.275862, 0.103448, 0.275862),
     (0.655172, 0.000000, 0.413793),
     (0.206897, 0.379310, 0.241379),
     (0.103448, 0.000000, 0.034483),
     (0.379310, 0.103448, 0.241379),
     (0.206897, 0.482759, 0.413793),
     (0.965517, 0.586207, 0.862069),
     (0.862069, 0.413793, 0.172414),
     (1.000000, 0.517241, 0.310345),
     (0.689655, 0.379310, 0.137931),
     (0.275862, 0.551724, 0.586207),
     (0.275862, 0.379310, 0.586207),
     (0.724138, 0.793103, 0.310345),
     (1.000000, 0.620690, 0.068966),
     (0.000000, 0.586207, 0.965517),
     (0.034483, 0.517241, 0.000000),
     (0.551724, 0.655172, 0.827586),
     (0.689655, 0.689655, 0.896552),
     (0.344828, 0.793103, 0.862069),
     (0.655172, 0.793103, 0.896552),
     (0.586207, 1.000000, 0.034483),
     (0.379310, 0.862069, 0.655172),
     (0.862069, 0.689655, 0.448276),
     (0.827586, 0.482759, 0.482759),
     (0.000000, 0.724138, 0.689655),
     (0.000000, 0.000000, 0.758621),
     (0.551724, 0.310345, 0.620690),
     (0.172414, 0.965517, 0.655172),
     (0.379310, 0.620690, 0.793103),
     (0.758621, 0.586207, 0.758621),
     (0.551724, 0.896552, 0.413793),
     (0.827586, 0.517241, 0.379310),
     (0.862069, 0.586207, 0.275862),
     (0.448276, 0.344828, 0.241379),
     (1.000000, 0.551724, 0.448276),
     (0.379310, 0.896552, 0.000000),
     (0.241379, 0.034483, 0.551724),
     (0.344828, 0.241379, 0.896552),
     (0.482759, 0.724138, 0.689655),
     (1.000000, 0.758621, 0.000000),
     (0.620690, 0.379310, 0.482759),
     (0.551724, 0.310345, 0.862069),
     (0.827586, 0.655172, 0.206897),
     (0.275862, 0.137931, 0.724138),
     (0.482759, 0.310345, 0.379310),
     (0.758621, 0.793103, 0.551724),
     (0.758621, 0.827586, 1.000000),
     (0.586207, 0.413793, 0.896552),
     (0.655172, 0.827586, 0.379310),
     (0.517241, 0.896552, 0.586207),
     (0.310345, 0.724138, 0.241379),
     (0.000000, 0.344828, 0.103448),
     (0.655172, 0.586207, 0.034483),
     (0.517241, 0.517241, 0.551724),
     (0.689655, 1.000000, 0.275862),
     (0.448276, 0.758621, 0.965517),
     (0.862069, 0.931034, 0.655172),
     (0.896552, 0.551724, 0.206897),
     (0.896552, 0.448276, 0.862069),
     (0.689655, 0.758621, 0.448276),
     (0.379310, 0.241379, 0.000000),
     (0.379310, 0.448276, 0.241379),
     (0.620690, 0.655172, 0.172414),
     (0.931034, 0.310345, 0.517241),
     (0.655172, 0.620690, 0.413793),
     (0.517241, 0.620690, 0.413793),
     (0.724138, 0.000000, 0.586207),
     (0.862069, 0.758621, 0.862069),
     (0.724138, 0.517241, 0.896552),
     (0.724138, 0.793103, 0.655172),
     (0.862069, 0.758621, 0.206897),
     (0.379310, 0.551724, 0.103448),
     (0.620690, 0.000000, 0.758621),
     (0.724138, 0.482759, 0.241379),
     (0.034483, 0.689655, 0.517241),
     (0.758621, 0.206897, 0.551724),
     (0.413793, 0.689655, 0.206897),
     (0.310345, 0.241379, 0.379310),
     (0.344828, 0.344828, 0.344828),
     (0.896552, 0.793103, 0.758621),
     (0.620690, 0.620690, 0.724138),
     (0.000000, 0.724138, 0.482759),
     (0.517241, 0.344828, 0.068966),
     (0.241379, 0.310345, 0.413793),
     (0.241379, 0.413793, 0.137931),
     (0.206897, 0.586207, 0.241379),
     (0.310345, 0.482759, 0.758621),
     (0.620690, 0.413793, 0.724138),
     (0.655172, 0.655172, 0.551724),
     (0.000000, 0.000000, 0.172414),
     (0.482759, 0.206897, 0.000000),
     (0.379310, 0.310345, 0.103448),
     (0.379310, 0.517241, 0.517241),
     (0.758621, 0.137931, 0.379310),
     (0.344828, 0.758621, 0.137931),
     (0.172414, 0.206897, 0.241379),
     (0.517241, 0.241379, 0.241379),
     (0.482759, 0.758621, 0.137931),
     (0.137931, 0.275862, 0.275862),
     (1.000000, 0.586207, 0.172414),
     (0.000000, 0.827586, 0.965517),
     (0.379310, 0.586207, 0.862069),
     (0.379310, 1.000000, 0.241379),
     (0.379310, 0.344828, 0.000000),
     (0.206897, 0.034483, 0.344828),
     (0.517241, 0.172414, 0.103448),
     (0.551724, 0.517241, 0.758621),
     (0.586207, 0.034483, 0.034483),
     (0.793103, 1.000000, 0.862069),
     (0.344828, 0.206897, 0.241379),
     (0.965517, 0.724138, 0.206897),
     (0.689655, 0.379310, 0.448276),
     (0.000000, 1.000000, 0.517241),
     (0.344828, 0.551724, 0.448276),
     (0.896552, 0.172414, 0.310345),
     (0.896552, 0.896552, 0.931034),
     (0.655172, 0.517241, 1.000000),
     (1.000000, 0.862069, 0.931034),
     (1.000000, 0.034483, 0.172414),
     (0.724138, 0.551724, 0.034483),
     (0.137931, 0.310345, 0.482759),
     (0.724138, 0.068966, 0.000000),
     (0.724138, 0.965517, 1.000000),
     (1.000000, 0.827586, 0.241379),
     (0.000000, 0.827586, 0.896552),
     (0.586207, 0.517241, 0.172414),
     (0.862069, 0.241379, 0.896552),
     (1.000000, 0.413793, 0.482759),
     (0.344828, 0.344828, 0.724138),
     (0.724138, 1.000000, 0.379310),
     (0.517241, 0.517241, 0.103448),
     (0.241379, 0.275862, 0.103448),
     (0.896552, 0.413793, 0.689655),
     (0.896552, 0.000000, 0.896552),
     (0.241379, 0.655172, 0.758621),
     (0.275862, 0.000000, 0.000000),
     (0.689655, 0.310345, 0.862069),
     (0.413793, 0.482759, 0.000000),
     (0.379310, 0.931034, 0.655172),
     (0.724138, 0.275862, 0.482759),
     (0.827586, 0.758621, 0.413793),
     (0.586207, 0.344828, 1.000000),
     (0.620690, 0.724138, 0.482759),
     (0.689655, 1.000000, 0.724138),
     (0.758621, 0.275862, 0.275862),
     (0.310345, 0.000000, 0.827586),
     (0.137931, 0.137931, 0.206897),
     (1.000000, 0.620690, 0.517241),
     (0.689655, 0.862069, 0.206897),
     (0.655172, 0.034483, 0.482759),
     (0.413793, 0.241379, 1.000000),
     (0.379310, 0.448276, 0.103448),
     (0.448276, 0.413793, 0.275862),
     (0.758621, 0.931034, 0.068966),
     (0.275862, 0.310345, 0.931034),
     (0.310345, 0.896552, 0.482759),
     (0.620690, 0.172414, 0.448276),
     (0.000000, 0.172414, 0.724138),
     (1.000000, 0.724138, 0.724138),
     (0.275862, 0.931034, 0.896552),
     (0.896552, 0.793103, 0.620690),
     (0.517241, 0.931034, 0.551724),
     (0.620690, 0.206897, 1.000000),
     (0.758621, 0.689655, 0.655172),
     (0.517241, 0.758621, 0.344828),
     (0.551724, 0.758621, 0.482759),
     (0.310345, 0.517241, 0.241379),
     (0.172414, 0.931034, 0.000000),
     (0.862069, 0.827586, 0.206897),
     (0.379310, 0.103448, 0.103448),
     (0.103448, 0.206897, 0.448276),
     (0.620690, 0.172414, 0.172414),
     (0.413793, 0.896552, 0.206897),
     (0.724138, 0.620690, 0.206897),
     (0.379310, 0.172414, 0.344828),
     (0.586207, 0.344828, 0.310345),
     (0.448276, 0.689655, 0.344828),
     (0.793103, 0.000000, 0.689655),
     (0.448276, 1.000000, 0.827586),
     (0.344828, 0.310345, 0.172414),
     (0.413793, 0.206897, 0.310345),
     (0.000000, 0.586207, 0.827586),
     (0.000000, 0.275862, 0.344828),
     (0.862069, 0.620690, 0.448276),
     (0.655172, 0.068966, 0.206897),
     (0.931034, 0.172414, 0.206897),
     (0.758621, 0.310345, 0.000000),
     (0.379310, 0.896552, 0.931034),
     (1.000000, 0.896552, 0.413793),
     (0.896552, 0.344828, 0.241379),
     (0.620690, 0.206897, 0.068966),
     (0.724138, 0.310345, 0.793103),
     (0.517241, 0.344828, 0.172414),
     (0.724138, 0.206897, 0.689655),
     (0.379310, 0.137931, 0.827586),
     (0.448276, 0.758621, 0.655172),
     (0.586207, 0.793103, 0.793103),
     (0.172414, 0.000000, 0.379310),
     (0.103448, 0.448276, 0.137931),
     (0.724138, 0.551724, 0.793103),
     (0.379310, 0.310345, 0.551724),
     (1.000000, 0.551724, 0.551724),
     (0.862069, 0.758621, 0.344828),
     (0.482759, 0.689655, 0.965517),
     (0.758621, 0.758621, 0.758621),
     (0.655172, 0.000000, 0.689655),
     (0.241379, 0.137931, 0.344828),
     (0.724138, 0.379310, 0.586207),
     (0.862069, 0.931034, 0.000000),
     (0.896552, 0.000000, 0.000000),
     (0.862069, 0.275862, 0.586207),
     (0.827586, 0.517241, 0.310345),
     (0.551724, 0.724138, 0.137931),
     (0.896552, 0.000000, 0.344828),
     (0.068966, 0.068966, 0.000000),
     (0.000000, 0.068966, 0.448276),
     (0.862069, 0.896552, 0.517241),
     (0.931034, 0.448276, 1.000000),
     (0.689655, 0.482759, 0.068966),
     (0.620690, 0.896552, 0.862069),
     (0.000000, 0.413793, 0.551724),
     (0.620690, 0.862069, 0.517241),
     (0.517241, 0.758621, 0.827586),
     (0.551724, 0.310345, 0.172414),
     (0.965517, 0.896552, 0.620690),
     (0.620690, 0.482759, 0.172414),
     (0.896552, 0.000000, 0.517241),
     (0.103448, 0.517241, 0.379310),
     (1.000000, 0.517241, 0.827586),
     (0.482759, 0.310345, 0.758621),
     (1.000000, 0.793103, 0.758621),
     (0.241379, 0.275862, 0.551724),
     (0.448276, 0.206897, 0.103448),
     (0.379310, 0.137931, 0.517241),
     (0.000000, 0.172414, 0.344828),
     (0.827586, 1.000000, 0.724138),
     (0.379310, 0.000000, 0.241379),
     (0.275862, 0.379310, 0.448276),
     (0.206897, 0.172414, 0.103448),
     (0.448276, 0.068966, 0.172414),
     (0.620690, 0.517241, 0.482759),
     (1.000000, 0.724138, 0.862069),
     (0.241379, 0.206897, 0.551724),
     (0.310345, 0.482759, 0.931034),
     (0.827586, 0.655172, 0.551724),
     (0.793103, 0.413793, 1.000000),
     (0.310345, 0.310345, 0.793103),
     (0.241379, 0.724138, 0.344828),
     (0.172414, 0.034483, 0.000000),
     (0.931034, 0.448276, 0.551724),
     (0.655172, 0.517241, 0.655172),
     (0.862069, 0.344828, 0.448276),
     (0.275862, 0.620690, 0.172414),
     (0.758621, 0.758621, 0.827586),
     (0.724138, 0.344828, 0.206897),
     (0.172414, 0.275862, 0.206897),
     (1.000000, 0.620690, 0.724138),
     (0.482759, 0.931034, 0.379310),
     (0.000000, 0.103448, 0.137931),
     (0.517241, 0.137931, 0.379310),
     (0.379310, 0.517241, 0.172414),
     (0.310345, 0.655172, 0.344828),
     (0.517241, 0.586207, 0.275862),
     (0.448276, 0.758621, 0.517241),
     (0.758621, 0.724138, 1.000000),
     (1.000000, 1.000000, 0.931034),
     (0.482759, 0.551724, 0.310345),
     (0.655172, 0.896552, 0.413793),
     (0.000000, 0.137931, 1.000000),
     (0.103448, 0.206897, 0.103448),
     (0.655172, 0.137931, 0.310345),
     (0.896552, 0.448276, 0.413793),
     (0.586207, 0.206897, 0.275862),
     (0.551724, 0.172414, 0.896552),
     (0.724138, 0.275862, 0.620690),
     (0.965517, 0.758621, 0.482759),
     (0.482759, 0.862069, 0.000000),
     (0.827586, 0.344828, 0.896552),
     (0.482759, 0.413793, 0.344828),
     (0.896552, 0.517241, 0.275862),
     (0.896552, 0.655172, 0.827586),
     (0.310345, 0.379310, 0.137931),
     (0.965517, 0.793103, 1.000000),
     (0.172414, 0.379310, 0.310345),
     (0.965517, 0.655172, 0.310345),
     (0.241379, 0.689655, 0.896552),
     (0.551724, 0.206897, 0.724138),
     (0.241379, 0.172414, 0.000000),
     (0.517241, 0.137931, 0.586207),
     (0.379310, 0.413793, 0.344828),
     (0.551724, 0.862069, 1.000000),
     (0.758621, 0.482759, 1.000000),
     (0.310345, 0.275862, 0.000000),
     (1.000000, 0.241379, 0.896552),
     (0.793103, 0.310345, 0.206897),
     (0.482759, 1.000000, 0.586207),
     (0.000000, 0.620690, 0.379310),
     (0.448276, 0.310345, 0.655172),
     (0.827586, 0.448276, 0.896552),
     (0.551724, 0.034483, 0.275862),
     (0.793103, 0.965517, 0.379310),
     (0.482759, 0.310345, 0.517241),
     (0.655172, 0.241379, 0.655172),
     (0.448276, 0.379310, 0.482759),
     (0.172414, 0.172414, 0.344828),
     (0.448276, 0.793103, 0.379310),
     (0.137931, 0.068966, 0.275862),
     (0.931034, 0.275862, 0.137931),
     (0.724138, 0.551724, 0.310345),
     (0.862069, 0.758621, 0.034483),
     (0.862069, 0.310345, 0.068966),
     (0.724138, 0.103448, 0.965517),
     (0.517241, 0.413793, 0.655172),
     (0.586207, 0.275862, 0.206897),
     (0.896552, 0.586207, 0.896552),
     (0.482759, 0.413793, 0.758621),
     (0.344828, 0.206897, 0.586207),
     (0.482759, 0.137931, 0.275862),
     (0.896552, 0.206897, 0.379310),
     (0.827586, 0.482759, 0.793103),
     (0.793103, 0.068966, 0.137931),
     (0.862069, 1.000000, 0.517241),
     (0.620690, 0.620690, 0.000000),
     (0.172414, 0.448276, 0.689655),
     (0.000000, 0.620690, 0.586207),
     (0.793103, 0.103448, 0.206897),
     (0.482759, 0.655172, 0.655172),
     (0.827586, 0.931034, 0.275862),
     (0.655172, 0.379310, 0.000000),
     (0.724138, 0.241379, 0.103448),
     (0.586207, 0.620690, 0.620690),
     (0.379310, 0.310345, 0.482759),
     (0.620690, 0.379310, 0.137931),
     (0.827586, 0.482759, 0.655172),
     (0.689655, 0.793103, 0.137931),
     (0.517241, 0.000000, 0.655172),
     (0.241379, 0.551724, 0.275862),
     (0.275862, 0.793103, 0.655172),
     (0.724138, 0.206897, 0.413793),
     (0.862069, 0.655172, 0.344828),
     (0.931034, 0.482759, 0.344828),
     (0.034483, 0.000000, 0.517241),
     (0.724138, 0.724138, 0.379310),
     (0.724138, 0.724138, 0.206897),
     (0.310345, 0.551724, 0.758621),
     (0.344828, 0.379310, 0.068966),
     (0.862069, 0.206897, 0.482759),
     (0.862069, 0.896552, 0.379310),
     (0.310345, 0.137931, 0.655172),
     (0.862069, 0.275862, 0.310345),
     (0.517241, 0.448276, 0.517241),
     (0.379310, 0.172414, 0.000000),
     (0.862069, 0.344828, 0.758621),
     (0.413793, 0.482759, 0.551724),
     (0.551724, 0.965517, 0.310345),
     (0.896552, 0.586207, 0.000000),
     (0.448276, 0.448276, 0.206897),
     (1.000000, 0.551724, 0.965517),
     (0.344828, 0.206897, 0.103448),
     (0.517241, 0.758621, 0.586207),
     (0.551724, 0.310345, 0.482759),
     (0.655172, 0.310345, 0.000000),
     (0.517241, 0.655172, 0.310345),
     (0.758621, 0.896552, 0.379310),
     (0.586207, 0.000000, 0.206897),
     (1.000000, 0.551724, 0.724138),
     (0.931034, 0.379310, 0.586207),
     (0.206897, 0.000000, 0.206897),
     (0.344828, 0.000000, 1.000000),
     (1.000000, 0.000000, 0.862069),
     (0.551724, 1.000000, 0.689655),
     (0.896552, 0.655172, 0.689655),
     (0.620690, 0.586207, 0.310345),
     (0.586207, 0.137931, 0.517241),
     (0.517241, 0.551724, 0.517241),
     (0.965517, 0.344828, 0.310345),
     (0.793103, 0.482759, 0.413793),
     (0.137931, 0.310345, 0.103448),
     (0.000000, 0.517241, 0.310345),
     (0.724138, 0.793103, 0.413793),
     (0.758621, 0.517241, 0.344828),
     (0.896552, 0.172414, 1.000000),
     (0.206897, 0.620690, 0.931034),
     (0.206897, 0.379310, 0.000000),
     (0.724138, 0.448276, 0.551724),
     (1.000000, 0.206897, 0.413793),
     (1.000000, 0.620690, 0.965517),
     (0.724138, 0.517241, 0.517241),
     (0.724138, 0.310345, 0.448276),
     (0.000000, 1.000000, 1.000000),
     (0.275862, 0.172414, 0.275862),
     (0.275862, 0.620690, 0.551724),
     (0.241379, 0.482759, 0.482759),
     (0.379310, 0.896552, 0.551724),
     (0.793103, 0.448276, 0.000000),
     (0.862069, 0.724138, 0.758621),
     (0.551724, 0.000000, 1.000000),
     (0.655172, 0.758621, 0.724138),
     (0.379310, 0.103448, 0.172414),
     (0.758621, 0.206897, 0.034483),
     (0.655172, 0.931034, 0.379310),
     (1.000000, 0.724138, 0.482759),
     (0.103448, 0.172414, 0.137931),
     (0.275862, 0.758621, 0.551724),
     (0.448276, 0.310345, 1.000000),
     (0.586207, 0.137931, 0.206897),
     (0.793103, 0.517241, 0.000000),
     (0.620690, 0.448276, 0.448276),
     (0.034483, 0.689655, 0.241379),
     (0.241379, 0.206897, 0.448276),
     (0.310345, 0.965517, 0.586207),
     (0.965517, 0.344828, 0.827586),
     (0.137931, 0.103448, 0.206897),
     (0.310345, 0.758621, 0.448276),
     (0.344828, 0.000000, 0.517241),
     (0.896552, 1.000000, 0.586207),
     (0.793103, 0.965517, 0.896552),
     (0.724138, 0.655172, 0.034483),
     (0.310345, 0.172414, 0.137931),
     (0.000000, 0.413793, 0.793103),
     (0.275862, 1.000000, 0.344828),
     (0.000000, 0.655172, 0.724138),
     (0.413793, 0.827586, 0.275862),
     (0.586207, 0.310345, 0.344828),
     (0.758621, 0.689655, 0.827586),
     (0.965517, 0.827586, 0.586207),
     (0.413793, 0.206897, 0.758621),
     (0.413793, 0.586207, 0.275862),
     (0.172414, 0.482759, 0.000000),
     (0.275862, 0.413793, 0.896552),
     (0.793103, 0.275862, 0.965517),
     (0.896552, 0.896552, 0.448276),
     (0.862069, 0.551724, 0.793103),
     (0.655172, 1.000000, 0.482759),
     (0.724138, 0.896552, 0.689655),
     (0.137931, 0.241379, 0.758621),
     (0.172414, 0.793103, 0.172414),
     (0.379310, 0.103448, 0.034483),
     (0.620690, 0.448276, 0.310345),
     (0.206897, 0.310345, 0.551724),
     (0.827586, 1.000000, 0.655172),
     (0.448276, 0.586207, 0.448276),
     (0.689655, 0.586207, 0.586207),
     (0.275862, 0.206897, 0.103448),
     (0.517241, 0.448276, 0.586207),
     (0.896552, 0.241379, 0.827586),
     (0.931034, 0.758621, 0.620690),
     (0.241379, 0.896552, 0.344828),
     (0.862069, 0.827586, 0.724138),
     (0.793103, 0.862069, 0.655172),
     (0.620690, 0.931034, 0.724138),
     (0.172414, 0.793103, 0.482759),
     (0.724138, 0.413793, 0.413793),
     (0.275862, 0.000000, 0.275862)]
