/**
 * @stability stable
 */
export interface CacheConfiguration {
    /**
     * @stability stable
     */
    readonly type?: "s3";
    /**
     * @stability stable
     */
    readonly shared?: boolean;
    /**
     * @stability stable
     */
    readonly s3?: CacheS3Configuration;
}
/**
 * @stability stable
 */
export interface CacheS3Configuration {
    /**
     * The AWS S3 host.
     *
     * @default "s3.amazonaws.com"
     * @stability stable
     */
    readonly serverAddress?: string;
    /**
     * The name of the storage bucket where cache is stored.
     *
     * @default "runners-cache"
     * @stability stable
     */
    readonly bucketName?: string;
    /**
     * The name of the S3 region.
     *
     * @stability stable
     */
    readonly bucketLocation?: string;
    /**
     * @stability stable
     */
    readonly accessKey?: string;
    /**
     * @stability stable
     */
    readonly secretKey?: string;
}
