# coding: utf-8

"""
    Apache NiFi Registry REST API

    The REST API provides an interface to a registry with operations for saving, versioning, reading NiFi flows and components.

    OpenAPI spec version: 0.7.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ExtensionsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_extensions(self, **kwargs):
        """
        Get all extensions
        Gets the metadata for all extensions that match the filter params and are part of bundles located in buckets the current user is authorized for. If the user is not authorized to any buckets, an empty result set will be returned.  NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extensions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_type: The type of bundles to return
        :param str extension_type: The type of extensions to return
        :param list[str] tag: The tags to filter on, will be used in an OR statement
        :return: ExtensionMetadataContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extensions_with_http_info(**kwargs)
        else:
            (data) = self.get_extensions_with_http_info(**kwargs)
            return data

    def get_extensions_with_http_info(self, **kwargs):
        """
        Get all extensions
        Gets the metadata for all extensions that match the filter params and are part of bundles located in buckets the current user is authorized for. If the user is not authorized to any buckets, an empty result set will be returned.  NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extensions_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_type: The type of bundles to return
        :param str extension_type: The type of extensions to return
        :param list[str] tag: The tags to filter on, will be used in an OR statement
        :return: ExtensionMetadataContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_type', 'extension_type', 'tag']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extensions" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'bundle_type' in params:
            query_params.append(('bundleType', params['bundle_type']))
        if 'extension_type' in params:
            query_params.append(('extensionType', params['extension_type']))
        if 'tag' in params:
            query_params.append(('tag', params['tag']))
            collection_formats['tag'] = 'multi'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extensions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionMetadataContainer',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_extensions_providing_service_api(self, class_name, group_id, artifact_id, version, **kwargs):
        """
        Get extensions providing service API
        Gets the metadata for extensions that provide the specified API and are part of bundles located in buckets the current user is authorized for. If the user is not authorized to any buckets, an empty result set will be returned.  NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extensions_providing_service_api(class_name, group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str class_name: The name of the service API class (required)
        :param str group_id: The groupId of the bundle containing the service API class (required)
        :param str artifact_id: The artifactId of the bundle containing the service API class (required)
        :param str version: The version of the bundle containing the service API class (required)
        :return: ExtensionMetadataContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_extensions_providing_service_api_with_http_info(class_name, group_id, artifact_id, version, **kwargs)
        else:
            (data) = self.get_extensions_providing_service_api_with_http_info(class_name, group_id, artifact_id, version, **kwargs)
            return data

    def get_extensions_providing_service_api_with_http_info(self, class_name, group_id, artifact_id, version, **kwargs):
        """
        Get extensions providing service API
        Gets the metadata for extensions that provide the specified API and are part of bundles located in buckets the current user is authorized for. If the user is not authorized to any buckets, an empty result set will be returned.  NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_extensions_providing_service_api_with_http_info(class_name, group_id, artifact_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str class_name: The name of the service API class (required)
        :param str group_id: The groupId of the bundle containing the service API class (required)
        :param str artifact_id: The artifactId of the bundle containing the service API class (required)
        :param str version: The version of the bundle containing the service API class (required)
        :return: ExtensionMetadataContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['class_name', 'group_id', 'artifact_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extensions_providing_service_api" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'class_name' is set
        if ('class_name' not in params) or (params['class_name'] is None):
            raise ValueError("Missing the required parameter `class_name` when calling `get_extensions_providing_service_api`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_extensions_providing_service_api`")
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_extensions_providing_service_api`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_extensions_providing_service_api`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'class_name' in params:
            query_params.append(('className', params['class_name']))
        if 'group_id' in params:
            query_params.append(('groupId', params['group_id']))
        if 'artifact_id' in params:
            query_params.append(('artifactId', params['artifact_id']))
        if 'version' in params:
            query_params.append(('version', params['version']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extensions/provided-service-api', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionMetadataContainer',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_tags(self, **kwargs):
        """
        Get extension tags
        Gets all the extension tags known to this NiFi Registry instance, along with the number of extensions that have the given tag.  NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tags(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[TagCount]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_tags_with_http_info(**kwargs)
        else:
            (data) = self.get_tags_with_http_info(**kwargs)
            return data

    def get_tags_with_http_info(self, **kwargs):
        """
        Get extension tags
        Gets all the extension tags known to this NiFi Registry instance, along with the number of extensions that have the given tag.  NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tags_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[TagCount]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tags" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/extensions/tags', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[TagCount]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
