# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.13.3-SNAPSHOT
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class TenantDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'versioned_component_id': 'str',
        'parent_group_id': 'str',
        'position': 'PositionDTO',
        'identity': 'str',
        'configurable': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'versioned_component_id': 'versionedComponentId',
        'parent_group_id': 'parentGroupId',
        'position': 'position',
        'identity': 'identity',
        'configurable': 'configurable'
    }

    def __init__(self, id=None, versioned_component_id=None, parent_group_id=None, position=None, identity=None, configurable=None):
        """
        TenantDTO - a model defined in Swagger
        """

        self._id = None
        self._versioned_component_id = None
        self._parent_group_id = None
        self._position = None
        self._identity = None
        self._configurable = None

        if id is not None:
          self.id = id
        if versioned_component_id is not None:
          self.versioned_component_id = versioned_component_id
        if parent_group_id is not None:
          self.parent_group_id = parent_group_id
        if position is not None:
          self.position = position
        if identity is not None:
          self.identity = identity
        if configurable is not None:
          self.configurable = configurable

    @property
    def id(self):
        """
        Gets the id of this TenantDTO.
        The id of the component.

        :return: The id of this TenantDTO.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TenantDTO.
        The id of the component.

        :param id: The id of this TenantDTO.
        :type: str
        """

        self._id = id

    @property
    def versioned_component_id(self):
        """
        Gets the versioned_component_id of this TenantDTO.
        The ID of the corresponding component that is under version control

        :return: The versioned_component_id of this TenantDTO.
        :rtype: str
        """
        return self._versioned_component_id

    @versioned_component_id.setter
    def versioned_component_id(self, versioned_component_id):
        """
        Sets the versioned_component_id of this TenantDTO.
        The ID of the corresponding component that is under version control

        :param versioned_component_id: The versioned_component_id of this TenantDTO.
        :type: str
        """

        self._versioned_component_id = versioned_component_id

    @property
    def parent_group_id(self):
        """
        Gets the parent_group_id of this TenantDTO.
        The id of parent process group of this component if applicable.

        :return: The parent_group_id of this TenantDTO.
        :rtype: str
        """
        return self._parent_group_id

    @parent_group_id.setter
    def parent_group_id(self, parent_group_id):
        """
        Sets the parent_group_id of this TenantDTO.
        The id of parent process group of this component if applicable.

        :param parent_group_id: The parent_group_id of this TenantDTO.
        :type: str
        """

        self._parent_group_id = parent_group_id

    @property
    def position(self):
        """
        Gets the position of this TenantDTO.
        The position of this component in the UI if applicable.

        :return: The position of this TenantDTO.
        :rtype: PositionDTO
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this TenantDTO.
        The position of this component in the UI if applicable.

        :param position: The position of this TenantDTO.
        :type: PositionDTO
        """

        self._position = position

    @property
    def identity(self):
        """
        Gets the identity of this TenantDTO.
        The identity of the tenant.

        :return: The identity of this TenantDTO.
        :rtype: str
        """
        return self._identity

    @identity.setter
    def identity(self, identity):
        """
        Sets the identity of this TenantDTO.
        The identity of the tenant.

        :param identity: The identity of this TenantDTO.
        :type: str
        """

        self._identity = identity

    @property
    def configurable(self):
        """
        Gets the configurable of this TenantDTO.
        Whether this tenant is configurable.

        :return: The configurable of this TenantDTO.
        :rtype: bool
        """
        return self._configurable

    @configurable.setter
    def configurable(self, configurable):
        """
        Sets the configurable of this TenantDTO.
        Whether this tenant is configurable.

        :param configurable: The configurable of this TenantDTO.
        :type: bool
        """

        self._configurable = configurable

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TenantDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
