# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.13.3-SNAPSHOT
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProvenanceEventDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'event_id': 'int',
        'event_time': 'str',
        'event_duration': 'int',
        'lineage_duration': 'int',
        'event_type': 'str',
        'flow_file_uuid': 'str',
        'file_size': 'str',
        'file_size_bytes': 'int',
        'cluster_node_id': 'str',
        'cluster_node_address': 'str',
        'group_id': 'str',
        'component_id': 'str',
        'component_type': 'str',
        'component_name': 'str',
        'source_system_flow_file_id': 'str',
        'alternate_identifier_uri': 'str',
        'attributes': 'list[AttributeDTO]',
        'parent_uuids': 'list[str]',
        'child_uuids': 'list[str]',
        'transit_uri': 'str',
        'relationship': 'str',
        'details': 'str',
        'content_equal': 'bool',
        'input_content_available': 'bool',
        'input_content_claim_section': 'str',
        'input_content_claim_container': 'str',
        'input_content_claim_identifier': 'str',
        'input_content_claim_offset': 'int',
        'input_content_claim_file_size': 'str',
        'input_content_claim_file_size_bytes': 'int',
        'output_content_available': 'bool',
        'output_content_claim_section': 'str',
        'output_content_claim_container': 'str',
        'output_content_claim_identifier': 'str',
        'output_content_claim_offset': 'int',
        'output_content_claim_file_size': 'str',
        'output_content_claim_file_size_bytes': 'int',
        'replay_available': 'bool',
        'replay_explanation': 'str',
        'source_connection_identifier': 'str'
    }

    attribute_map = {
        'id': 'id',
        'event_id': 'eventId',
        'event_time': 'eventTime',
        'event_duration': 'eventDuration',
        'lineage_duration': 'lineageDuration',
        'event_type': 'eventType',
        'flow_file_uuid': 'flowFileUuid',
        'file_size': 'fileSize',
        'file_size_bytes': 'fileSizeBytes',
        'cluster_node_id': 'clusterNodeId',
        'cluster_node_address': 'clusterNodeAddress',
        'group_id': 'groupId',
        'component_id': 'componentId',
        'component_type': 'componentType',
        'component_name': 'componentName',
        'source_system_flow_file_id': 'sourceSystemFlowFileId',
        'alternate_identifier_uri': 'alternateIdentifierUri',
        'attributes': 'attributes',
        'parent_uuids': 'parentUuids',
        'child_uuids': 'childUuids',
        'transit_uri': 'transitUri',
        'relationship': 'relationship',
        'details': 'details',
        'content_equal': 'contentEqual',
        'input_content_available': 'inputContentAvailable',
        'input_content_claim_section': 'inputContentClaimSection',
        'input_content_claim_container': 'inputContentClaimContainer',
        'input_content_claim_identifier': 'inputContentClaimIdentifier',
        'input_content_claim_offset': 'inputContentClaimOffset',
        'input_content_claim_file_size': 'inputContentClaimFileSize',
        'input_content_claim_file_size_bytes': 'inputContentClaimFileSizeBytes',
        'output_content_available': 'outputContentAvailable',
        'output_content_claim_section': 'outputContentClaimSection',
        'output_content_claim_container': 'outputContentClaimContainer',
        'output_content_claim_identifier': 'outputContentClaimIdentifier',
        'output_content_claim_offset': 'outputContentClaimOffset',
        'output_content_claim_file_size': 'outputContentClaimFileSize',
        'output_content_claim_file_size_bytes': 'outputContentClaimFileSizeBytes',
        'replay_available': 'replayAvailable',
        'replay_explanation': 'replayExplanation',
        'source_connection_identifier': 'sourceConnectionIdentifier'
    }

    def __init__(self, id=None, event_id=None, event_time=None, event_duration=None, lineage_duration=None, event_type=None, flow_file_uuid=None, file_size=None, file_size_bytes=None, cluster_node_id=None, cluster_node_address=None, group_id=None, component_id=None, component_type=None, component_name=None, source_system_flow_file_id=None, alternate_identifier_uri=None, attributes=None, parent_uuids=None, child_uuids=None, transit_uri=None, relationship=None, details=None, content_equal=None, input_content_available=None, input_content_claim_section=None, input_content_claim_container=None, input_content_claim_identifier=None, input_content_claim_offset=None, input_content_claim_file_size=None, input_content_claim_file_size_bytes=None, output_content_available=None, output_content_claim_section=None, output_content_claim_container=None, output_content_claim_identifier=None, output_content_claim_offset=None, output_content_claim_file_size=None, output_content_claim_file_size_bytes=None, replay_available=None, replay_explanation=None, source_connection_identifier=None):
        """
        ProvenanceEventDTO - a model defined in Swagger
        """

        self._id = None
        self._event_id = None
        self._event_time = None
        self._event_duration = None
        self._lineage_duration = None
        self._event_type = None
        self._flow_file_uuid = None
        self._file_size = None
        self._file_size_bytes = None
        self._cluster_node_id = None
        self._cluster_node_address = None
        self._group_id = None
        self._component_id = None
        self._component_type = None
        self._component_name = None
        self._source_system_flow_file_id = None
        self._alternate_identifier_uri = None
        self._attributes = None
        self._parent_uuids = None
        self._child_uuids = None
        self._transit_uri = None
        self._relationship = None
        self._details = None
        self._content_equal = None
        self._input_content_available = None
        self._input_content_claim_section = None
        self._input_content_claim_container = None
        self._input_content_claim_identifier = None
        self._input_content_claim_offset = None
        self._input_content_claim_file_size = None
        self._input_content_claim_file_size_bytes = None
        self._output_content_available = None
        self._output_content_claim_section = None
        self._output_content_claim_container = None
        self._output_content_claim_identifier = None
        self._output_content_claim_offset = None
        self._output_content_claim_file_size = None
        self._output_content_claim_file_size_bytes = None
        self._replay_available = None
        self._replay_explanation = None
        self._source_connection_identifier = None

        if id is not None:
          self.id = id
        if event_id is not None:
          self.event_id = event_id
        if event_time is not None:
          self.event_time = event_time
        if event_duration is not None:
          self.event_duration = event_duration
        if lineage_duration is not None:
          self.lineage_duration = lineage_duration
        if event_type is not None:
          self.event_type = event_type
        if flow_file_uuid is not None:
          self.flow_file_uuid = flow_file_uuid
        if file_size is not None:
          self.file_size = file_size
        if file_size_bytes is not None:
          self.file_size_bytes = file_size_bytes
        if cluster_node_id is not None:
          self.cluster_node_id = cluster_node_id
        if cluster_node_address is not None:
          self.cluster_node_address = cluster_node_address
        if group_id is not None:
          self.group_id = group_id
        if component_id is not None:
          self.component_id = component_id
        if component_type is not None:
          self.component_type = component_type
        if component_name is not None:
          self.component_name = component_name
        if source_system_flow_file_id is not None:
          self.source_system_flow_file_id = source_system_flow_file_id
        if alternate_identifier_uri is not None:
          self.alternate_identifier_uri = alternate_identifier_uri
        if attributes is not None:
          self.attributes = attributes
        if parent_uuids is not None:
          self.parent_uuids = parent_uuids
        if child_uuids is not None:
          self.child_uuids = child_uuids
        if transit_uri is not None:
          self.transit_uri = transit_uri
        if relationship is not None:
          self.relationship = relationship
        if details is not None:
          self.details = details
        if content_equal is not None:
          self.content_equal = content_equal
        if input_content_available is not None:
          self.input_content_available = input_content_available
        if input_content_claim_section is not None:
          self.input_content_claim_section = input_content_claim_section
        if input_content_claim_container is not None:
          self.input_content_claim_container = input_content_claim_container
        if input_content_claim_identifier is not None:
          self.input_content_claim_identifier = input_content_claim_identifier
        if input_content_claim_offset is not None:
          self.input_content_claim_offset = input_content_claim_offset
        if input_content_claim_file_size is not None:
          self.input_content_claim_file_size = input_content_claim_file_size
        if input_content_claim_file_size_bytes is not None:
          self.input_content_claim_file_size_bytes = input_content_claim_file_size_bytes
        if output_content_available is not None:
          self.output_content_available = output_content_available
        if output_content_claim_section is not None:
          self.output_content_claim_section = output_content_claim_section
        if output_content_claim_container is not None:
          self.output_content_claim_container = output_content_claim_container
        if output_content_claim_identifier is not None:
          self.output_content_claim_identifier = output_content_claim_identifier
        if output_content_claim_offset is not None:
          self.output_content_claim_offset = output_content_claim_offset
        if output_content_claim_file_size is not None:
          self.output_content_claim_file_size = output_content_claim_file_size
        if output_content_claim_file_size_bytes is not None:
          self.output_content_claim_file_size_bytes = output_content_claim_file_size_bytes
        if replay_available is not None:
          self.replay_available = replay_available
        if replay_explanation is not None:
          self.replay_explanation = replay_explanation
        if source_connection_identifier is not None:
          self.source_connection_identifier = source_connection_identifier

    @property
    def id(self):
        """
        Gets the id of this ProvenanceEventDTO.
        The event uuid.

        :return: The id of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ProvenanceEventDTO.
        The event uuid.

        :param id: The id of this ProvenanceEventDTO.
        :type: str
        """

        self._id = id

    @property
    def event_id(self):
        """
        Gets the event_id of this ProvenanceEventDTO.
        The event id. This is a one up number thats unique per node.

        :return: The event_id of this ProvenanceEventDTO.
        :rtype: int
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id):
        """
        Sets the event_id of this ProvenanceEventDTO.
        The event id. This is a one up number thats unique per node.

        :param event_id: The event_id of this ProvenanceEventDTO.
        :type: int
        """

        self._event_id = event_id

    @property
    def event_time(self):
        """
        Gets the event_time of this ProvenanceEventDTO.
        The timestamp of the event.

        :return: The event_time of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._event_time

    @event_time.setter
    def event_time(self, event_time):
        """
        Sets the event_time of this ProvenanceEventDTO.
        The timestamp of the event.

        :param event_time: The event_time of this ProvenanceEventDTO.
        :type: str
        """

        self._event_time = event_time

    @property
    def event_duration(self):
        """
        Gets the event_duration of this ProvenanceEventDTO.
        The event duration in milliseconds.

        :return: The event_duration of this ProvenanceEventDTO.
        :rtype: int
        """
        return self._event_duration

    @event_duration.setter
    def event_duration(self, event_duration):
        """
        Sets the event_duration of this ProvenanceEventDTO.
        The event duration in milliseconds.

        :param event_duration: The event_duration of this ProvenanceEventDTO.
        :type: int
        """

        self._event_duration = event_duration

    @property
    def lineage_duration(self):
        """
        Gets the lineage_duration of this ProvenanceEventDTO.
        The duration since the lineage began, in milliseconds.

        :return: The lineage_duration of this ProvenanceEventDTO.
        :rtype: int
        """
        return self._lineage_duration

    @lineage_duration.setter
    def lineage_duration(self, lineage_duration):
        """
        Sets the lineage_duration of this ProvenanceEventDTO.
        The duration since the lineage began, in milliseconds.

        :param lineage_duration: The lineage_duration of this ProvenanceEventDTO.
        :type: int
        """

        self._lineage_duration = lineage_duration

    @property
    def event_type(self):
        """
        Gets the event_type of this ProvenanceEventDTO.
        The type of the event.

        :return: The event_type of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """
        Sets the event_type of this ProvenanceEventDTO.
        The type of the event.

        :param event_type: The event_type of this ProvenanceEventDTO.
        :type: str
        """

        self._event_type = event_type

    @property
    def flow_file_uuid(self):
        """
        Gets the flow_file_uuid of this ProvenanceEventDTO.
        The uuid of the flowfile for the event.

        :return: The flow_file_uuid of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._flow_file_uuid

    @flow_file_uuid.setter
    def flow_file_uuid(self, flow_file_uuid):
        """
        Sets the flow_file_uuid of this ProvenanceEventDTO.
        The uuid of the flowfile for the event.

        :param flow_file_uuid: The flow_file_uuid of this ProvenanceEventDTO.
        :type: str
        """

        self._flow_file_uuid = flow_file_uuid

    @property
    def file_size(self):
        """
        Gets the file_size of this ProvenanceEventDTO.
        The size of the flowfile for the event.

        :return: The file_size of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._file_size

    @file_size.setter
    def file_size(self, file_size):
        """
        Sets the file_size of this ProvenanceEventDTO.
        The size of the flowfile for the event.

        :param file_size: The file_size of this ProvenanceEventDTO.
        :type: str
        """

        self._file_size = file_size

    @property
    def file_size_bytes(self):
        """
        Gets the file_size_bytes of this ProvenanceEventDTO.
        The size of the flowfile in bytes for the event.

        :return: The file_size_bytes of this ProvenanceEventDTO.
        :rtype: int
        """
        return self._file_size_bytes

    @file_size_bytes.setter
    def file_size_bytes(self, file_size_bytes):
        """
        Sets the file_size_bytes of this ProvenanceEventDTO.
        The size of the flowfile in bytes for the event.

        :param file_size_bytes: The file_size_bytes of this ProvenanceEventDTO.
        :type: int
        """

        self._file_size_bytes = file_size_bytes

    @property
    def cluster_node_id(self):
        """
        Gets the cluster_node_id of this ProvenanceEventDTO.
        The identifier for the node where the event originated.

        :return: The cluster_node_id of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._cluster_node_id

    @cluster_node_id.setter
    def cluster_node_id(self, cluster_node_id):
        """
        Sets the cluster_node_id of this ProvenanceEventDTO.
        The identifier for the node where the event originated.

        :param cluster_node_id: The cluster_node_id of this ProvenanceEventDTO.
        :type: str
        """

        self._cluster_node_id = cluster_node_id

    @property
    def cluster_node_address(self):
        """
        Gets the cluster_node_address of this ProvenanceEventDTO.
        The label for the node where the event originated.

        :return: The cluster_node_address of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._cluster_node_address

    @cluster_node_address.setter
    def cluster_node_address(self, cluster_node_address):
        """
        Sets the cluster_node_address of this ProvenanceEventDTO.
        The label for the node where the event originated.

        :param cluster_node_address: The cluster_node_address of this ProvenanceEventDTO.
        :type: str
        """

        self._cluster_node_address = cluster_node_address

    @property
    def group_id(self):
        """
        Gets the group_id of this ProvenanceEventDTO.
        The id of the group that the component resides in. If the component is no longer in the flow, the group id will not be set.

        :return: The group_id of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """
        Sets the group_id of this ProvenanceEventDTO.
        The id of the group that the component resides in. If the component is no longer in the flow, the group id will not be set.

        :param group_id: The group_id of this ProvenanceEventDTO.
        :type: str
        """

        self._group_id = group_id

    @property
    def component_id(self):
        """
        Gets the component_id of this ProvenanceEventDTO.
        The id of the component that generated the event.

        :return: The component_id of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._component_id

    @component_id.setter
    def component_id(self, component_id):
        """
        Sets the component_id of this ProvenanceEventDTO.
        The id of the component that generated the event.

        :param component_id: The component_id of this ProvenanceEventDTO.
        :type: str
        """

        self._component_id = component_id

    @property
    def component_type(self):
        """
        Gets the component_type of this ProvenanceEventDTO.
        The type of the component that generated the event.

        :return: The component_type of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._component_type

    @component_type.setter
    def component_type(self, component_type):
        """
        Sets the component_type of this ProvenanceEventDTO.
        The type of the component that generated the event.

        :param component_type: The component_type of this ProvenanceEventDTO.
        :type: str
        """

        self._component_type = component_type

    @property
    def component_name(self):
        """
        Gets the component_name of this ProvenanceEventDTO.
        The name of the component that generated the event.

        :return: The component_name of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._component_name

    @component_name.setter
    def component_name(self, component_name):
        """
        Sets the component_name of this ProvenanceEventDTO.
        The name of the component that generated the event.

        :param component_name: The component_name of this ProvenanceEventDTO.
        :type: str
        """

        self._component_name = component_name

    @property
    def source_system_flow_file_id(self):
        """
        Gets the source_system_flow_file_id of this ProvenanceEventDTO.
        The source system flowfile id.

        :return: The source_system_flow_file_id of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._source_system_flow_file_id

    @source_system_flow_file_id.setter
    def source_system_flow_file_id(self, source_system_flow_file_id):
        """
        Sets the source_system_flow_file_id of this ProvenanceEventDTO.
        The source system flowfile id.

        :param source_system_flow_file_id: The source_system_flow_file_id of this ProvenanceEventDTO.
        :type: str
        """

        self._source_system_flow_file_id = source_system_flow_file_id

    @property
    def alternate_identifier_uri(self):
        """
        Gets the alternate_identifier_uri of this ProvenanceEventDTO.
        The alternate identifier uri for the fileflow for the event.

        :return: The alternate_identifier_uri of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._alternate_identifier_uri

    @alternate_identifier_uri.setter
    def alternate_identifier_uri(self, alternate_identifier_uri):
        """
        Sets the alternate_identifier_uri of this ProvenanceEventDTO.
        The alternate identifier uri for the fileflow for the event.

        :param alternate_identifier_uri: The alternate_identifier_uri of this ProvenanceEventDTO.
        :type: str
        """

        self._alternate_identifier_uri = alternate_identifier_uri

    @property
    def attributes(self):
        """
        Gets the attributes of this ProvenanceEventDTO.
        The attributes of the flowfile for the event.

        :return: The attributes of this ProvenanceEventDTO.
        :rtype: list[AttributeDTO]
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Sets the attributes of this ProvenanceEventDTO.
        The attributes of the flowfile for the event.

        :param attributes: The attributes of this ProvenanceEventDTO.
        :type: list[AttributeDTO]
        """

        self._attributes = attributes

    @property
    def parent_uuids(self):
        """
        Gets the parent_uuids of this ProvenanceEventDTO.
        The parent uuids for the event.

        :return: The parent_uuids of this ProvenanceEventDTO.
        :rtype: list[str]
        """
        return self._parent_uuids

    @parent_uuids.setter
    def parent_uuids(self, parent_uuids):
        """
        Sets the parent_uuids of this ProvenanceEventDTO.
        The parent uuids for the event.

        :param parent_uuids: The parent_uuids of this ProvenanceEventDTO.
        :type: list[str]
        """

        self._parent_uuids = parent_uuids

    @property
    def child_uuids(self):
        """
        Gets the child_uuids of this ProvenanceEventDTO.
        The child uuids for the event.

        :return: The child_uuids of this ProvenanceEventDTO.
        :rtype: list[str]
        """
        return self._child_uuids

    @child_uuids.setter
    def child_uuids(self, child_uuids):
        """
        Sets the child_uuids of this ProvenanceEventDTO.
        The child uuids for the event.

        :param child_uuids: The child_uuids of this ProvenanceEventDTO.
        :type: list[str]
        """

        self._child_uuids = child_uuids

    @property
    def transit_uri(self):
        """
        Gets the transit_uri of this ProvenanceEventDTO.
        The source/destination system uri if the event was a RECEIVE/SEND.

        :return: The transit_uri of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._transit_uri

    @transit_uri.setter
    def transit_uri(self, transit_uri):
        """
        Sets the transit_uri of this ProvenanceEventDTO.
        The source/destination system uri if the event was a RECEIVE/SEND.

        :param transit_uri: The transit_uri of this ProvenanceEventDTO.
        :type: str
        """

        self._transit_uri = transit_uri

    @property
    def relationship(self):
        """
        Gets the relationship of this ProvenanceEventDTO.
        The relationship to which the flowfile was routed if the event is of type ROUTE.

        :return: The relationship of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._relationship

    @relationship.setter
    def relationship(self, relationship):
        """
        Sets the relationship of this ProvenanceEventDTO.
        The relationship to which the flowfile was routed if the event is of type ROUTE.

        :param relationship: The relationship of this ProvenanceEventDTO.
        :type: str
        """

        self._relationship = relationship

    @property
    def details(self):
        """
        Gets the details of this ProvenanceEventDTO.
        The event details.

        :return: The details of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this ProvenanceEventDTO.
        The event details.

        :param details: The details of this ProvenanceEventDTO.
        :type: str
        """

        self._details = details

    @property
    def content_equal(self):
        """
        Gets the content_equal of this ProvenanceEventDTO.
        Whether the input and output content claim is the same.

        :return: The content_equal of this ProvenanceEventDTO.
        :rtype: bool
        """
        return self._content_equal

    @content_equal.setter
    def content_equal(self, content_equal):
        """
        Sets the content_equal of this ProvenanceEventDTO.
        Whether the input and output content claim is the same.

        :param content_equal: The content_equal of this ProvenanceEventDTO.
        :type: bool
        """

        self._content_equal = content_equal

    @property
    def input_content_available(self):
        """
        Gets the input_content_available of this ProvenanceEventDTO.
        Whether the input content is still available.

        :return: The input_content_available of this ProvenanceEventDTO.
        :rtype: bool
        """
        return self._input_content_available

    @input_content_available.setter
    def input_content_available(self, input_content_available):
        """
        Sets the input_content_available of this ProvenanceEventDTO.
        Whether the input content is still available.

        :param input_content_available: The input_content_available of this ProvenanceEventDTO.
        :type: bool
        """

        self._input_content_available = input_content_available

    @property
    def input_content_claim_section(self):
        """
        Gets the input_content_claim_section of this ProvenanceEventDTO.
        The section in which the input content claim lives.

        :return: The input_content_claim_section of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._input_content_claim_section

    @input_content_claim_section.setter
    def input_content_claim_section(self, input_content_claim_section):
        """
        Sets the input_content_claim_section of this ProvenanceEventDTO.
        The section in which the input content claim lives.

        :param input_content_claim_section: The input_content_claim_section of this ProvenanceEventDTO.
        :type: str
        """

        self._input_content_claim_section = input_content_claim_section

    @property
    def input_content_claim_container(self):
        """
        Gets the input_content_claim_container of this ProvenanceEventDTO.
        The container in which the input content claim lives.

        :return: The input_content_claim_container of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._input_content_claim_container

    @input_content_claim_container.setter
    def input_content_claim_container(self, input_content_claim_container):
        """
        Sets the input_content_claim_container of this ProvenanceEventDTO.
        The container in which the input content claim lives.

        :param input_content_claim_container: The input_content_claim_container of this ProvenanceEventDTO.
        :type: str
        """

        self._input_content_claim_container = input_content_claim_container

    @property
    def input_content_claim_identifier(self):
        """
        Gets the input_content_claim_identifier of this ProvenanceEventDTO.
        The identifier of the input content claim.

        :return: The input_content_claim_identifier of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._input_content_claim_identifier

    @input_content_claim_identifier.setter
    def input_content_claim_identifier(self, input_content_claim_identifier):
        """
        Sets the input_content_claim_identifier of this ProvenanceEventDTO.
        The identifier of the input content claim.

        :param input_content_claim_identifier: The input_content_claim_identifier of this ProvenanceEventDTO.
        :type: str
        """

        self._input_content_claim_identifier = input_content_claim_identifier

    @property
    def input_content_claim_offset(self):
        """
        Gets the input_content_claim_offset of this ProvenanceEventDTO.
        The offset into the input content claim where the flowfiles content begins.

        :return: The input_content_claim_offset of this ProvenanceEventDTO.
        :rtype: int
        """
        return self._input_content_claim_offset

    @input_content_claim_offset.setter
    def input_content_claim_offset(self, input_content_claim_offset):
        """
        Sets the input_content_claim_offset of this ProvenanceEventDTO.
        The offset into the input content claim where the flowfiles content begins.

        :param input_content_claim_offset: The input_content_claim_offset of this ProvenanceEventDTO.
        :type: int
        """

        self._input_content_claim_offset = input_content_claim_offset

    @property
    def input_content_claim_file_size(self):
        """
        Gets the input_content_claim_file_size of this ProvenanceEventDTO.
        The file size of the input content claim formatted.

        :return: The input_content_claim_file_size of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._input_content_claim_file_size

    @input_content_claim_file_size.setter
    def input_content_claim_file_size(self, input_content_claim_file_size):
        """
        Sets the input_content_claim_file_size of this ProvenanceEventDTO.
        The file size of the input content claim formatted.

        :param input_content_claim_file_size: The input_content_claim_file_size of this ProvenanceEventDTO.
        :type: str
        """

        self._input_content_claim_file_size = input_content_claim_file_size

    @property
    def input_content_claim_file_size_bytes(self):
        """
        Gets the input_content_claim_file_size_bytes of this ProvenanceEventDTO.
        The file size of the intput content claim in bytes.

        :return: The input_content_claim_file_size_bytes of this ProvenanceEventDTO.
        :rtype: int
        """
        return self._input_content_claim_file_size_bytes

    @input_content_claim_file_size_bytes.setter
    def input_content_claim_file_size_bytes(self, input_content_claim_file_size_bytes):
        """
        Sets the input_content_claim_file_size_bytes of this ProvenanceEventDTO.
        The file size of the intput content claim in bytes.

        :param input_content_claim_file_size_bytes: The input_content_claim_file_size_bytes of this ProvenanceEventDTO.
        :type: int
        """

        self._input_content_claim_file_size_bytes = input_content_claim_file_size_bytes

    @property
    def output_content_available(self):
        """
        Gets the output_content_available of this ProvenanceEventDTO.
        Whether the output content is still available.

        :return: The output_content_available of this ProvenanceEventDTO.
        :rtype: bool
        """
        return self._output_content_available

    @output_content_available.setter
    def output_content_available(self, output_content_available):
        """
        Sets the output_content_available of this ProvenanceEventDTO.
        Whether the output content is still available.

        :param output_content_available: The output_content_available of this ProvenanceEventDTO.
        :type: bool
        """

        self._output_content_available = output_content_available

    @property
    def output_content_claim_section(self):
        """
        Gets the output_content_claim_section of this ProvenanceEventDTO.
        The section in which the output content claim lives.

        :return: The output_content_claim_section of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._output_content_claim_section

    @output_content_claim_section.setter
    def output_content_claim_section(self, output_content_claim_section):
        """
        Sets the output_content_claim_section of this ProvenanceEventDTO.
        The section in which the output content claim lives.

        :param output_content_claim_section: The output_content_claim_section of this ProvenanceEventDTO.
        :type: str
        """

        self._output_content_claim_section = output_content_claim_section

    @property
    def output_content_claim_container(self):
        """
        Gets the output_content_claim_container of this ProvenanceEventDTO.
        The container in which the output content claim lives.

        :return: The output_content_claim_container of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._output_content_claim_container

    @output_content_claim_container.setter
    def output_content_claim_container(self, output_content_claim_container):
        """
        Sets the output_content_claim_container of this ProvenanceEventDTO.
        The container in which the output content claim lives.

        :param output_content_claim_container: The output_content_claim_container of this ProvenanceEventDTO.
        :type: str
        """

        self._output_content_claim_container = output_content_claim_container

    @property
    def output_content_claim_identifier(self):
        """
        Gets the output_content_claim_identifier of this ProvenanceEventDTO.
        The identifier of the output content claim.

        :return: The output_content_claim_identifier of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._output_content_claim_identifier

    @output_content_claim_identifier.setter
    def output_content_claim_identifier(self, output_content_claim_identifier):
        """
        Sets the output_content_claim_identifier of this ProvenanceEventDTO.
        The identifier of the output content claim.

        :param output_content_claim_identifier: The output_content_claim_identifier of this ProvenanceEventDTO.
        :type: str
        """

        self._output_content_claim_identifier = output_content_claim_identifier

    @property
    def output_content_claim_offset(self):
        """
        Gets the output_content_claim_offset of this ProvenanceEventDTO.
        The offset into the output content claim where the flowfiles content begins.

        :return: The output_content_claim_offset of this ProvenanceEventDTO.
        :rtype: int
        """
        return self._output_content_claim_offset

    @output_content_claim_offset.setter
    def output_content_claim_offset(self, output_content_claim_offset):
        """
        Sets the output_content_claim_offset of this ProvenanceEventDTO.
        The offset into the output content claim where the flowfiles content begins.

        :param output_content_claim_offset: The output_content_claim_offset of this ProvenanceEventDTO.
        :type: int
        """

        self._output_content_claim_offset = output_content_claim_offset

    @property
    def output_content_claim_file_size(self):
        """
        Gets the output_content_claim_file_size of this ProvenanceEventDTO.
        The file size of the output content claim formatted.

        :return: The output_content_claim_file_size of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._output_content_claim_file_size

    @output_content_claim_file_size.setter
    def output_content_claim_file_size(self, output_content_claim_file_size):
        """
        Sets the output_content_claim_file_size of this ProvenanceEventDTO.
        The file size of the output content claim formatted.

        :param output_content_claim_file_size: The output_content_claim_file_size of this ProvenanceEventDTO.
        :type: str
        """

        self._output_content_claim_file_size = output_content_claim_file_size

    @property
    def output_content_claim_file_size_bytes(self):
        """
        Gets the output_content_claim_file_size_bytes of this ProvenanceEventDTO.
        The file size of the output content claim in bytes.

        :return: The output_content_claim_file_size_bytes of this ProvenanceEventDTO.
        :rtype: int
        """
        return self._output_content_claim_file_size_bytes

    @output_content_claim_file_size_bytes.setter
    def output_content_claim_file_size_bytes(self, output_content_claim_file_size_bytes):
        """
        Sets the output_content_claim_file_size_bytes of this ProvenanceEventDTO.
        The file size of the output content claim in bytes.

        :param output_content_claim_file_size_bytes: The output_content_claim_file_size_bytes of this ProvenanceEventDTO.
        :type: int
        """

        self._output_content_claim_file_size_bytes = output_content_claim_file_size_bytes

    @property
    def replay_available(self):
        """
        Gets the replay_available of this ProvenanceEventDTO.
        Whether or not replay is available.

        :return: The replay_available of this ProvenanceEventDTO.
        :rtype: bool
        """
        return self._replay_available

    @replay_available.setter
    def replay_available(self, replay_available):
        """
        Sets the replay_available of this ProvenanceEventDTO.
        Whether or not replay is available.

        :param replay_available: The replay_available of this ProvenanceEventDTO.
        :type: bool
        """

        self._replay_available = replay_available

    @property
    def replay_explanation(self):
        """
        Gets the replay_explanation of this ProvenanceEventDTO.
        Explanation as to why replay is unavailable.

        :return: The replay_explanation of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._replay_explanation

    @replay_explanation.setter
    def replay_explanation(self, replay_explanation):
        """
        Sets the replay_explanation of this ProvenanceEventDTO.
        Explanation as to why replay is unavailable.

        :param replay_explanation: The replay_explanation of this ProvenanceEventDTO.
        :type: str
        """

        self._replay_explanation = replay_explanation

    @property
    def source_connection_identifier(self):
        """
        Gets the source_connection_identifier of this ProvenanceEventDTO.
        The identifier of the queue/connection from which the flowfile was pulled to genereate this event. May be null if the queue/connection is unknown or the flowfile was generated from this event.

        :return: The source_connection_identifier of this ProvenanceEventDTO.
        :rtype: str
        """
        return self._source_connection_identifier

    @source_connection_identifier.setter
    def source_connection_identifier(self, source_connection_identifier):
        """
        Sets the source_connection_identifier of this ProvenanceEventDTO.
        The identifier of the queue/connection from which the flowfile was pulled to genereate this event. May be null if the queue/connection is unknown or the flowfile was generated from this event.

        :param source_connection_identifier: The source_connection_identifier of this ProvenanceEventDTO.
        :type: str
        """

        self._source_connection_identifier = source_connection_identifier

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProvenanceEventDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
