# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.13.3-SNAPSHOT
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ParameterContextDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'parameters': 'list[ParameterEntity]',
        'bound_process_groups': 'list[ProcessGroupEntity]',
        'id': 'str'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'parameters': 'parameters',
        'bound_process_groups': 'boundProcessGroups',
        'id': 'id'
    }

    def __init__(self, name=None, description=None, parameters=None, bound_process_groups=None, id=None):
        """
        ParameterContextDTO - a model defined in Swagger
        """

        self._name = None
        self._description = None
        self._parameters = None
        self._bound_process_groups = None
        self._id = None

        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if parameters is not None:
          self.parameters = parameters
        if bound_process_groups is not None:
          self.bound_process_groups = bound_process_groups
        if id is not None:
          self.id = id

    @property
    def name(self):
        """
        Gets the name of this ParameterContextDTO.
        The Name of the Parameter Context.

        :return: The name of this ParameterContextDTO.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ParameterContextDTO.
        The Name of the Parameter Context.

        :param name: The name of this ParameterContextDTO.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ParameterContextDTO.
        The Description of the Parameter Context.

        :return: The description of this ParameterContextDTO.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ParameterContextDTO.
        The Description of the Parameter Context.

        :param description: The description of this ParameterContextDTO.
        :type: str
        """

        self._description = description

    @property
    def parameters(self):
        """
        Gets the parameters of this ParameterContextDTO.
        The Parameters for the Parameter Context

        :return: The parameters of this ParameterContextDTO.
        :rtype: list[ParameterEntity]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this ParameterContextDTO.
        The Parameters for the Parameter Context

        :param parameters: The parameters of this ParameterContextDTO.
        :type: list[ParameterEntity]
        """

        self._parameters = parameters

    @property
    def bound_process_groups(self):
        """
        Gets the bound_process_groups of this ParameterContextDTO.
        The Process Groups that are bound to this Parameter Context

        :return: The bound_process_groups of this ParameterContextDTO.
        :rtype: list[ProcessGroupEntity]
        """
        return self._bound_process_groups

    @bound_process_groups.setter
    def bound_process_groups(self, bound_process_groups):
        """
        Sets the bound_process_groups of this ParameterContextDTO.
        The Process Groups that are bound to this Parameter Context

        :param bound_process_groups: The bound_process_groups of this ParameterContextDTO.
        :type: list[ProcessGroupEntity]
        """

        self._bound_process_groups = bound_process_groups

    @property
    def id(self):
        """
        Gets the id of this ParameterContextDTO.
        The ID the Parameter Context.

        :return: The id of this ParameterContextDTO.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ParameterContextDTO.
        The ID the Parameter Context.

        :param id: The id of this ParameterContextDTO.
        :type: str
        """

        self._id = id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ParameterContextDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
