# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.13.3-SNAPSHOT
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class FlowfileQueuesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_drop_request(self, id, **kwargs):
        """
        Creates a request to drop the contents of the queue in this connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_drop_request(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :return: DropRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_drop_request_with_http_info(id, **kwargs)
        else:
            (data) = self.create_drop_request_with_http_info(id, **kwargs)
            return data

    def create_drop_request_with_http_info(self, id, **kwargs):
        """
        Creates a request to drop the contents of the queue in this connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_drop_request_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :return: DropRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_drop_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_drop_request`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/flowfile-queues/{id}/drop-requests', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DropRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_flow_file_listing(self, id, **kwargs):
        """
        Lists the contents of the queue in this connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_flow_file_listing(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :return: ListingRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_flow_file_listing_with_http_info(id, **kwargs)
        else:
            (data) = self.create_flow_file_listing_with_http_info(id, **kwargs)
            return data

    def create_flow_file_listing_with_http_info(self, id, **kwargs):
        """
        Lists the contents of the queue in this connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_flow_file_listing_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :return: ListingRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_flow_file_listing" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_flow_file_listing`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/flowfile-queues/{id}/listing-requests', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListingRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_listing_request(self, id, listing_request_id, **kwargs):
        """
        Cancels and/or removes a request to list the contents of this connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_listing_request(id, listing_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str listing_request_id: The listing request id. (required)
        :return: ListingRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_listing_request_with_http_info(id, listing_request_id, **kwargs)
        else:
            (data) = self.delete_listing_request_with_http_info(id, listing_request_id, **kwargs)
            return data

    def delete_listing_request_with_http_info(self, id, listing_request_id, **kwargs):
        """
        Cancels and/or removes a request to list the contents of this connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_listing_request_with_http_info(id, listing_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str listing_request_id: The listing request id. (required)
        :return: ListingRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'listing_request_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_listing_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_listing_request`")
        # verify the required parameter 'listing_request_id' is set
        if ('listing_request_id' not in params) or (params['listing_request_id'] is None):
            raise ValueError("Missing the required parameter `listing_request_id` when calling `delete_listing_request`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'listing_request_id' in params:
            path_params['listing-request-id'] = params['listing_request_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/flowfile-queues/{id}/listing-requests/{listing-request-id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListingRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def download_flow_file_content(self, id, flowfile_uuid, **kwargs):
        """
        Gets the content for a FlowFile in a Connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_flow_file_content(id, flowfile_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str flowfile_uuid: The flowfile uuid. (required)
        :param str client_id: If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
        :param str cluster_node_id: The id of the node where the content exists if clustered.
        :return: StreamingOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.download_flow_file_content_with_http_info(id, flowfile_uuid, **kwargs)
        else:
            (data) = self.download_flow_file_content_with_http_info(id, flowfile_uuid, **kwargs)
            return data

    def download_flow_file_content_with_http_info(self, id, flowfile_uuid, **kwargs):
        """
        Gets the content for a FlowFile in a Connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_flow_file_content_with_http_info(id, flowfile_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str flowfile_uuid: The flowfile uuid. (required)
        :param str client_id: If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
        :param str cluster_node_id: The id of the node where the content exists if clustered.
        :return: StreamingOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'flowfile_uuid', 'client_id', 'cluster_node_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_flow_file_content" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `download_flow_file_content`")
        # verify the required parameter 'flowfile_uuid' is set
        if ('flowfile_uuid' not in params) or (params['flowfile_uuid'] is None):
            raise ValueError("Missing the required parameter `flowfile_uuid` when calling `download_flow_file_content`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'flowfile_uuid' in params:
            path_params['flowfile-uuid'] = params['flowfile_uuid']

        query_params = []
        if 'client_id' in params:
            query_params.append(('clientId', params['client_id']))
        if 'cluster_node_id' in params:
            query_params.append(('clusterNodeId', params['cluster_node_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/flowfile-queues/{id}/flowfiles/{flowfile-uuid}/content', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StreamingOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_drop_request(self, id, drop_request_id, **kwargs):
        """
        Gets the current status of a drop request for the specified connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_drop_request(id, drop_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str drop_request_id: The drop request id. (required)
        :return: DropRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_drop_request_with_http_info(id, drop_request_id, **kwargs)
        else:
            (data) = self.get_drop_request_with_http_info(id, drop_request_id, **kwargs)
            return data

    def get_drop_request_with_http_info(self, id, drop_request_id, **kwargs):
        """
        Gets the current status of a drop request for the specified connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_drop_request_with_http_info(id, drop_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str drop_request_id: The drop request id. (required)
        :return: DropRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'drop_request_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_drop_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_drop_request`")
        # verify the required parameter 'drop_request_id' is set
        if ('drop_request_id' not in params) or (params['drop_request_id'] is None):
            raise ValueError("Missing the required parameter `drop_request_id` when calling `get_drop_request`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'drop_request_id' in params:
            path_params['drop-request-id'] = params['drop_request_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/flowfile-queues/{id}/drop-requests/{drop-request-id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DropRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_flow_file(self, id, flowfile_uuid, **kwargs):
        """
        Gets a FlowFile from a Connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_file(id, flowfile_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str flowfile_uuid: The flowfile uuid. (required)
        :param str cluster_node_id: The id of the node where the content exists if clustered.
        :return: FlowFileEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_flow_file_with_http_info(id, flowfile_uuid, **kwargs)
        else:
            (data) = self.get_flow_file_with_http_info(id, flowfile_uuid, **kwargs)
            return data

    def get_flow_file_with_http_info(self, id, flowfile_uuid, **kwargs):
        """
        Gets a FlowFile from a Connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_file_with_http_info(id, flowfile_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str flowfile_uuid: The flowfile uuid. (required)
        :param str cluster_node_id: The id of the node where the content exists if clustered.
        :return: FlowFileEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'flowfile_uuid', 'cluster_node_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_flow_file`")
        # verify the required parameter 'flowfile_uuid' is set
        if ('flowfile_uuid' not in params) or (params['flowfile_uuid'] is None):
            raise ValueError("Missing the required parameter `flowfile_uuid` when calling `get_flow_file`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'flowfile_uuid' in params:
            path_params['flowfile-uuid'] = params['flowfile_uuid']

        query_params = []
        if 'cluster_node_id' in params:
            query_params.append(('clusterNodeId', params['cluster_node_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/flowfile-queues/{id}/flowfiles/{flowfile-uuid}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FlowFileEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_listing_request(self, id, listing_request_id, **kwargs):
        """
        Gets the current status of a listing request for the specified connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_listing_request(id, listing_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str listing_request_id: The listing request id. (required)
        :return: ListingRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_listing_request_with_http_info(id, listing_request_id, **kwargs)
        else:
            (data) = self.get_listing_request_with_http_info(id, listing_request_id, **kwargs)
            return data

    def get_listing_request_with_http_info(self, id, listing_request_id, **kwargs):
        """
        Gets the current status of a listing request for the specified connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_listing_request_with_http_info(id, listing_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str listing_request_id: The listing request id. (required)
        :return: ListingRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'listing_request_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_listing_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_listing_request`")
        # verify the required parameter 'listing_request_id' is set
        if ('listing_request_id' not in params) or (params['listing_request_id'] is None):
            raise ValueError("Missing the required parameter `listing_request_id` when calling `get_listing_request`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'listing_request_id' in params:
            path_params['listing-request-id'] = params['listing_request_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/flowfile-queues/{id}/listing-requests/{listing-request-id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListingRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def remove_drop_request(self, id, drop_request_id, **kwargs):
        """
        Cancels and/or removes a request to drop the contents of this connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_drop_request(id, drop_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str drop_request_id: The drop request id. (required)
        :return: DropRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_drop_request_with_http_info(id, drop_request_id, **kwargs)
        else:
            (data) = self.remove_drop_request_with_http_info(id, drop_request_id, **kwargs)
            return data

    def remove_drop_request_with_http_info(self, id, drop_request_id, **kwargs):
        """
        Cancels and/or removes a request to drop the contents of this connection.
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_drop_request_with_http_info(id, drop_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The connection id. (required)
        :param str drop_request_id: The drop request id. (required)
        :return: DropRequestEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'drop_request_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_drop_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_drop_request`")
        # verify the required parameter 'drop_request_id' is set
        if ('drop_request_id' not in params) or (params['drop_request_id'] is None):
            raise ValueError("Missing the required parameter `drop_request_id` when calling `remove_drop_request`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'drop_request_id' in params:
            path_params['drop-request-id'] = params['drop_request_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth']

        return self.api_client.call_api('/flowfile-queues/{id}/drop-requests/{drop-request-id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DropRequestEntity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
