# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class AggregatedReplicationState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """This is the aggregated replication status based on all the regional replication status flags.
    """

    UNKNOWN = "Unknown"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    FAILED = "Failed"

class ConfidentialVMEncryptionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """confidential VM encryption types
    """

    ENCRYPTED_VM_GUEST_STATE_ONLY_WITH_PMK = "EncryptedVMGuestStateOnlyWithPmk"
    ENCRYPTED_WITH_PMK = "EncryptedWithPmk"
    ENCRYPTED_WITH_CMK = "EncryptedWithCmk"

class GalleryApplicationVersionPropertiesProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state, which only appears in the response.
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    MIGRATING = "Migrating"

class GalleryExpandParams(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    SHARING_PROFILE_GROUPS = "SharingProfile/Groups"

class GalleryExtendedLocationType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """It is type of the extended location.
    """

    EDGE_ZONE = "EdgeZone"
    UNKNOWN = "Unknown"

class GalleryImagePropertiesProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state, which only appears in the response.
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    MIGRATING = "Migrating"

class GalleryImageVersionPropertiesProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state, which only appears in the response.
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    MIGRATING = "Migrating"

class GalleryPropertiesProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state, which only appears in the response.
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    MIGRATING = "Migrating"

class GallerySharingPermissionTypes(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """This property allows you to specify the permission of sharing gallery. :code:`<br>`:code:`<br>`
    Possible values are: :code:`<br>`:code:`<br>` **Private** :code:`<br>`:code:`<br>` **Groups**
    """

    PRIVATE = "Private"
    GROUPS = "Groups"

class HostCaching(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
    """

    NONE = "None"
    READ_ONLY = "ReadOnly"
    READ_WRITE = "ReadWrite"

class HyperVGeneration(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
    """

    V1 = "V1"
    V2 = "V2"

class OperatingSystemStateTypes(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """This property allows the user to specify whether the virtual machines created under this image
    are 'Generalized' or 'Specialized'.
    """

    GENERALIZED = "Generalized"
    SPECIALIZED = "Specialized"

class OperatingSystemTypes(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """This property allows you to specify the supported type of the OS that application is built for.
    :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Windows**
    :code:`<br>`:code:`<br>` **Linux**
    """

    WINDOWS = "Windows"
    LINUX = "Linux"

class ReplicationMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Optional parameter which specifies the mode to be used for replication. This property is not
    updatable.
    """

    FULL = "Full"
    SHALLOW = "Shallow"

class ReplicationState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """This is the regional replication state.
    """

    UNKNOWN = "Unknown"
    REPLICATING = "Replicating"
    COMPLETED = "Completed"
    FAILED = "Failed"

class ReplicationStatusTypes(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    REPLICATION_STATUS = "ReplicationStatus"

class SelectPermissions(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    PERMISSIONS = "Permissions"

class SharingProfileGroupTypes(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """This property allows you to specify the type of sharing group. :code:`<br>`:code:`<br>`
    Possible values are: :code:`<br>`:code:`<br>` **Subscriptions** :code:`<br>`:code:`<br>`
    **AADTenants** :code:`<br>`:code:`<br>` **Community**
    """

    SUBSCRIPTIONS = "Subscriptions"
    AAD_TENANTS = "AADTenants"
    COMMUNITY = "Community"

class SharingState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The sharing state of the gallery, which only appears in the response.
    """

    SUCCEEDED = "Succeeded"
    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    UNKNOWN = "Unknown"

class SharingUpdateOperationTypes(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """This property allows you to specify the operation type of gallery sharing update.
    :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Add**
    :code:`<br>`:code:`<br>` **Remove** :code:`<br>`:code:`<br>` **Reset**
    """

    ADD = "Add"
    REMOVE = "Remove"
    RESET = "Reset"
    ENABLE_COMMUNITY = "EnableCommunity"

class StorageAccountType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the storage account type to be used to store the image. This property is not
    updatable.
    """

    STANDARD_LRS = "Standard_LRS"
    STANDARD_ZRS = "Standard_ZRS"
    PREMIUM_LRS = "Premium_LRS"
