# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import Any, AsyncIterable, Callable, Dict, Generic, Optional, TypeVar, Union
import warnings

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._capacity_reservation_groups_operations import build_create_or_update_request, build_delete_request, build_get_request, build_list_by_resource_group_request, build_list_by_subscription_request, build_update_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class CapacityReservationGroupsOperations:
    """CapacityReservationGroupsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.compute.v2021_04_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        capacity_reservation_group_name: str,
        parameters: "_models.CapacityReservationGroup",
        **kwargs: Any
    ) -> "_models.CapacityReservationGroup":
        """The operation to create or update a capacity reservation group. When updating a capacity
        reservation group, only tags may be modified. Please refer to
        https://aka.ms/CapacityReservation for more details.

        :param resource_group_name: The name of the resource group.
        :type resource_group_name: str
        :param capacity_reservation_group_name: The name of the capacity reservation group.
        :type capacity_reservation_group_name: str
        :param parameters: Parameters supplied to the Create capacity reservation Group.
        :type parameters: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroup
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CapacityReservationGroup, or the result of cls(response)
        :rtype: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroup
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CapacityReservationGroup"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'CapacityReservationGroup')

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            capacity_reservation_group_name=capacity_reservation_group_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.create_or_update.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('CapacityReservationGroup', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('CapacityReservationGroup', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}'}  # type: ignore


    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        capacity_reservation_group_name: str,
        parameters: "_models.CapacityReservationGroupUpdate",
        **kwargs: Any
    ) -> "_models.CapacityReservationGroup":
        """The operation to update a capacity reservation group. When updating a capacity reservation
        group, only tags may be modified.

        :param resource_group_name: The name of the resource group.
        :type resource_group_name: str
        :param capacity_reservation_group_name: The name of the capacity reservation group.
        :type capacity_reservation_group_name: str
        :param parameters: Parameters supplied to the Update capacity reservation Group operation.
        :type parameters: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroupUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CapacityReservationGroup, or the result of cls(response)
        :rtype: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroup
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CapacityReservationGroup"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'CapacityReservationGroupUpdate')

        request = build_update_request(
            resource_group_name=resource_group_name,
            capacity_reservation_group_name=capacity_reservation_group_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.update.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('CapacityReservationGroup', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}'}  # type: ignore


    @distributed_trace_async
    async def delete(
        self,
        resource_group_name: str,
        capacity_reservation_group_name: str,
        **kwargs: Any
    ) -> None:
        """The operation to delete a capacity reservation group. This operation is allowed only if all the
        associated resources are disassociated from the reservation group and all capacity reservations
        under the reservation group have also been deleted. Please refer to
        https://aka.ms/CapacityReservation for more details.

        :param resource_group_name: The name of the resource group.
        :type resource_group_name: str
        :param capacity_reservation_group_name: The name of the capacity reservation group.
        :type capacity_reservation_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_request(
            resource_group_name=resource_group_name,
            capacity_reservation_group_name=capacity_reservation_group_name,
            subscription_id=self._config.subscription_id,
            template_url=self.delete.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}'}  # type: ignore


    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        capacity_reservation_group_name: str,
        expand: Optional[Union[str, "_models.CapacityReservationGroupInstanceViewTypes"]] = None,
        **kwargs: Any
    ) -> "_models.CapacityReservationGroup":
        """The operation that retrieves information about a capacity reservation group.

        :param resource_group_name: The name of the resource group.
        :type resource_group_name: str
        :param capacity_reservation_group_name: The name of the capacity reservation group.
        :type capacity_reservation_group_name: str
        :param expand: The expand expression to apply on the operation. 'InstanceView' will retrieve
         the list of instance views of the capacity reservations under the capacity reservation group
         which is a snapshot of the runtime properties of a capacity reservation that is managed by the
         platform and can change outside of control plane operations.
        :type expand: str or
         ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroupInstanceViewTypes
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CapacityReservationGroup, or the result of cls(response)
        :rtype: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroup
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CapacityReservationGroup"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_request(
            resource_group_name=resource_group_name,
            capacity_reservation_group_name=capacity_reservation_group_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('CapacityReservationGroup', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}'}  # type: ignore


    @distributed_trace
    def list_by_resource_group(
        self,
        resource_group_name: str,
        expand: Optional[Union[str, "_models.ExpandTypesForGetCapacityReservationGroups"]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.CapacityReservationGroupListResult"]:
        """Lists all of the capacity reservation groups in the specified resource group. Use the nextLink
        property in the response to get the next page of capacity reservation groups.

        :param resource_group_name: The name of the resource group.
        :type resource_group_name: str
        :param expand: The expand expression to apply on the operation. Based on the expand param(s)
         specified we return Virtual Machine or ScaleSet VM Instance or both resource Ids which are
         associated to capacity reservation group in the response.
        :type expand: str or
         ~azure.mgmt.compute.v2021_04_01.models.ExpandTypesForGetCapacityReservationGroups
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CapacityReservationGroupListResult or the result
         of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroupListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CapacityReservationGroupListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    expand=expand,
                    template_url=self.list_by_resource_group.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    expand=expand,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CapacityReservationGroupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_by_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups'}  # type: ignore

    @distributed_trace
    def list_by_subscription(
        self,
        expand: Optional[Union[str, "_models.ExpandTypesForGetCapacityReservationGroups"]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.CapacityReservationGroupListResult"]:
        """Lists all of the capacity reservation groups in the subscription. Use the nextLink property in
        the response to get the next page of capacity reservation groups.

        :param expand: The expand expression to apply on the operation. Based on the expand param(s)
         specified we return Virtual Machine or ScaleSet VM Instance or both resource Ids which are
         associated to capacity reservation group in the response.
        :type expand: str or
         ~azure.mgmt.compute.v2021_04_01.models.ExpandTypesForGetCapacityReservationGroups
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CapacityReservationGroupListResult or the result
         of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroupListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CapacityReservationGroupListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    expand=expand,
                    template_url=self.list_by_subscription.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    expand=expand,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CapacityReservationGroupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_by_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Compute/capacityReservationGroups'}  # type: ignore
