# LLC Science SDK

> A simple way to fetch scientific data from the Science Admin.

## Installation

```sh
pip install llcsciencesdk
```

## Updating to a new version

```sh
pip install llcsciencesdk -U
```

## Usage

#### Specifying environment

```python
from llcsciencesdk.llc_api import ScienceSdk

llc_api = ScienceSdk() # connect to production
llc_api = ScienceSdk(environment="staging") # connect to staging
llc_api = ScienceSdk(environment="local") # connect to localhost
```

#### Logging in

```python
from llcsciencesdk.llc_api import ScienceSdk

llc_api = ScienceSdk()
llc_api.login("username", "password")
```

#### Getting data for fasttrack

```python
model_input_json = llc_api.get_model_input_fast_track_json(1) # get json data
model_input_json = llc_api.get_model_input_fast_track(1) # get dict of data frames
```

#### Getting data for calibration

```python
model_input_json = llc_api.get_model_input_calibrate_fast_track_json(1) # get json data
model_input_json = llc_api.get_model_input_calibrate_fast_track(1) # get dict of data frames
```

#### Getting data for density analyses

```python
model_input_json = llc_api.get_model_input_density_analyses_fast_track_json(1) # get json data
model_input_json = llc_api.get_model_input_density_analyses_fast_track(1) # get dict of data frames
```

## Legacy methods

#### Getting the data in JSON format

```python
model_input = llc_api.get_model_input_fast_track_json(1)
```

#### Getting the data as a list of DataFrames

```python
model_input = llc_api.get_model_input_fast_track(1)
```

#### Getting data with legacy version8 and version11 parameter names

```python
model_input = llc_api.get_model_input_as_json(1, legacy_parameters=True)
```

#### Getting data for old model runs using the old API structure

```python
model_input = llc_api.get_old_model_inputs([46])
```

#### Getting data about a Planting Design

```python
from llcsciencesdk.llc_api import ScienceSdk

llc_api = ScienceSdk()
llc_api.login("username", "password")
planting_design_list = llc_api.get_planting_design_list()
planting_design_detail = llc_api.get_planting_design(10)

```

## Supported endpoints

The following endpoints can be called

### Fast Track Endpoints (Refer to FT API docs for more info)

- llc_api.get_model_input_fast_track_json
- llc_api.get_model_input_fast_track
- get_model_input_calibrate_fast_track_json
- get_model_input_calibrate_fast_track
- get_model_input_density_analyses_fast_track_json
- get_model_input_density_analyses_fast_track

### Planting Design Endpoints

- llc_api.get_planting_design_list -> Returns a list of the Planting Designs(id, name)
- llc_api.get_planting_design(id) -> Returns a detail object of the Planting Design (id, name, species, location)
- llc_api.update_remote_sensing_dashboard_status(planting_design_id, status_code) -> update the status in the internal admin once remote sensing assets are generated
