"""
    Enums for the AIRC module
"""

import enum


class ReplyCode(enum.IntEnum):

    # Initial connect codes

    WELCOME = 1
    YOURHOST = 2
    CREATED = 3
    MYINFO = 4
    ISUPPORT = 5

    # 200 Codes

    TRACELINK = 200
    TRACECONNECTING = 201
    TRACEHANDSHAKE = 202
    TRACEUNKNOWN = 203
    TRACEOPERATOR = 204
    TRACEUSER = 205
    TRACESERVER = 206
    TRACESERVICE = 207
    TRACENEWTYPE = 208
    TRACECLASS = 209
    TRACERECONNECT = 210
    STATSLINKINFO = 211
    STATSCOMMAND = 212

    ENDOFSTATS = 219

    UMODEIS = 221

    SERVLIST = 234
    SERVLISTEND = 235

    STATSUPTIME = 242
    STATSOLINE = 243

    LUSERCLIENT = 251
    LUSEROP = 252
    LUSERUNKOWN = 253
    LUSERCHANNELS = 254
    LUSERME = 255
    ADMINME = 256
    ADMINLOC1 = 257
    ADMINLOC2 = 258
    ADMINEMAIL = 259

    TRACELOG = 261
    TRACEEND = 262
    TRYAGAIN = 263

    LOCALUSERS = 265   # Both of these are defined by a couple common
    GLOBALUSERS = 266  # IRC systems

    # 300 Codes

    AWAY = 301
    USERHOST = 302
    ISON = 303

    UNAWAY = 305
    NOWAWAY = 306

    WHOISUSER = 311
    WHOISSERVER = 312
    WHOISOPERATOR = 313
    WHOWASUSER = 314
    ENDOFWHO = 315

    WHOISIDLE = 317
    ENDOFWHOIS = 318
    WHOISCHANNELS = 319

    LISTSTART = 321
    LIST = 322
    LISTEND = 323
    CHANNELMODEIS = 324
    UNIQOPIS = 325

    NOTOPIC = 331
    TOPIC = 332

    INVITING = 341
    SUMMONING = 342

    INVITELIST = 346
    ENDOFINVITELIST = 347
    EXCEPTLIST = 348
    ENDOFEXCEPTLIST = 349

    VERSION = 351
    WHOREPLY = 352
    NAMREPLY = 353

    LINKS = 364
    ENDOFLINKS = 365
    ENDOFNAMES = 366
    BANLIST = 367
    ENDOFBANLIST = 368
    ENDOFWHOWAS = 369

    INFO = 371
    MOTD = 372

    ENDOFINFO = 374
    MOTDSTART = 375
    ENDOFMOTD = 376

    YOUREOPER = 381
    REHASHING = 382
    YOURESERVICE = 383

    TIME = 391
    USERSSTART = 392
    USERS = 393
    ENDOFUSERS = 394
    NOUSERS = 395
    HOSTHIDDEN = 396  # Used by Undernet and UnrealIRC at least

    # 400 Codes

    NOSUCHNICK = 401
    NOSUCHSERVER = 402
    NOSUCHCHANNEL = 403
    CANNOTSENDTOCHAIN = 404
    TOOMANYCHANNELS = 405
    WASNOSUCHNICK = 406
    TOOMANYTARGETS = 407
    NOSUCHSERVICE = 408
    NOORIGIN = 409
    INVALIDCAPCMD = 410
    NORECIPIENT = 411
    NOTEXTTOSEND = 412
    NOTOPLEVEL = 413
    WILDTOPLEVEL = 414
    BADMASK = 415

    UNKNOWNCOMMAND = 421
    NOMOTD = 422
    NOADMININFO = 423
    FILEERROR = 424

    NONICKNAMEGIVEN = 431
    ERRONEUSNICKNAME = 432
    NICKNAMEINUSE = 433

    NICKCOLLISION = 436
    UNAVAILRESOURCE = 437

    USERNOTINCHANNEL = 441
    NOTONCHANNEL = 442
    USERONCHANNEL = 443
    NOLOGIN = 444
    SUMMONDISABLED = 445
    USERSDISABLED = 446

    NOTREGISTERED = 451

    NEEDMOREPARAMS = 461
    ALREADYREGISTERED = 462
    NOPERMFORHOST = 463
    PASSWDMISMATCH = 464
    YOUREBANNEDCREEP = 465
    YOUWILLBEBANNED = 466
    KEYSET = 467

    CHANNELISFULL = 471
    UNKNOWNMODE = 472
    INVITEONLYCHAN = 473
    BANNEDFROMCHAN = 474
    BADCHANNELKEY = 475
    BADCHANMASK = 476
    NOCHANMODES = 477
    BANLISTFULL = 478

    NOPRIVILEGES = 481
    CHANOPRIVSNEEDED = 482
    CANTKILLSERVER = 483
    RESTRICTED = 484
    UNIQOPPRIVSNEEDED = 485

    NOOPERHOST = 491

    # 500 Codes

    UMODEUNKNOWNFLAG = 501
    USERSDONTMATCH = 502


class ReplyType(enum.Enum):

    REPLY = "RPL"  # Code between 0 and 399
    ERROR = "ERR"  # Code between 400 and 599
    PROTOCOL = "PROT"  # Non-numeric code
    UNKNOWN = "UNK"  # Unrecognized numeric code
    CLIENT = "CLNT"  # Client-side event


class UserType(enum.Enum):

    normal_user = "USER"
    known_bot = "KNOWN"
    verified_bot = "VERIFIED"
