"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssociationManager = void 0;
const servicecatalog_generated_1 = require("../servicecatalog.generated");
const util_1 = require("./util");
const validation_1 = require("./validation");
class AssociationManager {
    static associateProductWithPortfolio(portfolio, product) {
        const associationKey = util_1.hashValues(portfolio.node.addr, product.node.addr, product.stack.node.addr);
        const constructId = `PortfolioProductAssociation${associationKey}`;
        const existingAssociation = portfolio.node.tryFindChild(constructId);
        const cfnAssociation = existingAssociation
            ? existingAssociation
            : new servicecatalog_generated_1.CfnPortfolioProductAssociation(portfolio, constructId, {
                portfolioId: portfolio.portfolioId,
                productId: product.productId,
            });
        return {
            associationKey: associationKey,
            cfnPortfolioProductAssociation: cfnAssociation,
        };
    }
    static constrainTagUpdates(portfolio, product, options) {
        validation_1.InputValidator.validateLength(this.prettyPrintAssociation(portfolio, product), 'description', 0, 2000, options.description);
        const association = this.associateProductWithPortfolio(portfolio, product);
        const constructId = `ResourceUpdateConstraint${association.associationKey}`;
        if (!portfolio.node.tryFindChild(constructId)) {
            const constraint = new servicecatalog_generated_1.CfnResourceUpdateConstraint(portfolio, constructId, {
                acceptLanguage: options.messageLanguage,
                description: options.description,
                portfolioId: portfolio.portfolioId,
                productId: product.productId,
                tagUpdateOnProvisionedProduct: options.allow === false ? 'NOT_ALLOWED' : 'ALLOWED',
            });
            // Add dependsOn to force proper order in deployment.
            constraint.addDependsOn(association.cfnPortfolioProductAssociation);
        }
        else {
            throw new Error(`Cannot have multiple tag update constraints for association ${this.prettyPrintAssociation(portfolio, product)}`);
        }
    }
    static prettyPrintAssociation(portfolio, product) {
        return `- Portfolio: ${portfolio.node.path} | Product: ${product.node.path}`;
    }
}
exports.AssociationManager = AssociationManager;
//# sourceMappingURL=data:application/json;base64,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