import { MessageLanguage } from './common';
/**
 * (experimental) Properties for governance mechanisms and constraints.
 *
 * @experimental
 */
export interface CommonConstraintOptions {
    /**
     * (experimental) The language code.
     *
     * Configures the language for error messages from service catalog.
     *
     * @default - English
     * @experimental
     */
    readonly messageLanguage?: MessageLanguage;
    /**
     * (experimental) The description of the constraint.
     *
     * @default - No description provided
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) Properties for ResourceUpdateConstraint.
 *
 * @experimental
 */
export interface TagUpdateConstraintOptions extends CommonConstraintOptions {
    /**
     * (experimental) Toggle for if users should be allowed to change/update tags on provisioned products.
     *
     * @default true
     * @experimental
     */
    readonly allow?: boolean;
}
