# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class EmailAnalysis(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'spam_verdict': 'str',
        'virus_verdict': 'str',
        'spf_verdict': 'str',
        'dkim_verdict': 'str',
        'dmarc_verdict': 'str'
    }

    attribute_map = {
        'spam_verdict': 'spamVerdict',
        'virus_verdict': 'virusVerdict',
        'spf_verdict': 'spfVerdict',
        'dkim_verdict': 'dkimVerdict',
        'dmarc_verdict': 'dmarcVerdict'
    }

    def __init__(self, spam_verdict=None, virus_verdict=None, spf_verdict=None, dkim_verdict=None, dmarc_verdict=None, local_vars_configuration=None):  # noqa: E501
        """EmailAnalysis - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._spam_verdict = None
        self._virus_verdict = None
        self._spf_verdict = None
        self._dkim_verdict = None
        self._dmarc_verdict = None
        self.discriminator = None

        if spam_verdict is not None:
            self.spam_verdict = spam_verdict
        if virus_verdict is not None:
            self.virus_verdict = virus_verdict
        if spf_verdict is not None:
            self.spf_verdict = spf_verdict
        if dkim_verdict is not None:
            self.dkim_verdict = dkim_verdict
        if dmarc_verdict is not None:
            self.dmarc_verdict = dmarc_verdict

    @property
    def spam_verdict(self):
        """Gets the spam_verdict of this EmailAnalysis.  # noqa: E501

        Verdict of spam ranking analysis  # noqa: E501

        :return: The spam_verdict of this EmailAnalysis.  # noqa: E501
        :rtype: str
        """
        return self._spam_verdict

    @spam_verdict.setter
    def spam_verdict(self, spam_verdict):
        """Sets the spam_verdict of this EmailAnalysis.

        Verdict of spam ranking analysis  # noqa: E501

        :param spam_verdict: The spam_verdict of this EmailAnalysis.  # noqa: E501
        :type: str
        """

        self._spam_verdict = spam_verdict

    @property
    def virus_verdict(self):
        """Gets the virus_verdict of this EmailAnalysis.  # noqa: E501

        Verdict of virus scan analysis  # noqa: E501

        :return: The virus_verdict of this EmailAnalysis.  # noqa: E501
        :rtype: str
        """
        return self._virus_verdict

    @virus_verdict.setter
    def virus_verdict(self, virus_verdict):
        """Sets the virus_verdict of this EmailAnalysis.

        Verdict of virus scan analysis  # noqa: E501

        :param virus_verdict: The virus_verdict of this EmailAnalysis.  # noqa: E501
        :type: str
        """

        self._virus_verdict = virus_verdict

    @property
    def spf_verdict(self):
        """Gets the spf_verdict of this EmailAnalysis.  # noqa: E501

        Verdict of Send Policy Framework record spoofing analysis  # noqa: E501

        :return: The spf_verdict of this EmailAnalysis.  # noqa: E501
        :rtype: str
        """
        return self._spf_verdict

    @spf_verdict.setter
    def spf_verdict(self, spf_verdict):
        """Sets the spf_verdict of this EmailAnalysis.

        Verdict of Send Policy Framework record spoofing analysis  # noqa: E501

        :param spf_verdict: The spf_verdict of this EmailAnalysis.  # noqa: E501
        :type: str
        """

        self._spf_verdict = spf_verdict

    @property
    def dkim_verdict(self):
        """Gets the dkim_verdict of this EmailAnalysis.  # noqa: E501

        Verdict of DomainKeys Identified Mail analysis  # noqa: E501

        :return: The dkim_verdict of this EmailAnalysis.  # noqa: E501
        :rtype: str
        """
        return self._dkim_verdict

    @dkim_verdict.setter
    def dkim_verdict(self, dkim_verdict):
        """Sets the dkim_verdict of this EmailAnalysis.

        Verdict of DomainKeys Identified Mail analysis  # noqa: E501

        :param dkim_verdict: The dkim_verdict of this EmailAnalysis.  # noqa: E501
        :type: str
        """

        self._dkim_verdict = dkim_verdict

    @property
    def dmarc_verdict(self):
        """Gets the dmarc_verdict of this EmailAnalysis.  # noqa: E501

        Verdict of Domain-based Message Authentication Reporting and Conformance analysis  # noqa: E501

        :return: The dmarc_verdict of this EmailAnalysis.  # noqa: E501
        :rtype: str
        """
        return self._dmarc_verdict

    @dmarc_verdict.setter
    def dmarc_verdict(self, dmarc_verdict):
        """Sets the dmarc_verdict of this EmailAnalysis.

        Verdict of Domain-based Message Authentication Reporting and Conformance analysis  # noqa: E501

        :param dmarc_verdict: The dmarc_verdict of this EmailAnalysis.  # noqa: E501
        :type: str
        """

        self._dmarc_verdict = dmarc_verdict

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EmailAnalysis):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EmailAnalysis):
            return True

        return self.to_dict() != other.to_dict()
