# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class CreateInboxForwarderOptions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'field': 'str',
        'match': 'str',
        'forward_to_recipients': 'list[str]'
    }

    attribute_map = {
        'field': 'field',
        'match': 'match',
        'forward_to_recipients': 'forwardToRecipients'
    }

    def __init__(self, field=None, match=None, forward_to_recipients=None, local_vars_configuration=None):  # noqa: E501
        """CreateInboxForwarderOptions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._field = None
        self._match = None
        self._forward_to_recipients = None
        self.discriminator = None

        if field is not None:
            self.field = field
        self.match = match
        if forward_to_recipients is not None:
            self.forward_to_recipients = forward_to_recipients

    @property
    def field(self):
        """Gets the field of this CreateInboxForwarderOptions.  # noqa: E501

        Field to match against to trigger inbox forwarding for inbound email  # noqa: E501

        :return: The field of this CreateInboxForwarderOptions.  # noqa: E501
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """Sets the field of this CreateInboxForwarderOptions.

        Field to match against to trigger inbox forwarding for inbound email  # noqa: E501

        :param field: The field of this CreateInboxForwarderOptions.  # noqa: E501
        :type: str
        """
        allowed_values = ["RECIPIENTS", "SENDER", "SUBJECT", "ATTACHMENTS"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and field not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `field` ({0}), must be one of {1}"  # noqa: E501
                .format(field, allowed_values)
            )

        self._field = field

    @property
    def match(self):
        """Gets the match of this CreateInboxForwarderOptions.  # noqa: E501

        String or wildcard style match for field specified when evaluating forwarding rules  # noqa: E501

        :return: The match of this CreateInboxForwarderOptions.  # noqa: E501
        :rtype: str
        """
        return self._match

    @match.setter
    def match(self, match):
        """Sets the match of this CreateInboxForwarderOptions.

        String or wildcard style match for field specified when evaluating forwarding rules  # noqa: E501

        :param match: The match of this CreateInboxForwarderOptions.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and match is None:  # noqa: E501
            raise ValueError("Invalid value for `match`, must not be `None`")  # noqa: E501

        self._match = match

    @property
    def forward_to_recipients(self):
        """Gets the forward_to_recipients of this CreateInboxForwarderOptions.  # noqa: E501

        Email addresses to forward an email to if it matches the field and match criteria of the forwarder  # noqa: E501

        :return: The forward_to_recipients of this CreateInboxForwarderOptions.  # noqa: E501
        :rtype: list[str]
        """
        return self._forward_to_recipients

    @forward_to_recipients.setter
    def forward_to_recipients(self, forward_to_recipients):
        """Sets the forward_to_recipients of this CreateInboxForwarderOptions.

        Email addresses to forward an email to if it matches the field and match criteria of the forwarder  # noqa: E501

        :param forward_to_recipients: The forward_to_recipients of this CreateInboxForwarderOptions.  # noqa: E501
        :type: list[str]
        """

        self._forward_to_recipients = forward_to_recipients

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateInboxForwarderOptions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateInboxForwarderOptions):
            return True

        return self.to_dict() != other.to_dict()
