# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HistoryExecutionStepArgs', 'HistoryExecutionStep']

@pulumi.input_type
class HistoryExecutionStepArgs:
    def __init__(__self__, *,
                 execution_id: pulumi.Input[str],
                 history_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 step_id: pulumi.Input[str],
                 completion_time: Optional[pulumi.Input['TimestampArgs']] = None,
                 creation_time: Optional[pulumi.Input['TimestampArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_usage_duration: Optional[pulumi.Input['DurationArgs']] = None,
                 dimension_value: Optional[pulumi.Input[Sequence[pulumi.Input['StepDimensionValueEntryArgs']]]] = None,
                 has_images: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['StepLabelsEntryArgs']]]] = None,
                 multi_step: Optional[pulumi.Input['MultiStepArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outcome: Optional[pulumi.Input['OutcomeArgs']] = None,
                 run_duration: Optional[pulumi.Input['DurationArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 test_execution_step: Optional[pulumi.Input['TestExecutionStepArgs']] = None,
                 tool_execution_step: Optional[pulumi.Input['ToolExecutionStepArgs']] = None):
        """
        The set of arguments for constructing a HistoryExecutionStep resource.
        :param pulumi.Input[str] step_id: A unique identifier within a Execution for this Step. Returns INVALID_ARGUMENT if this field is set or overwritten by the caller. - In response: always set - In create/update request: never set
        :param pulumi.Input['TimestampArgs'] completion_time: The time when the step status was set to complete. This value will be set automatically when state transitions to COMPLETE. - In response: set if the execution state is COMPLETE. - In create/update request: never set
        :param pulumi.Input['TimestampArgs'] creation_time: The time when the step was created. - In response: always set - In create/update request: never set
        :param pulumi.Input[str] description: A description of this tool For example: mvn clean package -D skipTests=true - In response: present if set by create/update request - In create/update request: optional
        :param pulumi.Input['DurationArgs'] device_usage_duration: How much the device resource is used to perform the test. This is the device usage used for billing purpose, which is different from the run_duration, for example, infrastructure failure won't be charged for device usage. PRECONDITION_FAILED will be returned if one attempts to set a device_usage on a step which already has this field set. - In response: present if previously set. - In create request: optional - In update request: optional
        :param pulumi.Input[Sequence[pulumi.Input['StepDimensionValueEntryArgs']]] dimension_value: If the execution containing this step has any dimension_definition set, then this field allows the child to specify the values of the dimensions. The keys must exactly match the dimension_definition of the execution. For example, if the execution has `dimension_definition = ['attempt', 'device']` then a step must define values for those dimensions, eg. `dimension_value = ['attempt': '1', 'device': 'Nexus 6']` If a step does not participate in one dimension of the matrix, the value for that dimension should be empty string. For example, if one of the tests is executed by a runner which does not support retries, the step could have `dimension_value = ['attempt': '', 'device': 'Nexus 6']` If the step does not participate in any dimensions of the matrix, it may leave dimension_value unset. A PRECONDITION_FAILED will be returned if any of the keys do not exist in the dimension_definition of the execution. A PRECONDITION_FAILED will be returned if another step in this execution already has the same name and dimension_value, but differs on other data fields, for example, step field is different. A PRECONDITION_FAILED will be returned if dimension_value is set, and there is a dimension_definition in the execution which is not specified as one of the keys. - In response: present if set by create - In create request: optional - In update request: never set
        :param pulumi.Input[bool] has_images: Whether any of the outputs of this step are images whose thumbnails can be fetched with ListThumbnails. - In response: always set - In create/update request: never set
        :param pulumi.Input[Sequence[pulumi.Input['StepLabelsEntryArgs']]] labels: Arbitrary user-supplied key/value pairs that are associated with the step. Users are responsible for managing the key namespace such that keys don't accidentally collide. An INVALID_ARGUMENT will be returned if the number of labels exceeds 100 or if the length of any of the keys or values exceeds 100 characters. - In response: always set - In create request: optional - In update request: optional; any new key/value pair will be added to the map, and any new value for an existing key will update that key's value
        :param pulumi.Input['MultiStepArgs'] multi_step: Details when multiple steps are run with the same configuration as a group. These details can be used identify which group this step is part of. It also identifies the groups 'primary step' which indexes all the group members. - In response: present if previously set. - In create request: optional, set iff this step was performed more than once. - In update request: optional
        :param pulumi.Input[str] name: A short human-readable name to display in the UI. Maximum of 100 characters. For example: Clean build A PRECONDITION_FAILED will be returned upon creating a new step if it shares its name and dimension_value with an existing step. If two steps represent a similar action, but have different dimension values, they should share the same name. For instance, if the same set of tests is run on two different platforms, the two steps should have the same name. - In response: always set - In create request: always set - In update request: never set
        :param pulumi.Input['OutcomeArgs'] outcome: Classification of the result, for example into SUCCESS or FAILURE - In response: present if set by create/update request - In create/update request: optional
        :param pulumi.Input['DurationArgs'] run_duration: How long it took for this step to run. If unset, this is set to the difference between creation_time and completion_time when the step is set to the COMPLETE state. In some cases, it is appropriate to set this value separately: For instance, if a step is created, but the operation it represents is queued for a few minutes before it executes, it would be appropriate not to include the time spent queued in its run_duration. PRECONDITION_FAILED will be returned if one attempts to set a run_duration on a step which already has this field set. - In response: present if previously set; always present on COMPLETE step - In create request: optional - In update request: optional
        :param pulumi.Input[str] state: The initial state is IN_PROGRESS. The only legal state transitions are * IN_PROGRESS -> COMPLETE A PRECONDITION_FAILED will be returned if an invalid transition is requested. It is valid to create Step with a state set to COMPLETE. The state can only be set to COMPLETE once. A PRECONDITION_FAILED will be returned if the state is set to COMPLETE multiple times. - In response: always set - In create/update request: optional
        :param pulumi.Input['TestExecutionStepArgs'] test_execution_step: An execution of a test runner.
        :param pulumi.Input['ToolExecutionStepArgs'] tool_execution_step: An execution of a tool (used for steps we don't explicitly support).
        """
        pulumi.set(__self__, "execution_id", execution_id)
        pulumi.set(__self__, "history_id", history_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "step_id", step_id)
        if completion_time is not None:
            pulumi.set(__self__, "completion_time", completion_time)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_usage_duration is not None:
            pulumi.set(__self__, "device_usage_duration", device_usage_duration)
        if dimension_value is not None:
            pulumi.set(__self__, "dimension_value", dimension_value)
        if has_images is not None:
            pulumi.set(__self__, "has_images", has_images)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if multi_step is not None:
            pulumi.set(__self__, "multi_step", multi_step)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outcome is not None:
            pulumi.set(__self__, "outcome", outcome)
        if run_duration is not None:
            pulumi.set(__self__, "run_duration", run_duration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if test_execution_step is not None:
            pulumi.set(__self__, "test_execution_step", test_execution_step)
        if tool_execution_step is not None:
            pulumi.set(__self__, "tool_execution_step", tool_execution_step)

    @property
    @pulumi.getter(name="executionId")
    def execution_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "execution_id")

    @execution_id.setter
    def execution_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_id", value)

    @property
    @pulumi.getter(name="historyId")
    def history_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "history_id")

    @history_id.setter
    def history_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "history_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> pulumi.Input[str]:
        """
        A unique identifier within a Execution for this Step. Returns INVALID_ARGUMENT if this field is set or overwritten by the caller. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "step_id")

    @step_id.setter
    def step_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "step_id", value)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> Optional[pulumi.Input['TimestampArgs']]:
        """
        The time when the step status was set to complete. This value will be set automatically when state transitions to COMPLETE. - In response: set if the execution state is COMPLETE. - In create/update request: never set
        """
        return pulumi.get(self, "completion_time")

    @completion_time.setter
    def completion_time(self, value: Optional[pulumi.Input['TimestampArgs']]):
        pulumi.set(self, "completion_time", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input['TimestampArgs']]:
        """
        The time when the step was created. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input['TimestampArgs']]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of this tool For example: mvn clean package -D skipTests=true - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceUsageDuration")
    def device_usage_duration(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        How much the device resource is used to perform the test. This is the device usage used for billing purpose, which is different from the run_duration, for example, infrastructure failure won't be charged for device usage. PRECONDITION_FAILED will be returned if one attempts to set a device_usage on a step which already has this field set. - In response: present if previously set. - In create request: optional - In update request: optional
        """
        return pulumi.get(self, "device_usage_duration")

    @device_usage_duration.setter
    def device_usage_duration(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "device_usage_duration", value)

    @property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StepDimensionValueEntryArgs']]]]:
        """
        If the execution containing this step has any dimension_definition set, then this field allows the child to specify the values of the dimensions. The keys must exactly match the dimension_definition of the execution. For example, if the execution has `dimension_definition = ['attempt', 'device']` then a step must define values for those dimensions, eg. `dimension_value = ['attempt': '1', 'device': 'Nexus 6']` If a step does not participate in one dimension of the matrix, the value for that dimension should be empty string. For example, if one of the tests is executed by a runner which does not support retries, the step could have `dimension_value = ['attempt': '', 'device': 'Nexus 6']` If the step does not participate in any dimensions of the matrix, it may leave dimension_value unset. A PRECONDITION_FAILED will be returned if any of the keys do not exist in the dimension_definition of the execution. A PRECONDITION_FAILED will be returned if another step in this execution already has the same name and dimension_value, but differs on other data fields, for example, step field is different. A PRECONDITION_FAILED will be returned if dimension_value is set, and there is a dimension_definition in the execution which is not specified as one of the keys. - In response: present if set by create - In create request: optional - In update request: never set
        """
        return pulumi.get(self, "dimension_value")

    @dimension_value.setter
    def dimension_value(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StepDimensionValueEntryArgs']]]]):
        pulumi.set(self, "dimension_value", value)

    @property
    @pulumi.getter(name="hasImages")
    def has_images(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether any of the outputs of this step are images whose thumbnails can be fetched with ListThumbnails. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "has_images")

    @has_images.setter
    def has_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_images", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StepLabelsEntryArgs']]]]:
        """
        Arbitrary user-supplied key/value pairs that are associated with the step. Users are responsible for managing the key namespace such that keys don't accidentally collide. An INVALID_ARGUMENT will be returned if the number of labels exceeds 100 or if the length of any of the keys or values exceeds 100 characters. - In response: always set - In create request: optional - In update request: optional; any new key/value pair will be added to the map, and any new value for an existing key will update that key's value
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StepLabelsEntryArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="multiStep")
    def multi_step(self) -> Optional[pulumi.Input['MultiStepArgs']]:
        """
        Details when multiple steps are run with the same configuration as a group. These details can be used identify which group this step is part of. It also identifies the groups 'primary step' which indexes all the group members. - In response: present if previously set. - In create request: optional, set iff this step was performed more than once. - In update request: optional
        """
        return pulumi.get(self, "multi_step")

    @multi_step.setter
    def multi_step(self, value: Optional[pulumi.Input['MultiStepArgs']]):
        pulumi.set(self, "multi_step", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A short human-readable name to display in the UI. Maximum of 100 characters. For example: Clean build A PRECONDITION_FAILED will be returned upon creating a new step if it shares its name and dimension_value with an existing step. If two steps represent a similar action, but have different dimension values, they should share the same name. For instance, if the same set of tests is run on two different platforms, the two steps should have the same name. - In response: always set - In create request: always set - In update request: never set
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def outcome(self) -> Optional[pulumi.Input['OutcomeArgs']]:
        """
        Classification of the result, for example into SUCCESS or FAILURE - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "outcome")

    @outcome.setter
    def outcome(self, value: Optional[pulumi.Input['OutcomeArgs']]):
        pulumi.set(self, "outcome", value)

    @property
    @pulumi.getter(name="runDuration")
    def run_duration(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        How long it took for this step to run. If unset, this is set to the difference between creation_time and completion_time when the step is set to the COMPLETE state. In some cases, it is appropriate to set this value separately: For instance, if a step is created, but the operation it represents is queued for a few minutes before it executes, it would be appropriate not to include the time spent queued in its run_duration. PRECONDITION_FAILED will be returned if one attempts to set a run_duration on a step which already has this field set. - In response: present if previously set; always present on COMPLETE step - In create request: optional - In update request: optional
        """
        return pulumi.get(self, "run_duration")

    @run_duration.setter
    def run_duration(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "run_duration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The initial state is IN_PROGRESS. The only legal state transitions are * IN_PROGRESS -> COMPLETE A PRECONDITION_FAILED will be returned if an invalid transition is requested. It is valid to create Step with a state set to COMPLETE. The state can only be set to COMPLETE once. A PRECONDITION_FAILED will be returned if the state is set to COMPLETE multiple times. - In response: always set - In create/update request: optional
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="testExecutionStep")
    def test_execution_step(self) -> Optional[pulumi.Input['TestExecutionStepArgs']]:
        """
        An execution of a test runner.
        """
        return pulumi.get(self, "test_execution_step")

    @test_execution_step.setter
    def test_execution_step(self, value: Optional[pulumi.Input['TestExecutionStepArgs']]):
        pulumi.set(self, "test_execution_step", value)

    @property
    @pulumi.getter(name="toolExecutionStep")
    def tool_execution_step(self) -> Optional[pulumi.Input['ToolExecutionStepArgs']]:
        """
        An execution of a tool (used for steps we don't explicitly support).
        """
        return pulumi.get(self, "tool_execution_step")

    @tool_execution_step.setter
    def tool_execution_step(self, value: Optional[pulumi.Input['ToolExecutionStepArgs']]):
        pulumi.set(self, "tool_execution_step", value)


class HistoryExecutionStep(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 completion_time: Optional[pulumi.Input[pulumi.InputType['TimestampArgs']]] = None,
                 creation_time: Optional[pulumi.Input[pulumi.InputType['TimestampArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_usage_duration: Optional[pulumi.Input[pulumi.InputType['DurationArgs']]] = None,
                 dimension_value: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepDimensionValueEntryArgs']]]]] = None,
                 execution_id: Optional[pulumi.Input[str]] = None,
                 has_images: Optional[pulumi.Input[bool]] = None,
                 history_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepLabelsEntryArgs']]]]] = None,
                 multi_step: Optional[pulumi.Input[pulumi.InputType['MultiStepArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outcome: Optional[pulumi.Input[pulumi.InputType['OutcomeArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 run_duration: Optional[pulumi.Input[pulumi.InputType['DurationArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 step_id: Optional[pulumi.Input[str]] = None,
                 test_execution_step: Optional[pulumi.Input[pulumi.InputType['TestExecutionStepArgs']]] = None,
                 tool_execution_step: Optional[pulumi.Input[pulumi.InputType['ToolExecutionStepArgs']]] = None,
                 __props__=None):
        """
        Creates a Step. The returned Step will have the id set. May return any of the following canonical error codes: - PERMISSION_DENIED - if the user is not authorized to write to project - INVALID_ARGUMENT - if the request is malformed - FAILED_PRECONDITION - if the step is too large (more than 10Mib) - NOT_FOUND - if the containing Execution does not exist

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TimestampArgs']] completion_time: The time when the step status was set to complete. This value will be set automatically when state transitions to COMPLETE. - In response: set if the execution state is COMPLETE. - In create/update request: never set
        :param pulumi.Input[pulumi.InputType['TimestampArgs']] creation_time: The time when the step was created. - In response: always set - In create/update request: never set
        :param pulumi.Input[str] description: A description of this tool For example: mvn clean package -D skipTests=true - In response: present if set by create/update request - In create/update request: optional
        :param pulumi.Input[pulumi.InputType['DurationArgs']] device_usage_duration: How much the device resource is used to perform the test. This is the device usage used for billing purpose, which is different from the run_duration, for example, infrastructure failure won't be charged for device usage. PRECONDITION_FAILED will be returned if one attempts to set a device_usage on a step which already has this field set. - In response: present if previously set. - In create request: optional - In update request: optional
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepDimensionValueEntryArgs']]]] dimension_value: If the execution containing this step has any dimension_definition set, then this field allows the child to specify the values of the dimensions. The keys must exactly match the dimension_definition of the execution. For example, if the execution has `dimension_definition = ['attempt', 'device']` then a step must define values for those dimensions, eg. `dimension_value = ['attempt': '1', 'device': 'Nexus 6']` If a step does not participate in one dimension of the matrix, the value for that dimension should be empty string. For example, if one of the tests is executed by a runner which does not support retries, the step could have `dimension_value = ['attempt': '', 'device': 'Nexus 6']` If the step does not participate in any dimensions of the matrix, it may leave dimension_value unset. A PRECONDITION_FAILED will be returned if any of the keys do not exist in the dimension_definition of the execution. A PRECONDITION_FAILED will be returned if another step in this execution already has the same name and dimension_value, but differs on other data fields, for example, step field is different. A PRECONDITION_FAILED will be returned if dimension_value is set, and there is a dimension_definition in the execution which is not specified as one of the keys. - In response: present if set by create - In create request: optional - In update request: never set
        :param pulumi.Input[bool] has_images: Whether any of the outputs of this step are images whose thumbnails can be fetched with ListThumbnails. - In response: always set - In create/update request: never set
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepLabelsEntryArgs']]]] labels: Arbitrary user-supplied key/value pairs that are associated with the step. Users are responsible for managing the key namespace such that keys don't accidentally collide. An INVALID_ARGUMENT will be returned if the number of labels exceeds 100 or if the length of any of the keys or values exceeds 100 characters. - In response: always set - In create request: optional - In update request: optional; any new key/value pair will be added to the map, and any new value for an existing key will update that key's value
        :param pulumi.Input[pulumi.InputType['MultiStepArgs']] multi_step: Details when multiple steps are run with the same configuration as a group. These details can be used identify which group this step is part of. It also identifies the groups 'primary step' which indexes all the group members. - In response: present if previously set. - In create request: optional, set iff this step was performed more than once. - In update request: optional
        :param pulumi.Input[str] name: A short human-readable name to display in the UI. Maximum of 100 characters. For example: Clean build A PRECONDITION_FAILED will be returned upon creating a new step if it shares its name and dimension_value with an existing step. If two steps represent a similar action, but have different dimension values, they should share the same name. For instance, if the same set of tests is run on two different platforms, the two steps should have the same name. - In response: always set - In create request: always set - In update request: never set
        :param pulumi.Input[pulumi.InputType['OutcomeArgs']] outcome: Classification of the result, for example into SUCCESS or FAILURE - In response: present if set by create/update request - In create/update request: optional
        :param pulumi.Input[pulumi.InputType['DurationArgs']] run_duration: How long it took for this step to run. If unset, this is set to the difference between creation_time and completion_time when the step is set to the COMPLETE state. In some cases, it is appropriate to set this value separately: For instance, if a step is created, but the operation it represents is queued for a few minutes before it executes, it would be appropriate not to include the time spent queued in its run_duration. PRECONDITION_FAILED will be returned if one attempts to set a run_duration on a step which already has this field set. - In response: present if previously set; always present on COMPLETE step - In create request: optional - In update request: optional
        :param pulumi.Input[str] state: The initial state is IN_PROGRESS. The only legal state transitions are * IN_PROGRESS -> COMPLETE A PRECONDITION_FAILED will be returned if an invalid transition is requested. It is valid to create Step with a state set to COMPLETE. The state can only be set to COMPLETE once. A PRECONDITION_FAILED will be returned if the state is set to COMPLETE multiple times. - In response: always set - In create/update request: optional
        :param pulumi.Input[str] step_id: A unique identifier within a Execution for this Step. Returns INVALID_ARGUMENT if this field is set or overwritten by the caller. - In response: always set - In create/update request: never set
        :param pulumi.Input[pulumi.InputType['TestExecutionStepArgs']] test_execution_step: An execution of a test runner.
        :param pulumi.Input[pulumi.InputType['ToolExecutionStepArgs']] tool_execution_step: An execution of a tool (used for steps we don't explicitly support).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HistoryExecutionStepArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Step. The returned Step will have the id set. May return any of the following canonical error codes: - PERMISSION_DENIED - if the user is not authorized to write to project - INVALID_ARGUMENT - if the request is malformed - FAILED_PRECONDITION - if the step is too large (more than 10Mib) - NOT_FOUND - if the containing Execution does not exist

        :param str resource_name: The name of the resource.
        :param HistoryExecutionStepArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HistoryExecutionStepArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 completion_time: Optional[pulumi.Input[pulumi.InputType['TimestampArgs']]] = None,
                 creation_time: Optional[pulumi.Input[pulumi.InputType['TimestampArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_usage_duration: Optional[pulumi.Input[pulumi.InputType['DurationArgs']]] = None,
                 dimension_value: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepDimensionValueEntryArgs']]]]] = None,
                 execution_id: Optional[pulumi.Input[str]] = None,
                 has_images: Optional[pulumi.Input[bool]] = None,
                 history_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepLabelsEntryArgs']]]]] = None,
                 multi_step: Optional[pulumi.Input[pulumi.InputType['MultiStepArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outcome: Optional[pulumi.Input[pulumi.InputType['OutcomeArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 run_duration: Optional[pulumi.Input[pulumi.InputType['DurationArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 step_id: Optional[pulumi.Input[str]] = None,
                 test_execution_step: Optional[pulumi.Input[pulumi.InputType['TestExecutionStepArgs']]] = None,
                 tool_execution_step: Optional[pulumi.Input[pulumi.InputType['ToolExecutionStepArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HistoryExecutionStepArgs.__new__(HistoryExecutionStepArgs)

            __props__.__dict__["completion_time"] = completion_time
            __props__.__dict__["creation_time"] = creation_time
            __props__.__dict__["description"] = description
            __props__.__dict__["device_usage_duration"] = device_usage_duration
            __props__.__dict__["dimension_value"] = dimension_value
            if execution_id is None and not opts.urn:
                raise TypeError("Missing required property 'execution_id'")
            __props__.__dict__["execution_id"] = execution_id
            __props__.__dict__["has_images"] = has_images
            if history_id is None and not opts.urn:
                raise TypeError("Missing required property 'history_id'")
            __props__.__dict__["history_id"] = history_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["multi_step"] = multi_step
            __props__.__dict__["name"] = name
            __props__.__dict__["outcome"] = outcome
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["run_duration"] = run_duration
            __props__.__dict__["state"] = state
            if step_id is None and not opts.urn:
                raise TypeError("Missing required property 'step_id'")
            __props__.__dict__["step_id"] = step_id
            __props__.__dict__["test_execution_step"] = test_execution_step
            __props__.__dict__["tool_execution_step"] = tool_execution_step
        super(HistoryExecutionStep, __self__).__init__(
            'google-native:toolresults/v1beta3:HistoryExecutionStep',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'HistoryExecutionStep':
        """
        Get an existing HistoryExecutionStep resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = HistoryExecutionStepArgs.__new__(HistoryExecutionStepArgs)

        __props__.__dict__["completion_time"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["device_usage_duration"] = None
        __props__.__dict__["dimension_value"] = None
        __props__.__dict__["has_images"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["multi_step"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["outcome"] = None
        __props__.__dict__["run_duration"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["step_id"] = None
        __props__.__dict__["test_execution_step"] = None
        __props__.__dict__["tool_execution_step"] = None
        return HistoryExecutionStep(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> pulumi.Output['outputs.TimestampResponse']:
        """
        The time when the step status was set to complete. This value will be set automatically when state transitions to COMPLETE. - In response: set if the execution state is COMPLETE. - In create/update request: never set
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output['outputs.TimestampResponse']:
        """
        The time when the step was created. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A description of this tool For example: mvn clean package -D skipTests=true - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceUsageDuration")
    def device_usage_duration(self) -> pulumi.Output['outputs.DurationResponse']:
        """
        How much the device resource is used to perform the test. This is the device usage used for billing purpose, which is different from the run_duration, for example, infrastructure failure won't be charged for device usage. PRECONDITION_FAILED will be returned if one attempts to set a device_usage on a step which already has this field set. - In response: present if previously set. - In create request: optional - In update request: optional
        """
        return pulumi.get(self, "device_usage_duration")

    @property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> pulumi.Output[Sequence['outputs.StepDimensionValueEntryResponse']]:
        """
        If the execution containing this step has any dimension_definition set, then this field allows the child to specify the values of the dimensions. The keys must exactly match the dimension_definition of the execution. For example, if the execution has `dimension_definition = ['attempt', 'device']` then a step must define values for those dimensions, eg. `dimension_value = ['attempt': '1', 'device': 'Nexus 6']` If a step does not participate in one dimension of the matrix, the value for that dimension should be empty string. For example, if one of the tests is executed by a runner which does not support retries, the step could have `dimension_value = ['attempt': '', 'device': 'Nexus 6']` If the step does not participate in any dimensions of the matrix, it may leave dimension_value unset. A PRECONDITION_FAILED will be returned if any of the keys do not exist in the dimension_definition of the execution. A PRECONDITION_FAILED will be returned if another step in this execution already has the same name and dimension_value, but differs on other data fields, for example, step field is different. A PRECONDITION_FAILED will be returned if dimension_value is set, and there is a dimension_definition in the execution which is not specified as one of the keys. - In response: present if set by create - In create request: optional - In update request: never set
        """
        return pulumi.get(self, "dimension_value")

    @property
    @pulumi.getter(name="hasImages")
    def has_images(self) -> pulumi.Output[bool]:
        """
        Whether any of the outputs of this step are images whose thumbnails can be fetched with ListThumbnails. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "has_images")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Sequence['outputs.StepLabelsEntryResponse']]:
        """
        Arbitrary user-supplied key/value pairs that are associated with the step. Users are responsible for managing the key namespace such that keys don't accidentally collide. An INVALID_ARGUMENT will be returned if the number of labels exceeds 100 or if the length of any of the keys or values exceeds 100 characters. - In response: always set - In create request: optional - In update request: optional; any new key/value pair will be added to the map, and any new value for an existing key will update that key's value
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="multiStep")
    def multi_step(self) -> pulumi.Output['outputs.MultiStepResponse']:
        """
        Details when multiple steps are run with the same configuration as a group. These details can be used identify which group this step is part of. It also identifies the groups 'primary step' which indexes all the group members. - In response: present if previously set. - In create request: optional, set iff this step was performed more than once. - In update request: optional
        """
        return pulumi.get(self, "multi_step")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A short human-readable name to display in the UI. Maximum of 100 characters. For example: Clean build A PRECONDITION_FAILED will be returned upon creating a new step if it shares its name and dimension_value with an existing step. If two steps represent a similar action, but have different dimension values, they should share the same name. For instance, if the same set of tests is run on two different platforms, the two steps should have the same name. - In response: always set - In create request: always set - In update request: never set
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def outcome(self) -> pulumi.Output['outputs.OutcomeResponse']:
        """
        Classification of the result, for example into SUCCESS or FAILURE - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "outcome")

    @property
    @pulumi.getter(name="runDuration")
    def run_duration(self) -> pulumi.Output['outputs.DurationResponse']:
        """
        How long it took for this step to run. If unset, this is set to the difference between creation_time and completion_time when the step is set to the COMPLETE state. In some cases, it is appropriate to set this value separately: For instance, if a step is created, but the operation it represents is queued for a few minutes before it executes, it would be appropriate not to include the time spent queued in its run_duration. PRECONDITION_FAILED will be returned if one attempts to set a run_duration on a step which already has this field set. - In response: present if previously set; always present on COMPLETE step - In create request: optional - In update request: optional
        """
        return pulumi.get(self, "run_duration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The initial state is IN_PROGRESS. The only legal state transitions are * IN_PROGRESS -> COMPLETE A PRECONDITION_FAILED will be returned if an invalid transition is requested. It is valid to create Step with a state set to COMPLETE. The state can only be set to COMPLETE once. A PRECONDITION_FAILED will be returned if the state is set to COMPLETE multiple times. - In response: always set - In create/update request: optional
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> pulumi.Output[str]:
        """
        A unique identifier within a Execution for this Step. Returns INVALID_ARGUMENT if this field is set or overwritten by the caller. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "step_id")

    @property
    @pulumi.getter(name="testExecutionStep")
    def test_execution_step(self) -> pulumi.Output['outputs.TestExecutionStepResponse']:
        """
        An execution of a test runner.
        """
        return pulumi.get(self, "test_execution_step")

    @property
    @pulumi.getter(name="toolExecutionStep")
    def tool_execution_step(self) -> pulumi.Output['outputs.ToolExecutionStepResponse']:
        """
        An execution of a tool (used for steps we don't explicitly support).
        """
        return pulumi.get(self, "tool_execution_step")

