# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instances_id: pulumi.Input[str],
                 locations_id: pulumi.Input[str],
                 projects_id: pulumi.Input[str],
                 alternative_location_id: Optional[pulumi.Input[str]] = None,
                 auth_enabled: Optional[pulumi.Input[bool]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 connect_mode: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 memory_size_gb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 reserved_ip_range: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] alternative_location_id: Optional. Only applicable to STANDARD_HA tier which protects the instance against zonal failures by provisioning it across two zones. If provided, it must be a different zone from the one provided in location_id.
        :param pulumi.Input[bool] auth_enabled: Optional. Indicates whether OSS Redis AUTH is enabled for the instance. If set to "true" AUTH is enabled on the instance. Default value is "false" meaning AUTH is disabled.
        :param pulumi.Input[str] authorized_network: Optional. The full name of the Google Compute Engine [network](https://cloud.google.com/vpc/docs/vpc) to which the instance is connected. If left unspecified, the `default` network will be used.
        :param pulumi.Input[str] connect_mode: Optional. The network connect mode of the Redis instance. If not provided, the connect mode defaults to DIRECT_PEERING.
        :param pulumi.Input[str] display_name: An arbitrary and optional user-provided name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user provided metadata
        :param pulumi.Input[str] location_id: Optional. The zone where the instance will be provisioned. If not provided, the service will choose a zone for the instance. For STANDARD_HA tier, instances will be created across two zones for protection against zonal failures. If alternative_location_id is also provided, it must be different from location_id.
        :param pulumi.Input[int] memory_size_gb: Required. Redis memory size in GiB.
        :param pulumi.Input[str] name: Required. Unique name of the resource in this scope including project and location using the form: `projects/{project_id}/locations/{location_id}/instances/{instance_id}` Note: Redis instances are managed and addressed at regional level so location_id here refers to a GCP region; however, users may choose which specific zone (or collection of zones for cross-zone instances) an instance should be provisioned in. Refer to location_id and alternative_location_id fields for more details.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] redis_configs: Optional. Redis configuration parameters, according to http://redis.io/topics/config. Currently, the only supported parameters are: Redis version 3.2 and newer: * maxmemory-policy * notify-keyspace-events Redis version 4.0 and newer: * activedefrag * lfu-decay-time * lfu-log-factor * maxmemory-gb Redis version 5.0 and newer: * stream-node-max-bytes * stream-node-max-entries
        :param pulumi.Input[str] redis_version: Optional. The version of Redis software. If not provided, latest supported version will be used. Currently, the supported values are: * `REDIS_3_2` for Redis 3.2 compatibility * `REDIS_4_0` for Redis 4.0 compatibility (default) * `REDIS_5_0` for Redis 5.0 compatibility
        :param pulumi.Input[str] reserved_ip_range: Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses that are reserved for this instance. Range must be unique and non-overlapping with existing subnets in an authorized network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP address ranges associated with this private service access connection. If not provided, the service will choose an unused /29 block, for example, 10.0.0.0/29 or 192.168.0.0/29.
        :param pulumi.Input[str] tier: Required. The service tier of the instance.
        :param pulumi.Input[str] transit_encryption_mode: Optional. The TLS mode of the Redis instance. If not provided, TLS is disabled for the instance.
        """
        pulumi.set(__self__, "instances_id", instances_id)
        pulumi.set(__self__, "locations_id", locations_id)
        pulumi.set(__self__, "projects_id", projects_id)
        if alternative_location_id is not None:
            pulumi.set(__self__, "alternative_location_id", alternative_location_id)
        if auth_enabled is not None:
            pulumi.set(__self__, "auth_enabled", auth_enabled)
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if connect_mode is not None:
            pulumi.set(__self__, "connect_mode", connect_mode)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if memory_size_gb is not None:
            pulumi.set(__self__, "memory_size_gb", memory_size_gb)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redis_configs is not None:
            pulumi.set(__self__, "redis_configs", redis_configs)
        if redis_version is not None:
            pulumi.set(__self__, "redis_version", redis_version)
        if reserved_ip_range is not None:
            pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)

    @property
    @pulumi.getter(name="instancesId")
    def instances_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "instances_id")

    @instances_id.setter
    def instances_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instances_id", value)

    @property
    @pulumi.getter(name="locationsId")
    def locations_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "locations_id")

    @locations_id.setter
    def locations_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "locations_id", value)

    @property
    @pulumi.getter(name="projectsId")
    def projects_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "projects_id")

    @projects_id.setter
    def projects_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "projects_id", value)

    @property
    @pulumi.getter(name="alternativeLocationId")
    def alternative_location_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Only applicable to STANDARD_HA tier which protects the instance against zonal failures by provisioning it across two zones. If provided, it must be a different zone from the one provided in location_id.
        """
        return pulumi.get(self, "alternative_location_id")

    @alternative_location_id.setter
    def alternative_location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alternative_location_id", value)

    @property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates whether OSS Redis AUTH is enabled for the instance. If set to "true" AUTH is enabled on the instance. Default value is "false" meaning AUTH is disabled.
        """
        return pulumi.get(self, "auth_enabled")

    @auth_enabled.setter
    def auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auth_enabled", value)

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The full name of the Google Compute Engine [network](https://cloud.google.com/vpc/docs/vpc) to which the instance is connected. If left unspecified, the `default` network will be used.
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorized_network", value)

    @property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The network connect mode of the Redis instance. If not provided, the connect mode defaults to DIRECT_PEERING.
        """
        return pulumi.get(self, "connect_mode")

    @connect_mode.setter
    def connect_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_mode", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary and optional user-provided name for the instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels to represent user provided metadata
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The zone where the instance will be provisioned. If not provided, the service will choose a zone for the instance. For STANDARD_HA tier, instances will be created across two zones for protection against zonal failures. If alternative_location_id is also provided, it must be different from location_id.
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter(name="memorySizeGb")
    def memory_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Required. Redis memory size in GiB.
        """
        return pulumi.get(self, "memory_size_gb")

    @memory_size_gb.setter
    def memory_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_gb", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Unique name of the resource in this scope including project and location using the form: `projects/{project_id}/locations/{location_id}/instances/{instance_id}` Note: Redis instances are managed and addressed at regional level so location_id here refers to a GCP region; however, users may choose which specific zone (or collection of zones for cross-zone instances) an instance should be provisioned in. Refer to location_id and alternative_location_id fields for more details.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Redis configuration parameters, according to http://redis.io/topics/config. Currently, the only supported parameters are: Redis version 3.2 and newer: * maxmemory-policy * notify-keyspace-events Redis version 4.0 and newer: * activedefrag * lfu-decay-time * lfu-log-factor * maxmemory-gb Redis version 5.0 and newer: * stream-node-max-bytes * stream-node-max-entries
        """
        return pulumi.get(self, "redis_configs")

    @redis_configs.setter
    def redis_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "redis_configs", value)

    @property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The version of Redis software. If not provided, latest supported version will be used. Currently, the supported values are: * `REDIS_3_2` for Redis 3.2 compatibility * `REDIS_4_0` for Redis 4.0 compatibility (default) * `REDIS_5_0` for Redis 5.0 compatibility
        """
        return pulumi.get(self, "redis_version")

    @redis_version.setter
    def redis_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redis_version", value)

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses that are reserved for this instance. Range must be unique and non-overlapping with existing subnets in an authorized network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP address ranges associated with this private service access connection. If not provided, the service will choose an unused /29 block, for example, 10.0.0.0/29 or 192.168.0.0/29.
        """
        return pulumi.get(self, "reserved_ip_range")

    @reserved_ip_range.setter
    def reserved_ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_ip_range", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The service tier of the instance.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The TLS mode of the Redis instance. If not provided, TLS is disabled for the instance.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_encryption_mode", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternative_location_id: Optional[pulumi.Input[str]] = None,
                 auth_enabled: Optional[pulumi.Input[bool]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 connect_mode: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 instances_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 memory_size_gb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 reserved_ip_range: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a Redis instance based on the specified tier and memory size. By default, the instance is accessible from the project's [default network](https://cloud.google.com/vpc/docs/vpc). The creation is executed asynchronously and callers may check the returned operation to track its progress. Once the operation is completed the Redis instance will be fully functional. Completed longrunning.Operation will contain the new instance object in the response field. The returned operation is automatically deleted after a few hours, so there is no need to call DeleteOperation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alternative_location_id: Optional. Only applicable to STANDARD_HA tier which protects the instance against zonal failures by provisioning it across two zones. If provided, it must be a different zone from the one provided in location_id.
        :param pulumi.Input[bool] auth_enabled: Optional. Indicates whether OSS Redis AUTH is enabled for the instance. If set to "true" AUTH is enabled on the instance. Default value is "false" meaning AUTH is disabled.
        :param pulumi.Input[str] authorized_network: Optional. The full name of the Google Compute Engine [network](https://cloud.google.com/vpc/docs/vpc) to which the instance is connected. If left unspecified, the `default` network will be used.
        :param pulumi.Input[str] connect_mode: Optional. The network connect mode of the Redis instance. If not provided, the connect mode defaults to DIRECT_PEERING.
        :param pulumi.Input[str] display_name: An arbitrary and optional user-provided name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user provided metadata
        :param pulumi.Input[str] location_id: Optional. The zone where the instance will be provisioned. If not provided, the service will choose a zone for the instance. For STANDARD_HA tier, instances will be created across two zones for protection against zonal failures. If alternative_location_id is also provided, it must be different from location_id.
        :param pulumi.Input[int] memory_size_gb: Required. Redis memory size in GiB.
        :param pulumi.Input[str] name: Required. Unique name of the resource in this scope including project and location using the form: `projects/{project_id}/locations/{location_id}/instances/{instance_id}` Note: Redis instances are managed and addressed at regional level so location_id here refers to a GCP region; however, users may choose which specific zone (or collection of zones for cross-zone instances) an instance should be provisioned in. Refer to location_id and alternative_location_id fields for more details.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] redis_configs: Optional. Redis configuration parameters, according to http://redis.io/topics/config. Currently, the only supported parameters are: Redis version 3.2 and newer: * maxmemory-policy * notify-keyspace-events Redis version 4.0 and newer: * activedefrag * lfu-decay-time * lfu-log-factor * maxmemory-gb Redis version 5.0 and newer: * stream-node-max-bytes * stream-node-max-entries
        :param pulumi.Input[str] redis_version: Optional. The version of Redis software. If not provided, latest supported version will be used. Currently, the supported values are: * `REDIS_3_2` for Redis 3.2 compatibility * `REDIS_4_0` for Redis 4.0 compatibility (default) * `REDIS_5_0` for Redis 5.0 compatibility
        :param pulumi.Input[str] reserved_ip_range: Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses that are reserved for this instance. Range must be unique and non-overlapping with existing subnets in an authorized network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP address ranges associated with this private service access connection. If not provided, the service will choose an unused /29 block, for example, 10.0.0.0/29 or 192.168.0.0/29.
        :param pulumi.Input[str] tier: Required. The service tier of the instance.
        :param pulumi.Input[str] transit_encryption_mode: Optional. The TLS mode of the Redis instance. If not provided, TLS is disabled for the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Redis instance based on the specified tier and memory size. By default, the instance is accessible from the project's [default network](https://cloud.google.com/vpc/docs/vpc). The creation is executed asynchronously and callers may check the returned operation to track its progress. Once the operation is completed the Redis instance will be fully functional. Completed longrunning.Operation will contain the new instance object in the response field. The returned operation is automatically deleted after a few hours, so there is no need to call DeleteOperation.

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternative_location_id: Optional[pulumi.Input[str]] = None,
                 auth_enabled: Optional[pulumi.Input[bool]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 connect_mode: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 instances_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 memory_size_gb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 reserved_ip_range: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["alternative_location_id"] = alternative_location_id
            __props__.__dict__["auth_enabled"] = auth_enabled
            __props__.__dict__["authorized_network"] = authorized_network
            __props__.__dict__["connect_mode"] = connect_mode
            __props__.__dict__["display_name"] = display_name
            if instances_id is None and not opts.urn:
                raise TypeError("Missing required property 'instances_id'")
            __props__.__dict__["instances_id"] = instances_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location_id"] = location_id
            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__.__dict__["locations_id"] = locations_id
            __props__.__dict__["memory_size_gb"] = memory_size_gb
            __props__.__dict__["name"] = name
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__.__dict__["projects_id"] = projects_id
            __props__.__dict__["redis_configs"] = redis_configs
            __props__.__dict__["redis_version"] = redis_version
            __props__.__dict__["reserved_ip_range"] = reserved_ip_range
            __props__.__dict__["tier"] = tier
            __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
            __props__.__dict__["create_time"] = None
            __props__.__dict__["current_location_id"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["persistence_iam_identity"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["server_ca_certs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status_message"] = None
        super(Instance, __self__).__init__(
            'google-native:redis/v1beta1:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InstanceArgs.__new__(InstanceArgs)

        __props__.__dict__["alternative_location_id"] = None
        __props__.__dict__["auth_enabled"] = None
        __props__.__dict__["authorized_network"] = None
        __props__.__dict__["connect_mode"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["current_location_id"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["host"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location_id"] = None
        __props__.__dict__["memory_size_gb"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["persistence_iam_identity"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["redis_configs"] = None
        __props__.__dict__["redis_version"] = None
        __props__.__dict__["reserved_ip_range"] = None
        __props__.__dict__["server_ca_certs"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["status_message"] = None
        __props__.__dict__["tier"] = None
        __props__.__dict__["transit_encryption_mode"] = None
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alternativeLocationId")
    def alternative_location_id(self) -> pulumi.Output[str]:
        """
        Optional. Only applicable to STANDARD_HA tier which protects the instance against zonal failures by provisioning it across two zones. If provided, it must be a different zone from the one provided in location_id.
        """
        return pulumi.get(self, "alternative_location_id")

    @property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> pulumi.Output[bool]:
        """
        Optional. Indicates whether OSS Redis AUTH is enabled for the instance. If set to "true" AUTH is enabled on the instance. Default value is "false" meaning AUTH is disabled.
        """
        return pulumi.get(self, "auth_enabled")

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> pulumi.Output[str]:
        """
        Optional. The full name of the Google Compute Engine [network](https://cloud.google.com/vpc/docs/vpc) to which the instance is connected. If left unspecified, the `default` network will be used.
        """
        return pulumi.get(self, "authorized_network")

    @property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> pulumi.Output[str]:
        """
        Optional. The network connect mode of the Redis instance. If not provided, the connect mode defaults to DIRECT_PEERING.
        """
        return pulumi.get(self, "connect_mode")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time the instance was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="currentLocationId")
    def current_location_id(self) -> pulumi.Output[str]:
        """
        The current zone where the Redis endpoint is placed. For Basic Tier instances, this will always be the same as the location_id provided by the user at creation time. For Standard Tier instances, this can be either location_id or alternative_location_id and can change after a failover event.
        """
        return pulumi.get(self, "current_location_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        An arbitrary and optional user-provided name for the instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Hostname or IP address of the exposed Redis endpoint used by clients to connect to the service.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Resource labels to represent user provided metadata
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Output[str]:
        """
        Optional. The zone where the instance will be provisioned. If not provided, the service will choose a zone for the instance. For STANDARD_HA tier, instances will be created across two zones for protection against zonal failures. If alternative_location_id is also provided, it must be different from location_id.
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter(name="memorySizeGb")
    def memory_size_gb(self) -> pulumi.Output[int]:
        """
        Required. Redis memory size in GiB.
        """
        return pulumi.get(self, "memory_size_gb")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Required. Unique name of the resource in this scope including project and location using the form: `projects/{project_id}/locations/{location_id}/instances/{instance_id}` Note: Redis instances are managed and addressed at regional level so location_id here refers to a GCP region; however, users may choose which specific zone (or collection of zones for cross-zone instances) an instance should be provisioned in. Refer to location_id and alternative_location_id fields for more details.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="persistenceIamIdentity")
    def persistence_iam_identity(self) -> pulumi.Output[str]:
        """
        Cloud IAM identity used by import / export operations to transfer data to/from Cloud Storage. Format is "serviceAccount:". The value may change over time for a given instance so should be checked before each import/export operation.
        """
        return pulumi.get(self, "persistence_iam_identity")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The port number of the exposed Redis endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Optional. Redis configuration parameters, according to http://redis.io/topics/config. Currently, the only supported parameters are: Redis version 3.2 and newer: * maxmemory-policy * notify-keyspace-events Redis version 4.0 and newer: * activedefrag * lfu-decay-time * lfu-log-factor * maxmemory-gb Redis version 5.0 and newer: * stream-node-max-bytes * stream-node-max-entries
        """
        return pulumi.get(self, "redis_configs")

    @property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> pulumi.Output[str]:
        """
        Optional. The version of Redis software. If not provided, latest supported version will be used. Currently, the supported values are: * `REDIS_3_2` for Redis 3.2 compatibility * `REDIS_4_0` for Redis 4.0 compatibility (default) * `REDIS_5_0` for Redis 5.0 compatibility
        """
        return pulumi.get(self, "redis_version")

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> pulumi.Output[str]:
        """
        Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses that are reserved for this instance. Range must be unique and non-overlapping with existing subnets in an authorized network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP address ranges associated with this private service access connection. If not provided, the service will choose an unused /29 block, for example, 10.0.0.0/29 or 192.168.0.0/29.
        """
        return pulumi.get(self, "reserved_ip_range")

    @property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> pulumi.Output[Sequence['outputs.TlsCertificateResponse']]:
        """
        List of server CA certificates for the instance.
        """
        return pulumi.get(self, "server_ca_certs")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of this instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[str]:
        """
        Additional information about the current status of this instance, if available.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[str]:
        """
        Required. The service tier of the instance.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> pulumi.Output[str]:
        """
        Optional. The TLS mode of the Redis instance. If not provided, TLS is disabled for the instance.
        """
        return pulumi.get(self, "transit_encryption_mode")

