# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CatalogCatalogItemArgs', 'CatalogCatalogItem']

@pulumi.input_type
class CatalogCatalogItemArgs:
    def __init__(__self__, *,
                 catalog_items_id: pulumi.Input[str],
                 catalogs_id: pulumi.Input[str],
                 locations_id: pulumi.Input[str],
                 projects_id: pulumi.Input[str],
                 category_hierarchies: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 item_attributes: Optional[pulumi.Input['GoogleCloudRecommendationengineV1beta1FeatureMapArgs']] = None,
                 item_group_id: Optional[pulumi.Input[str]] = None,
                 product_metadata: Optional[pulumi.Input['GoogleCloudRecommendationengineV1beta1ProductCatalogItemArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CatalogCatalogItem resource.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyArgs']]] category_hierarchies: Required. Catalog item categories. This field is repeated for supporting one catalog item belonging to several parallel category hierarchies. For example, if a shoes product belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented as: "categoryHierarchies": [ { "categories": ["Shoes & Accessories", "Shoes"]}, { "categories": ["Sports & Fitness", "Athletic Clothing", "Shoes"] } ]
        :param pulumi.Input[str] description: Optional. Catalog item description. UTF-8 encoded string with a length limit of 5 KiB.
        :param pulumi.Input[str] id: Required. Catalog item identifier. UTF-8 encoded string with a length limit of 128 bytes. This id must be unique among all catalog items within the same catalog. It should also be used when logging user events in order for the user events to be joined with the Catalog.
        :param pulumi.Input['GoogleCloudRecommendationengineV1beta1FeatureMapArgs'] item_attributes: Optional. Highly encouraged. Extra catalog item attributes to be included in the recommendation model. For example, for retail products, this could include the store name, vendor, style, color, etc. These are very strong signals for recommendation model, thus we highly recommend providing the item attributes here.
        :param pulumi.Input[str] item_group_id: Optional. Variant group identifier for prediction results. UTF-8 encoded string with a length limit of 128 bytes. This field must be enabled before it can be used. [Learn more](/recommendations-ai/docs/catalog#item-group-id).
        :param pulumi.Input['GoogleCloudRecommendationengineV1beta1ProductCatalogItemArgs'] product_metadata: Optional. Metadata specific to retail products.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Optional. Filtering tags associated with the catalog item. Each tag should be a UTF-8 encoded string with a length limit of 1 KiB. This tag can be used for filtering recommendation results by passing the tag as part of the predict request filter.
        :param pulumi.Input[str] title: Required. Catalog item title. UTF-8 encoded string with a length limit of 1 KiB.
        """
        pulumi.set(__self__, "catalog_items_id", catalog_items_id)
        pulumi.set(__self__, "catalogs_id", catalogs_id)
        pulumi.set(__self__, "locations_id", locations_id)
        pulumi.set(__self__, "projects_id", projects_id)
        if category_hierarchies is not None:
            pulumi.set(__self__, "category_hierarchies", category_hierarchies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if item_attributes is not None:
            pulumi.set(__self__, "item_attributes", item_attributes)
        if item_group_id is not None:
            pulumi.set(__self__, "item_group_id", item_group_id)
        if product_metadata is not None:
            pulumi.set(__self__, "product_metadata", product_metadata)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="catalogItemsId")
    def catalog_items_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "catalog_items_id")

    @catalog_items_id.setter
    def catalog_items_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "catalog_items_id", value)

    @property
    @pulumi.getter(name="catalogsId")
    def catalogs_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "catalogs_id")

    @catalogs_id.setter
    def catalogs_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "catalogs_id", value)

    @property
    @pulumi.getter(name="locationsId")
    def locations_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "locations_id")

    @locations_id.setter
    def locations_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "locations_id", value)

    @property
    @pulumi.getter(name="projectsId")
    def projects_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "projects_id")

    @projects_id.setter
    def projects_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "projects_id", value)

    @property
    @pulumi.getter(name="categoryHierarchies")
    def category_hierarchies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyArgs']]]]:
        """
        Required. Catalog item categories. This field is repeated for supporting one catalog item belonging to several parallel category hierarchies. For example, if a shoes product belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented as: "categoryHierarchies": [ { "categories": ["Shoes & Accessories", "Shoes"]}, { "categories": ["Sports & Fitness", "Athletic Clothing", "Shoes"] } ]
        """
        return pulumi.get(self, "category_hierarchies")

    @category_hierarchies.setter
    def category_hierarchies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyArgs']]]]):
        pulumi.set(self, "category_hierarchies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Catalog item description. UTF-8 encoded string with a length limit of 5 KiB.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Catalog item identifier. UTF-8 encoded string with a length limit of 128 bytes. This id must be unique among all catalog items within the same catalog. It should also be used when logging user events in order for the user events to be joined with the Catalog.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="itemAttributes")
    def item_attributes(self) -> Optional[pulumi.Input['GoogleCloudRecommendationengineV1beta1FeatureMapArgs']]:
        """
        Optional. Highly encouraged. Extra catalog item attributes to be included in the recommendation model. For example, for retail products, this could include the store name, vendor, style, color, etc. These are very strong signals for recommendation model, thus we highly recommend providing the item attributes here.
        """
        return pulumi.get(self, "item_attributes")

    @item_attributes.setter
    def item_attributes(self, value: Optional[pulumi.Input['GoogleCloudRecommendationengineV1beta1FeatureMapArgs']]):
        pulumi.set(self, "item_attributes", value)

    @property
    @pulumi.getter(name="itemGroupId")
    def item_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Variant group identifier for prediction results. UTF-8 encoded string with a length limit of 128 bytes. This field must be enabled before it can be used. [Learn more](/recommendations-ai/docs/catalog#item-group-id).
        """
        return pulumi.get(self, "item_group_id")

    @item_group_id.setter
    def item_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "item_group_id", value)

    @property
    @pulumi.getter(name="productMetadata")
    def product_metadata(self) -> Optional[pulumi.Input['GoogleCloudRecommendationengineV1beta1ProductCatalogItemArgs']]:
        """
        Optional. Metadata specific to retail products.
        """
        return pulumi.get(self, "product_metadata")

    @product_metadata.setter
    def product_metadata(self, value: Optional[pulumi.Input['GoogleCloudRecommendationengineV1beta1ProductCatalogItemArgs']]):
        pulumi.set(self, "product_metadata", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Filtering tags associated with the catalog item. Each tag should be a UTF-8 encoded string with a length limit of 1 KiB. This tag can be used for filtering recommendation results by passing the tag as part of the predict request filter.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Catalog item title. UTF-8 encoded string with a length limit of 1 KiB.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


class CatalogCatalogItem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_items_id: Optional[pulumi.Input[str]] = None,
                 catalogs_id: Optional[pulumi.Input[str]] = None,
                 category_hierarchies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 item_attributes: Optional[pulumi.Input[pulumi.InputType['GoogleCloudRecommendationengineV1beta1FeatureMapArgs']]] = None,
                 item_group_id: Optional[pulumi.Input[str]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 product_metadata: Optional[pulumi.Input[pulumi.InputType['GoogleCloudRecommendationengineV1beta1ProductCatalogItemArgs']]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a catalog item.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyArgs']]]] category_hierarchies: Required. Catalog item categories. This field is repeated for supporting one catalog item belonging to several parallel category hierarchies. For example, if a shoes product belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented as: "categoryHierarchies": [ { "categories": ["Shoes & Accessories", "Shoes"]}, { "categories": ["Sports & Fitness", "Athletic Clothing", "Shoes"] } ]
        :param pulumi.Input[str] description: Optional. Catalog item description. UTF-8 encoded string with a length limit of 5 KiB.
        :param pulumi.Input[str] id: Required. Catalog item identifier. UTF-8 encoded string with a length limit of 128 bytes. This id must be unique among all catalog items within the same catalog. It should also be used when logging user events in order for the user events to be joined with the Catalog.
        :param pulumi.Input[pulumi.InputType['GoogleCloudRecommendationengineV1beta1FeatureMapArgs']] item_attributes: Optional. Highly encouraged. Extra catalog item attributes to be included in the recommendation model. For example, for retail products, this could include the store name, vendor, style, color, etc. These are very strong signals for recommendation model, thus we highly recommend providing the item attributes here.
        :param pulumi.Input[str] item_group_id: Optional. Variant group identifier for prediction results. UTF-8 encoded string with a length limit of 128 bytes. This field must be enabled before it can be used. [Learn more](/recommendations-ai/docs/catalog#item-group-id).
        :param pulumi.Input[pulumi.InputType['GoogleCloudRecommendationengineV1beta1ProductCatalogItemArgs']] product_metadata: Optional. Metadata specific to retail products.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Optional. Filtering tags associated with the catalog item. Each tag should be a UTF-8 encoded string with a length limit of 1 KiB. This tag can be used for filtering recommendation results by passing the tag as part of the predict request filter.
        :param pulumi.Input[str] title: Required. Catalog item title. UTF-8 encoded string with a length limit of 1 KiB.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CatalogCatalogItemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a catalog item.

        :param str resource_name: The name of the resource.
        :param CatalogCatalogItemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CatalogCatalogItemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_items_id: Optional[pulumi.Input[str]] = None,
                 catalogs_id: Optional[pulumi.Input[str]] = None,
                 category_hierarchies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 item_attributes: Optional[pulumi.Input[pulumi.InputType['GoogleCloudRecommendationengineV1beta1FeatureMapArgs']]] = None,
                 item_group_id: Optional[pulumi.Input[str]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 product_metadata: Optional[pulumi.Input[pulumi.InputType['GoogleCloudRecommendationengineV1beta1ProductCatalogItemArgs']]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CatalogCatalogItemArgs.__new__(CatalogCatalogItemArgs)

            if catalog_items_id is None and not opts.urn:
                raise TypeError("Missing required property 'catalog_items_id'")
            __props__.__dict__["catalog_items_id"] = catalog_items_id
            if catalogs_id is None and not opts.urn:
                raise TypeError("Missing required property 'catalogs_id'")
            __props__.__dict__["catalogs_id"] = catalogs_id
            __props__.__dict__["category_hierarchies"] = category_hierarchies
            __props__.__dict__["description"] = description
            __props__.__dict__["id"] = id
            __props__.__dict__["item_attributes"] = item_attributes
            __props__.__dict__["item_group_id"] = item_group_id
            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__.__dict__["locations_id"] = locations_id
            __props__.__dict__["product_metadata"] = product_metadata
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__.__dict__["projects_id"] = projects_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["title"] = title
        super(CatalogCatalogItem, __self__).__init__(
            'google-native:recommendationengine/v1beta1:CatalogCatalogItem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CatalogCatalogItem':
        """
        Get an existing CatalogCatalogItem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CatalogCatalogItemArgs.__new__(CatalogCatalogItemArgs)

        __props__.__dict__["category_hierarchies"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["item_attributes"] = None
        __props__.__dict__["item_group_id"] = None
        __props__.__dict__["product_metadata"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["title"] = None
        return CatalogCatalogItem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="categoryHierarchies")
    def category_hierarchies(self) -> pulumi.Output[Sequence['outputs.GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyResponse']]:
        """
        Required. Catalog item categories. This field is repeated for supporting one catalog item belonging to several parallel category hierarchies. For example, if a shoes product belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented as: "categoryHierarchies": [ { "categories": ["Shoes & Accessories", "Shoes"]}, { "categories": ["Sports & Fitness", "Athletic Clothing", "Shoes"] } ]
        """
        return pulumi.get(self, "category_hierarchies")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Optional. Catalog item description. UTF-8 encoded string with a length limit of 5 KiB.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="itemAttributes")
    def item_attributes(self) -> pulumi.Output['outputs.GoogleCloudRecommendationengineV1beta1FeatureMapResponse']:
        """
        Optional. Highly encouraged. Extra catalog item attributes to be included in the recommendation model. For example, for retail products, this could include the store name, vendor, style, color, etc. These are very strong signals for recommendation model, thus we highly recommend providing the item attributes here.
        """
        return pulumi.get(self, "item_attributes")

    @property
    @pulumi.getter(name="itemGroupId")
    def item_group_id(self) -> pulumi.Output[str]:
        """
        Optional. Variant group identifier for prediction results. UTF-8 encoded string with a length limit of 128 bytes. This field must be enabled before it can be used. [Learn more](/recommendations-ai/docs/catalog#item-group-id).
        """
        return pulumi.get(self, "item_group_id")

    @property
    @pulumi.getter(name="productMetadata")
    def product_metadata(self) -> pulumi.Output['outputs.GoogleCloudRecommendationengineV1beta1ProductCatalogItemResponse']:
        """
        Optional. Metadata specific to retail products.
        """
        return pulumi.get(self, "product_metadata")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Optional. Filtering tags associated with the catalog item. Each tag should be a UTF-8 encoded string with a length limit of 1 KiB. This tag can be used for filtering recommendation results by passing the tag as part of the predict request filter.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        Required. Catalog item title. UTF-8 encoded string with a length limit of 1 KiB.
        """
        return pulumi.get(self, "title")

